/*
 * Copyright (c) 2012, 2020, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package com.sun.tools.javac.api;

import java.util.HashMap;

import com.sun.source.doctree.EntityTree;
import com.sun.tools.javac.util.StringUtils;

/**
 * Table of entities defined in HTML 5.2.
 *
 * <p> Derived from the
 * <a href="https://www.w3.org/TR/html52/syntax.html#named-character-references">Named character references</a>
 * section of the HTML 5.2 specification.
 *
 * <p><b>This is NOT part of any supported API.
 * If you write code that depends on this, you do so at your own
 * risk.  This code and its internal interfaces are subject to change
 * or deletion without notice.</b></p>
 */
class Entity {

    private static final HashMap<String,String> entities = new HashMap<>();

    static {
        put("Aacute", '\u00C1');
        put("aacute", '\u00E1');
        put("Abreve", '\u0102');
        put("abreve", '\u0103');
        put("ac", '\u223E');
        put("acd", '\u223F');
        put("acE", '\u223E', '\u0333');
        put("Acirc", '\u00C2');
        put("acirc", '\u00E2');
        put("acute", '\u00B4');
        put("Acy", '\u0410');
        put("acy", '\u0430');
        put("AElig", '\u00C6');
        put("aelig", '\u00E6');
        put("af", '\u2061');
        put("Afr", '\uD835', '\uDD04');
        put("afr", '\uD835', '\uDD1E');
        put("Agrave", '\u00C0');
        put("agrave", '\u00E0');
        put("alefsym", '\u2135');
        put("aleph", '\u2135');
        put("Alpha", '\u0391');
        put("alpha", '\u03B1');
        put("Amacr", '\u0100');
        put("amacr", '\u0101');
        put("amalg", '\u2A3F');
        put("amp", '\u0026');
        put("AMP", '\u0026');
        put("andand", '\u2A55');
        put("And", '\u2A53');
        put("and", '\u2227');
        put("andd", '\u2A5C');
        put("andslope", '\u2A58');
        put("andv", '\u2A5A');
        put("ang", '\u2220');
        put("ange", '\u29A4');
        put("angle", '\u2220');
        put("angmsdaa", '\u29A8');
        put("angmsdab", '\u29A9');
        put("angmsdac", '\u29AA');
        put("angmsdad", '\u29AB');
        put("angmsdae", '\u29AC');
        put("angmsdaf", '\u29AD');
        put("angmsdag", '\u29AE');
        put("angmsdah", '\u29AF');
        put("angmsd", '\u2221');
        put("angrt", '\u221F');
        put("angrtvb", '\u22BE');
        put("angrtvbd", '\u299D');
        put("angsph", '\u2222');
        put("angst", '\u00C5');
        put("angzarr", '\u237C');
        put("Aogon", '\u0104');
        put("aogon", '\u0105');
        put("Aopf", '\uD835', '\uDD38');
        put("aopf", '\uD835', '\uDD52');
        put("apacir", '\u2A6F');
        put("ap", '\u2248');
        put("apE", '\u2A70');
        put("ape", '\u224A');
        put("apid", '\u224B');
        put("apos", '\'');
        put("ApplyFunction", '\u2061');
        put("approx", '\u2248');
        put("approxeq", '\u224A');
        put("Aring", '\u00C5');
        put("aring", '\u00E5');
        put("Ascr", '\uD835', '\uDC9C');
        put("ascr", '\uD835', '\uDCB6');
        put("Assign", '\u2254');
        put("ast", '\u002A');
        put("asymp", '\u2248');
        put("asympeq", '\u224D');
        put("Atilde", '\u00C3');
        put("atilde", '\u00E3');
        put("Auml", '\u00C4');
        put("auml", '\u00E4');
        put("awconint", '\u2233');
        put("awint", '\u2A11');
        put("backcong", '\u224C');
        put("backepsilon", '\u03F6');
        put("backprime", '\u2035');
        put("backsim", '\u223D');
        put("backsimeq", '\u22CD');
        put("Backslash", '\u2216');
        put("Barv", '\u2AE7');
        put("barvee", '\u22BD');
        put("barwed", '\u2305');
        put("Barwed", '\u2306');
        put("barwedge", '\u2305');
        put("bbrk", '\u23B5');
        put("bbrktbrk", '\u23B6');
        put("bcong", '\u224C');
        put("Bcy", '\u0411');
        put("bcy", '\u0431');
        put("bdquo", '\u201E');
        put("becaus", '\u2235');
        put("because", '\u2235');
        put("Because", '\u2235');
        put("bemptyv", '\u29B0');
        put("bepsi", '\u03F6');
        put("bernou", '\u212C');
        put("Bernoullis", '\u212C');
        put("Beta", '\u0392');
        put("beta", '\u03B2');
        put("beth", '\u2136');
        put("between", '\u226C');
        put("Bfr", '\uD835', '\uDD05');
        put("bfr", '\uD835', '\uDD1F');
        put("bigcap", '\u22C2');
        put("bigcirc", '\u25EF');
        put("bigcup", '\u22C3');
        put("bigodot", '\u2A00');
        put("bigoplus", '\u2A01');
        put("bigotimes", '\u2A02');
        put("bigsqcup", '\u2A06');
        put("bigstar", '\u2605');
        put("bigtriangledown", '\u25BD');
        put("bigtriangleup", '\u25B3');
        put("biguplus", '\u2A04');
        put("bigvee", '\u22C1');
        put("bigwedge", '\u22C0');
        put("bkarow", '\u290D');
        put("blacklozenge", '\u29EB');
        put("blacksquare", '\u25AA');
        put("blacktriangle", '\u25B4');
        put("blacktriangledown", '\u25BE');
        put("blacktriangleleft", '\u25C2');
        put("blacktriangleright", '\u25B8');
        put("blank", '\u2423');
        put("blk12", '\u2592');
        put("blk14", '\u2591');
        put("blk34", '\u2593');
        put("block", '\u2588');
        put("bne", '\u003D', '\u20E5');
        put("bnequiv", '\u2261', '\u20E5');
        put("bNot", '\u2AED');
        put("bnot", '\u2310');
        put("Bopf", '\uD835', '\uDD39');
        put("bopf", '\uD835', '\uDD53');
        put("bot", '\u22A5');
        put("bottom", '\u22A5');
        put("bowtie", '\u22C8');
        put("boxbox", '\u29C9');
        put("boxdl", '\u2510');
        put("boxdL", '\u2555');
        put("boxDl", '\u2556');
        put("boxDL", '\u2557');
        put("boxdr", '\u250C');
        put("boxdR", '\u2552');
        put("boxDr", '\u2553');
        put("boxDR", '\u2554');
        put("boxh", '\u2500');
        put("boxH", '\u2550');
        put("boxhd", '\u252C');
        put("boxHd", '\u2564');
        put("boxhD", '\u2565');
        put("boxHD", '\u2566');
        put("boxhu", '\u2534');
        put("boxHu", '\u2567');
        put("boxhU", '\u2568');
        put("boxHU", '\u2569');
        put("boxminus", '\u229F');
        put("boxplus", '\u229E');
        put("boxtimes", '\u22A0');
        put("boxul", '\u2518');
        put("boxuL", '\u255B');
        put("boxUl", '\u255C');
        put("boxUL", '\u255D');
        put("boxur", '\u2514');
        put("boxuR", '\u2558');
        put("boxUr", '\u2559');
        put("boxUR", '\u255A');
        put("boxv", '\u2502');
        put("boxV", '\u2551');
        put("boxvh", '\u253C');
        put("boxvH", '\u256A');
        put("boxVh", '\u256B');
        put("boxVH", '\u256C');
        put("boxvl", '\u2524');
        put("boxvL", '\u2561');
        put("boxVl", '\u2562');
        put("boxVL", '\u2563');
        put("boxvr", '\u251C');
        put("boxvR", '\u255E');
        put("boxVr", '\u255F');
        put("boxVR", '\u2560');
        put("bprime", '\u2035');
        put("breve", '\u02D8');
        put("Breve", '\u02D8');
        put("brvbar", '\u00A6');
        put("bscr", '\uD835', '\uDCB7');
        put("Bscr", '\u212C');
        put("bsemi", '\u204F');
        put("bsim", '\u223D');
        put("bsime", '\u22CD');
        put("bsolb", '\u29C5');
        put("bsol", '\\');
        put("bsolhsub", '\u27C8');
        put("bull", '\u2022');
        put("bullet", '\u2022');
        put("bump", '\u224E');
        put("bumpE", '\u2AAE');
        put("bumpe", '\u224F');
        put("Bumpeq", '\u224E');
        put("bumpeq", '\u224F');
        put("Cacute", '\u0106');
        put("cacute", '\u0107');
        put("capand", '\u2A44');
        put("capbrcup", '\u2A49');
        put("capcap", '\u2A4B');
        put("cap", '\u2229');
        put("Cap", '\u22D2');
        put("capcup", '\u2A47');
        put("capdot", '\u2A40');
        put("CapitalDifferentialD", '\u2145');
        put("caps", '\u2229', '\uFE00');
        put("caret", '\u2041');
        put("caron", '\u02C7');
        put("Cayleys", '\u212D');
        put("ccaps", '\u2A4D');
        put("Ccaron", '\u010C');
        put("ccaron", '\u010D');
        put("Ccedil", '\u00C7');
        put("ccedil", '\u00E7');
        put("Ccirc", '\u0108');
        put("ccirc", '\u0109');
        put("Cconint", '\u2230');
        put("ccups", '\u2A4C');
        put("ccupssm", '\u2A50');
        put("Cdot", '\u010A');
        put("cdot", '\u010B');
        put("cedil", '\u00B8');
        put("Cedilla", '\u00B8');
        put("cemptyv", '\u29B2');
        put("cent", '\u00A2');
        put("centerdot", '\u00B7');
        put("CenterDot", '\u00B7');
        put("cfr", '\uD835', '\uDD20');
        put("Cfr", '\u212D');
        put("CHcy", '\u0427');
        put("chcy", '\u0447');
        put("check", '\u2713');
        put("checkmark", '\u2713');
        put("Chi", '\u03A7');
        put("chi", '\u03C7');
        put("circ", '\u02C6');
        put("circeq", '\u2257');
        put("circlearrowleft", '\u21BA');
        put("circlearrowright", '\u21BB');
        put("circledast", '\u229B');
        put("circledcirc", '\u229A');
        put("circleddash", '\u229D');
        put("CircleDot", '\u2299');
        put("circledR", '\u00AE');
        put("circledS", '\u24C8');
        put("CircleMinus", '\u2296');
        put("CirclePlus", '\u2295');
        put("CircleTimes", '\u2297');
        put("cir", '\u25CB');
        put("cirE", '\u29C3');
        put("cire", '\u2257');
        put("cirfnint", '\u2A10');
        put("cirmid", '\u2AEF');
        put("cirscir", '\u29C2');
        put("ClockwiseContourIntegral", '\u2232');
        put("CloseCurlyDoubleQuote", '\u201D');
        put("CloseCurlyQuote", '\u2019');
        put("clubs", '\u2663');
        put("clubsuit", '\u2663');
        put("colon", '\u003A');
        put("Colon", '\u2237');
        put("Colone", '\u2A74');
        put("colone", '\u2254');
        put("coloneq", '\u2254');
        put("comma", '\u002C');
        put("commat", '\u0040');
        put("comp", '\u2201');
        put("compfn", '\u2218');
        put("complement", '\u2201');
        put("complexes", '\u2102');
        put("cong", '\u2245');
        put("congdot", '\u2A6D');
        put("Congruent", '\u2261');
        put("conint", '\u222E');
        put("Conint", '\u222F');
        put("ContourIntegral", '\u222E');
        put("copf", '\uD835', '\uDD54');
        put("Copf", '\u2102');
        put("coprod", '\u2210');
        put("Coproduct", '\u2210');
        put("copy", '\u00A9');
        put("COPY", '\u00A9');
        put("copysr", '\u2117');
        put("CounterClockwiseContourIntegral", '\u2233');
        put("crarr", '\u21B5');
        put("cross", '\u2717');
        put("Cross", '\u2A2F');
        put("Cscr", '\uD835', '\uDC9E');
        put("cscr", '\uD835', '\uDCB8');
        put("csub", '\u2ACF');
        put("csube", '\u2AD1');
        put("csup", '\u2AD0');
        put("csupe", '\u2AD2');
        put("ctdot", '\u22EF');
        put("cudarrl", '\u2938');
        put("cudarrr", '\u2935');
        put("cuepr", '\u22DE');
        put("cuesc", '\u22DF');
        put("cularr", '\u21B6');
        put("cularrp", '\u293D');
        put("cupbrcap", '\u2A48');
        put("cupcap", '\u2A46');
        put("CupCap", '\u224D');
        put("cup", '\u222A');
        put("Cup", '\u22D3');
        put("cupcup", '\u2A4A');
        put("cupdot", '\u228D');
        put("cupor", '\u2A45');
        put("cups", '\u222A', '\uFE00');
        put("curarr", '\u21B7');
        put("curarrm", '\u293C');
        put("curlyeqprec", '\u22DE');
        put("curlyeqsucc", '\u22DF');
        put("curlyvee", '\u22CE');
        put("curlywedge", '\u22CF');
        put("curren", '\u00A4');
        put("curvearrowleft", '\u21B6');
        put("curvearrowright", '\u21B7');
        put("cuvee", '\u22CE');
        put("cuwed", '\u22CF');
        put("cwconint", '\u2232');
        put("cwint", '\u2231');
        put("cylcty", '\u232D');
        put("dagger", '\u2020');
        put("Dagger", '\u2021');
        put("daleth", '\u2138');
        put("darr", '\u2193');
        put("Darr", '\u21A1');
        put("dArr", '\u21D3');
        put("dash", '\u2010');
        put("Dashv", '\u2AE4');
        put("dashv", '\u22A3');
        put("dbkarow", '\u290F');
        put("dblac", '\u02DD');
        put("Dcaron", '\u010E');
        put("dcaron", '\u010F');
        put("Dcy", '\u0414');
        put("dcy", '\u0434');
        put("ddagger", '\u2021');
        put("ddarr", '\u21CA');
        put("DD", '\u2145');
        put("dd", '\u2146');
        put("DDotrahd", '\u2911');
        put("ddotseq", '\u2A77');
        put("deg", '\u00B0');
        put("Del", '\u2207');
        put("Delta", '\u0394');
        put("delta", '\u03B4');
        put("demptyv", '\u29B1');
        put("dfisht", '\u297F');
        put("Dfr", '\uD835', '\uDD07');
        put("dfr", '\uD835', '\uDD21');
        put("dHar", '\u2965');
        put("dharl", '\u21C3');
        put("dharr", '\u21C2');
        put("DiacriticalAcute", '\u00B4');
        put("DiacriticalDot", '\u02D9');
        put("DiacriticalDoubleAcute", '\u02DD');
        put("DiacriticalGrave", '\u0060');
        put("DiacriticalTilde", '\u02DC');
        put("diam", '\u22C4');
        put("diamond", '\u22C4');
        put("Diamond", '\u22C4');
        put("diamondsuit", '\u2666');
        put("diams", '\u2666');
        put("die", '\u00A8');
        put("DifferentialD", '\u2146');
        put("digamma", '\u03DD');
        put("disin", '\u22F2');
        put("div", '\u00F7');
        put("divide", '\u00F7');
        put("divideontimes", '\u22C7');
        put("divonx", '\u22C7');
        put("DJcy", '\u0402');
        put("djcy", '\u0452');
        put("dlcorn", '\u231E');
        put("dlcrop", '\u230D');
        put("dollar", '\u0024');
        put("Dopf", '\uD835', '\uDD3B');
        put("dopf", '\uD835', '\uDD55');
        put("Dot", '\u00A8');
        put("dot", '\u02D9');
        put("DotDot", '\u20DC');
        put("doteq", '\u2250');
        put("doteqdot", '\u2251');
        put("DotEqual", '\u2250');
        put("dotminus", '\u2238');
        put("dotplus", '\u2214');
        put("dotsquare", '\u22A1');
        put("doublebarwedge", '\u2306');
        put("DoubleContourIntegral", '\u222F');
        put("DoubleDot", '\u00A8');
        put("DoubleDownArrow", '\u21D3');
        put("DoubleLeftArrow", '\u21D0');
        put("DoubleLeftRightArrow", '\u21D4');
        put("DoubleLeftTee", '\u2AE4');
        put("DoubleLongLeftArrow", '\u27F8');
        put("DoubleLongLeftRightArrow", '\u27FA');
        put("DoubleLongRightArrow", '\u27F9');
        put("DoubleRightArrow", '\u21D2');
        put("DoubleRightTee", '\u22A8');
        put("DoubleUpArrow", '\u21D1');
        put("DoubleUpDownArrow", '\u21D5');
        put("DoubleVerticalBar", '\u2225');
        put("DownArrowBar", '\u2913');
        put("downarrow", '\u2193');
        put("DownArrow", '\u2193');
        put("Downarrow", '\u21D3');
        put("DownArrowUpArrow", '\u21F5');
        put("DownBreve", '\u0311');
        put("downdownarrows", '\u21CA');
        put("downharpoonleft", '\u21C3');
        put("downharpoonright", '\u21C2');
        put("DownLeftRightVector", '\u2950');
        put("DownLeftTeeVector", '\u295E');
        put("DownLeftVectorBar", '\u2956');
        put("DownLeftVector", '\u21BD');
        put("DownRightTeeVector", '\u295F');
        put("DownRightVectorBar", '\u2957');
        put("DownRightVector", '\u21C1');
        put("DownTeeArrow", '\u21A7');
        put("DownTee", '\u22A4');
        put("drbkarow", '\u2910');
        put("drcorn", '\u231F');
        put("drcrop", '\u230C');
        put("Dscr", '\uD835', '\uDC9F');
        put("dscr", '\uD835', '\uDCB9');
        put("DScy", '\u0405');
        put("dscy", '\u0455');
        put("dsol", '\u29F6');
        put("Dstrok", '\u0110');
        put("dstrok", '\u0111');
        put("dtdot", '\u22F1');
        put("dtri", '\u25BF');
        put("dtrif", '\u25BE');
        put("duarr", '\u21F5');
        put("duhar", '\u296F');
        put("dwangle", '\u29A6');
        put("DZcy", '\u040F');
        put("dzcy", '\u045F');
        put("dzigrarr", '\u27FF');
        put("Eacute", '\u00C9');
        put("eacute", '\u00E9');
        put("easter", '\u2A6E');
        put("Ecaron", '\u011A');
        put("ecaron", '\u011B');
        put("Ecirc", '\u00CA');
        put("ecirc", '\u00EA');
        put("ecir", '\u2256');
        put("ecolon", '\u2255');
        put("Ecy", '\u042D');
        put("ecy", '\u044D');
        put("eDDot", '\u2A77');
        put("Edot", '\u0116');
        put("edot", '\u0117');
        put("eDot", '\u2251');
        put("ee", '\u2147');
        put("efDot", '\u2252');
        put("Efr", '\uD835', '\uDD08');
        put("efr", '\uD835', '\uDD22');
        put("eg", '\u2A9A');
        put("Egrave", '\u00C8');
        put("egrave", '\u00E8');
        put("egs", '\u2A96');
        put("egsdot", '\u2A98');
        put("el", '\u2A99');
        put("Element", '\u2208');
        put("elinters", '\u23E7');
        put("ell", '\u2113');
        put("els", '\u2A95');
        put("elsdot", '\u2A97');
        put("Emacr", '\u0112');
        put("emacr", '\u0113');
        put("empty", '\u2205');
        put("emptyset", '\u2205');
        put("EmptySmallSquare", '\u25FB');
        put("emptyv", '\u2205');
        put("EmptyVerySmallSquare", '\u25AB');
        put("emsp13", '\u2004');
        put("emsp14", '\u2005');
        put("emsp", '\u2003');
        put("ENG", '\u014A');
        put("eng", '\u014B');
        put("ensp", '\u2002');
        put("Eogon", '\u0118');
        put("eogon", '\u0119');
        put("Eopf", '\uD835', '\uDD3C');
        put("eopf", '\uD835', '\uDD56');
        put("epar", '\u22D5');
        put("eparsl", '\u29E3');
        put("eplus", '\u2A71');
        put("epsi", '\u03B5');
        put("Epsilon", '\u0395');
        put("epsilon", '\u03B5');
        put("epsiv", '\u03F5');
        put("eqcirc", '\u2256');
        put("eqcolon", '\u2255');
        put("eqsim", '\u2242');
        put("eqslantgtr", '\u2A96');
        put("eqslantless", '\u2A95');
        put("Equal", '\u2A75');
        put("equals", '\u003D');
        put("EqualTilde", '\u2242');
        put("equest", '\u225F');
        put("Equilibrium", '\u21CC');
        put("equiv", '\u2261');
        put("equivDD", '\u2A78');
        put("eqvparsl", '\u29E5');
        put("erarr", '\u2971');
        put("erDot", '\u2253');
        put("escr", '\u212F');
        put("Escr", '\u2130');
        put("esdot", '\u2250');
        put("Esim", '\u2A73');
        put("esim", '\u2242');
        put("Eta", '\u0397');
        put("eta", '\u03B7');
        put("ETH", '\u00D0');
        put("eth", '\u00F0');
        put("Euml", '\u00CB');
        put("euml", '\u00EB');
        put("euro", '\u20AC');
        put("excl", '\u0021');
        put("exist", '\u2203');
        put("Exists", '\u2203');
        put("expectation", '\u2130');
        put("exponentiale", '\u2147');
        put("ExponentialE", '\u2147');
        put("fallingdotseq", '\u2252');
        put("Fcy", '\u0424');
        put("fcy", '\u0444');
        put("female", '\u2640');
        put("ffilig", '\uFB03');
        put("fflig", '\uFB00');
        put("ffllig", '\uFB04');
        put("Ffr", '\uD835', '\uDD09');
        put("ffr", '\uD835', '\uDD23');
        put("filig", '\uFB01');
        put("FilledSmallSquare", '\u25FC');
        put("FilledVerySmallSquare", '\u25AA');
        put("fjlig", '\u0066', '\u006A');
        put("flat", '\u266D');
        put("fllig", '\uFB02');
        put("fltns", '\u25B1');
        put("fnof", '\u0192');
        put("Fopf", '\uD835', '\uDD3D');
        put("fopf", '\uD835', '\uDD57');
        put("forall", '\u2200');
        put("ForAll", '\u2200');
        put("fork", '\u22D4');
        put("forkv", '\u2AD9');
        put("Fouriertrf", '\u2131');
        put("fpartint", '\u2A0D');
        put("frac12", '\u00BD');
        put("frac13", '\u2153');
        put("frac14", '\u00BC');
        put("frac15", '\u2155');
        put("frac16", '\u2159');
        put("frac18", '\u215B');
        put("frac23", '\u2154');
        put("frac25", '\u2156');
        put("frac34", '\u00BE');
        put("frac35", '\u2157');
        put("frac38", '\u215C');
        put("frac45", '\u2158');
        put("frac56", '\u215A');
        put("frac58", '\u215D');
        put("frac78", '\u215E');
        put("frasl", '\u2044');
        put("frown", '\u2322');
        put("fscr", '\uD835', '\uDCBB');
        put("Fscr", '\u2131');
        put("gacute", '\u01F5');
        put("Gamma", '\u0393');
        put("gamma", '\u03B3');
        put("Gammad", '\u03DC');
        put("gammad", '\u03DD');
        put("gap", '\u2A86');
        put("Gbreve", '\u011E');
        put("gbreve", '\u011F');
        put("Gcedil", '\u0122');
        put("Gcirc", '\u011C');
        put("gcirc", '\u011D');
        put("Gcy", '\u0413');
        put("gcy", '\u0433');
        put("Gdot", '\u0120');
        put("gdot", '\u0121');
        put("ge", '\u2265');
        put("gE", '\u2267');
        put("gEl", '\u2A8C');
        put("gel", '\u22DB');
        put("geq", '\u2265');
        put("geqq", '\u2267');
        put("geqslant", '\u2A7E');
        put("gescc", '\u2AA9');
        put("ges", '\u2A7E');
        put("gesdot", '\u2A80');
        put("gesdoto", '\u2A82');
        put("gesdotol", '\u2A84');
        put("gesl", '\u22DB', '\uFE00');
        put("gesles", '\u2A94');
        put("Gfr", '\uD835', '\uDD0A');
        put("gfr", '\uD835', '\uDD24');
        put("gg", '\u226B');
        put("Gg", '\u22D9');
        put("ggg", '\u22D9');
        put("gimel", '\u2137');
        put("GJcy", '\u0403');
        put("gjcy", '\u0453');
        put("gla", '\u2AA5');
        put("gl", '\u2277');
        put("glE", '\u2A92');
        put("glj", '\u2AA4');
        put("gnap", '\u2A8A');
        put("gnapprox", '\u2A8A');
        put("gne", '\u2A88');
        put("gnE", '\u2269');
        put("gneq", '\u2A88');
        put("gneqq", '\u2269');
        put("gnsim", '\u22E7');
        put("Gopf", '\uD835', '\uDD3E');
        put("gopf", '\uD835', '\uDD58');
        put("grave", '\u0060');
        put("GreaterEqual", '\u2265');
        put("GreaterEqualLess", '\u22DB');
        put("GreaterFullEqual", '\u2267');
        put("GreaterGreater", '\u2AA2');
        put("GreaterLess", '\u2277');
        put("GreaterSlantEqual", '\u2A7E');
        put("GreaterTilde", '\u2273');
        put("Gscr", '\uD835', '\uDCA2');
        put("gscr", '\u210A');
        put("gsim", '\u2273');
        put("gsime", '\u2A8E');
        put("gsiml", '\u2A90');
        put("gtcc", '\u2AA7');
        put("gtcir", '\u2A7A');
        put("gt", '\u003E');
        put("GT", '\u003E');
        put("Gt", '\u226B');
        put("gtdot", '\u22D7');
        put("gtlPar", '\u2995');
        put("gtquest", '\u2A7C');
        put("gtrapprox", '\u2A86');
        put("gtrarr", '\u2978');
        put("gtrdot", '\u22D7');
        put("gtreqless", '\u22DB');
        put("gtreqqless", '\u2A8C');
        put("gtrless", '\u2277');
        put("gtrsim", '\u2273');
        put("gvertneqq", '\u2269', '\uFE00');
        put("gvnE", '\u2269', '\uFE00');
        put("Hacek", '\u02C7');
        put("hairsp", '\u200A');
        put("half", '\u00BD');
        put("hamilt", '\u210B');
        put("HARDcy", '\u042A');
        put("hardcy", '\u044A');
        put("harrcir", '\u2948');
        put("harr", '\u2194');
        put("hArr", '\u21D4');
        put("harrw", '\u21AD');
        put("Hat", '\u005E');
        put("hbar", '\u210F');
        put("Hcirc", '\u0124');
        put("hcirc", '\u0125');
        put("hearts", '\u2665');
        put("heartsuit", '\u2665');
        put("hellip", '\u2026');
        put("hercon", '\u22B9');
        put("hfr", '\uD835', '\uDD25');
        put("Hfr", '\u210C');
        put("HilbertSpace", '\u210B');
        put("hksearow", '\u2925');
        put("hkswarow", '\u2926');
        put("hoarr", '\u21FF');
        put("homtht", '\u223B');
        put("hookleftarrow", '\u21A9');
        put("hookrightarrow", '\u21AA');
        put("hopf", '\uD835', '\uDD59');
        put("Hopf", '\u210D');
        put("horbar", '\u2015');
        put("HorizontalLine", '\u2500');
        put("hscr", '\uD835', '\uDCBD');
        put("Hscr", '\u210B');
        put("hslash", '\u210F');
        put("Hstrok", '\u0126');
        put("hstrok", '\u0127');
        put("HumpDownHump", '\u224E');
        put("HumpEqual", '\u224F');
        put("hybull", '\u2043');
        put("hyphen", '\u2010');
        put("Iacute", '\u00CD');
        put("iacute", '\u00ED');
        put("ic", '\u2063');
        put("Icirc", '\u00CE');
        put("icirc", '\u00EE');
        put("Icy", '\u0418');
        put("icy", '\u0438');
        put("Idot", '\u0130');
        put("IEcy", '\u0415');
        put("iecy", '\u0435');
        put("iexcl", '\u00A1');
        put("iff", '\u21D4');
        put("ifr", '\uD835', '\uDD26');
        put("Ifr", '\u2111');
        put("Igrave", '\u00CC');
        put("igrave", '\u00EC');
        put("ii", '\u2148');
        put("iiiint", '\u2A0C');
        put("iiint", '\u222D');
        put("iinfin", '\u29DC');
        put("iiota", '\u2129');
        put("IJlig", '\u0132');
        put("ijlig", '\u0133');
        put("Imacr", '\u012A');
        put("imacr", '\u012B');
        put("image", '\u2111');
        put("ImaginaryI", '\u2148');
        put("imagline", '\u2110');
        put("imagpart", '\u2111');
        put("imath", '\u0131');
        put("Im", '\u2111');
        put("imof", '\u22B7');
        put("imped", '\u01B5');
        put("Implies", '\u21D2');
        put("incare", '\u2105');
        put("in", '\u2208');
        put("infin", '\u221E');
        put("infintie", '\u29DD');
        put("inodot", '\u0131');
        put("intcal", '\u22BA');
        put("int", '\u222B');
        put("Int", '\u222C');
        put("integers", '\u2124');
        put("Integral", '\u222B');
        put("intercal", '\u22BA');
        put("Intersection", '\u22C2');
        put("intlarhk", '\u2A17');
        put("intprod", '\u2A3C');
        put("InvisibleComma", '\u2063');
        put("InvisibleTimes", '\u2062');
        put("IOcy", '\u0401');
        put("iocy", '\u0451');
        put("Iogon", '\u012E');
        put("iogon", '\u012F');
        put("Iopf", '\uD835', '\uDD40');
        put("iopf", '\uD835', '\uDD5A');
        put("Iota", '\u0399');
        put("iota", '\u03B9');
        put("iprod", '\u2A3C');
        put("iquest", '\u00BF');
        put("iscr", '\uD835', '\uDCBE');
        put("Iscr", '\u2110');
        put("isin", '\u2208');
        put("isindot", '\u22F5');
        put("isinE", '\u22F9');
        put("isins", '\u22F4');
        put("isinsv", '\u22F3');
        put("isinv", '\u2208');
        put("it", '\u2062');
        put("Itilde", '\u0128');
        put("itilde", '\u0129');
        put("Iukcy", '\u0406');
        put("iukcy", '\u0456');
        put("Iuml", '\u00CF');
        put("iuml", '\u00EF');
        put("Jcirc", '\u0134');
        put("jcirc", '\u0135');
        put("Jcy", '\u0419');
        put("jcy", '\u0439');
        put("Jfr", '\uD835', '\uDD0D');
        put("jfr", '\uD835', '\uDD27');
        put("jmath", '\u0237');
        put("Jopf", '\uD835', '\uDD41');
        put("jopf", '\uD835', '\uDD5B');
        put("Jscr", '\uD835', '\uDCA5');
        put("jscr", '\uD835', '\uDCBF');
        put("Jsercy", '\u0408');
        put("jsercy", '\u0458');
        put("Jukcy", '\u0404');
        put("jukcy", '\u0454');
        put("Kappa", '\u039A');
        put("kappa", '\u03BA');
        put("kappav", '\u03F0');
        put("Kcedil", '\u0136');
        put("kcedil", '\u0137');
        put("Kcy", '\u041A');
        put("kcy", '\u043A');
        put("Kfr", '\uD835', '\uDD0E');
        put("kfr", '\uD835', '\uDD28');
        put("kgreen", '\u0138');
        put("KHcy", '\u0425');
        put("khcy", '\u0445');
        put("KJcy", '\u040C');
        put("kjcy", '\u045C');
        put("Kopf", '\uD835', '\uDD42');
        put("kopf", '\uD835', '\uDD5C');
        put("Kscr", '\uD835', '\uDCA6');
        put("kscr", '\uD835', '\uDCC0');
        put("lAarr", '\u21DA');
        put("Lacute", '\u0139');
        put("lacute", '\u013A');
        put("laemptyv", '\u29B4');
        put("lagran", '\u2112');
        put("Lambda", '\u039B');
        put("lambda", '\u03BB');
        put("lang", '\u27E8');
        put("Lang", '\u27EA');
        put("langd", '\u2991');
        put("langle", '\u27E8');
        put("lap", '\u2A85');
        put("Laplacetrf", '\u2112');
        put("laquo", '\u00AB');
        put("larrb", '\u21E4');
        put("larrbfs", '\u291F');
        put("larr", '\u2190');
        put("Larr", '\u219E');
        put("lArr", '\u21D0');
        put("larrfs", '\u291D');
        put("larrhk", '\u21A9');
        put("larrlp", '\u21AB');
        put("larrpl", '\u2939');
        put("larrsim", '\u2973');
        put("larrtl", '\u21A2');
        put("latail", '\u2919');
        put("lAtail", '\u291B');
        put("lat", '\u2AAB');
        put("late", '\u2AAD');
        put("lates", '\u2AAD', '\uFE00');
        put("lbarr", '\u290C');
        put("lBarr", '\u290E');
        put("lbbrk", '\u2772');
        put("lbrace", '\u007B');
        put("lbrack", '\u005B');
        put("lbrke", '\u298B');
        put("lbrksld", '\u298F');
        put("lbrkslu", '\u298D');
        put("Lcaron", '\u013D');
        put("lcaron", '\u013E');
        put("Lcedil", '\u013B');
        put("lcedil", '\u013C');
        put("lceil", '\u2308');
        put("lcub", '\u007B');
        put("Lcy", '\u041B');
        put("lcy", '\u043B');
        put("ldca", '\u2936');
        put("ldquo", '\u201C');
        put("ldquor", '\u201E');
        put("ldrdhar", '\u2967');
        put("ldrushar", '\u294B');
        put("ldsh", '\u21B2');
        put("le", '\u2264');
        put("lE", '\u2266');
        put("LeftAngleBracket", '\u27E8');
        put("LeftArrowBar", '\u21E4');
        put("leftarrow", '\u2190');
        put("LeftArrow", '\u2190');
        put("Leftarrow", '\u21D0');
        put("LeftArrowRightArrow", '\u21C6');
        put("leftarrowtail", '\u21A2');
        put("LeftCeiling", '\u2308');
        put("LeftDoubleBracket", '\u27E6');
        put("LeftDownTeeVector", '\u2961');
        put("LeftDownVectorBar", '\u2959');
        put("LeftDownVector", '\u21C3');
        put("LeftFloor", '\u230A');
        put("leftharpoondown", '\u21BD');
        put("leftharpoonup", '\u21BC');
        put("leftleftarrows", '\u21C7');
        put("leftrightarrow", '\u2194');
        put("LeftRightArrow", '\u2194');
        put("Leftrightarrow", '\u21D4');
        put("leftrightarrows", '\u21C6');
        put("leftrightharpoons", '\u21CB');
        put("leftrightsquigarrow", '\u21AD');
        put("LeftRightVector", '\u294E');
        put("LeftTeeArrow", '\u21A4');
        put("LeftTee", '\u22A3');
        put("LeftTeeVector", '\u295A');
        put("leftthreetimes", '\u22CB');
        put("LeftTriangleBar", '\u29CF');
        put("LeftTriangle", '\u22B2');
        put("LeftTriangleEqual", '\u22B4');
        put("LeftUpDownVector", '\u2951');
        put("LeftUpTeeVector", '\u2960');
        put("LeftUpVectorBar", '\u2958');
        put("LeftUpVector", '\u21BF');
        put("LeftVectorBar", '\u2952');
        put("LeftVector", '\u21BC');
        put("lEg", '\u2A8B');
        put("leg", '\u22DA');
        put("leq", '\u2264');
        put("leqq", '\u2266');
        put("leqslant", '\u2A7D');
        put("lescc", '\u2AA8');
        put("les", '\u2A7D');
        put("lesdot", '\u2A7F');
        put("lesdoto", '\u2A81');
        put("lesdotor", '\u2A83');
        put("lesg", '\u22DA', '\uFE00');
        put("lesges", '\u2A93');
        put("lessapprox", '\u2A85');
        put("lessdot", '\u22D6');
        put("lesseqgtr", '\u22DA');
        put("lesseqqgtr", '\u2A8B');
        put("LessEqualGreater", '\u22DA');
        put("LessFullEqual", '\u2266');
        put("LessGreater", '\u2276');
        put("lessgtr", '\u2276');
        put("LessLess", '\u2AA1');
        put("lesssim", '\u2272');
        put("LessSlantEqual", '\u2A7D');
        put("LessTilde", '\u2272');
        put("lfisht", '\u297C');
        put("lfloor", '\u230A');
        put("Lfr", '\uD835', '\uDD0F');
        put("lfr", '\uD835', '\uDD29');
        put("lg", '\u2276');
        put("lgE", '\u2A91');
        put("lHar", '\u2962');
        put("lhard", '\u21BD');
        put("lharu", '\u21BC');
        put("lharul", '\u296A');
        put("lhblk", '\u2584');
        put("LJcy", '\u0409');
        put("ljcy", '\u0459');
        put("llarr", '\u21C7');
        put("ll", '\u226A');
        put("Ll", '\u22D8');
        put("llcorner", '\u231E');
        put("Lleftarrow", '\u21DA');
        put("llhard", '\u296B');
        put("lltri", '\u25FA');
        put("Lmidot", '\u013F');
        put("lmidot", '\u0140');
        put("lmoustache", '\u23B0');
        put("lmoust", '\u23B0');
        put("lnap", '\u2A89');
        put("lnapprox", '\u2A89');
        put("lne", '\u2A87');
        put("lnE", '\u2268');
        put("lneq", '\u2A87');
        put("lneqq", '\u2268');
        put("lnsim", '\u22E6');
        put("loang", '\u27EC');
        put("loarr", '\u21FD');
        put("lobrk", '\u27E6');
        put("longleftarrow", '\u27F5');
        put("LongLeftArrow", '\u27F5');
        put("Longleftarrow", '\u27F8');
        put("longleftrightarrow", '\u27F7');
        put("LongLeftRightArrow", '\u27F7');
        put("Longleftrightarrow", '\u27FA');
        put("longmapsto", '\u27FC');
        put("longrightarrow", '\u27F6');
        put("LongRightArrow", '\u27F6');
        put("Longrightarrow", '\u27F9');
        put("looparrowleft", '\u21AB');
        put("looparrowright", '\u21AC');
        put("lopar", '\u2985');
        put("Lopf", '\uD835', '\uDD43');
        put("lopf", '\uD835', '\uDD5D');
        put("loplus", '\u2A2D');
        put("lotimes", '\u2A34');
        put("lowast", '\u2217');
        put("lowbar", '\u005F');
        put("LowerLeftArrow", '\u2199');
        put("LowerRightArrow", '\u2198');
        put("loz", '\u25CA');
        put("lozenge", '\u25CA');
        put("lozf", '\u29EB');
        put("lpar", '\u0028');
        put("lparlt", '\u2993');
        put("lrarr", '\u21C6');
        put("lrcorner", '\u231F');
        put("lrhar", '\u21CB');
        put("lrhard", '\u296D');
        put("lrm", '\u200E');
        put("lrtri", '\u22BF');
        put("lsaquo", '\u2039');
        put("lscr", '\uD835', '\uDCC1');
        put("Lscr", '\u2112');
        put("lsh", '\u21B0');
        put("Lsh", '\u21B0');
        put("lsim", '\u2272');
        put("lsime", '\u2A8D');
        put("lsimg", '\u2A8F');
        put("lsqb", '\u005B');
        put("lsquo", '\u2018');
        put("lsquor", '\u201A');
        put("Lstrok", '\u0141');
        put("lstrok", '\u0142');
        put("ltcc", '\u2AA6');
        put("ltcir", '\u2A79');
        put("lt", '\u003C');
        put("LT", '\u003C');
        put("Lt", '\u226A');
        put("ltdot", '\u22D6');
        put("lthree", '\u22CB');
        put("ltimes", '\u22C9');
        put("ltlarr", '\u2976');
        put("ltquest", '\u2A7B');
        put("ltri", '\u25C3');
        put("ltrie", '\u22B4');
        put("ltrif", '\u25C2');
        put("ltrPar", '\u2996');
        put("lurdshar", '\u294A');
        put("luruhar", '\u2966');
        put("lvertneqq", '\u2268', '\uFE00');
        put("lvnE", '\u2268', '\uFE00');
        put("macr", '\u00AF');
        put("male", '\u2642');
        put("malt", '\u2720');
        put("maltese", '\u2720');
        put("Map", '\u2905');
        put("map", '\u21A6');
        put("mapsto", '\u21A6');
        put("mapstodown", '\u21A7');
        put("mapstoleft", '\u21A4');
        put("mapstoup", '\u21A5');
        put("marker", '\u25AE');
        put("mcomma", '\u2A29');
        put("Mcy", '\u041C');
        put("mcy", '\u043C');
        put("mdash", '\u2014');
        put("mDDot", '\u223A');
        put("measuredangle", '\u2221');
        put("MediumSpace", '\u205F');
        put("Mellintrf", '\u2133');
        put("Mfr", '\uD835', '\uDD10');
        put("mfr", '\uD835', '\uDD2A');
        put("mho", '\u2127');
        put("micro", '\u00B5');
        put("midast", '\u002A');
        put("midcir", '\u2AF0');
        put("mid", '\u2223');
        put("middot", '\u00B7');
        put("minusb", '\u229F');
        put("minus", '\u2212');
        put("minusd", '\u2238');
        put("minusdu", '\u2A2A');
        put("MinusPlus", '\u2213');
        put("mlcp", '\u2ADB');
        put("mldr", '\u2026');
        put("mnplus", '\u2213');
        put("models", '\u22A7');
        put("Mopf", '\uD835', '\uDD44');
        put("mopf", '\uD835', '\uDD5E');
        put("mp", '\u2213');
        put("mscr", '\uD835', '\uDCC2');
        put("Mscr", '\u2133');
        put("mstpos", '\u223E');
        put("Mu", '\u039C');
        put("mu", '\u03BC');
        put("multimap", '\u22B8');
        put("mumap", '\u22B8');
        put("nabla", '\u2207');
        put("Nacute", '\u0143');
        put("nacute", '\u0144');
        put("nang", '\u2220', '\u20D2');
        put("nap", '\u2249');
        put("napE", '\u2A70', '\u0338');
        put("napid", '\u224B', '\u0338');
        put("napos", '\u0149');
        put("napprox", '\u2249');
        put("natural", '\u266E');
        put("naturals", '\u2115');
        put("natur", '\u266E');
        put("nbsp", '\u00A0');
        put("nbump", '\u224E', '\u0338');
        put("nbumpe", '\u224F', '\u0338');
        put("ncap", '\u2A43');
        put("Ncaron", '\u0147');
        put("ncaron", '\u0148');
        put("Ncedil", '\u0145');
        put("ncedil", '\u0146');
        put("ncong", '\u2247');
        put("ncongdot", '\u2A6D', '\u0338');
        put("ncup", '\u2A42');
        put("Ncy", '\u041D');
        put("ncy", '\u043D');
        put("ndash", '\u2013');
        put("nearhk", '\u2924');
        put("nearr", '\u2197');
        put("neArr", '\u21D7');
        put("nearrow", '\u2197');
        put("ne", '\u2260');
        put("nedot", '\u2250', '\u0338');
        put("NegativeMediumSpace", '\u200B');
        put("NegativeThickSpace", '\u200B');
        put("NegativeThinSpace", '\u200B');
        put("NegativeVeryThinSpace", '\u200B');
        put("nequiv", '\u2262');
        put("nesear", '\u2928');
        put("nesim", '\u2242', '\u0338');
        put("NestedGreaterGreater", '\u226B');
        put("NestedLessLess", '\u226A');
        put("NewLine", '\n');
        put("nexist", '\u2204');
        put("nexists", '\u2204');
        put("Nfr", '\uD835', '\uDD11');
        put("nfr", '\uD835', '\uDD2B');
        put("ngE", '\u2267', '\u0338');
        put("nge", '\u2271');
        put("ngeq", '\u2271');
        put("ngeqq", '\u2267', '\u0338');
        put("ngeqslant", '\u2A7E', '\u0338');
        put("nges", '\u2A7E', '\u0338');
        put("nGg", '\u22D9', '\u0338');
        put("ngsim", '\u2275');
        put("nGt", '\u226B', '\u20D2');
        put("ngt", '\u226F');
        put("ngtr", '\u226F');
        put("nGtv", '\u226B', '\u0338');
        put("nharr", '\u21AE');
        put("nhArr", '\u21CE');
        put("nhpar", '\u2AF2');
        put("ni", '\u220B');
        put("nis", '\u22FC');
        put("nisd", '\u22FA');
        put("niv", '\u220B');
        put("NJcy", '\u040A');
        put("njcy", '\u045A');
        put("nlarr", '\u219A');
        put("nlArr", '\u21CD');
        put("nldr", '\u2025');
        put("nlE", '\u2266', '\u0338');
        put("nle", '\u2270');
        put("nleftarrow", '\u219A');
        put("nLeftarrow", '\u21CD');
        put("nleftrightarrow", '\u21AE');
        put("nLeftrightarrow", '\u21CE');
        put("nleq", '\u2270');
        put("nleqq", '\u2266', '\u0338');
        put("nleqslant", '\u2A7D', '\u0338');
        put("nles", '\u2A7D', '\u0338');
        put("nless", '\u226E');
        put("nLl", '\u22D8', '\u0338');
        put("nlsim", '\u2274');
        put("nLt", '\u226A', '\u20D2');
        put("nlt", '\u226E');
        put("nltri", '\u22EA');
        put("nltrie", '\u22EC');
        put("nLtv", '\u226A', '\u0338');
        put("nmid", '\u2224');
        put("NoBreak", '\u2060');
        put("NonBreakingSpace", '\u00A0');
        put("nopf", '\uD835', '\uDD5F');
        put("Nopf", '\u2115');
        put("Not", '\u2AEC');
        put("not", '\u00AC');
        put("NotCongruent", '\u2262');
        put("NotCupCap", '\u226D');
        put("NotDoubleVerticalBar", '\u2226');
        put("NotElement", '\u2209');
        put("NotEqual", '\u2260');
        put("NotEqualTilde", '\u2242', '\u0338');
        put("NotExists", '\u2204');
        put("NotGreater", '\u226F');
        put("NotGreaterEqual", '\u2271');
        put("NotGreaterFullEqual", '\u2267', '\u0338');
        put("NotGreaterGreater", '\u226B', '\u0338');
        put("NotGreaterLess", '\u2279');
        put("NotGreaterSlantEqual", '\u2A7E', '\u0338');
        put("NotGreaterTilde", '\u2275');
        put("NotHumpDownHump", '\u224E', '\u0338');
        put("NotHumpEqual", '\u224F', '\u0338');
        put("notin", '\u2209');
        put("notindot", '\u22F5', '\u0338');
        put("notinE", '\u22F9', '\u0338');
        put("notinva", '\u2209');
        put("notinvb", '\u22F7');
        put("notinvc", '\u22F6');
        put("NotLeftTriangleBar", '\u29CF', '\u0338');
        put("NotLeftTriangle", '\u22EA');
        put("NotLeftTriangleEqual", '\u22EC');
        put("NotLess", '\u226E');
        put("NotLessEqual", '\u2270');
        put("NotLessGreater", '\u2278');
        put("NotLessLess", '\u226A', '\u0338');
        put("NotLessSlantEqual", '\u2A7D', '\u0338');
        put("NotLessTilde", '\u2274');
        put("NotNestedGreaterGreater", '\u2AA2', '\u0338');
        put("NotNestedLessLess", '\u2AA1', '\u0338');
        put("notni", '\u220C');
        put("notniva", '\u220C');
        put("notnivb", '\u22FE');
        put("notnivc", '\u22FD');
        put("NotPrecedes", '\u2280');
        put("NotPrecedesEqual", '\u2AAF', '\u0338');
        put("NotPrecedesSlantEqual", '\u22E0');
        put("NotReverseElement", '\u220C');
        put("NotRightTriangleBar", '\u29D0', '\u0338');
        put("NotRightTriangle", '\u22EB');
        put("NotRightTriangleEqual", '\u22ED');
        put("NotSquareSubset", '\u228F', '\u0338');
        put("NotSquareSubsetEqual", '\u22E2');
        put("NotSquareSuperset", '\u2290', '\u0338');
        put("NotSquareSupersetEqual", '\u22E3');
        put("NotSubset", '\u2282', '\u20D2');
        put("NotSubsetEqual", '\u2288');
        put("NotSucceeds", '\u2281');
        put("NotSucceedsEqual", '\u2AB0', '\u0338');
        put("NotSucceedsSlantEqual", '\u22E1');
        put("NotSucceedsTilde", '\u227F', '\u0338');
        put("NotSuperset", '\u2283', '\u20D2');
        put("NotSupersetEqual", '\u2289');
        put("NotTilde", '\u2241');
        put("NotTildeEqual", '\u2244');
        put("NotTildeFullEqual", '\u2247');
        put("NotTildeTilde", '\u2249');
        put("NotVerticalBar", '\u2224');
        put("nparallel", '\u2226');
        put("npar", '\u2226');
        put("nparsl", '\u2AFD', '\u20E5');
        put("npart", '\u2202', '\u0338');
        put("npolint", '\u2A14');
        put("npr", '\u2280');
        put("nprcue", '\u22E0');
        put("nprec", '\u2280');
        put("npreceq", '\u2AAF', '\u0338');
        put("npre", '\u2AAF', '\u0338');
        put("nrarrc", '\u2933', '\u0338');
        put("nrarr", '\u219B');
        put("nrArr", '\u21CF');
        put("nrarrw", '\u219D', '\u0338');
        put("nrightarrow", '\u219B');
        put("nRightarrow", '\u21CF');
        put("nrtri", '\u22EB');
        put("nrtrie", '\u22ED');
        put("nsc", '\u2281');
        put("nsccue", '\u22E1');
        put("nsce", '\u2AB0', '\u0338');
        put("Nscr", '\uD835', '\uDCA9');
        put("nscr", '\uD835', '\uDCC3');
        put("nshortmid", '\u2224');
        put("nshortparallel", '\u2226');
        put("nsim", '\u2241');
        put("nsime", '\u2244');
        put("nsimeq", '\u2244');
        put("nsmid", '\u2224');
        put("nspar", '\u2226');
        put("nsqsube", '\u22E2');
        put("nsqsupe", '\u22E3');
        put("nsub", '\u2284');
        put("nsubE", '\u2AC5', '\u0338');
        put("nsube", '\u2288');
        put("nsubset", '\u2282', '\u20D2');
        put("nsubseteq", '\u2288');
        put("nsubseteqq", '\u2AC5', '\u0338');
        put("nsucc", '\u2281');
        put("nsucceq", '\u2AB0', '\u0338');
        put("nsup", '\u2285');
        put("nsupE", '\u2AC6', '\u0338');
        put("nsupe", '\u2289');
        put("nsupset", '\u2283', '\u20D2');
        put("nsupseteq", '\u2289');
        put("nsupseteqq", '\u2AC6', '\u0338');
        put("ntgl", '\u2279');
        put("Ntilde", '\u00D1');
        put("ntilde", '\u00F1');
        put("ntlg", '\u2278');
        put("ntriangleleft", '\u22EA');
        put("ntrianglelefteq", '\u22EC');
        put("ntriangleright", '\u22EB');
        put("ntrianglerighteq", '\u22ED');
        put("Nu", '\u039D');
        put("nu", '\u03BD');
        put("num", '\u0023');
        put("numero", '\u2116');
        put("numsp", '\u2007');
        put("nvap", '\u224D', '\u20D2');
        put("nvdash", '\u22AC');
        put("nvDash", '\u22AD');
        put("nVdash", '\u22AE');
        put("nVDash", '\u22AF');
        put("nvge", '\u2265', '\u20D2');
        put("nvgt", '\u003E', '\u20D2');
        put("nvHarr", '\u2904');
        put("nvinfin", '\u29DE');
        put("nvlArr", '\u2902');
        put("nvle", '\u2264', '\u20D2');
        put("nvlt", '\u003C', '\u20D2');
        put("nvltrie", '\u22B4', '\u20D2');
        put("nvrArr", '\u2903');
        put("nvrtrie", '\u22B5', '\u20D2');
        put("nvsim", '\u223C', '\u20D2');
        put("nwarhk", '\u2923');
        put("nwarr", '\u2196');
        put("nwArr", '\u21D6');
        put("nwarrow", '\u2196');
        put("nwnear", '\u2927');
        put("Oacute", '\u00D3');
        put("oacute", '\u00F3');
        put("oast", '\u229B');
        put("Ocirc", '\u00D4');
        put("ocirc", '\u00F4');
        put("ocir", '\u229A');
        put("Ocy", '\u041E');
        put("ocy", '\u043E');
        put("odash", '\u229D');
        put("Odblac", '\u0150');
        put("odblac", '\u0151');
        put("odiv", '\u2A38');
        put("odot", '\u2299');
        put("odsold", '\u29BC');
        put("OElig", '\u0152');
        put("oelig", '\u0153');
        put("ofcir", '\u29BF');
        put("Ofr", '\uD835', '\uDD12');
        put("ofr", '\uD835', '\uDD2C');
        put("ogon", '\u02DB');
        put("Ograve", '\u00D2');
        put("ograve", '\u00F2');
        put("ogt", '\u29C1');
        put("ohbar", '\u29B5');
        put("ohm", '\u03A9');
        put("oint", '\u222E');
        put("olarr", '\u21BA');
        put("olcir", '\u29BE');
        put("olcross", '\u29BB');
        put("oline", '\u203E');
        put("olt", '\u29C0');
        put("Omacr", '\u014C');
        put("omacr", '\u014D');
        put("Omega", '\u03A9');
        put("omega", '\u03C9');
        put("Omicron", '\u039F');
        put("omicron", '\u03BF');
        put("omid", '\u29B6');
        put("ominus", '\u2296');
        put("Oopf", '\uD835', '\uDD46');
        put("oopf", '\uD835', '\uDD60');
        put("opar", '\u29B7');
        put("OpenCurlyDoubleQuote", '\u201C');
        put("OpenCurlyQuote", '\u2018');
        put("operp", '\u29B9');
        put("oplus", '\u2295');
        put("orarr", '\u21BB');
        put("Or", '\u2A54');
        put("or", '\u2228');
        put("ord", '\u2A5D');
        put("order", '\u2134');
        put("orderof", '\u2134');
        put("ordf", '\u00AA');
        put("ordm", '\u00BA');
        put("origof", '\u22B6');
        put("oror", '\u2A56');
        put("orslope", '\u2A57');
        put("orv", '\u2A5B');
        put("oS", '\u24C8');
        put("Oscr", '\uD835', '\uDCAA');
        put("oscr", '\u2134');
        put("Oslash", '\u00D8');
        put("oslash", '\u00F8');
        put("osol", '\u2298');
        put("Otilde", '\u00D5');
        put("otilde", '\u00F5');
        put("otimesas", '\u2A36');
        put("Otimes", '\u2A37');
        put("otimes", '\u2297');
        put("Ouml", '\u00D6');
        put("ouml", '\u00F6');
        put("ovbar", '\u233D');
        put("OverBar", '\u203E');
        put("OverBrace", '\u23DE');
        put("OverBracket", '\u23B4');
        put("OverParenthesis", '\u23DC');
        put("para", '\u00B6');
        put("parallel", '\u2225');
        put("par", '\u2225');
        put("parsim", '\u2AF3');
        put("parsl", '\u2AFD');
        put("part", '\u2202');
        put("PartialD", '\u2202');
        put("Pcy", '\u041F');
        put("pcy", '\u043F');
        put("percnt", '\u0025');
        put("period", '\u002E');
        put("permil", '\u2030');
        put("perp", '\u22A5');
        put("pertenk", '\u2031');
        put("Pfr", '\uD835', '\uDD13');
        put("pfr", '\uD835', '\uDD2D');
        put("Phi", '\u03A6');
        put("phi", '\u03C6');
        put("phiv", '\u03D5');
        put("phmmat", '\u2133');
        put("phone", '\u260E');
        put("Pi", '\u03A0');
        put("pi", '\u03C0');
        put("pitchfork", '\u22D4');
        put("piv", '\u03D6');
        put("planck", '\u210F');
        put("planckh", '\u210E');
        put("plankv", '\u210F');
        put("plusacir", '\u2A23');
        put("plusb", '\u229E');
        put("pluscir", '\u2A22');
        put("plus", '\u002B');
        put("plusdo", '\u2214');
        put("plusdu", '\u2A25');
        put("pluse", '\u2A72');
        put("PlusMinus", '\u00B1');
        put("plusmn", '\u00B1');
        put("plussim", '\u2A26');
        put("plustwo", '\u2A27');
        put("pm", '\u00B1');
        put("Poincareplane", '\u210C');
        put("pointint", '\u2A15');
        put("popf", '\uD835', '\uDD61');
        put("Popf", '\u2119');
        put("pound", '\u00A3');
        put("prap", '\u2AB7');
        put("Pr", '\u2ABB');
        put("pr", '\u227A');
        put("prcue", '\u227C');
        put("precapprox", '\u2AB7');
        put("prec", '\u227A');
        put("preccurlyeq", '\u227C');
        put("Precedes", '\u227A');
        put("PrecedesEqual", '\u2AAF');
        put("PrecedesSlantEqual", '\u227C');
        put("PrecedesTilde", '\u227E');
        put("preceq", '\u2AAF');
        put("precnapprox", '\u2AB9');
        put("precneqq", '\u2AB5');
        put("precnsim", '\u22E8');
        put("pre", '\u2AAF');
        put("prE", '\u2AB3');
        put("precsim", '\u227E');
        put("prime", '\u2032');
        put("Prime", '\u2033');
        put("primes", '\u2119');
        put("prnap", '\u2AB9');
        put("prnE", '\u2AB5');
        put("prnsim", '\u22E8');
        put("prod", '\u220F');
        put("Product", '\u220F');
        put("profalar", '\u232E');
        put("profline", '\u2312');
        put("profsurf", '\u2313');
        put("prop", '\u221D');
        put("Proportional", '\u221D');
        put("Proportion", '\u2237');
        put("propto", '\u221D');
        put("prsim", '\u227E');
        put("prurel", '\u22B0');
        put("Pscr", '\uD835', '\uDCAB');
        put("pscr", '\uD835', '\uDCC5');
        put("Psi", '\u03A8');
        put("psi", '\u03C8');
        put("puncsp", '\u2008');
        put("Qfr", '\uD835', '\uDD14');
        put("qfr", '\uD835', '\uDD2E');
        put("qint", '\u2A0C');
        put("qopf", '\uD835', '\uDD62');
        put("Qopf", '\u211A');
        put("qprime", '\u2057');
        put("Qscr", '\uD835', '\uDCAC');
        put("qscr", '\uD835', '\uDCC6');
        put("quaternions", '\u210D');
        put("quatint", '\u2A16');
        put("quest", '\u003F');
        put("questeq", '\u225F');
        put("quot", '\"');
        put("QUOT", '\"');
        put("rAarr", '\u21DB');
        put("race", '\u223D', '\u0331');
        put("Racute", '\u0154');
        put("racute", '\u0155');
        put("radic", '\u221A');
        put("raemptyv", '\u29B3');
        put("rang", '\u27E9');
        put("Rang", '\u27EB');
        put("rangd", '\u2992');
        put("range", '\u29A5');
        put("rangle", '\u27E9');
        put("raquo", '\u00BB');
        put("rarrap", '\u2975');
        put("rarrb", '\u21E5');
        put("rarrbfs", '\u2920');
        put("rarrc", '\u2933');
        put("rarr", '\u2192');
        put("Rarr", '\u21A0');
        put("rArr", '\u21D2');
        put("rarrfs", '\u291E');
        put("rarrhk", '\u21AA');
        put("rarrlp", '\u21AC');
        put("rarrpl", '\u2945');
        put("rarrsim", '\u2974');
        put("Rarrtl", '\u2916');
        put("rarrtl", '\u21A3');
        put("rarrw", '\u219D');
        put("ratail", '\u291A');
        put("rAtail", '\u291C');
        put("ratio", '\u2236');
        put("rationals", '\u211A');
        put("rbarr", '\u290D');
        put("rBarr", '\u290F');
        put("RBarr", '\u2910');
        put("rbbrk", '\u2773');
        put("rbrace", '\u007D');
        put("rbrack", '\u005D');
        put("rbrke", '\u298C');
        put("rbrksld", '\u298E');
        put("rbrkslu", '\u2990');
        put("Rcaron", '\u0158');
        put("rcaron", '\u0159');
        put("Rcedil", '\u0156');
        put("rcedil", '\u0157');
        put("rceil", '\u2309');
        put("rcub", '\u007D');
        put("Rcy", '\u0420');
        put("rcy", '\u0440');
        put("rdca", '\u2937');
        put("rdldhar", '\u2969');
        put("rdquo", '\u201D');
        put("rdquor", '\u201D');
        put("rdsh", '\u21B3');
        put("real", '\u211C');
        put("realine", '\u211B');
        put("realpart", '\u211C');
        put("reals", '\u211D');
        put("Re", '\u211C');
        put("rect", '\u25AD');
        put("reg", '\u00AE');
        put("REG", '\u00AE');
        put("ReverseElement", '\u220B');
        put("ReverseEquilibrium", '\u21CB');
        put("ReverseUpEquilibrium", '\u296F');
        put("rfisht", '\u297D');
        put("rfloor", '\u230B');
        put("rfr", '\uD835', '\uDD2F');
        put("Rfr", '\u211C');
        put("rHar", '\u2964');
        put("rhard", '\u21C1');
        put("rharu", '\u21C0');
        put("rharul", '\u296C');
        put("Rho", '\u03A1');
        put("rho", '\u03C1');
        put("rhov", '\u03F1');
        put("RightAngleBracket", '\u27E9');
        put("RightArrowBar", '\u21E5');
        put("rightarrow", '\u2192');
        put("RightArrow", '\u2192');
        put("Rightarrow", '\u21D2');
        put("RightArrowLeftArrow", '\u21C4');
        put("rightarrowtail", '\u21A3');
        put("RightCeiling", '\u2309');
        put("RightDoubleBracket", '\u27E7');
        put("RightDownTeeVector", '\u295D');
        put("RightDownVectorBar", '\u2955');
        put("RightDownVector", '\u21C2');
        put("RightFloor", '\u230B');
        put("rightharpoondown", '\u21C1');
        put("rightharpoonup", '\u21C0');
        put("rightleftarrows", '\u21C4');
        put("rightleftharpoons", '\u21CC');
        put("rightrightarrows", '\u21C9');
        put("rightsquigarrow", '\u219D');
        put("RightTeeArrow", '\u21A6');
        put("RightTee", '\u22A2');
        put("RightTeeVector", '\u295B');
        put("rightthreetimes", '\u22CC');
        put("RightTriangleBar", '\u29D0');
        put("RightTriangle", '\u22B3');
        put("RightTriangleEqual", '\u22B5');
        put("RightUpDownVector", '\u294F');
        put("RightUpTeeVector", '\u295C');
        put("RightUpVectorBar", '\u2954');
        put("RightUpVector", '\u21BE');
        put("RightVectorBar", '\u2953');
        put("RightVector", '\u21C0');
        put("ring", '\u02DA');
        put("risingdotseq", '\u2253');
        put("rlarr", '\u21C4');
        put("rlhar", '\u21CC');
        put("rlm", '\u200F');
        put("rmoustache", '\u23B1');
        put("rmoust", '\u23B1');
        put("rnmid", '\u2AEE');
        put("roang", '\u27ED');
        put("roarr", '\u21FE');
        put("robrk", '\u27E7');
        put("ropar", '\u2986');
        put("ropf", '\uD835', '\uDD63');
        put("Ropf", '\u211D');
        put("roplus", '\u2A2E');
        put("rotimes", '\u2A35');
        put("RoundImplies", '\u2970');
        put("rpar", '\u0029');
        put("rpargt", '\u2994');
        put("rppolint", '\u2A12');
        put("rrarr", '\u21C9');
        put("Rrightarrow", '\u21DB');
        put("rsaquo", '\u203A');
        put("rscr", '\uD835', '\uDCC7');
        put("Rscr", '\u211B');
        put("rsh", '\u21B1');
        put("Rsh", '\u21B1');
        put("rsqb", '\u005D');
        put("rsquo", '\u2019');
        put("rsquor", '\u2019');
        put("rthree", '\u22CC');
        put("rtimes", '\u22CA');
        put("rtri", '\u25B9');
        put("rtrie", '\u22B5');
        put("rtrif", '\u25B8');
        put("rtriltri", '\u29CE');
        put("RuleDelayed", '\u29F4');
        put("ruluhar", '\u2968');
        put("rx", '\u211E');
        put("Sacute", '\u015A');
        put("sacute", '\u015B');
        put("sbquo", '\u201A');
        put("scap", '\u2AB8');
        put("Scaron", '\u0160');
        put("scaron", '\u0161');
        put("Sc", '\u2ABC');
        put("sc", '\u227B');
        put("sccue", '\u227D');
        put("sce", '\u2AB0');
        put("scE", '\u2AB4');
        put("Scedil", '\u015E');
        put("scedil", '\u015F');
        put("Scirc", '\u015C');
        put("scirc", '\u015D');
        put("scnap", '\u2ABA');
        put("scnE", '\u2AB6');
        put("scnsim", '\u22E9');
        put("scpolint", '\u2A13');
        put("scsim", '\u227F');
        put("Scy", '\u0421');
        put("scy", '\u0441');
        put("sdotb", '\u22A1');
        put("sdot", '\u22C5');
        put("sdote", '\u2A66');
        put("searhk", '\u2925');
        put("searr", '\u2198');
        put("seArr", '\u21D8');
        put("searrow", '\u2198');
        put("sect", '\u00A7');
        put("semi", '\u003B');
        put("seswar", '\u2929');
        put("setminus", '\u2216');
        put("setmn", '\u2216');
        put("sext", '\u2736');
        put("Sfr", '\uD835', '\uDD16');
        put("sfr", '\uD835', '\uDD30');
        put("sfrown", '\u2322');
        put("sharp", '\u266F');
        put("SHCHcy", '\u0429');
        put("shchcy", '\u0449');
        put("SHcy", '\u0428');
        put("shcy", '\u0448');
        put("ShortDownArrow", '\u2193');
        put("ShortLeftArrow", '\u2190');
        put("shortmid", '\u2223');
        put("shortparallel", '\u2225');
        put("ShortRightArrow", '\u2192');
        put("ShortUpArrow", '\u2191');
        put("shy", '\u00AD');
        put("Sigma", '\u03A3');
        put("sigma", '\u03C3');
        put("sigmaf", '\u03C2');
        put("sigmav", '\u03C2');
        put("sim", '\u223C');
        put("simdot", '\u2A6A');
        put("sime", '\u2243');
        put("simeq", '\u2243');
        put("simg", '\u2A9E');
        put("simgE", '\u2AA0');
        put("siml", '\u2A9D');
        put("simlE", '\u2A9F');
        put("simne", '\u2246');
        put("simplus", '\u2A24');
        put("simrarr", '\u2972');
        put("slarr", '\u2190');
        put("SmallCircle", '\u2218');
        put("smallsetminus", '\u2216');
        put("smashp", '\u2A33');
        put("smeparsl", '\u29E4');
        put("smid", '\u2223');
        put("smile", '\u2323');
        put("smt", '\u2AAA');
        put("smte", '\u2AAC');
        put("smtes", '\u2AAC', '\uFE00');
        put("SOFTcy", '\u042C');
        put("softcy", '\u044C');
        put("solbar", '\u233F');
        put("solb", '\u29C4');
        put("sol", '\u002F');
        put("Sopf", '\uD835', '\uDD4A');
        put("sopf", '\uD835', '\uDD64');
        put("spades", '\u2660');
        put("spadesuit", '\u2660');
        put("spar", '\u2225');
        put("sqcap", '\u2293');
        put("sqcaps", '\u2293', '\uFE00');
        put("sqcup", '\u2294');
        put("sqcups", '\u2294', '\uFE00');
        put("Sqrt", '\u221A');
        put("sqsub", '\u228F');
        put("sqsube", '\u2291');
        put("sqsubset", '\u228F');
        put("sqsubseteq", '\u2291');
        put("sqsup", '\u2290');
        put("sqsupe", '\u2292');
        put("sqsupset", '\u2290');
        put("sqsupseteq", '\u2292');
        put("square", '\u25A1');
        put("Square", '\u25A1');
        put("SquareIntersection", '\u2293');
        put("SquareSubset", '\u228F');
        put("SquareSubsetEqual", '\u2291');
        put("SquareSuperset", '\u2290');
        put("SquareSupersetEqual", '\u2292');
        put("SquareUnion", '\u2294');
        put("squarf", '\u25AA');
        put("squ", '\u25A1');
        put("squf", '\u25AA');
        put("srarr", '\u2192');
        put("Sscr", '\uD835', '\uDCAE');
        put("sscr", '\uD835', '\uDCC8');
        put("ssetmn", '\u2216');
        put("ssmile", '\u2323');
        put("sstarf", '\u22C6');
        put("Star", '\u22C6');
        put("star", '\u2606');
        put("starf", '\u2605');
        put("straightepsilon", '\u03F5');
        put("straightphi", '\u03D5');
        put("strns", '\u00AF');
        put("sub", '\u2282');
        put("Sub", '\u22D0');
        put("subdot", '\u2ABD');
        put("subE", '\u2AC5');
        put("sube", '\u2286');
        put("subedot", '\u2AC3');
        put("submult", '\u2AC1');
        put("subnE", '\u2ACB');
        put("subne", '\u228A');
        put("subplus", '\u2ABF');
        put("subrarr", '\u2979');
        put("subset", '\u2282');
        put("Subset", '\u22D0');
        put("subseteq", '\u2286');
        put("subseteqq", '\u2AC5');
        put("SubsetEqual", '\u2286');
        put("subsetneq", '\u228A');
        put("subsetneqq", '\u2ACB');
        put("subsim", '\u2AC7');
        put("subsub", '\u2AD5');
        put("subsup", '\u2AD3');
        put("succapprox", '\u2AB8');
        put("succ", '\u227B');
        put("succcurlyeq", '\u227D');
        put("Succeeds", '\u227B');
        put("SucceedsEqual", '\u2AB0');
        put("SucceedsSlantEqual", '\u227D');
        put("SucceedsTilde", '\u227F');
        put("succeq", '\u2AB0');
        put("succnapprox", '\u2ABA');
        put("succneqq", '\u2AB6');
        put("succnsim", '\u22E9');
        put("succsim", '\u227F');
        put("SuchThat", '\u220B');
        put("sum", '\u2211');
        put("Sum", '\u2211');
        put("sung", '\u266A');
        put("sup1", '\u00B9');
        put("sup2", '\u00B2');
        put("sup3", '\u00B3');
        put("sup", '\u2283');
        put("Sup", '\u22D1');
        put("supdot", '\u2ABE');
        put("supdsub", '\u2AD8');
        put("supE", '\u2AC6');
        put("supe", '\u2287');
        put("supedot", '\u2AC4');
        put("Superset", '\u2283');
        put("SupersetEqual", '\u2287');
        put("suphsol", '\u27C9');
        put("suphsub", '\u2AD7');
        put("suplarr", '\u297B');
        put("supmult", '\u2AC2');
        put("supnE", '\u2ACC');
        put("supne", '\u228B');
        put("supplus", '\u2AC0');
        put("supset", '\u2283');
        put("Supset", '\u22D1');
        put("supseteq", '\u2287');
        put("supseteqq", '\u2AC6');
        put("supsetneq", '\u228B');
        put("supsetneqq", '\u2ACC');
        put("supsim", '\u2AC8');
        put("supsub", '\u2AD4');
        put("supsup", '\u2AD6');
        put("swarhk", '\u2926');
        put("swarr", '\u2199');
        put("swArr", '\u21D9');
        put("swarrow", '\u2199');
        put("swnwar", '\u292A');
        put("szlig", '\u00DF');
        put("Tab", '\u0009');
        put("target", '\u2316');
        put("Tau", '\u03A4');
        put("tau", '\u03C4');
        put("tbrk", '\u23B4');
        put("Tcaron", '\u0164');
        put("tcaron", '\u0165');
        put("Tcedil", '\u0162');
        put("tcedil", '\u0163');
        put("Tcy", '\u0422');
        put("tcy", '\u0442');
        put("tdot", '\u20DB');
        put("telrec", '\u2315');
        put("Tfr", '\uD835', '\uDD17');
        put("tfr", '\uD835', '\uDD31');
        put("there4", '\u2234');
        put("therefore", '\u2234');
        put("Therefore", '\u2234');
        put("Theta", '\u0398');
        put("theta", '\u03B8');
        put("thetasym", '\u03D1');
        put("thetav", '\u03D1');
        put("thickapprox", '\u2248');
        put("thicksim", '\u223C');
        put("ThickSpace", '\u205F', '\u200A');
        put("ThinSpace", '\u2009');
        put("thinsp", '\u2009');
        put("thkap", '\u2248');
        put("thksim", '\u223C');
        put("THORN", '\u00DE');
        put("thorn", '\u00FE');
        put("tilde", '\u02DC');
        put("Tilde", '\u223C');
        put("TildeEqual", '\u2243');
        put("TildeFullEqual", '\u2245');
        put("TildeTilde", '\u2248');
        put("timesbar", '\u2A31');
        put("timesb", '\u22A0');
        put("times", '\u00D7');
        put("timesd", '\u2A30');
        put("tint", '\u222D');
        put("toea", '\u2928');
        put("topbot", '\u2336');
        put("topcir", '\u2AF1');
        put("top", '\u22A4');
        put("Topf", '\uD835', '\uDD4B');
        put("topf", '\uD835', '\uDD65');
        put("topfork", '\u2ADA');
        put("tosa", '\u2929');
        put("tprime", '\u2034');
        put("trade", '\u2122');
        put("TRADE", '\u2122');
        put("triangle", '\u25B5');
        put("triangledown", '\u25BF');
        put("triangleleft", '\u25C3');
        put("trianglelefteq", '\u22B4');
        put("triangleq", '\u225C');
        put("triangleright", '\u25B9');
        put("trianglerighteq", '\u22B5');
        put("tridot", '\u25EC');
        put("trie", '\u225C');
        put("triminus", '\u2A3A');
        put("TripleDot", '\u20DB');
        put("triplus", '\u2A39');
        put("trisb", '\u29CD');
        put("tritime", '\u2A3B');
        put("trpezium", '\u23E2');
        put("Tscr", '\uD835', '\uDCAF');
        put("tscr", '\uD835', '\uDCC9');
        put("TScy", '\u0426');
        put("tscy", '\u0446');
        put("TSHcy", '\u040B');
        put("tshcy", '\u045B');
        put("Tstrok", '\u0166');
        put("tstrok", '\u0167');
        put("twixt", '\u226C');
        put("twoheadleftarrow", '\u219E');
        put("twoheadrightarrow", '\u21A0');
        put("Uacute", '\u00DA');
        put("uacute", '\u00FA');
        put("uarr", '\u2191');
        put("Uarr", '\u219F');
        put("uArr", '\u21D1');
        put("Uarrocir", '\u2949');
        put("Ubrcy", '\u040E');
        put("ubrcy", '\u045E');
        put("Ubreve", '\u016C');
        put("ubreve", '\u016D');
        put("Ucirc", '\u00DB');
        put("ucirc", '\u00FB');
        put("Ucy", '\u0423');
        put("ucy", '\u0443');
        put("udarr", '\u21C5');
        put("Udblac", '\u0170');
        put("udblac", '\u0171');
        put("udhar", '\u296E');
        put("ufisht", '\u297E');
        put("Ufr", '\uD835', '\uDD18');
        put("ufr", '\uD835', '\uDD32');
        put("Ugrave", '\u00D9');
        put("ugrave", '\u00F9');
        put("uHar", '\u2963');
        put("uharl", '\u21BF');
        put("uharr", '\u21BE');
        put("uhblk", '\u2580');
        put("ulcorn", '\u231C');
        put("ulcorner", '\u231C');
        put("ulcrop", '\u230F');
        put("ultri", '\u25F8');
        put("Umacr", '\u016A');
        put("umacr", '\u016B');
        put("uml", '\u00A8');
        put("UnderBar", '\u005F');
        put("UnderBrace", '\u23DF');
        put("UnderBracket", '\u23B5');
        put("UnderParenthesis", '\u23DD');
        put("Union", '\u22C3');
        put("UnionPlus", '\u228E');
        put("Uogon", '\u0172');
        put("uogon", '\u0173');
        put("Uopf", '\uD835', '\uDD4C');
        put("uopf", '\uD835', '\uDD66');
        put("UpArrowBar", '\u2912');
        put("uparrow", '\u2191');
        put("UpArrow", '\u2191');
        put("Uparrow", '\u21D1');
        put("UpArrowDownArrow", '\u21C5');
        put("updownarrow", '\u2195');
        put("UpDownArrow", '\u2195');
        put("Updownarrow", '\u21D5');
        put("UpEquilibrium", '\u296E');
        put("upharpoonleft", '\u21BF');
        put("upharpoonright", '\u21BE');
        put("uplus", '\u228E');
        put("UpperLeftArrow", '\u2196');
        put("UpperRightArrow", '\u2197');
        put("upsi", '\u03C5');
        put("Upsi", '\u03D2');
        put("upsih", '\u03D2');
        put("Upsilon", '\u03A5');
        put("upsilon", '\u03C5');
        put("UpTeeArrow", '\u21A5');
        put("UpTee", '\u22A5');
        put("upuparrows", '\u21C8');
        put("urcorn", '\u231D');
        put("urcorner", '\u231D');
        put("urcrop", '\u230E');
        put("Uring", '\u016E');
        put("uring", '\u016F');
        put("urtri", '\u25F9');
        put("Uscr", '\uD835', '\uDCB0');
        put("uscr", '\uD835', '\uDCCA');
        put("utdot", '\u22F0');
        put("Utilde", '\u0168');
        put("utilde", '\u0169');
        put("utri", '\u25B5');
        put("utrif", '\u25B4');
        put("uuarr", '\u21C8');
        put("Uuml", '\u00DC');
        put("uuml", '\u00FC');
        put("uwangle", '\u29A7');
        put("vangrt", '\u299C');
        put("varepsilon", '\u03F5');
        put("varkappa", '\u03F0');
        put("varnothing", '\u2205');
        put("varphi", '\u03D5');
        put("varpi", '\u03D6');
        put("varpropto", '\u221D');
        put("varr", '\u2195');
        put("vArr", '\u21D5');
        put("varrho", '\u03F1');
        put("varsigma", '\u03C2');
        put("varsubsetneq", '\u228A', '\uFE00');
        put("varsubsetneqq", '\u2ACB', '\uFE00');
        put("varsupsetneq", '\u228B', '\uFE00');
        put("varsupsetneqq", '\u2ACC', '\uFE00');
        put("vartheta", '\u03D1');
        put("vartriangleleft", '\u22B2');
        put("vartriangleright", '\u22B3');
        put("vBar", '\u2AE8');
        put("Vbar", '\u2AEB');
        put("vBarv", '\u2AE9');
        put("Vcy", '\u0412');
        put("vcy", '\u0432');
        put("vdash", '\u22A2');
        put("vDash", '\u22A8');
        put("Vdash", '\u22A9');
        put("VDash", '\u22AB');
        put("Vdashl", '\u2AE6');
        put("veebar", '\u22BB');
        put("vee", '\u2228');
        put("Vee", '\u22C1');
        put("veeeq", '\u225A');
        put("vellip", '\u22EE');
        put("verbar", '\u007C');
        put("Verbar", '\u2016');
        put("vert", '\u007C');
        put("Vert", '\u2016');
        put("VerticalBar", '\u2223');
        put("VerticalLine", '\u007C');
        put("VerticalSeparator", '\u2758');
        put("VerticalTilde", '\u2240');
        put("VeryThinSpace", '\u200A');
        put("Vfr", '\uD835', '\uDD19');
        put("vfr", '\uD835', '\uDD33');
        put("vltri", '\u22B2');
        put("vnsub", '\u2282', '\u20D2');
        put("vnsup", '\u2283', '\u20D2');
        put("Vopf", '\uD835', '\uDD4D');
        put("vopf", '\uD835', '\uDD67');
        put("vprop", '\u221D');
        put("vrtri", '\u22B3');
        put("Vscr", '\uD835', '\uDCB1');
        put("vscr", '\uD835', '\uDCCB');
        put("vsubnE", '\u2ACB', '\uFE00');
        put("vsubne", '\u228A', '\uFE00');
        put("vsupnE", '\u2ACC', '\uFE00');
        put("vsupne", '\u228B', '\uFE00');
        put("Vvdash", '\u22AA');
        put("vzigzag", '\u299A');
        put("Wcirc", '\u0174');
        put("wcirc", '\u0175');
        put("wedbar", '\u2A5F');
        put("wedge", '\u2227');
        put("Wedge", '\u22C0');
        put("wedgeq", '\u2259');
        put("weierp", '\u2118');
        put("Wfr", '\uD835', '\uDD1A');
        put("wfr", '\uD835', '\uDD34');
        put("Wopf", '\uD835', '\uDD4E');
        put("wopf", '\uD835', '\uDD68');
        put("wp", '\u2118');
        put("wr", '\u2240');
        put("wreath", '\u2240');
        put("Wscr", '\uD835', '\uDCB2');
        put("wscr", '\uD835', '\uDCCC');
        put("xcap", '\u22C2');
        put("xcirc", '\u25EF');
        put("xcup", '\u22C3');
        put("xdtri", '\u25BD');
        put("Xfr", '\uD835', '\uDD1B');
        put("xfr", '\uD835', '\uDD35');
        put("xharr", '\u27F7');
        put("xhArr", '\u27FA');
        put("Xi", '\u039E');
        put("xi", '\u03BE');
        put("xlarr", '\u27F5');
        put("xlArr", '\u27F8');
        put("xmap", '\u27FC');
        put("xnis", '\u22FB');
        put("xodot", '\u2A00');
        put("Xopf", '\uD835', '\uDD4F');
        put("xopf", '\uD835', '\uDD69');
        put("xoplus", '\u2A01');
        put("xotime", '\u2A02');
        put("xrarr", '\u27F6');
        put("xrArr", '\u27F9');
        put("Xscr", '\uD835', '\uDCB3');
        put("xscr", '\uD835', '\uDCCD');
        put("xsqcup", '\u2A06');
        put("xuplus", '\u2A04');
        put("xutri", '\u25B3');
        put("xvee", '\u22C1');
        put("xwedge", '\u22C0');
        put("Yacute", '\u00DD');
        put("yacute", '\u00FD');
        put("YAcy", '\u042F');
        put("yacy", '\u044F');
        put("Ycirc", '\u0176');
        put("ycirc", '\u0177');
        put("Ycy", '\u042B');
        put("ycy", '\u044B');
        put("yen", '\u00A5');
        put("Yfr", '\uD835', '\uDD1C');
        put("yfr", '\uD835', '\uDD36');
        put("YIcy", '\u0407');
        put("yicy", '\u0457');
        put("Yopf", '\uD835', '\uDD50');
        put("yopf", '\uD835', '\uDD6A');
        put("Yscr", '\uD835', '\uDCB4');
        put("yscr", '\uD835', '\uDCCE');
        put("YUcy", '\u042E');
        put("yucy", '\u044E');
        put("yuml", '\u00FF');
        put("Yuml", '\u0178');
        put("Zacute", '\u0179');
        put("zacute", '\u017A');
        put("Zcaron", '\u017D');
        put("zcaron", '\u017E');
        put("Zcy", '\u0417');
        put("zcy", '\u0437');
        put("Zdot", '\u017B');
        put("zdot", '\u017C');
        put("zeetrf", '\u2128');
        put("ZeroWidthSpace", '\u200B');
        put("Zeta", '\u0396');
        put("zeta", '\u03B6');
        put("zfr", '\uD835', '\uDD37');
        put("Zfr", '\u2128');
        put("ZHcy", '\u0416');
        put("zhcy", '\u0436');
        put("zigrarr", '\u21DD');
        put("zopf", '\uD835', '\uDD6B');
        put("Zopf", '\u2124');
        put("Zscr", '\uD835', '\uDCB5');
        put("zscr", '\uD835', '\uDCCF');
        put("zwj", '\u200D');
        put("zwnj", '\u200C');
    }

    private static void put(String name, char c) {
        entities.put(name, String.valueOf(c));
    }

    private static void put(String name, char c1, char c2) {
        entities.put(name, String.valueOf(new char[] { c1, c2 }));
    }

    static String getCharacters(EntityTree tree) {
        String name = tree.getName().toString();
        if (name.startsWith("#")) {
            try {
                int v = StringUtils.toLowerCase(name).startsWith("#x")
                        ? Integer.parseInt(name.substring(2), 16)
                        : Integer.parseInt(name.substring(1), 10);
                // See https://www.w3.org/TR/html52/syntax.html#character-references
                if (Character.isDefined(v)
                        && (!Character.isISOControl(v) || Character.isSpaceChar(v))
                        && (v < 0xd800 || v > 0xdfff)) {
                    return String.valueOf((char) v);
                }
            } catch (NumberFormatException ex) {
                //ignore
            }
            return null;
        } else {
            return entities.get(name);
        }
    }
}
