/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.util.ArrayList;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.Ticker;
import org.recompile.mobile.Mobile;
import org.recompile.mobile.PlatformGraphics;
import org.recompile.mobile.PlatformImage;

public abstract class Displayable {
    public PlatformImage platformImage;
    public int width = 0;
    public int height = 0;
    public boolean fullScreen = false;
    protected String title = "";
    protected ArrayList<Command> commands = new ArrayList();
    protected ArrayList<Item> items = new ArrayList();
    protected CommandListener commandlistener;
    protected boolean listCommands = false;
    protected int currentCommand = 0;
    protected int currentItem = -1;
    public Ticker ticker;

    public Displayable() {
        this.width = Mobile.getPlatform().lcdWidth;
        this.height = Mobile.getPlatform().lcdHeight;
    }

    public void addCommand(Command cmd) {
        try {
            this.commands.add(cmd);
        }
        catch (Exception e) {
            System.out.println("Problem Adding Command: " + e.getMessage());
        }
    }

    public void removeCommand(Command cmd) {
        this.commands.remove(cmd);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String text) {
        this.title = text;
    }

    public boolean isShown() {
        return true;
    }

    public Ticker getTicker() {
        return this.ticker;
    }

    public void setTicker(Ticker tick) {
        this.ticker = tick;
    }

    public void setCommandListener(CommandListener listener) {
        this.commandlistener = listener;
    }

    protected void sizeChanged(int width, int height) {
    }

    public Display getDisplay() {
        return Mobile.getDisplay();
    }

    public ArrayList<Command> getCommands() {
        return this.commands;
    }

    public void keyPressed(int key) {
    }

    public void keyReleased(int key) {
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerPressed(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
    }

    public void showNotify() {
    }

    public void hideNotify() {
    }

    public void notifySetCurrent() {
    }

    protected void render() {
        if (this.listCommands) {
            this.renderCommands();
        } else {
            this.renderItems();
        }
    }

    public void renderItems() {
        PlatformGraphics gc = this.platformImage.getGraphics();
        gc.setColor(0xFFFFFF);
        gc.fillRect(0, 0, this.width, this.height);
        gc.setColor(0);
        gc.drawString(this.title, this.width / 2, 2, 1);
        gc.drawLine(0, 20, this.width, 20);
        gc.drawLine(0, this.height - 20, this.width, this.height - 20);
        if (this.items.size() > 0) {
            if (this.currentItem < 0) {
                this.currentItem = 0;
            }
            int ah = this.height - 50;
            int max = (int)Math.floor(ah / 15);
            if (this.items.size() < max) {
                max = this.items.size();
            }
            int page = 0;
            page = (int)Math.floor(this.currentItem / max);
            int first = page * max;
            int last = first + max - 1;
            if (last >= this.items.size()) {
                last = this.items.size() - 1;
            }
            int y = 25;
            for (int i = first; i <= last; ++i) {
                if (this.currentItem == i) {
                    gc.fillRect(0, y, this.width, 15);
                    gc.setColor(0xFFFFFF);
                }
                gc.drawString(this.items.get(i).getLabel(), this.width / 2, y, 1);
                if (this.items.get(i) instanceof StringItem) {
                    gc.drawString(((StringItem)this.items.get(i)).getText(), this.width / 2, y, 1);
                }
                gc.setColor(0);
                if (this.items.get(i) instanceof ImageItem) {
                    gc.drawImage(((ImageItem)this.items.get(i)).getImage(), this.width / 2, y, 1);
                }
                y += 15;
            }
        }
        switch (this.commands.size()) {
            case 0: {
                break;
            }
            case 1: {
                gc.drawString(this.commands.get(0).getLabel(), 3, this.height - 17, 4);
                gc.drawString("" + (this.currentItem + 1) + " of " + this.items.size(), this.width - 3, this.height - 17, 8);
                break;
            }
            case 2: {
                gc.drawString(this.commands.get(0).getLabel(), 3, this.height - 17, 4);
                gc.drawString(this.commands.get(1).getLabel(), this.width - 3, this.height - 17, 8);
                break;
            }
            default: {
                gc.drawString("Options", 3, this.height - 17, 4);
            }
        }
        if (this.getDisplay().getCurrent() == this) {
            Mobile.getPlatform().repaint(this.platformImage, 0, 0, this.width, this.height);
        }
    }

    protected void renderCommands() {
        PlatformGraphics gc = this.platformImage.getGraphics();
        gc.setColor(0xFFFFFF);
        gc.fillRect(0, 0, this.width, this.height);
        gc.setColor(0);
        gc.drawString("Options", this.width / 2, 2, 1);
        gc.drawLine(0, 20, this.width, 20);
        gc.drawLine(0, this.height - 20, this.width, this.height - 20);
        if (this.commands.size() > 0) {
            if (this.currentCommand < 0) {
                this.currentCommand = 0;
            }
            int ah = this.height - 50;
            int max = (int)Math.floor(ah / 15);
            if (this.commands.size() < max) {
                max = this.commands.size();
            }
            int page = 0;
            page = (int)Math.floor(this.currentCommand / max);
            int first = page * max;
            int last = first + max - 1;
            if (last >= this.commands.size()) {
                last = this.commands.size() - 1;
            }
            int y = 25;
            for (int i = first; i <= last; ++i) {
                if (this.currentCommand == i) {
                    gc.fillRect(0, y, this.width, 15);
                    gc.setColor(0xFFFFFF);
                }
                gc.drawString(this.commands.get(i).getLabel(), this.width / 2, y, 1);
                gc.setColor(0);
                y += 15;
            }
        }
        gc.drawString("Okay", 3, this.height - 17, 4);
        gc.drawString("Back", this.width - 3, this.height - 17, 8);
        if (this.getDisplay().getCurrent() == this) {
            Mobile.getPlatform().repaint(this.platformImage, 0, 0, this.width, this.height);
        }
    }

    protected void keyPressedCommands(int key) {
        switch (key) {
            case 50: {
                --this.currentCommand;
                break;
            }
            case 56: {
                ++this.currentCommand;
                break;
            }
            case -1: {
                --this.currentCommand;
                break;
            }
            case -2: {
                ++this.currentCommand;
                break;
            }
            case -6: {
                this.doLeftCommand();
                break;
            }
            case -7: {
                this.doRightCommand();
                break;
            }
            case 53: {
                this.doLeftCommand();
            }
        }
        if (this.currentCommand >= this.commands.size()) {
            this.currentCommand = 0;
        }
        if (this.currentCommand < 0) {
            this.currentCommand = this.commands.size() - 1;
        }
        if (this.listCommands) {
            this.renderCommands();
        }
    }

    protected void doCommand(int index) {
        if (index >= 0 && this.commands.size() > index && this.commandlistener != null) {
            this.commandlistener.commandAction(this.commands.get(index), this);
        }
    }

    protected void doDefaultCommand() {
        this.doCommand(0);
    }

    protected void doLeftCommand() {
        if (this.commands.size() > 2) {
            if (this.listCommands) {
                this.doCommand(this.currentCommand);
            } else {
                this.listCommands = true;
                this.currentCommand = 0;
                this.render();
            }
            return;
        }
        if (this.commands.size() > 0 && this.commands.size() <= 2) {
            this.doCommand(0);
        }
    }

    protected void doRightCommand() {
        if (this.listCommands) {
            this.listCommands = false;
            this.currentCommand = 0;
            this.render();
        } else if (this.commands.size() > 0 && this.commands.size() <= 2) {
            this.doCommand(1);
        }
    }
}

