/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Screen;
import org.recompile.mobile.Mobile;

public class Alert
extends Screen {
    public static final Command DISMISS_COMMAND = new Command("OK", 4, 0);
    public static final int FOREVER = -2;
    private String message;
    private Image image;
    private AlertType type;
    private int timeout = -2;
    private Gauge indicator;
    private Displayable nextScreen = null;
    public CommandListener defaultListener = new CommandListener(){

        @Override
        public void commandAction(Command cmd, Displayable next) {
            Mobile.getDisplay().setCurrent(next);
        }
    };

    public Alert(String title) {
        System.out.println("Alert: " + title);
        this.setTitle(title);
        Thread.dumpStack();
    }

    public Alert(String title, String alertText, Image alertImage, AlertType alertType) {
        System.out.println("Alert: " + title);
        System.out.println("Alert: " + alertText);
        this.setTitle(title);
        this.setString(alertText);
        this.setImage(alertImage);
        this.setType(alertType);
        this.setTimeout(this.getDefaultTimeout());
        this.addCommand(DISMISS_COMMAND);
        this.setCommandListener(this.defaultListener);
    }

    public int getDefaultTimeout() {
        return -2;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int time) {
        this.timeout = time;
    }

    public AlertType getType() {
        return this.type;
    }

    public void setType(AlertType t) {
        this.type = t;
    }

    public String getString() {
        return this.message;
    }

    public void setString(String text) {
        System.out.println(text);
        this.message = text;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image img) {
        this.image = img;
    }

    public void setIndicator(Gauge gauge) {
        this.indicator = gauge;
    }

    public Gauge getIndicator() {
        return this.indicator;
    }

    @Override
    public void addCommand(Command cmd) {
        super.addCommand(cmd);
        if (this.getCommands().size() == 2) {
            super.removeCommand(DISMISS_COMMAND);
        }
    }

    @Override
    public void removeCommand(Command cmd) {
        if (this.getCommands().size() > 1) {
            super.removeCommand(cmd);
        }
    }

    @Override
    public void setCommandListener(CommandListener listener) {
        if (listener == null) {
            listener = this.defaultListener;
        }
        super.setCommandListener(listener);
    }

    public void setNextScreen(Displayable next) {
        this.nextScreen = next;
    }
}

