/*
 * Decompiled with CFR 0.152.
 */
package code.Gameplay.Map;

import code.Gameplay.Map.Room;
import code.Math.MathUtils;
import code.Math.Matrix;
import code.Rendering.DirectX7;
import code.Rendering.Meshes.Mesh;
import code.Rendering.MultyTexture;
import code.Rendering.Texture;
import javax.microedition.lcdui.Graphics;

public class Skybox {
    private byte mode = 0;
    private Matrix matrix;
    private Mesh mesh;
    public MultyTexture texture;
    private int color;
    private int groundColor;
    private Texture tex;
    private float repeatX;
    private float repeatY;
    private int lowestDegree;
    private float horizonScale;
    private float horizonOffset;
    public int x1;
    public int y1;
    public int x2;
    public int y2;
    private boolean resetViewport;
    public boolean skyboxAlways = false;
    public boolean draw = true;
    public Texture skyLighting;
    public boolean lighting = false;
    public long lastLighting = -1L;
    public float rotateX;
    public float rotateY;

    public Skybox() {
    }

    public Skybox(String modelPath, String texturePath) {
        this.resetViewport = false;
        this.skyboxAlways = false;
        this.mode = 0;
        this.matrix = new Matrix();
        this.texture = new MultyTexture(texturePath, true);
        this.mesh = Room.loadMeshes(modelPath, 7.0f, 7.0f, 7.0f, this.texture)[0];
    }

    public Skybox(int colors) {
        this.resetViewport = false;
        this.skyboxAlways = false;
        this.mode = 1;
        this.color = colors;
    }

    public Skybox(Texture colors, int lowestDegree, float horizonScale, float horizonOffset) {
        this.resetViewport = false;
        this.skyboxAlways = false;
        this.mode = (byte)3;
        this.tex = colors;
        this.lowestDegree = lowestDegree;
        this.horizonScale = horizonScale;
        this.horizonOffset = horizonOffset;
    }

    public Skybox(Texture colors, float repeatX, float repeatY, int lowestDegree, float horizonScale, float horizonOffset, int color, int groundColor) {
        this.resetViewport = false;
        this.skyboxAlways = false;
        this.mode = (byte)2;
        this.tex = colors;
        this.repeatX = repeatX;
        this.repeatY = repeatY;
        this.lowestDegree = lowestDegree;
        this.horizonScale = horizonScale;
        this.horizonOffset = horizonOffset;
        this.color = color;
        this.groundColor = groundColor;
    }

    public void destroy() {
        this.matrix = null;
        this.texture = null;
        if (this.mesh != null) {
            this.mesh.destroy();
        }
        this.mesh = null;
        this.tex = null;
    }

    public void resetViewport() {
        this.resetViewport = true;
        this.draw = false;
    }

    public void addViewport(int ax1, int ay1, int ax2, int ay2) {
        if (this.resetViewport) {
            this.resetViewport = false;
            this.x1 = ax1;
            this.y1 = ay1;
            this.x2 = ax2;
            this.y2 = ay2;
        } else {
            if (ax1 < this.x1) {
                this.x1 = ax1;
            }
            if (ay1 < this.y1) {
                this.y1 = ay1;
            }
            if (ax2 > this.x2) {
                this.x2 = ax2;
            }
            if (ay2 > this.y2) {
                this.y2 = ay2;
            }
        }
    }

    public final void render(Graphics g, DirectX7 g3d) {
        if (this.skyboxAlways) {
            this.x1 = 0;
            this.y1 = 0;
            this.x2 = g3d.width;
            this.y2 = g3d.height;
        }
        if (this.lighting) {
            if (this.skyLighting == null) {
                g3d.clearDisplay(0xE5E5E5);
            } else if (this.mode == 3) {
                this.renderGradient(g3d, this.skyLighting, this.lowestDegree, this.horizonScale, this.horizonOffset);
            } else {
                this.renderGradient(g3d, this.skyLighting, -91, 1.0f, 0.0f);
            }
            if (this.lighting) {
                this.drawLighting(g3d);
            }
            this.lighting = false;
        } else if (this.mode == 0) {
            this.matrix.setIdentity();
            this.matrix.setPosition(g3d.getCamera().m03, g3d.getCamera().m13, g3d.getCamera().m23);
            Matrix fm = g3d.computeFinalMatrix(this.matrix);
            g3d.transformAndProjectVertices(this.mesh, fm);
            this.mesh.getTexture().updateAnimation();
            g3d.addMesh(this.mesh, this.x1, this.y1, this.x2, this.y2);
        } else if (this.mode == 1) {
            g3d.clearDisplay(this.color);
        } else if (this.mode == 2) {
            this.render2DSkybox(g3d);
        } else if (this.mode == 3) {
            this.renderGradient(g3d, this.tex, this.lowestDegree, this.horizonScale, this.horizonOffset);
        }
    }

    void renderGradient(DirectX7 g3d, Texture texs, int lowestDegree, float horizonScale, float horizonOffset) {
        int col;
        int gradientBegin;
        if (this.x2 - this.x1 == 0 || this.y2 - this.y1 == 0) {
            return;
        }
        int horizonY = (int)((float)(g3d.height / 2) + this.rotateX * (float)g3d.height / (float)g3d.fovY);
        horizonY = (horizonY - g3d.centreY) * g3d.distY / (11 + g3d.distY) + g3d.centreY;
        horizonY = (int)((float)horizonY - horizonOffset * (float)g3d.height / (float)g3d.fovY);
        int ySize = (int)(90.0f * horizonScale * (float)g3d.height / (float)g3d.fovY);
        int rx1 = this.y1 * g3d.width;
        int yy2 = this.y2;
        if (lowestDegree != -91) {
            int horCrop = (int)((float)(g3d.height / 2 - lowestDegree * g3d.height / g3d.fovY) + this.rotateX * (float)g3d.height / (float)g3d.fovY);
            if (this.y2 > (horCrop = (horCrop - g3d.centreY) * g3d.distY / (11 + g3d.distY) + g3d.centreY)) {
                this.y2 = horCrop;
            }
        }
        int rx2 = this.y2 * g3d.width;
        int[] rgb = g3d.display;
        int[] tex = texs.rImg.img;
        int step = ySize / texs.rImg.h;
        if (step == 0) {
            step = 1;
        }
        if ((gradientBegin = horizonY - ySize) >= g3d.height) {
            return;
        }
        if (gradientBegin > 0 && gradientBegin < this.y2) {
            int rx3 = gradientBegin * g3d.width;
            col = ((tex[0] & 0xFF00FF) * 255 & 0xFF00FF00 | (tex[0] & 0xFF00) * 255 & 0xFF0000) >>> 8;
            while (rx3 - rx1 > 6) {
                int n = col;
                rgb[rx1 + 5] = n;
                rgb[rx1 + 4] = n;
                rgb[rx1 + 3] = n;
                rgb[rx1 + 2] = n;
                rgb[rx1 + 1] = n;
                rgb[rx1] = n;
                rx1 += 6;
            }
            while (rx1 < rx3) {
                rgb[rx1] = col;
                ++rx1;
            }
        }
        if ((gradientBegin = horizonY + ySize) > 0 && gradientBegin < this.y2) {
            rx2 = gradientBegin * g3d.width;
        }
        while (rx1 < rx2) {
            int yy = rx1 / g3d.width;
            int mix2 = yy - horizonY;
            if (mix2 < 0) {
                mix2 = -mix2;
            }
            int yp = texs.rImg.h - mix2 / step;
            int yp2 = yp - 1;
            if (yp >= texs.rImg.h) {
                yp = texs.rImg.h - 1;
            }
            if (yp2 >= texs.rImg.h) {
                yp2 = yp;
            }
            if (yp < 0) {
                yp = 0;
            }
            if (yp2 < 0) {
                yp2 = 0;
            }
            mix2 = mix2 % step * 255 / step;
            col = tex[yp];
            int col2 = tex[yp2];
            int mix = 255 - mix2;
            col = ((col & 0xFF00FF) * mix + (col2 & 0xFF00FF) * mix2 & 0xFF00FF00 | (col & 0xFF00) * mix + (col2 & 0xFF00) * mix2 & 0xFF0000) >>> 8;
            int rx3 = rx1 + g3d.width;
            while (rx3 - rx1 <= 6) {
                rgb[rx1] = col;
                rgb[rx1 + 1] = col;
                rgb[rx1 + 2] = col;
                rgb[rx1 + 3] = col;
                rgb[rx1 + 4] = col;
                rgb[rx1 + 5] = col;
                rx1 += 6;
            }
            while (rx1 < rx3) {
                rgb[rx1] = col;
                ++rx1;
            }
        }
        if (gradientBegin > 0 && gradientBegin < this.y2) {
            rx2 = this.y2 * g3d.width;
            col = ((tex[0] & 0xFF00FF) * 255 & 0xFF00FF00 | (tex[0] & 0xFF00) * 255 & 0xFF0000) >>> 8;
            while (rx2 - rx1 <= 6) {
                int n = col;
                rgb[rx1 + 5] = n;
                rgb[rx1 + 4] = n;
                rgb[rx1 + 3] = n;
                rgb[rx1 + 2] = n;
                rgb[rx1 + 1] = n;
                rgb[rx1] = n;
                rx1 += 6;
            }
            while (rx1 < rx2) {
                rgb[rx1] = col;
                ++rx1;
            }
        }
    }

    void render2DSkybox(DirectX7 g3d) {
        if (this.x2 - this.x1 == 0 || this.y2 - this.y1 == 0) {
            return;
        }
        int beginx = (int)((360.0f - this.rotateY - (float)(g3d.fovX / 2)) * (float)this.tex.rImg.w * this.repeatX / 360.0f);
        int endx = (int)((360.0f - this.rotateY + (float)(g3d.fovX / 2)) * (float)this.tex.rImg.w * this.repeatX / 360.0f);
        int horizonY = (int)((float)(g3d.height / 2) + this.rotateX * (float)g3d.height / (float)g3d.fovY);
        horizonY = (horizonY - g3d.centreY) * g3d.distY / (11 + g3d.distY) + g3d.centreY;
        int ySize = (int)(90.0f * this.horizonScale * (float)g3d.height / (float)g3d.fovY);
        int endy = (horizonY = (int)((float)horizonY - this.horizonOffset * (float)g3d.height / (float)g3d.fovY)) + ySize;
        int beginy = horizonY - ySize;
        if (endy <= beginy) {
            endy = beginy + 1;
        }
        if (this.lowestDegree != -91) {
            int horCrop = (int)((float)(g3d.height / 2 - this.lowestDegree * g3d.height / g3d.fovY) + this.rotateX * (float)g3d.height / (float)g3d.fovY);
            if (this.y2 > (horCrop = (horCrop - g3d.centreY) * g3d.distY / (11 + g3d.distY) + g3d.centreY)) {
                this.y2 = horCrop;
            }
        }
        int fp = 12;
        int sx = beginx << 12;
        int width = g3d.width;
        int xstep = ((endx << 12) - sx) / width;
        int ystep = (int)((float)(this.tex.rImg.h << 12) * this.repeatY) / (endy - beginy);
        this.render2D(g3d, sx, beginy, endy, xstep, ystep);
    }

    void render2D(DirectX7 g3d, int uStart, int startY, int endY, int du, int dv) {
        int y;
        int[] rgb = g3d.display;
        int width = g3d.width;
        int fp = 12;
        int[] texRgb = this.tex.rImg.img;
        int texW = this.tex.rImg.w;
        int texWlen = this.tex.rImg.w - 1;
        int texWBits = this.tex.rImg.widthBIT;
        int texH = this.tex.rImg.h;
        while (uStart < 0) {
            uStart += texW << 12;
        }
        int texStartY = Math.max(this.y1, Math.min(this.y2, startY));
        int texEndY = Math.max(this.y1, Math.min(this.y2, endY));
        for (int y2 = this.y1; y2 < texStartY; ++y2) {
            int yy = y2 * width;
            this.fillLine(rgb, this.x1 + yy, this.x2 + yy, this.color);
        }
        int v = dv * (texStartY - startY);
        for (y = texStartY; y < texEndY; ++y) {
            int u = uStart - du;
            int rx1 = y * width;
            int rx2 = rx1 + width;
            if (this.x1 > 0) {
                rx1 += this.x1;
                u += du * this.x1;
            }
            if (this.x2 < width) {
                rx2 -= width - this.x2;
            }
            int ysa = (v >>> 12) % texH << texWBits;
            while (rx2 - rx1 >= 4) {
                rgb[rx1] = texRgb[((u += du) >>> 12 & texWlen) + ysa];
                rgb[rx1 + 1] = texRgb[((u += du) >>> 12 & texWlen) + ysa];
                rgb[rx1 + 2] = texRgb[((u += du) >>> 12 & texWlen) + ysa];
                rgb[rx1 + 3] = texRgb[((u += du) >>> 12 & texWlen) + ysa];
                rx1 += 4;
            }
            while (rx1 < rx2) {
                rgb[rx1] = texRgb[((u += du) >>> 12 & texWlen) + ysa];
                ++rx1;
            }
            v += dv;
        }
        for (y = texEndY; y < this.y2; ++y) {
            int yy = y * width;
            this.fillLine(rgb, this.x1 + yy, this.x2 + yy, this.groundColor);
        }
    }

    private void fillLine(int[] rgb, int x1, int x2, int col) {
        while (x2 - x1 <= 6) {
            rgb[x1] = col;
            rgb[x1 + 1] = col;
            rgb[x1 + 2] = col;
            rgb[x1 + 3] = col;
            rgb[x1 + 4] = col;
            rgb[x1 + 5] = col;
            x1 += 6;
        }
        while (x1 < x2) {
            rgb[x1] = col;
            ++x1;
        }
    }

    public Mesh getMesh() {
        return this.mesh;
    }

    public void drawLighting(DirectX7 g3d) {
        MathUtils.randomCall = 0;
        if (MathUtils.preudoRandom(this.lastLighting, 8) == 0) {
            return;
        }
        int horizonY = (int)((float)(g3d.height / 2) + this.rotateX * (float)g3d.height / (float)g3d.fovY);
        horizonY = (horizonY - g3d.centreY) * g3d.distY / (11 + g3d.distY) + g3d.centreY;
        int ySize = 90 * g3d.height / g3d.fovY;
        int fat = 222 / g3d.fovY;
        if (fat < 1) {
            fat = 1;
        }
        int by = horizonY - ySize;
        int bx = MathUtils.preudoRandom(this.lastLighting, g3d.width);
        int deg20 = g3d.width * 20 / g3d.fovX;
        int mx = bx + (MathUtils.preudoRandom(this.lastLighting, 100) - 50) * deg20 / 100;
        int my = horizonY - ySize / 3 + MathUtils.preudoRandom(this.lastLighting, 100) * g3d.height * 10 / g3d.fovY / 100;
        g3d.drawLine(bx, by, mx, my, fat, 0xFFFFFF);
        if (MathUtils.preudoRandom(this.lastLighting, 4) == 0) {
            int rnd = (MathUtils.preudoRandom(this.lastLighting, 100) - 50) * deg20 / 25;
            g3d.drawLine(mx / 2 + bx / 2, my / 2 + by / 2, mx + rnd, horizonY, fat, 0xFFFFFF);
        }
        int sparksCount = 2 + MathUtils.preudoRandom(this.lastLighting, 3);
        int fat2 = fat - 1;
        if (fat2 < 1) {
            fat2 = 1;
        }
        for (int i = 0; i < sparksCount; ++i) {
            int rnd = (MathUtils.preudoRandom(this.lastLighting, 100) - 50) * deg20 / 50;
            if (MathUtils.preudoRandom(this.lastLighting, 4) == 0) {
                int rnd2 = (MathUtils.preudoRandom(this.lastLighting, 100) - 50) * deg20 / 150;
                g3d.drawLine(mx, my, mx + rnd / 2, horizonY / 2 + my / 2, fat2, 0xFDFDFD);
                g3d.drawLine(mx + rnd / 2, horizonY / 2 + my / 2, mx + rnd / 2 + rnd2 / 2, horizonY, fat2, 0xFDFDFD);
                g3d.drawLine(mx + rnd / 2, horizonY / 2 + my / 2, mx + rnd / 2 - rnd2 / 2, horizonY, fat2, 0xFDFDFD);
                continue;
            }
            g3d.drawLine(mx, my, mx + rnd, horizonY, fat2, 0xFDFDFD);
        }
    }
}

