/*
 * Decompiled with CFR 0.152.
 */
package code.Gameplay;

import code.utils.FPS;

public final class Magazine {
    private final short capacity;
    public short ammo;
    public short rounds;
    private final short reloadTime;
    private short frame = (short)-1;

    public Magazine(int capacity, int reloadTime) {
        this.capacity = (short)capacity;
        this.reloadTime = (short)reloadTime;
    }

    public void setAmmo(int ammo) {
        this.ammo = (short)ammo;
    }

    public final void set(short ammo, short rounds) {
        this.ammo = ammo;
        this.rounds = rounds;
    }

    public void addAmmo(int number) {
        this.ammo = (short)(this.ammo + number);
        if (this.ammo < 0) {
            this.ammo = 0;
        }
    }

    final void reload() {
        if (this.ammo != 0 && this.frame == -1) {
            this.frame = 0;
        }
    }

    final void update() {
        if (this.frame >= 0) {
            this.frame = (short)(this.frame + 1);
        }
        if (this.frame > this.reloadTime * 50 / (FPS.frameTime == 0 ? 1 : FPS.frameTime)) {
            this.frame = (short)-1;
            this.recount();
        }
    }

    final void recount() {
        this.rounds = (short)Math.min(this.capacity, this.ammo);
        this.ammo = (short)(this.ammo - this.rounds);
    }

    final boolean isReloading() {
        return this.frame != -1;
    }

    final int percentage() {
        return 100 * this.frame * FPS.frameTime / 50 / this.reloadTime;
    }

    final void takeRounds(int number) {
        this.rounds = (short)(this.rounds - number);
    }
}

