/*
 * Decompiled with CFR 0.152.
 */
package code.Gameplay;

import code.AI.BigZombie;
import code.AI.Bot;
import code.AI.NPC;
import code.AI.Player;
import code.AI.Zombie;
import code.Gameplay.DialogScreen;
import code.Gameplay.GameScreen;
import code.Gameplay.Map.House;
import code.Gameplay.Map.HouseCreator;
import code.Gameplay.Map.Light;
import code.Gameplay.Map.LightMapper;
import code.Gameplay.Map.Room;
import code.Gameplay.Map.RoomObject;
import code.Gameplay.Map.Scene;
import code.Gameplay.Map.Skybox;
import code.Gameplay.Objects.GameObject;
import code.Gameplay.Objects.Image2D;
import code.Gameplay.Objects.KeyObject;
import code.Gameplay.Objects.LVLChange;
import code.Gameplay.Objects.MeshObject;
import code.Gameplay.Objects.NPCSpawner;
import code.Gameplay.Objects.ShopObject;
import code.Gameplay.Objects.SpriteObject;
import code.Gameplay.Objects.Teleport;
import code.Gameplay.Respawn;
import code.Gameplay.Shop;
import code.Math.Vector3D;
import code.Rendering.DirectX7;
import code.Rendering.Meshes.Mesh;
import code.Rendering.Meshes.MeshImage;
import code.Rendering.Meshes.Sprite;
import code.Rendering.MultyTexture;
import code.Rendering.Texture;
import code.Rendering.Vertex;
import code.utils.Asset;
import code.utils.GameIni;
import code.utils.ImageResize;
import code.utils.Main;
import code.utils.StringTools;
import code.utils.WeatherGenerator;
import java.util.Vector;
import javax.microedition.lcdui.Image;

public class LevelLoader {
    public static boolean defaultOneBot = false;
    private static final String[] levelGroups = new String[]{"WTEX_BEGIN", "WTEX_END"};

    private static String[] cutLevelFile(String file) {
        int index = file.indexOf(91);
        if (index > -1) {
            int tmpIndex = file.indexOf(levelGroups[0]);
            if (tmpIndex > -1) {
                int ind2 = file.indexOf(levelGroups[1]);
                String textures = file.substring(tmpIndex + levelGroups[1].length() + 3, ind2 - 2);
                index = (file = file.substring(0, tmpIndex - 2) + file.substring(ind2 + levelGroups[1].length() + 1, file.length())).indexOf(91);
                if (index > -1) {
                    file = file.substring(0, index - 1);
                }
                return new String[]{file, textures};
            }
            return new String[]{file.substring(0, index - 1)};
        }
        return new String[]{file};
    }

    public static final Scene createScene(int width, int height, String file, Main main, GameScreen gs) {
        String str;
        String weatherType;
        boolean botsInLevel;
        String file2;
        String oldF = file2 = StringTools.getStringFromResource(file);
        String[] data = LevelLoader.cutLevelFile(file2);
        file2 = data[0];
        GameIni lvl = new GameIni(file2, false);
        GameIni setting = Main.settings;
        String zombiemod = LevelLoader.getStringdef("ZOMBIE_MODEL", lvl, setting, "/zombie.png");
        String zombietex = LevelLoader.getStringdef("ZOMBIE_TEXTURE", lvl, setting, "/zombie.png");
        String bigzombiemod = LevelLoader.getStringdef("BIGZOMBIE_MODEL", lvl, setting, "/big_zombie.png");
        String bigzombietex = LevelLoader.getStringdef("BIGZOMBIE_TEXTURE", lvl, setting, "/big_zombie.png");
        BigZombie.model = null;
        Zombie.model = null;
        BigZombie.texture = null;
        Zombie.texture = null;
        float zombiescale = LevelLoader.getFloat("ZOMBIE_SCALE", lvl, setting, 4.5f);
        float bigzombiescale = LevelLoader.getFloat("BIGZOMBIE_SCALE", lvl, setting, 50.0f);
        Zombie.animSpeed = LevelLoader.getInt("ZOMBIE_ANIMSPEED", lvl, setting, 140);
        BigZombie.animSpeed = LevelLoader.getInt("BIGZOMBIE_ANIMSPEED", lvl, setting, 135);
        Zombie.attackAnimSpeed = LevelLoader.getInt("ZOMBIE_ATTACKANIMSPEED", lvl, setting, 700);
        BigZombie.attackAnimSpeed = LevelLoader.getInt("BIGZOMBIE_ATTACKANIMSPEED", lvl, setting, 270);
        Zombie.attackDamage = LevelLoader.getInt("ZOMBIE_DAMAGE", lvl, setting, 1);
        BigZombie.attackDamage = LevelLoader.getInt("BIGZOMBIE_DAMAGE", lvl, setting, 7);
        Zombie.attackRadius = LevelLoader.getFloat("ZOMBIE_ATTACKRADIUS", lvl, setting, 1.2f);
        BigZombie.attackRadius = LevelLoader.getFloat("BIGZOMBIE_ATTACKRADIUS", lvl, setting, 1.2f);
        Zombie.jumpHeight = LevelLoader.getInt("ZOMBIE_JUMPHEIGHT", lvl, setting, 140);
        BigZombie.jumpHeight = LevelLoader.getInt("BIGZOMBIE_JUMPHEIGHT", lvl, setting, 202);
        Zombie.jumpSpeed = LevelLoader.getFloat("ZOMBIE_JUMPSPEED", lvl, setting, 1.2f);
        BigZombie.jumpSpeed = LevelLoader.getFloat("BIGZOMBIE_JUMPSPEED", lvl, setting, 1.2f);
        BigZombie.jumpHeight2 = LevelLoader.getInt("BIGZOMBIE_JUMPHEIGHT2", lvl, setting, 202);
        BigZombie.jumpSpeed2 = LevelLoader.getFloat("BIGZOMBIE_JUMPSPEED2", lvl, setting, 1.2f);
        Zombie.walkSpeed = LevelLoader.getInt("ZOMBIE_SPEED", lvl, setting, 140);
        BigZombie.walkSpeed = LevelLoader.getInt("BIGZOMBIE_SPEED", lvl, setting, 135);
        Zombie.reactTimer = LevelLoader.getInt("ZOMBIE_REACTTIMER", lvl, setting, 8);
        BigZombie.reactTimer = LevelLoader.getInt("BIGZOMBIE_REACTTIMER", lvl, setting, 8);
        Zombie.attackTimer = LevelLoader.getInt("ZOMBIE_ATTACKTIMER", lvl, setting, 8);
        BigZombie.attackTimer = LevelLoader.getInt("BIGZOMBIE_ATTACKTIMER", lvl, setting, 14);
        Zombie.AI = LevelLoader.getInt("ZOMBIE_AI", lvl, setting, 1);
        BigZombie.AI = LevelLoader.getInt("BIGZOMBIE_AI", lvl, setting, 1);
        Zombie.enemyReaction = LevelLoader.getInt("ZOMBIE_PLAYERREACTION", lvl, setting, 2);
        BigZombie.enemyReaction = LevelLoader.getInt("BIGZOMBIE_PLAYERREACTION", lvl, setting, 2);
        Zombie.attackState = LevelLoader.getInt("ZOMBIE_ATTACKTRIGGER", lvl, setting, 2);
        BigZombie.attackState = LevelLoader.getInt("BIGZOMBIE_ATTACKTRIGGER", lvl, setting, 2);
        Zombie.moneyOnDeath = LevelLoader.getInt("ZOMBIE_PRICE", lvl, setting, 10);
        BigZombie.moneyOnDeath = LevelLoader.getInt("BIGZOMBIE_PRICE", lvl, setting, 30);
        Zombie.maxHP = LevelLoader.getInt("LIFE_ZOMBIE", lvl, setting, 100);
        BigZombie.max_hp = LevelLoader.getInt("LIFE_BIG_ZOMBIE", lvl, setting, 400);
        Zombie.attackTo = GameIni.cutOnInts(LevelLoader.getStringdef("ZOMBIE_ATTACK", lvl, setting, "0,3"), ',', ';');
        BigZombie.attackTo = GameIni.cutOnInts(LevelLoader.getStringdef("BIGZOMBIE_ATTACK", lvl, setting, "0,3"), ',', ';');
        defaultOneBot = LevelLoader.getBoolean("SPAWN_ONE_ENEMY", lvl, setting, false);
        Bot.cleverPathfinfing = LevelLoader.getBoolean("BOTS_CLEVER_PATHFINDING", lvl, setting, true);
        float levelScale = LevelLoader.getFloat("WORLD_SCALE", lvl, setting, 1.0f);
        Main.floorOffsetSZ = LevelLoader.getInt("FLOOR_OFFSETSZ", lvl, setting, 0);
        Main.fullScreenSight = LevelLoader.getBoolean("MAXIMIZE_SIGHT", lvl, setting, false);
        Main.originalSight = LevelLoader.getBoolean("ORIGINAL_SIGHT", lvl, setting, false);
        Main.sight_icon = LevelLoader.getStringdef("SIGHT_ICON", lvl, setting, "/sight.png");
        Main.originalUseIcon = LevelLoader.getBoolean("ORIGINAL_USE_ICON", lvl, setting, false);
        Zombie.fallDeath = (byte)LevelLoader.getInt("ZOMBIE_FALL_ON_DEATH", lvl, setting, 1);
        BigZombie.fallDeath = (byte)LevelLoader.getInt("BIGZOMBIE_FALL_ON_DEATH", lvl, setting, 1);
        Zombie.bloodHas = LevelLoader.getBoolean("ZOMBIE_HAS_BLOOD", lvl, setting, true);
        BigZombie.bloodHas = LevelLoader.getBoolean("BIGZOMBIE_HAS_BLOOD", lvl, setting, true);
        Main.Blood = LevelLoader.getString("BLOOD_TEX", lvl, setting);
        if (Main.Blood != null) {
            Asset.getTexture(Main.Blood);
        }
        GameScreen.bloom = LevelLoader.getBoolean("BLOOM", lvl, setting, false);
        DirectX7.lightdiry = (short)LevelLoader.getInt("LIGHT_Y", lvl, setting, 4096);
        DirectX7.lightdirx = (short)LevelLoader.getInt("LIGHT_X", lvl, setting, -4096);
        DirectX7.lightdirz = (short)LevelLoader.getInt("LIGHT_Z", lvl, setting, 4096);
        DirectX7.setFogDist(LevelLoader.getInt("FOGD", lvl, setting, 1));
        DirectX7.setDrDist(LevelLoader.getInt("DIST", lvl, setting, Integer.MAX_VALUE));
        DirectX7.standartDrawmode = (byte)LevelLoader.getInt("DMODE", lvl, setting, 0);
        String c = LevelLoader.getStringdef("FOGCR", lvl, setting, "NULL");
        if (!c.equals("NULL")) {
            int g = LevelLoader.getInt("FOGCG", lvl, setting, 0);
            int b = LevelLoader.getInt("FOGCB", lvl, setting, 0);
            DirectX7.fogc = StringTools.parseInt(c) << 16 | g << 8 | b;
        }
        if (!(c = LevelLoader.getStringdef("FOGC", lvl, setting, "NULL")).equals("NULL")) {
            DirectX7.fogc = StringTools.getRGB(c, ',');
        }
        MultyTexture mt = data.length == 1 ? new MultyTexture(lvl.get("WORLD_TEXTURE"), true) : new MultyTexture(StringTools.cutOnStrings(data[1], '\n'));
        Mesh[] meshes = Room.loadMeshes(lvl.get("WORLD_MODEL"), levelScale, levelScale, levelScale, mt);
        c = lvl.get("DRAW_MODES");
        if (c != null) {
            Asset.applyMeshEffects(meshes, c);
        }
        if ((c = lvl.get("MAP_ADDSZ")) != null) {
            int[] asz = GameIni.cutOnInts(c, ',', ';');
            for (int i = 0; i < asz.length; ++i) {
                mt.textures[i].addsz = asz[i];
            }
        }
        Main.forceLQFog = LevelLoader.getBoolean("LQFOG", lvl, setting, false);
        Main.updateOnlyNear = LevelLoader.getBoolean("UPDATE_ONLY_NEAR", lvl, setting, false);
        Main.updateOnlyNearPhysics = LevelLoader.getBoolean("UPDATE_ONLY_NEAR_PHYSICS", lvl, setting, Main.updateOnlyNear);
        String skyboxModel = LevelLoader.getStringdef("SKYBOX_MODEL", lvl, setting, "NULL");
        String skyboxTexture = LevelLoader.getStringdef("SKYBOX_TEXTURE", lvl, setting, "NULL");
        String skyboxGradient = LevelLoader.getStringdef("SKYBOX_GRADIENT", lvl, setting, "NULL");
        String skyboxLighting = LevelLoader.getStringdef("SKYBOX_LIGHTING", lvl, setting, "NULL");
        boolean M3G_SkyBoxSpeedUp = false;
        try {
            Class.forName("javax.microedition.m3g.Graphics3D");
        }
        catch (ClassNotFoundException e) {
            M3G_SkyBoxSpeedUp = false;
        }
        Skybox skybox = null;
        byte oldf = DirectX7.standartDrawmode;
        DirectX7.standartDrawmode = 0;
        if (!skyboxModel.equals("NULL") && !skyboxTexture.equals("NULL")) {
            if (!M3G_SkyBoxSpeedUp || skyboxTexture.indexOf(59) > -1 || skyboxTexture.indexOf(44) > -1) {
                skybox = new Skybox(skyboxModel, skyboxTexture, false, 0, 0);
                boolean pers = LevelLoader.getBoolean("SKYBOX_PERS", lvl, setting, true);
                Texture[] texs = skybox.texture.textures;
                for (int ti = 0; ti < texs.length; ++ti) {
                    texs[ti].setPerspectiveCorrection(pers);
                }
                String modesz = LevelLoader.getStringdef("SKYBOX_MODES", lvl, setting, "NULL");
                if (!modesz.equals("NULL")) {
                    Asset.applyMeshEffects(skybox.getMesh(), modesz);
                }
            } else {
                skybox = new Skybox(skyboxModel, skyboxTexture, true, width, height);
            }
        } else {
            c = LevelLoader.getStringdef("SKYBOX_COLOR_R", lvl, setting, "NULL");
            if (!c.equals("NULL") && skyboxModel.equals("NULL") && skyboxTexture.equals("NULL")) {
                skybox = new Skybox(StringTools.parseInt(c) << 16 | LevelLoader.getInt("SKYBOX_COLOR_G", lvl, setting, 0) << 8 | LevelLoader.getInt("SKYBOX_COLOR_B", lvl, setting, 0));
            } else {
                c = LevelLoader.getStringdef("SKYBOX_COLOR", lvl, setting, "NULL");
                if (!c.equals("NULL") && skyboxModel.equals("NULL") && skyboxTexture.equals("NULL")) {
                    int[] rgb = GameIni.cutOnInts(c, ',', ';');
                    int color = rgb.length > 1 ? rgb[0] << 16 | rgb[1] << 8 | rgb[2] : rgb[0] * 65793;
                    skybox = new Skybox(color);
                } else if (LevelLoader.getStringdef("SKYBOX_COLOR_R", lvl, setting, "NULL").equals("NULL") && skyboxModel.equals("NULL") && !skyboxTexture.equals("NULL")) {
                    float xs = LevelLoader.getFloat("SKYBOX_REPEAT_X", lvl, setting, 2.0f);
                    float ys = LevelLoader.getFloat("SKYBOX_REPEAT_Y", lvl, setting, 1.0f);
                    skybox = new Skybox(Asset.getTexture(skyboxTexture), xs, ys);
                } else if (!skyboxGradient.equals("NULL") && skyboxModel.equals("NULL") && skyboxTexture.equals("NULL")) {
                    int crop = -120;
                    float scale = 1.0f;
                    String[] tmp = GameIni.cutOnStrings(skyboxGradient, ',', ';');
                    if (tmp.length >= 2) {
                        scale = StringTools.parseFloat(tmp[1]);
                    }
                    if (tmp.length >= 3) {
                        crop = StringTools.parseInt(tmp[2]);
                    }
                    skybox = new Skybox(Asset.getTexture(tmp[0]), crop, scale);
                }
            }
        }
        if (skybox != null) {
            if (!skyboxLighting.equals("NULL")) {
                skybox.skyLighting = Asset.getTexture(skyboxLighting);
            }
            skybox.skyboxAlways = LevelLoader.getBoolean("SKYBOX_ALWAYS", lvl, setting, false);
            skybox.addViewport(0, 0, width, height);
        }
        DirectX7.standartDrawmode = oldf;
        Room.chunkSize = LevelLoader.getInt("CHUNK_COLLISION_SIZE", lvl, setting, 5000);
        Room.chunkSizeRender = LevelLoader.getInt("CHUNK_SIZE", lvl, setting, 0);
        LightMapper.reset();
        LightMapper.setFastCalc(!LevelLoader.getBoolean("LIGHTMAPPER_RAYCASTING", lvl, setting, !LightMapper.fastCalc));
        LightMapper.setslCheap(LevelLoader.getBoolean("SKY_LIGHT_CHEAP", lvl, setting, LightMapper.slCheap));
        LightMapper.ambientLightSet(GameIni.cutOnInts(LevelLoader.getString("AMBIENT_LIGHT", lvl, setting), ',', ';'));
        LightMapper.skyLightIntensitySet(GameIni.cutOnInts(LevelLoader.getString("SKY_LIGHT", lvl, setting), ',', ';'));
        LightMapper.sunLightIntensitySet(GameIni.cutOnInts(LevelLoader.getString("SUN_LIGHT", lvl, setting), ',', ';'));
        LightMapper.aoDistance = LevelLoader.getInt("AO_DISTANCE", lvl, setting, LightMapper.aoDistance);
        LightMapper.aoIntensity = LevelLoader.getInt("AO_INTENSITY", lvl, setting, LightMapper.aoIntensity);
        LightMapper.giRays = LevelLoader.getInt("GI_RAYS", lvl, setting, LightMapper.giRays);
        LightMapper.lumFromTexturesSet(GameIni.cutOnInts(LevelLoader.getString("GI_LUM_FROM_TEXTURES", lvl, setting), ',', ';'));
        LightMapper.giIntensitySet(GameIni.cutOnInts(LevelLoader.getString("GI_INTENSITY", lvl, setting), ',', ';'));
        LightMapper.giFallOffSet(GameIni.cutOnInts(LevelLoader.getString("GI_FALLOFF", lvl, setting), ',', ';'));
        LightMapper.cameraVectorLight = LevelLoader.getBoolean("CAMERA_VECTOR_LIGHT", lvl, setting, LightMapper.cameraVectorLight);
        LightMapper.bwGI = LevelLoader.getBoolean("GI_BW", lvl, setting, LightMapper.bwGI);
        LightMapper.smoothMax = (int)(8192.0f * LevelLoader.getFloat("PHONG_ANGLE", lvl, setting, 29.6631f) / 90.0f);
        gs.doubleBright = LevelLoader.getBoolean("DOUBLE_BRIGHT", lvl, setting, false);
        LightMapper.allRooms = LevelLoader.getBoolean("LIGHTMAPPER_ALLROOMS", lvl, setting, LightMapper.allRooms);
        String rays = LevelLoader.getString("LIGHT_RAYS", lvl, setting);
        if (rays != null) {
            LightMapper.setRays(StringTools.parseInt(rays));
        }
        Player.arcadeJumpPhysics = LevelLoader.getBoolean("ARCADE_JUMP_PHYSICS", lvl, setting, false);
        LevelLoader.loadLights(oldF, lvl);
        House house = HouseCreator.create(meshes, false, lvl.get("LIGHTMAP"));
        Respawn start = null;
        String tmp = lvl.get("START");
        if (tmp != null) {
            start = LevelLoader.readPoints(tmp, house)[0];
        }
        Respawn finish = null;
        tmp = lvl.get("FINISH");
        if (tmp != null) {
            finish = LevelLoader.readPoints(tmp, house)[0];
        }
        Respawn[] enemies = null;
        tmp = lvl.get("ENEMIES");
        if (tmp != null) {
            enemies = LevelLoader.readPoints(tmp, house);
        }
        int enemyCount = 0;
        if (enemies != null) {
            enemyCount = enemies.length;
        }
        if ((tmp = lvl.get("ENEMY_COUNT")) != null) {
            enemyCount = StringTools.parseInt(tmp);
        }
        int frequency = 2000;
        tmp = LevelLoader.getStringdef("FREQUENCY", lvl, setting, "NULL");
        if (!tmp.equals("NULL")) {
            frequency = LevelLoader.getInt("FREQUENCY", lvl, setting);
        }
        boolean bl = botsInLevel = enemies != null;
        if (botsInLevel) {
            boolean bl2 = botsInLevel = enemies.length > 0;
        }
        if (enemyCount > 0 && botsInLevel) {
            BigZombie.texture = new MultyTexture(bigzombietex, false);
            Zombie.texture = new MultyTexture(zombietex, false);
            Zombie.model = Asset.getMeshImageDynamic(zombiemod, zombiescale, zombiescale, zombiescale);
            Zombie.model_height = Zombie.model.getAnimation().getMesh().maxY() - Zombie.model.getAnimation().getMesh().minY();
            BigZombie.model = Asset.getMeshImageDynamic(bigzombiemod, bigzombiescale, bigzombiescale, bigzombiescale);
            BigZombie.model_height = BigZombie.model.getAnimation().getMesh().maxY() - BigZombie.model.getAnimation().getMesh().minY();
            tmp = LevelLoader.getStringdef("ZOMBIE_DRAW_MODES", lvl, setting, "NULL");
            if (!tmp.equals("NULL")) {
                Asset.applyMeshEffects(Zombie.model.getMesh(), tmp);
            }
            if (!(tmp = LevelLoader.getStringdef("BIGZOMBIE_DRAW_MODES", lvl, setting, "NULL")).equals("NULL")) {
                Asset.applyMeshEffects(BigZombie.model.getMesh(), tmp);
            }
        } else {
            Zombie.texture = null;
            Zombie.model = null;
            BigZombie.texture = null;
            BigZombie.model = null;
        }
        Scene scene = new Scene(width, height, house, start, finish, enemies, enemyCount, frequency, main, LevelLoader.getInt("ZOMBIE_COUNT", lvl, setting, 5), LevelLoader.getInt("GENERATE_BOTS_WAYS", lvl, setting, 1) == 1);
        house.setSkybox(skybox);
        if (LightMapper.lights != null) {
            house.sortLights(LightMapper.lights);
        }
        scene.g3d.updateFov(Main.stdFov);
        tmp = lvl.get("NEED_TO_EXIT");
        if (tmp != null) {
            scene.need = StringTools.cutOnStrings(lvl.get("NEED_TO_EXIT"), ',');
        }
        scene.deleteAnPart = LevelLoader.getInt("DELETE_IN_DISTANCE", lvl, setting, 0) == 1;
        scene.alwaysExit = LevelLoader.getInt("ALWAYS_EXIT", lvl, setting, 1) == 1;
        GameScreen.mus = LevelLoader.getStringdef("MUSIC", lvl, setting, "/music.mid");
        boolean bl3 = scene.exitWithoutWait = LevelLoader.getInt("NEW_EXIT", lvl, setting, 0) == 1;
        if (LevelLoader.getString("PLAYER_SHOP", lvl, setting) != null) {
            String sh = LevelLoader.getNoLang("PLAYER_SHOP", lvl, setting);
            gs.shopItems = (int[])(sh.equals("OFF") ? null : StringTools.cutOnInts(sh, ','));
        }
        if (gs.shopItems != null) {
            for (int i = 0; i < gs.shopItems.length; ++i) {
                if (gs.shopItems[i] != -1) continue;
                gs.shopItems[i] = Shop.weapon_count - 1;
            }
        }
        if ((weatherType = LevelLoader.getString("WEATHER", lvl, setting)) != null) {
            int[] tmp2;
            int particlesCount = LevelLoader.getInt("WEATHER_PARTICLES_COUNT", lvl, setting, 170);
            boolean isRain = weatherType.equals("RAIN");
            int[] colors = new int[]{0xAABBDD, 0x666666, 0xFFFFFF, 13290719};
            String userClrs = LevelLoader.getString("WEATHER_COLOR_NEAR", lvl, setting);
            if (userClrs != null) {
                tmp2 = GameIni.cutOnInts(userClrs, ',', ';');
                colors[isRain ? 0 : 2] = tmp2[0] << 16 | tmp2[1] << 8 | tmp2[2];
            }
            if ((userClrs = LevelLoader.getString("WEATHER_COLOR_FAR", lvl, setting)) != null) {
                tmp2 = GameIni.cutOnInts(userClrs, ',', ';');
                colors[isRain ? 1 : 3] = tmp2[0] << 16 | tmp2[1] << 8 | tmp2[2];
            }
            int[] lightingTimes = null;
            userClrs = LevelLoader.getString("WEATHER_LIGHTING", lvl, setting);
            if (userClrs != null) {
                lightingTimes = GameIni.cutOnInts(userClrs, ',', ';');
            }
            int particlesSize = LevelLoader.getInt("WEATHER_PARTICLES_SIZE", lvl, setting, isRain ? 22 : 4);
            (gs.wg = new WeatherGenerator((int)GameScreen.width, (int)(GameScreen.height * Main.getDisplaySize() / 100), (int)particlesCount, (int)colors[0], (int)colors[1], (int)colors[2], (int)colors[3], (boolean)(lightingTimes != null ? true : false), (int[])lightingTimes, (int)(isRain ? 4 : particlesSize), (int)(isRain ? particlesSize : 22), (int)(GameScreen.width / 2), (int)(GameScreen.height / 2), (int)2, (int)10)).generate = (byte)(isRain ? 1 : 2);
            gs.wg.createParticles();
        }
        if ((str = LevelLoader.getString("WALK_SOUND", lvl, setting)) != null) {
            String[] snds = GameIni.cutOnStrings(str, ';', ',');
            Main.stepSound = snds;
            for (int i = 0; i < snds.length; ++i) {
                if (!Main.isFootsteps || Main.footsteps == 0) continue;
                Asset.getSound(snds[i]);
            }
        }
        Main.jumpSound = LevelLoader.getString("JUMP_SOUND", lvl, setting);
        if (Main.isFootsteps && Main.footsteps != 0 && Main.jumpSound != null) {
            Asset.getSound(Main.jumpSound);
        }
        gs.levelIni = lvl;
        String rev = LevelLoader.getString("REVERB", lvl, setting);
        for (int i = 0; i < house.getRooms().length; ++i) {
            Room rm = house.getRooms()[i];
            str = lvl.get("WALK_SOUND_" + i);
            String reverb = LevelLoader.getStringdef("REVERB_" + i, lvl, setting, rev);
            if (str != null) {
                String[] snds = GameIni.cutOnStrings(str, ';', ',');
                rm.stepSound = snds;
                for (int i2 = 0; i2 < snds.length; ++i2) {
                    if (!Main.isFootsteps || Main.footsteps == 0) continue;
                    Asset.getSound(snds[i2]);
                }
            }
            rm.reverb = reverb;
            rm.jumpSound = lvl.get("JUMP_SOUND_" + i);
            if (rm.jumpSound == null || !Main.isFootsteps || Main.footsteps == 0) continue;
            Asset.getSound(rm.jumpSound);
        }
        str = LevelLoader.getString("PLAYER_ZOOM", lvl, setting);
        if (str != null) {
            int[] snds = GameIni.cutOnInts(str, ';', ',');
            Main.stdFov = snds[0];
            Main.zoomFov = snds[1];
            Main.hasZoom = false;
            if (snds[2] == 1) {
                Main.hasZoom = true;
            }
        }
        House.l2dRoomRendering = LevelLoader.getBoolean("L2D_ROOM_RENDERING", lvl, setting, false);
        House.boxRoomTesting = LevelLoader.getBoolean("BOX_ROOM_TESTING", lvl, setting, false);
        Player.fallDamage = LevelLoader.getBoolean("FALL_DAMAGE", lvl, setting, true);
        gs.fullMoveLvl = LevelLoader.getBoolean("LEVEL_END_CHANGEPOS", lvl, setting, false);
        if (LevelLoader.getString("SPAWN_LIMITER", lvl, setting) != null) {
            scene.botLimiter = GameIni.cutOnInts(LevelLoader.getString("SPAWN_LIMITER", lvl, setting), ',', ';');
        }
        if ((str = LevelLoader.getString("VIGNETTE", lvl, setting)) != null) {
            Image img = ImageResize.createImage(str, scene.g3d.getWidth(), scene.g3d.getHeight());
            int[] vignette = new int[img.getWidth() * img.getHeight()];
            img.getRGB(vignette, 0, width, 0, 0, img.getWidth(), img.getHeight());
            gs.vignette = new byte[vignette.length];
            for (int i = 0; i < vignette.length; ++i) {
                gs.vignette[i] = (byte)((vignette[i] & 0xFF) - 128);
            }
        }
        return scene;
    }

    private static Respawn[] readPoints(String file, House house) {
        if (file == null) {
            return null;
        }
        StringBuffer points = new StringBuffer();
        for (int i = 0; i < file.length(); ++i) {
            char ch = file.charAt(i);
            if (ch == ' ') continue;
            points.append(ch);
        }
        String[] poses = StringTools.cutOnStrings(points.toString(), ';');
        Respawn[] spawn = new Respawn[poses.length];
        for (int i = 0; i < spawn.length; ++i) {
            int[] vals = StringTools.cutOnInts(poses[i], ',');
            Vector3D pos = new Vector3D(vals[0], vals[1], vals[2]);
            spawn[i] = new Respawn(pos, house);
            if (vals.length >= 4) {
                spawn[i].mode = (byte)-127;
                spawn[i].cmode = (byte)(-127 + vals[3]);
                if (vals.length != 5 || vals[4] != 1) continue;
                spawn[i].respa = true;
                continue;
            }
            if (!defaultOneBot) continue;
            spawn[i].mode = (byte)-127;
            spawn[i].cmode = (byte)-126;
        }
        return spawn;
    }

    public static final void loadLights(String file, GameIni lvl) {
        int pos = 0;
        if (file == null) {
            return;
        }
        Vector<Light> light = new Vector<Light>();
        while (file.indexOf(91) >= 0) {
            pos = file.indexOf(91);
            int endpos = file.indexOf(93);
            String objectType = file.substring(pos + 1, endpos);
            String object = file.substring(endpos + 1);
            if ((endpos = object.indexOf(91)) >= 0) {
                file = object.substring(endpos);
                object = object.substring(0, endpos - 1);
            }
            GameIni obj = new GameIni(object, false);
            String key = obj.get("PRESET");
            if (objectType.indexOf("LIGHT") > -1) {
                String[] poses = StringTools.cutOnStrings(obj.get("POS"), ';');
                for (int count = 0; count < poses.length; ++count) {
                    int brightness = LevelLoader.getInt("BRIGHTNESS", obj, Main.settings, key, lvl, 255);
                    int[] color = new int[3];
                    String col = LevelLoader.getString("COLOR", obj, Main.settings, key);
                    if (col != null) {
                        color = GameIni.cutOnInts(col, ',', ';');
                        color[0] = color[0] * brightness / 255;
                        if (color.length > 1) {
                            color[1] = color[1] * brightness / 255;
                            color[2] = color[2] * brightness / 255;
                        } else {
                            int tmp = color[0];
                            color = new int[3];
                            color[2] = color[0] = tmp;
                            color[1] = color[0];
                        }
                    } else {
                        color[1] = color[2] = brightness;
                        color[0] = color[2];
                    }
                    Light l = new Light(StringTools.cutOnInts(poses[count], ','), color);
                    String tmp = LevelLoader.getString("DIRECTION", obj, Main.settings, key);
                    if (tmp != null) {
                        l.direction = new Vector3D(StringTools.cutOnInts(tmp, ','));
                    } else {
                        tmp = LevelLoader.getString("LOOK_AT", obj, Main.settings, key);
                        if (tmp != null) {
                            l.direction = new Vector3D(StringTools.cutOnInts(tmp, ','));
                            l.direction.add(-l.pos.x, -l.pos.y, -l.pos.z);
                        }
                    }
                    l.ceilingFix = (short)LevelLoader.getInt("CEILING_FIX", obj, Main.settings, key, lvl, 0);
                    l.floorFix = (short)LevelLoader.getInt("FLOOR_FIX", obj, Main.settings, key, lvl, 0);
                    l.part = LevelLoader.getInt("ROOM_ID", obj, Main.settings, key, lvl, -1);
                    light.addElement(l);
                }
            }
            if (endpos >= 0) continue;
            break;
        }
        LightMapper.lights = null;
        if (light.size() > 0) {
            Light[] l2 = new Light[light.size()];
            for (int i = 0; i < l2.length; ++i) {
                l2[i] = (Light)light.elementAt(i);
            }
            LightMapper.lights = l2;
        }
    }

    public static final void loadObjects(String level, GameIni lvl, Scene scene, Player p, boolean onlyObjs) {
        int pos = 0;
        String file = StringTools.getStringFromResource(level);
        int spawnersCount = 0;
        if (scene.rmsBots == null) {
            scene.rmsBots = new Vector();
        }
        if (scene.rmsObjects == null) {
            scene.rmsObjects = new Vector();
        }
        RoomObject lastAddedObject = null;
        int cmdIndex = -1;
        while (file.indexOf(91) >= 0) {
            Vector objs;
            pos = file.indexOf(91);
            int endpos = file.indexOf(93);
            String objectType = file.substring(pos + 1, endpos);
            String object = file.substring(endpos + 1);
            if ((endpos = object.indexOf(91)) >= 0) {
                file = object.substring(endpos);
                object = object.substring(0, endpos - 1);
            }
            GameIni obj = new GameIni(object, false);
            String key = obj.get("PRESET");
            cmdIndex = objectType.indexOf("ON_ACTIVATE");
            if (cmdIndex > -1) {
                objs = scene.getHouse().getObjects();
                if (cmdIndex > 0) {
                    if (objs.size() > 0) {
                        String newName = objectType.substring(0, cmdIndex - 1);
                        for (int i = 0; i < objs.size(); ++i) {
                            RoomObject robj = (RoomObject)objs.elementAt(i);
                            if (robj == null || robj.name == null || !robj.name.equals(newName)) continue;
                            robj.additional = LevelLoader.createScript(object);
                        }
                    }
                } else if (lastAddedObject != null) {
                    lastAddedObject.additional = LevelLoader.createScript(object);
                }
            } else {
                cmdIndex = objectType.indexOf("ON_SPAWN");
                if (cmdIndex > -1) {
                    objs = scene.getHouse().getObjects();
                    if (cmdIndex > 0) {
                        if (objs.size() > 0) {
                            String newName = objectType.substring(0, cmdIndex - 1);
                            for (int i = 0; i < objs.size(); ++i) {
                                RoomObject robj = (RoomObject)objs.elementAt(i);
                                if (robj == null || robj.name == null || !robj.name.equals(newName) || !(robj instanceof NPCSpawner)) continue;
                                ((NPCSpawner)robj).onSpawn = LevelLoader.createScript(object);
                            }
                        }
                    } else if (lastAddedObject != null && lastAddedObject instanceof NPCSpawner) {
                        ((NPCSpawner)lastAddedObject).onSpawn = LevelLoader.createScript(object);
                    }
                } else {
                    cmdIndex = objectType.indexOf("ON_DEATH");
                    if (cmdIndex > -1) {
                        objs = scene.getHouse().getObjects();
                        if (cmdIndex > 0) {
                            if (objs.size() > 0) {
                                String newName = objectType.substring(0, cmdIndex - 1);
                                for (int i = 0; i < objs.size(); ++i) {
                                    RoomObject robj = (RoomObject)objs.elementAt(i);
                                    if (robj == null || robj.name == null || !robj.name.equals(newName) || !(robj instanceof NPC)) continue;
                                    ((NPC)robj).onDeath = LevelLoader.createScript(object);
                                }
                            }
                        } else if (lastAddedObject != null && lastAddedObject instanceof NPC) {
                            ((NPC)lastAddedObject).onDeath = LevelLoader.createScript(object);
                        }
                    } else {
                        int i;
                        cmdIndex = objectType.indexOf("MESSAGE");
                        if (cmdIndex > -1) {
                            objs = scene.getHouse().getObjects();
                            String msg = object.replace('\n', '@');
                            if (cmdIndex > 0) {
                                if (objs.size() > 0) {
                                    String newName = objectType.substring(0, cmdIndex - 1);
                                    for (i = 0; i < objs.size(); ++i) {
                                        RoomObject robj = (RoomObject)objs.elementAt(i);
                                        if (robj == null || robj.name == null || !robj.name.equals(newName)) continue;
                                        robj.message = msg;
                                    }
                                }
                            } else if (lastAddedObject != null) {
                                lastAddedObject.message = msg;
                            }
                        } else {
                            String[] poses;
                            cmdIndex = objectType.indexOf("ERRMSG");
                            if (cmdIndex > -1) {
                                objs = scene.getHouse().getObjects();
                                String msg = object.replace('\n', '@');
                                if (cmdIndex > 0) {
                                    if (objs.size() > 0) {
                                        String newName = objectType.substring(0, cmdIndex - 1);
                                        for (i = 0; i < objs.size(); ++i) {
                                            RoomObject robj = (RoomObject)objs.elementAt(i);
                                            if (robj == null || robj.name == null || !robj.name.equals(newName)) continue;
                                            robj.errMessage = msg;
                                        }
                                    }
                                } else if (lastAddedObject != null) {
                                    lastAddedObject.errMessage = msg;
                                }
                            } else if (objectType.indexOf("OBJECT") > -1) {
                                poses = StringTools.cutOnStrings(obj.get("POS"), ';');
                                for (int count = 0; count < poses.length; ++count) {
                                    int[] ps = StringTools.cutOnInts(poses[count], ',');
                                    KeyObject t = new KeyObject(new Vector3D(ps[0], ps[1], ps[2]));
                                    LevelLoader.loadRM(obj, t, lvl, key);
                                    lastAddedObject = t;
                                    scene.getHouse().addObject(t);
                                }
                            } else if (objectType.indexOf("TELEPORT") > -1) {
                                poses = StringTools.cutOnStrings(obj.get("POS"), ';');
                                for (int count = 0; count < poses.length; ++count) {
                                    int[] ps = StringTools.cutOnInts(poses[count], ',');
                                    int[] ps2 = StringTools.cutOnInts(LevelLoader.getString("NEW_POS", obj, Main.settings, key), ',');
                                    Teleport t = new Teleport(new Vector3D(ps[0], ps[1], ps[2]), new Vector3D(ps2[0], ps2[1], ps2[2]));
                                    LevelLoader.loadRM(obj, t, lvl, key);
                                    t.pRot = LevelLoader.getInt("ROT", obj, Main.settings, key, 0);
                                    lastAddedObject = t;
                                    scene.getHouse().addObject(t);
                                }
                            } else if (objectType.indexOf("NPC") > -1) {
                                poses = StringTools.cutOnStrings(obj.get("POS"), ';');
                                for (int count = 0; count < poses.length; ++count) {
                                    boolean saveInRms;
                                    int[] ps = StringTools.cutOnInts(poses[count], ',');
                                    NPC t = LevelLoader.loadNPC(obj, key, ps);
                                    NPCSpawner spawn = null;
                                    String str = LevelLoader.getString("SPAWN", obj, Main.settings, key);
                                    if (str != null) {
                                        int[] sets = StringTools.cutOnInts(str, ',');
                                        spawn = new NPCSpawner(new Vector3D(ps[0], ps[1], ps[2]));
                                        spawn.canSpawn = sets[0];
                                        if (sets.length >= 2) {
                                            spawn.respawnIn = sets[1];
                                        }
                                        if (sets.length == 3) {
                                            spawn.rot = sets[2];
                                        }
                                        LevelLoader.loadRM(obj, spawn, lvl, key, "SPAWNER_");
                                        spawn.visiblityChecker = LevelLoader.getInt("SPAWNER_IGNORE_VISIBLITY_CHECK", obj, Main.settings, key, spawn.visiblityChecker ? 1 : 0) == 1;
                                        spawn.visiblityChecker = LevelLoader.getInt("SPAWNER_SAVE", obj, Main.settings, key, spawn.visiblityChecker ? 1 : 0) == 1;
                                        spawn.distanceToSpawn = LevelLoader.getLong("SPAWNER_DISTANCE", obj, Main.settings, key, spawn.distanceToSpawn);
                                        if (LevelLoader.getString("SPAWNER_ON_SPAWN", obj, Main.settings, key) != null) {
                                            spawn.onSpawn = StringTools.cutOnStrings(LevelLoader.getString("SPAWNER_ON_SPAWN", obj, Main.settings, key), ',');
                                        }
                                        if (LevelLoader.getString("SPAWNER_COUNT", obj, Main.settings, key) != null) {
                                            spawn.bots = new NPC[Math.max(1, LevelLoader.getInt("SPAWNER_COUNT", obj, Main.settings, key))];
                                            spawn.bots[0] = t;
                                            for (int i2 = 1; i2 < spawn.bots.length; ++i2) {
                                                spawn.bots[i2] = LevelLoader.loadNPC(obj, key, ps);
                                                spawn.bots[i2].name = spawn.bots[i2].name + "_" + String.valueOf(i2);
                                            }
                                        } else {
                                            spawn.bots = new NPC[1];
                                            spawn.bots[0] = t;
                                            spawn.bots[0].name = spawn.bots[0].name + "_1";
                                        }
                                    }
                                    boolean bl = saveInRms = LevelLoader.getInt("SAVE_IN_RMS", obj, Main.settings, key, 0) == 1;
                                    if (saveInRms) {
                                        ++spawnersCount;
                                    }
                                    LevelLoader.loadRM(obj, t, lvl, key);
                                    if (spawn == null) {
                                        if (saveInRms) {
                                            t.spawnerId = spawnersCount - 1;
                                            scene.rmsBots.addElement(t);
                                        }
                                        lastAddedObject = t;
                                        scene.getHouse().addObject(t);
                                        continue;
                                    }
                                    if (saveInRms) {
                                        spawn.spawnerId = spawnersCount - 1;
                                        scene.rmsBots.addElement(spawn);
                                    }
                                    lastAddedObject = spawn;
                                    scene.getHouse().addObject(spawn);
                                }
                            } else if (objectType.indexOf("SPRITE") > -1) {
                                poses = StringTools.cutOnStrings(obj.get("POS"), ';');
                                for (int count = 0; count < poses.length; ++count) {
                                    int[] flc;
                                    String[] texs = StringTools.cutOnStrings(LevelLoader.getString("TEX", obj, Main.settings, key), ',');
                                    Texture[] textures = new Texture[texs.length];
                                    for (int ti = 0; ti < texs.length; ++ti) {
                                        textures[ti] = Asset.getTextureNM(texs[ti]);
                                    }
                                    SpriteObject spr = new SpriteObject();
                                    spr.spr.setTextures(textures);
                                    spr.spr.setScale(LevelLoader.getInt("SCALE", obj, Main.settings, key, spr.spr.scale));
                                    spr.addsz = LevelLoader.getInt("ADDSZ", obj, Main.settings, key, spr.addsz);
                                    String tmp = LevelLoader.getString("OFFSET", obj, Main.settings, key, "NULL");
                                    if (!tmp.equals("NULL")) {
                                        if (tmp.equals("MID")) {
                                            spr.spr.setOffset(0, -spr.spr.getHeight() / 2);
                                        } else if (tmp.equals("UP")) {
                                            spr.spr.setOffset(0, -spr.spr.getHeight());
                                        }
                                    }
                                    spr.spr.animation_speed = LevelLoader.getFloat("ANIMATION_SPEED", obj, Main.settings, key, spr.spr.animation_speed);
                                    tmp = LevelLoader.getString("MODE", obj, Main.settings, key, "NULL");
                                    spr.spr.setMode(tmp);
                                    tmp = LevelLoader.getString("FOG", obj, Main.settings, key, "NULL");
                                    spr.spr.setFog(tmp);
                                    spr.spr.color = LevelLoader.getInt("COLOR", obj, Main.settings, key, spr.spr.color);
                                    tmp = LevelLoader.getString("CUTOFF", obj, Main.settings, key, "NULL");
                                    if (!tmp.equals("NULL") && tmp.equals("UP")) {
                                        spr.spr.cutoff = 1;
                                    }
                                    if (!(tmp = LevelLoader.getString("FLICKER", obj, Main.settings, key, "NULL")).equals("NULL")) {
                                        flc = StringTools.cutOnInts(tmp, ',');
                                        boolean[] flicker = new boolean[flc.length];
                                        for (int fi = 0; fi < flc.length; ++fi) {
                                            flicker[fi] = flc[fi] == 1;
                                        }
                                        spr.flicker = flicker;
                                    }
                                    if (!(tmp = LevelLoader.getString("COLOR_ANIM", obj, Main.settings, key, "NULL")).equals("NULL")) {
                                        flc = StringTools.cutOnInts(tmp, ',');
                                        spr.colorFlicker = flc;
                                    }
                                    int[] ps = StringTools.cutOnInts(poses[count], ',');
                                    spr.spr.getPosition().set(ps[0], ps[1], ps[2]);
                                    LevelLoader.loadRM(obj, spr, lvl, key);
                                    lastAddedObject = spr;
                                    scene.getHouse().addObject(spr);
                                }
                            } else if (objectType.indexOf("MESH") > -1) {
                                poses = StringTools.cutOnStrings(obj.get("POS"), ';');
                                for (int count = 0; count < poses.length; ++count) {
                                    int[] ps = StringTools.cutOnInts(poses[count], ',');
                                    float scale = LevelLoader.getFloat("MODEL_SCALE", obj, Main.settings, key, 1.0f);
                                    scale = LevelLoader.getFloat("SCALE", obj, Main.settings, key, scale);
                                    Mesh[] meshes = Asset.getMeshes(LevelLoader.getString("MODEL", obj, Main.settings, key), scale, scale, scale);
                                    MultyTexture mt = new MultyTexture(LevelLoader.getString("TEX", obj, Main.settings, key), false);
                                    MeshObject mobj = new MeshObject(meshes, mt, ps[0], ps[1], ps[2], LevelLoader.getBoolean("REALTIME_LIGHTING", obj, Main.settings, key, lvl, false));
                                    LevelLoader.loadRM(obj, mobj, lvl, key);
                                    String modes = LevelLoader.getString("DRAW_MODES", obj, Main.settings, key);
                                    Mesh meshz = mobj.animation.getMesh();
                                    if (modes != null) {
                                        Asset.applyMeshEffects(meshz, modes);
                                    }
                                    int rotY = LevelLoader.getInt("ROTATE_Y", obj, Main.settings, key, 0);
                                    if ((rotY = LevelLoader.getInt("ROT", obj, Main.settings, key, rotY)) != 0) {
                                        mobj.getCharacter().getTransform().rotY(rotY);
                                    }
                                    mobj.animSpeed = LevelLoader.getFloat("ANIMATION_SPEED", obj, Main.settings, key, mobj.animSpeed);
                                    mobj.getCharacter().setCollision(LevelLoader.getBoolean("PHYSICS", obj, Main.settings, key, true));
                                    mobj.getCharacter().setCollidable(LevelLoader.getBoolean("COLLIDER", obj, Main.settings, key, true));
                                    mobj.getCharacter().setUpdatable(LevelLoader.getBoolean("NOCOLL_UPDATE", obj, Main.settings, key, mobj.getCharacter().isCollidable()));
                                    mobj.setFriction(LevelLoader.getFloat("FRICTION", obj, Main.settings, key, mobj.getFriction()));
                                    mobj.setHp(LevelLoader.getInt("HP", obj, Main.settings, key, mobj.getHp()));
                                    float cscalex = LevelLoader.getFloat("COLLISION_SCALE_X", obj, Main.settings, key, 1.0f);
                                    float cscaley = LevelLoader.getFloat("COLLISION_SCALE_Y", obj, Main.settings, key, 1.0f);
                                    int xsize = mobj.animation.getMesh().maxX() - mobj.animation.getMesh().minX();
                                    int zsize = mobj.animation.getMesh().maxZ() - mobj.animation.getMesh().minZ();
                                    int ysize = mobj.animation.getMesh().maxY() - mobj.animation.getMesh().minY();
                                    mobj.setCharacterSize((int)((float)(xsize / 2) * cscalex), (int)((float)(zsize / 2) * cscalex), (int)((float)ysize * cscaley));
                                    String tmp = LevelLoader.getString("LIFT_POS", obj, Main.settings, key, "NULL");
                                    if (!tmp.equals("NULL")) {
                                        String[] poses2 = StringTools.cutOnStrings(tmp, ';');
                                        mobj.poses = new Vector3D[poses2.length + 1];
                                        mobj.poses[0] = new Vector3D(ps);
                                        for (int i3 = 0; i3 < poses2.length; ++i3) {
                                            int[] ps2 = StringTools.cutOnInts(poses2[i3], ',');
                                            mobj.poses[i3 + 1] = new Vector3D(ps2);
                                        }
                                        mobj.liftCycled = LevelLoader.getBoolean("LIFT_LOOP", obj, Main.settings, key, lvl, false);
                                        tmp = LevelLoader.getString("LIFT_TIMER", obj, Main.settings, key, "NULL");
                                        if (!tmp.equals("NULL")) {
                                            mobj.timeToMove = StringTools.cutOnInts(tmp, ',');
                                        } else {
                                            int speed = LevelLoader.getInt("LIFT_SPEED", obj, Main.settings, key, lvl, 2000);
                                            mobj.timeToMove = new int[mobj.poses.length - (mobj.liftCycled ? 0 : 1)];
                                            for (int i4 = 0; i4 < mobj.timeToMove.length; ++i4) {
                                                int i2 = i4 + 1;
                                                if (i2 >= mobj.poses.length) {
                                                    i2 = 0;
                                                }
                                                Vector3D a = mobj.poses[i4];
                                                Vector3D b = mobj.poses[i2];
                                                mobj.timeToMove[i4] = (int)(Math.sqrt((double)(a.x - b.x) * (double)(a.x - b.x) + (double)(a.y - b.y) * (double)(a.y - b.y) + (double)(a.z - b.z) * (double)(a.z - b.z)) * 1000.0 / (double)speed);
                                            }
                                        }
                                        mobj.lookAtDirect(mobj.poses[1].x, mobj.poses[1].z);
                                        mobj.activable = LevelLoader.getInt("ACTIVABLE", obj, Main.settings, key, lvl, 1) == 1;
                                        mobj.clickable = LevelLoader.getInt("CLICKABLE", obj, Main.settings, key, lvl, 1) == 1;
                                        mobj.liftReUse = LevelLoader.getInt("LIFT_REUSE", obj, Main.settings, key, lvl, 1) == 1;
                                        mobj.disactivateOnEnd = LevelLoader.getInt("LIFT_DISACTIVABLE_ON_END", obj, Main.settings, key, lvl, 0) == 1;
                                        mobj.liftSmoothMove = LevelLoader.getInt("LIFT_SMOOTH_MOVE", obj, Main.settings, key, lvl, 0);
                                        mobj.liftRotateToMove = LevelLoader.getInt("LIFT_SMOOTH_ROTATE", obj, Main.settings, key, lvl, 0) == 1;
                                        mobj.liftCanBePaused = LevelLoader.getInt("LIFT_CAN_BE_PAUSED", obj, Main.settings, key, lvl, 0) == 1;
                                        tmp = LevelLoader.getString("LIFT_PLAYER_FOLLOW", obj, Main.settings, key);
                                        if (tmp != null) {
                                            mobj.playerFollowLift = new Vector3D(StringTools.cutOnInts(tmp, ','));
                                        }
                                    }
                                    mobj.addsz = LevelLoader.getInt("ADDSZ", obj, Main.settings, key, mobj.addsz);
                                    tmp = LevelLoader.getString("ANIMATION_TYPE", obj, Main.settings, key, "NULL");
                                    if (!tmp.equals("NULL")) {
                                        int at = StringTools.parseInt(tmp);
                                        if (at < 2) {
                                            mobj.animType = at;
                                        }
                                        if (at == 2) {
                                            mobj.animType = 2;
                                            mobj.state = 2;
                                            mobj.activable = true;
                                            mobj.clickable = true;
                                        }
                                    }
                                    mobj.ignoreWeaponRayCast = LevelLoader.getInt("IGNORE_WEAPON_RAYCAST", obj, Main.settings, key, lvl, 0) == 1;
                                    mobj.precCol = LevelLoader.getInt("PRECISE_COLLISION", obj, Main.settings, key, 0) == 1;
                                    lastAddedObject = mobj;
                                    scene.getHouse().addObject(mobj);
                                }
                            } else if (objectType.indexOf("SHOP") > -1) {
                                poses = StringTools.cutOnStrings(obj.get("POS"), ';');
                                for (int count = 0; count < poses.length; ++count) {
                                    int[] ps = StringTools.cutOnInts(poses[count], ',');
                                    int[] prices = null;
                                    String[] files = null;
                                    int[] items = Shop.items;
                                    String tmp = LevelLoader.getString("SHOP", obj, Main.settings, key, "NULL");
                                    if (!tmp.equals("NULL")) {
                                        items = StringTools.cutOnInts(tmp, ',');
                                        for (int i5 = 0; i5 < items.length; ++i5) {
                                            if (items[i5] != -1) continue;
                                            items[i5] = Shop.weapon_count - 1;
                                        }
                                    }
                                    if (!(tmp = LevelLoader.getString("PRICES", obj, Main.settings, key, "NULL")).equals("NULL")) {
                                        prices = StringTools.cutOnInts(tmp, ',');
                                    }
                                    if (!(tmp = LevelLoader.getString("FILES", obj, Main.settings, key, "NULL")).equals("NULL")) {
                                        files = StringTools.cutOnStrings(LevelLoader.getString("FILES", obj, Main.settings, key), ',');
                                    }
                                    ShopObject mobj = new ShopObject(items, prices, files, ps[0], ps[1], ps[2]);
                                    LevelLoader.loadRM(obj, mobj, lvl, key);
                                    lastAddedObject = mobj;
                                    scene.getHouse().addObject(mobj);
                                }
                            } else if (objectType.indexOf("LEVELCHANGE") > -1) {
                                poses = StringTools.cutOnStrings(obj.get("POS"), ';');
                                for (int count = 0; count < poses.length; ++count) {
                                    int[] ps = StringTools.cutOnInts(poses[count], ',');
                                    int[] ps2 = GameIni.createPos(LevelLoader.getString("START_POS", obj, Main.settings, key), ',');
                                    LVLChange mobj = new LVLChange(ps[0], ps[1], ps[2], new Vector3D(ps2[0], ps2[1], ps2[2]), LevelLoader.getInt("LEVEL", obj, Main.settings, key));
                                    mobj.pRot = LevelLoader.getInt("ROT", obj, Main.settings, key, mobj.pRot);
                                    mobj.saveMus = LevelLoader.getInt("SAVEMUSIC", obj, Main.settings, key, 0) == 1;
                                    mobj.fullMove = LevelLoader.getInt("FULLMOVE", obj, Main.settings, key, lvl, 0) == 1;
                                    mobj.activable = true;
                                    LevelLoader.loadRM(obj, mobj, lvl, key);
                                    lastAddedObject = mobj;
                                    scene.getHouse().addObject(mobj);
                                }
                            } else if (objectType.indexOf("IMAGE2D") > -1) {
                                poses = StringTools.cutOnStrings(obj.get("POS"), ';');
                                for (int count = 0; count < poses.length; ++count) {
                                    int[] ps = StringTools.cutOnInts(poses[count], ',');
                                    Image img = null;
                                    try {
                                        String tmp = LevelLoader.getString("IMAGE", obj, Main.settings, key, "NULL");
                                        if (!tmp.equals("NULL")) {
                                            String scaleType = LevelLoader.getString("RESIZE", obj, Main.settings, key, "PROPORTIONAL3D");
                                            img = Image.createImage((String)tmp);
                                            float scalex = LevelLoader.getFloat("SCALE_X", obj, Main.settings, key, 1.0f);
                                            float scaley = LevelLoader.getFloat("SCALE_Y", obj, Main.settings, key, 1.0f);
                                            if (scaleType.equalsIgnoreCase("PROPORTIONAL3D")) {
                                                img = ImageResize.bilinearScaleImage(img, (float)scene.g3d.height * scalex / (float)img.getHeight(), (float)scene.g3d.height * scaley / (float)img.getHeight());
                                            } else if (scaleType.equalsIgnoreCase("FULL3DSCREEN")) {
                                                img = ImageResize.bilinearScaleImage(img, (float)scene.g3d.width * scalex / (float)img.getWidth(), (float)scene.g3d.height * scaley / (float)img.getHeight());
                                            } else if (scaleType.equalsIgnoreCase("PROPORTIONAL")) {
                                                img = ImageResize.bilinearScaleImage(img, (float)scene.g3d.height * scalex / (float)img.getHeight(), (float)(scene.g3d.height * 100 / Main.displaySize) * scaley / (float)img.getHeight());
                                            } else if (scaleType.equalsIgnoreCase("FULLSCREEN")) {
                                                img = ImageResize.bilinearResizeImage(img, scene.g3d.width, scene.g3d.height * 100 / Main.displaySize);
                                            } else if (scaleType.equalsIgnoreCase("ORIGINALSIZE")) {
                                                img = ImageResize.bilinearScaleImage(img, scaley, scaley);
                                            }
                                        }
                                    }
                                    catch (Exception tmp) {
                                        // empty catch block
                                    }
                                    long timeout = LevelLoader.getLong("TIMEOUT", obj, Main.settings, key, 1000L);
                                    Image2D mobj = new Image2D(new Vector3D(ps[0], ps[1], ps[2]), img, timeout);
                                    LevelLoader.loadRM(obj, mobj, lvl, key);
                                    lastAddedObject = mobj;
                                    scene.getHouse().addObject(mobj);
                                }
                            }
                        }
                    }
                }
            }
            if (lastAddedObject != null && lastAddedObject.destroyOnUse && lastAddedObject.reloadDestroy && lastAddedObject.name == null) {
                scene.rmsObjects.addElement(lastAddedObject);
            }
            if (endpos >= 0) continue;
            break;
        }
    }

    public static NPC loadNPC(GameIni obj, String key, int[] ps) {
        int rotY;
        float scale = LevelLoader.getFloat("SCALE", obj, Main.settings, key, 1.0f);
        scale = LevelLoader.getFloat("MODEl_SCALE", obj, Main.settings, key, scale);
        int hp = LevelLoader.getInt("HP", obj, Main.settings, key, 100);
        MultyTexture mt = null;
        String str = LevelLoader.getString("TEX", obj, Main.settings, key, "NULL");
        if (!str.equals("NULL")) {
            mt = new MultyTexture(LevelLoader.getString("TEX", obj, Main.settings, key), false);
        }
        String modes = LevelLoader.getString("DRAW_MODES", obj, Main.settings, key);
        MeshImage meim = null;
        str = LevelLoader.getString("MODEL", obj, Main.settings, key, "NULL");
        if (!str.equals("NULL")) {
            meim = Asset.getMeshImageDynamic(str, scale, scale, scale);
        }
        NPC t = new NPC(new Vector3D(ps[0], ps[1], ps[2]), meim, hp, mt);
        String mode = LevelLoader.getString("MODE", obj, Main.settings, key, "NULL");
        String fog = LevelLoader.getString("FOG", obj, Main.settings, key, "NULL");
        int color = LevelLoader.getInt("COLOR", obj, Main.settings, key, 0);
        t.damageFront = LevelLoader.loadSpriteAnim("DAMAGE_ANIM", obj, key, mode, fog, color);
        t.deathFront = LevelLoader.loadSpriteAnim("DEATH_ANIM", obj, key, mode, fog, color);
        if (t.deathFront != null) {
            t.deathFront.limiter = true;
        }
        t.attackFront = LevelLoader.loadSpriteAnim("ATTACK_ANIM", obj, key, mode, fog, color);
        t.stayFront = LevelLoader.loadSpriteAnim("STAY_ANIM", obj, key, mode, fog, color);
        if (t.stayFront != null) {
            t.model_height = t.stayFront.getHeight() * (t.stayFront.textures[0].rImg.scale < 2 ? 2 : 1);
            t.setCharacterSize(t.model_height);
        }
        t.walkFront = LevelLoader.loadSpriteAnim("WALK_ANIM", obj, key, mode, fog, color);
        t.damageBack = LevelLoader.loadSpriteAnim("DAMAGE_BACK_ANIM", obj, key, mode, fog, color);
        t.deathBack = LevelLoader.loadSpriteAnim("DEATH_BACK_ANIM", obj, key, mode, fog, color);
        if (t.deathBack != null) {
            t.deathBack.limiter = true;
        }
        t.attackBack = LevelLoader.loadSpriteAnim("ATTACK_BACK_ANIM", obj, key, mode, fog, color);
        t.stayBack = LevelLoader.loadSpriteAnim("STAY_BACK_ANIM", obj, key, mode, fog, color);
        t.walkBack = LevelLoader.loadSpriteAnim("WALK_BACK_ANIM", obj, key, mode, fog, color);
        t.damageSide = LevelLoader.loadSpriteAnim("DAMAGE_SIDE_ANIM", obj, key, mode, fog, color);
        t.deathSide = LevelLoader.loadSpriteAnim("DEATH_SIDE_ANIM", obj, key, mode, fog, color);
        if (t.deathSide != null) {
            t.deathBack.limiter = true;
        }
        t.attackSide = LevelLoader.loadSpriteAnim("ATTACK_SIDE_ANIM", obj, key, mode, fog, color);
        t.staySide = LevelLoader.loadSpriteAnim("STAY_SIDE_ANIM", obj, key, mode, fog, color);
        t.walkSide = LevelLoader.loadSpriteAnim("WALK_SIDE_ANIM", obj, key, mode, fog, color);
        Mesh meshz = null;
        if (t.meshImage != null) {
            meshz = t.meshImage.getMesh();
            meshz.setTexture(mt);
        }
        t.animspeed = LevelLoader.getInt("ANIMSPEED", obj, Main.settings, key, t.animspeed);
        t.attackanimspeed = LevelLoader.getInt("ATTACKANIMSPEED", obj, Main.settings, key, t.attackanimspeed);
        t.damage = LevelLoader.getInt("DAMAGE", obj, Main.settings, key, t.damage);
        t.attackradius = LevelLoader.getFloat("ATTACKRADIUS", obj, Main.settings, key, t.attackradius);
        t.jumpheight = LevelLoader.getInt("JUMPHEIGHT", obj, Main.settings, key, t.jumpheight);
        t.jumpspeed = LevelLoader.getFloat("JUMPSPEED", obj, Main.settings, key, t.jumpspeed);
        t.speed = LevelLoader.getInt("SPEED", obj, Main.settings, key, t.speed);
        t.reacttimer = LevelLoader.getInt("REACTTIMER", obj, Main.settings, key, t.reacttimer);
        t.attacktimer = LevelLoader.getInt("ATTACKTIMER", obj, Main.settings, key, t.attacktimer);
        t.whenEnemyIsFar = LevelLoader.getInt("AI", obj, Main.settings, key, t.whenEnemyIsFar);
        t.whenEnemyIsNear = LevelLoader.getInt("ENEMYREACTION", obj, Main.settings, key, t.whenEnemyIsNear);
        t.attackState = LevelLoader.getInt("ATTACKTRIGGER", obj, Main.settings, key, t.attackState);
        t.fraction = LevelLoader.getInt("FRACTION", obj, Main.settings, key, t.fraction);
        t.fragsOnDeath = LevelLoader.getInt("FRAGSONDEATH", obj, Main.settings, key, t.fragsOnDeath);
        t.fragsOnAnyDeath = LevelLoader.getInt("FRAGS_ON_ANY_DEATH", obj, Main.settings, key, t.fragsOnAnyDeath);
        t.moneyOnDeath = LevelLoader.getInt("MONEYONDEATH", obj, Main.settings, key, t.moneyOnDeath);
        t.damageSleepTime = LevelLoader.getInt("SLEEPONDAMAGE", obj, Main.settings, key, t.damageSleepTime);
        t.maxEnemyDistance = LevelLoader.getLong("MAXENEMYDISTANCE", obj, Main.settings, key, t.maxEnemyDistance);
        t.visiblityCheck = LevelLoader.getInt("VISIBLITY_CHECK", obj, Main.settings, key, 0) == 1;
        t.deathFall = (byte)LevelLoader.getInt("FALL_ON_DEATH", obj, Main.settings, key, 1);
        t.hasBlood = (byte)LevelLoader.getInt("HAS_BLOOD", obj, Main.settings, key, 1) == 1;
        str = LevelLoader.getString("ATTACK", obj, Main.settings, key);
        if (str != null) {
            t.toAttack = (int[])(str.equalsIgnoreCase("all") ? null : GameIni.cutOnInts(str, ',', ';'));
        }
        if ((str = LevelLoader.getString("FOLLOW", obj, Main.settings, key)) != null) {
            t.toFollow = (int[])(str.equalsIgnoreCase("all") ? null : GameIni.cutOnInts(str, ',', ';'));
        }
        t.inPlayerTeam = LevelLoader.getInt("IN_PLAYER_TEAM", obj, Main.settings, key, t.inPlayerTeam ? 1 : 0) == 1;
        str = LevelLoader.getString("FRIENDLY_FIRE", obj, Main.settings, key);
        if (str != null) {
            t.friendlyFire = GameIni.cutOnInts(str, ',', ';');
        }
        if ((str = LevelLoader.getString("ATTACKONDAMAGE", obj, Main.settings, key)) != null && StringTools.parseInt(str) == 1) {
            t.unicalEnemies = new Vector();
        }
        if ((str = LevelLoader.getString("ATTACKONDAMAGE_OP", obj, Main.settings, key)) != null && StringTools.parseInt(str) == 1) {
            if (t.unicalEnemies == null) {
                t.unicalEnemies = new Vector();
            }
            t.attackOnDamageOnlyPlayer = true;
        }
        if ((rotY = LevelLoader.getInt("ROT", obj, Main.settings, key, 0)) != 0) {
            t.getCharacter().rotY(rotY);
        }
        if ((str = LevelLoader.getString("MUZZLE_FLASH_POS", obj, Main.settings, key)) != null) {
            t.muzzleFlashPos = new Vertex(GameIni.cutOnInts(str, ',', ';'));
            t.muzzleFlash = new Sprite(Asset.getTexture(LevelLoader.getString("MUZZLE_FLASH", obj, Main.settings, key)), LevelLoader.getInt("MUZZLE_FLASH_SCALE", obj, Main.settings, key));
            if (t.muzzleFlash.textures[0].rImg.alphaMixing) {
                t.muzzleFlash.mode = (byte)3;
            }
            t.muzzleFlash.fog = false;
            t.lastAttack = 0L;
            t.muzzleFlashTimer = LevelLoader.getInt("MUZZLE_FLASH_TIMER", obj, Main.settings, key);
        }
        if ((str = LevelLoader.getString("ON_DEATH", obj, Main.settings, key)) != null) {
            t.onDeath = LevelLoader.loadScriptFromFile(str);
        }
        if (modes != null && meshz != null) {
            Asset.applyMeshEffects(meshz, modes);
        }
        t.getCharacter().setCollision(LevelLoader.getInt("PHYSICS", obj, Main.settings, key, 1) == 1);
        t.getCharacter().setCollidable(LevelLoader.getInt("COLLIDER", obj, Main.settings, key, 1) == 1);
        t.getCharacter().setUpdatable(LevelLoader.getInt("NOCOLL_UPDATE", obj, Main.settings, key, t.getCharacter().isCollidable() ? 1 : 0) == 1);
        float cscalex = (float)t.getCharacter().getRadius() * LevelLoader.getFloat("COLLISION_SCALE_X", obj, Main.settings, key, 1.0f);
        float cscaley = (float)t.getCharacter().getHeight() * LevelLoader.getFloat("COLLISION_SCALE_Y", obj, Main.settings, key, 1.0f);
        t.setCharacterSize((int)cscalex, (int)cscaley);
        t.initStaySprite();
        return t;
    }

    public static Sprite loadSpriteAnim(String name, GameIni obj, String key, String mode, String fog, int color) {
        String str = LevelLoader.getString(name, obj, Main.settings, key);
        if (str == null) {
            return null;
        }
        String[] texs = GameIni.cutOnStrings(str, ',', ';');
        Texture[] textures = new Texture[texs.length - 2];
        for (int i = 0; i < textures.length; ++i) {
            textures[i] = Asset.getTextureNM(texs[i + 2]);
        }
        Sprite spr = new Sprite(textures, StringTools.parseInt(texs[1]), StringTools.parseFloat(texs[0]));
        spr.setMode(mode);
        spr.setFog(fog);
        spr.color = color;
        return spr;
    }

    public static void loadRM(GameIni txt, RoomObject obj, GameIni lvl, String key) {
        LevelLoader.loadRM(txt, obj, lvl, key, "");
    }

    public static void loadRM(GameIni txt, RoomObject obj, GameIni lvl, String key, String bN) {
        obj.activable = LevelLoader.getBoolean(bN + "ACTIVABLE", txt, Main.settings, key, obj.activable);
        obj.clickable = LevelLoader.getBoolean(bN + "CLICKABLE", txt, Main.settings, key, obj.clickable);
        obj.singleUse = LevelLoader.getBoolean(bN + "SINGLEUSE", txt, Main.settings, key, obj.singleUse);
        obj.destroyOnUse = LevelLoader.getBoolean(bN + "DESTROYONUSE", txt, Main.settings, key, obj.destroyOnUse);
        obj.name = LevelLoader.getString(bN + "NAME", txt, Main.settings, key, obj.name);
        obj.desc = LevelLoader.getString(bN + "DESC", txt, Main.settings, key, obj.desc);
        obj.need = StringTools.cutOnStrings(LevelLoader.getString(bN + "NEED", txt, Main.settings, key), ',');
        String tmp = LevelLoader.getString(bN + "ON_ACTIVATE", txt, Main.settings, key);
        if (tmp != null) {
            obj.additional = LevelLoader.loadScriptFromFile(tmp);
        }
        obj.alwaysActivate = LevelLoader.getBoolean(bN + "ALWAYS_ACTIVATE", txt, Main.settings, key, obj.alwaysActivate);
        tmp = LevelLoader.getString(bN + "MESSAGE", txt, Main.settings, key);
        if (tmp != null) {
            obj.message = DialogScreen.loadTextFromFile(tmp);
        }
        if ((tmp = LevelLoader.getString(bN + "ERRMESSAGE", txt, Main.settings, key)) != null) {
            obj.errMessage = DialogScreen.loadTextFromFile(tmp);
        }
        obj.radius = LevelLoader.getLong(bN + "RADIUS", txt, Main.settings, key, obj.radius);
        obj.messageTimeOut = LevelLoader.getLong(bN + "MESSAGETIMEOUT", txt, Main.settings, key, obj.messageTimeOut);
        obj.messageType = LevelLoader.getInt(bN + "MESSAGETYPE", txt, Main.settings, key, obj.messageType);
        obj.errMessageTimeOut = LevelLoader.getLong(bN + "ERRMESSAGETIMEOUT", txt, Main.settings, key, obj.errMessageTimeOut);
        obj.errMessageType = LevelLoader.getInt(bN + "ERRMESSAGETYPE", txt, Main.settings, key, obj.errMessageType);
        obj.messageDelay = LevelLoader.getLong(bN + "MSGDELAY", txt, Main.settings, key, obj.messageDelay);
        obj.errMessageDelay = LevelLoader.getLong(bN + "ERRMSGDELAY", txt, Main.settings, key, obj.errMessageDelay);
        tmp = LevelLoader.getString(bN + "REUSETIMER", txt, Main.settings, key);
        if (tmp != null) {
            obj.lastActivate = 0L;
            obj.timeToReset = StringTools.parseLong(tmp);
            obj.hideWhenUnusable = true;
        }
        obj.hideWhenUnusable = LevelLoader.getBoolean(bN + "HIDEREUSE", txt, Main.settings, key, obj.hideWhenUnusable);
        tmp = LevelLoader.getString(bN + "NEEDTOPOINT", txt, Main.settings, key);
        if (tmp != null) {
            if (tmp.equals("1")) {
                obj.needToPoint = true;
            } else if (tmp.equals("2")) {
                obj.needToPoint = true;
                obj.squarePoint = true;
            }
        }
        if (obj.needToPoint && (obj instanceof SpriteObject || obj instanceof MeshObject || obj instanceof NPC)) {
            obj.dynamicPoint = true;
        }
        obj.dynamicPoint = LevelLoader.getBoolean(bN + "DYNAMICPOINT", txt, Main.settings, key, obj.dynamicPoint);
        if (obj.needToPoint && !obj.dynamicPoint) {
            GameObject mo;
            if (obj instanceof SpriteObject) {
                SpriteObject spr = (SpriteObject)obj;
                obj.pointRadius = spr.spr.getWidth() / 2;
                obj.pointHeight = spr.spr.getHeight() / 2;
                obj.pointOffset = new Vector3D(0, spr.spr.getHeight() / 2 + spr.spr.offsetY, 0);
            } else if (obj instanceof MeshObject) {
                mo = (MeshObject)obj;
                int sizex = mo.animation.getMesh().maxX() - mo.animation.getMesh().minX();
                int sizey = mo.animation.getMesh().maxY() - mo.animation.getMesh().minY();
                int sizez = mo.animation.getMesh().maxZ() - mo.animation.getMesh().minZ();
                obj.pointRadius = (sizex + sizez) / 4;
                obj.pointHeight = sizey / 2;
                obj.pointOffset = new Vector3D(mo.animation.getMesh().maxX() - sizex / 2, mo.animation.getMesh().maxY() - sizey / 2, mo.animation.getMesh().maxZ() - sizez / 2);
            } else if (obj instanceof NPC) {
                mo = (NPC)obj;
                int sizex = ((NPC)mo).meshImage.getMesh().maxX() - ((NPC)mo).meshImage.getMesh().minX();
                int sizey = ((NPC)mo).meshImage.getMesh().maxY() - ((NPC)mo).meshImage.getMesh().minY();
                int sizez = ((NPC)mo).meshImage.getMesh().maxZ() - ((NPC)mo).meshImage.getMesh().minZ();
                obj.pointRadius = (sizex + sizez) / 4;
                obj.pointHeight = sizey / 2;
                obj.pointOffset = new Vector3D(((NPC)mo).meshImage.getMesh().maxX() - sizex / 2, ((NPC)mo).meshImage.getMesh().maxY() - sizey / 2, ((NPC)mo).meshImage.getMesh().maxZ() - sizez / 2);
            }
        }
        if ((tmp = LevelLoader.getString(bN + "POINTRADIUS", txt, Main.settings, key)) != null) {
            obj.pointHeight = obj.pointRadius = StringTools.parseInt(tmp);
        }
        obj.pointHeight = LevelLoader.getInt(bN + "POINTHEIGHT", txt, Main.settings, key, obj.pointHeight);
        tmp = LevelLoader.getString(bN + "POINTOFFSET", txt, Main.settings, key);
        if (tmp != null) {
            int[] ps = StringTools.cutOnInts(tmp, ',');
            obj.pointOffset = new Vector3D(ps[0], ps[1], ps[2]);
        }
        if ((tmp = LevelLoader.getString(bN + "SOUND_ON_ACTIVATE", txt, Main.settings, key)) != null) {
            obj.sound = tmp;
            if (Main.isSounds && Main.sounds != 0) {
                Asset.getSound(tmp);
            }
        }
        obj.visible = LevelLoader.getBoolean(bN + "VISIBLE", txt, Main.settings, key, obj.visible);
        obj.activateOnlyOne = LevelLoader.getBoolean(bN + "ACTIVATE_ONLY_THIS", txt, Main.settings, key, lvl, obj.activateOnlyOne);
        obj.reloadDestroy = LevelLoader.getBoolean(bN + "DESTROY_ON_LEVEL_RELOAD", txt, Main.settings, key, lvl, obj.reloadDestroy);
        tmp = LevelLoader.getString(bN + "ROOM_ID", txt, Main.settings, key);
        if (tmp != null) {
            obj.setNewPart(StringTools.parseInt(tmp));
        }
    }

    private static String getString(String s, GameIni s1, GameIni s2) {
        return s1.getDef(s, s2.get(s));
    }

    private static String getNoLang(String s, GameIni s1, GameIni s2) {
        return s1.getNoLang(s, s2.getNoLang(s));
    }

    private static int getInt(String s, GameIni s1, GameIni s2) {
        return LevelLoader.getInt(s, s1, s2, 0);
    }

    private static int getInt(String s, GameIni s1, GameIni s2, int def) {
        return s1.getInt(s, s2.getInt(s, def));
    }

    private static boolean getBoolean(String s, GameIni s1, GameIni s2, boolean def) {
        return s1.getInt(s, s2.getInt(s, def ? 1 : 0)) == 1;
    }

    private static float getFloat(String s, GameIni s1, GameIni s2) {
        return LevelLoader.getFloat(s, s1, s2, 0.0f);
    }

    private static String getString(String s, GameIni s1, GameIni s2, String key) {
        return s1.getDef(s, key == null ? s2.get(s) : s2.getDef(key, s, s2.get(s)));
    }

    private static String getString(String s, GameIni s1, GameIni s2, String key, String def) {
        return s1.getDef(s, key == null ? s2.getDef(s, def) : s2.getDef(key, s, s2.getDef(s, def)));
    }

    private static String getStringdef(String s, GameIni s1, GameIni s2, String def) {
        return s1.getDef(s, s2.getDef(s, def));
    }

    private static int getInt(String s, GameIni s1, GameIni s2, String key) {
        return LevelLoader.getInt(s, s1, s2, key, 0);
    }

    private static int getInt(String s, GameIni s1, GameIni s2, String key, int def) {
        String tmp = LevelLoader.getString(s, s1, s2, key);
        if (tmp != null) {
            return StringTools.parseInt(tmp);
        }
        return def;
    }

    private static boolean getBoolean(String s, GameIni s1, GameIni s2, String key, boolean def) {
        return LevelLoader.getInt(s, s1, s2, key, def ? 1 : 0) == 1;
    }

    private static boolean getBoolean(String s, GameIni s1, GameIni s2, String key, GameIni lvl, boolean def) {
        return LevelLoader.getInt(s, s1, s2, key, lvl, def ? 1 : 0) == 1;
    }

    private static int getInt(String s, GameIni s1, GameIni s2, String key, GameIni lvl, int def) {
        return s1.getInt(s, key == null ? lvl.getInt(s, s2.getInt(s, def)) : s2.getInt(key, s, lvl.getInt(s, s2.getInt(s, def))));
    }

    private static float getFloat(String s, GameIni s1, GameIni s2, float def) {
        return s1.getFloat(s, s2.getFloat(s, def));
    }

    private static float getFloat(String s, GameIni s1, float def) {
        return s1.getFloat(s, def);
    }

    private static long getLong(String s, GameIni s1, GameIni s2, String key) {
        return LevelLoader.getLong(s, s1, s2, key, 0L);
    }

    private static long getLong(String s, GameIni s1, GameIni s2, String key, long def) {
        String tmp = LevelLoader.getString(s, s1, s2, key);
        if (tmp != null) {
            return StringTools.parseLong(tmp);
        }
        return def;
    }

    private static float getFloat(String s, GameIni s1, GameIni s2, String key) {
        return LevelLoader.getFloat(s, s1, s2, key, 0.0f);
    }

    private static float getFloat(String s, GameIni s1, GameIni s2, String key, float def) {
        String tmp = LevelLoader.getString(s, s1, s2, key);
        if (tmp != null) {
            return StringTools.parseFloat(tmp);
        }
        return def;
    }

    public static String[] createScript(String str) {
        Vector<Object> tmp = new Vector<Object>();
        Object[] strs = StringTools.cutOnStrings(str, '\n');
        for (int i = 0; i < strs.length; ++i) {
            if (strs[i] == null) continue;
            strs[i] = ((String)strs[i]).trim();
            if (((String)strs[i]).indexOf("//") == 0 || ((String)strs[i]).equals(" ")) continue;
            if (((String)strs[i]).indexOf("//") > 0) {
                strs[i] = ((String)strs[i]).substring(0, ((String)strs[i]).indexOf("//"));
            }
            if ((((String)strs[i]).charAt(0) == '}' || ((String)strs[i]).charAt(0) == '{') && ((String)strs[i]).length() > 1) {
                tmp.addElement(((String)strs[i]).substring(1, ((String)strs[i]).length()));
                tmp.addElement(((String)strs[i]).substring(0, 1));
                continue;
            }
            if ((((String)strs[i]).charAt(((String)strs[i]).length() - 1) == '}' || ((String)strs[i]).charAt(((String)strs[i]).length() - 1) == '{') && ((String)strs[i]).length() > 1) {
                tmp.addElement(((String)strs[i]).substring(0, ((String)strs[i]).length() - 1));
                tmp.addElement(((String)strs[i]).substring(((String)strs[i]).length() - 1, ((String)strs[i]).length()));
                continue;
            }
            tmp.addElement(strs[i]);
        }
        strs = new String[tmp.size()];
        tmp.copyInto(strs);
        return strs;
    }

    public static String[] loadScriptFromFile(String text) {
        if (text == null) {
            return null;
        }
        if (text.charAt(0) != '/' || !text.toLowerCase().endsWith(".txt")) {
            return StringTools.cutOnStrings(text, ';');
        }
        text = StringTools.getStringFromResource(text);
        return LevelLoader.createScript(text);
    }
}

