/*
 * Decompiled with CFR 0.152.
 */
package code.utils;

import code.Gameplay.GameScreen;
import code.HUD.Base.TextView;

public class DelayedDialog {
    public long messageTimeOut = -1L;
    public int messageType = 0;
    public String message = null;
    public long timeToShow = 0L;
    public long lastCheck = -1L;
    public long time = 0L;

    public DelayedDialog(long mto, int mt, String msg, long tts) {
        this.messageTimeOut = mto;
        this.messageType = mt;
        this.message = msg;
        this.timeToShow = tts;
    }

    public boolean update(GameScreen gs) {
        if (this.lastCheck == -1L) {
            this.lastCheck = System.currentTimeMillis();
        }
        this.time += System.currentTimeMillis() - this.lastCheck;
        if (this.time >= this.timeToShow) {
            this.activateDialog(gs);
            return true;
        }
        this.lastCheck = System.currentTimeMillis();
        return false;
    }

    private void activateDialog(GameScreen gs) {
        if (this.messageType > 0) {
            gs.customMessage = this.message;
            gs.customMessagePause = false;
            gs.customMessageEndTime = System.currentTimeMillis() + this.messageTimeOut;
            if (this.messageType == 2) {
                gs.customMessagePause = true;
                gs.customMessageEndTime = this.messageTimeOut;
            }
            GameScreen.lines.removeAllElements();
            TextView.createLines(this.message, GameScreen.lines, gs.font, GameScreen.width);
        }
        if (this.messageType == 0) {
            gs.showDialog(this.message);
        }
    }
}

