/*
 * Decompiled with CFR 0.152.
 */
package code.Rendering.Meshes;

import code.Math.MathUtils;
import code.Rendering.DirectX7;
import code.Rendering.Meshes.ColorLightedPolygon3V;
import code.Rendering.Meshes.Polygon3V;
import code.Rendering.Texture;
import code.Rendering.TexturingAffine;
import code.Rendering.TexturingPers;
import code.Rendering.Vertex;
import code.utils.Main;

public class LightedPolygon3V
extends Polygon3V {
    public volatile byte la;
    public volatile byte lb;
    public volatile byte lc;
    private static int q;
    private static int sz2;
    private static short sizex;
    private static short sizey;
    private static short sizeu;
    private static short sizev;
    private static byte addmip;
    private static byte fog;

    public LightedPolygon3V(LightedPolygon3V p) {
        super(p);
        this.la = p.la;
        this.lb = p.lb;
        this.lc = p.lc;
    }

    public LightedPolygon3V(ColorLightedPolygon3V p) {
        super(p);
        this.la = (byte)((p.ar + p.ag + p.ab) / 3);
        this.lb = (byte)((p.br + p.bg + p.bb) / 3);
        this.lc = (byte)((p.cr + p.cg + p.cb) / 3);
    }

    public LightedPolygon3V(Vertex a2, Vertex b2, Vertex c2, byte au, byte av, byte bu, byte bv, byte cu, byte cv) {
        super(a2, b2, c2, au, av, bu, bv, cu, cv);
        this.lc = (byte)127;
        this.lb = (byte)127;
        this.la = (byte)127;
    }

    public final void render(DirectX7 g3d, Texture texture) {
        if (Main.persQ == 0 && !Main.mipMapping) {
            this.renderFast(g3d, texture);
            return;
        }
        fog = texture.drawmode;
        sizex = (short)LightedPolygon3V.size(this.a.sx, this.b.sx, this.c.sx);
        sizey = (short)LightedPolygon3V.size(this.a.sy, this.b.sy, this.c.sy);
        int la2 = this.getLight(this.a, this.la, g3d);
        int lb2 = this.getLight(this.b, this.lb, g3d);
        int lc2 = this.getLight(this.c, this.lc, g3d);
        if (fog == 5) {
            sz2 = 255 - MathUtils.calcLight(this.nx, this.ny, this.nz, DirectX7.lightdirx, DirectX7.lightdiry, DirectX7.lightdirz);
        }
        if (fog == 1) {
            this.szCalcfogAdd();
        }
        int n = q = this.ny > 4000 || this.ny < -4000 ? 9999999 : Main.q;
        if (Main.mipMapping && texture.mip != null) {
            texture.rImg = texture.mip[0];
            if (texture.drawmode < 10 || texture.drawmode > 12) {
                addmip = (byte)(q > 999 ? 2 : 3);
                if ((sizex + sizey >> 1) * addmip < (sizeu = (short)(LightedPolygon3V.size(this.au & 0xFF, this.bu & 0xFF, this.cu & 0xFF) * texture.rImg.w >> 8)) + (sizev = (short)(LightedPolygon3V.size(this.av & 0xFF, this.bv & 0xFF, this.cv & 0xFF) * texture.rImg.h >> 8))) {
                    texture.rImg = texture.mip[1];
                    if (texture.mip != null && (sizex + sizey >> 1) * addmip < (sizeu = (short)(sizeu >> 1)) + (sizev = (short)(sizev >> 1))) {
                        texture.rImg = texture.mip[2];
                    }
                }
            } else if (sizex < texture.rImg.w || sizey < texture.rImg.w) {
                texture.rImg = texture.mip[1];
                if (texture.mip != null && (sizex < texture.rImg.w || sizey < texture.rImg.w)) {
                    texture.rImg = texture.mip[2];
                }
            }
        }
        if (texture.perspectiveCorrection && (sizex > 30 - (Main.persQ < 3 ? 0 : 15) || sizey > 30 - (Main.persQ < 3 ? 0 : 15)) && Main.persQ != 0 || Main.persQ == 4) {
            TexturingPers.paint(g3d, texture, this.a, this.au & 0xFF, this.av & 0xFF, this.b, this.bu & 0xFF, this.bv & 0xFF, this.c, this.cu & 0xFF, this.cv & 0xFF, DirectX7.fogc, fog, sz2, q, la2, lb2, lc2, la2, lb2, lc2, la2, lb2, lc2, this.nx, this.ny, this.nz);
        } else {
            TexturingAffine.paint(g3d, texture, this.a, this.au & 0xFF, this.av & 0xFF, this.b, this.bu & 0xFF, this.bv & 0xFF, this.c, this.cu & 0xFF, this.cv & 0xFF, DirectX7.fogc, fog, sz2, la2, lb2, lc2, la2, lb2, lc2, la2, lb2, lc2, this.nx, this.ny, this.nz);
        }
    }

    public void renderFast(DirectX7 g3d, Texture texture) {
        if (texture.drawmode == 5 && (sz2 = 255 - MathUtils.calcLight(this.nx, this.ny, this.nz, DirectX7.lightdirx, DirectX7.lightdiry, DirectX7.lightdirz)) < 0) {
            sz2 = 0;
        }
        if (texture.drawmode == 1 && fog == 1) {
            this.szCalcfogAdd();
        }
        TexturingAffine.paint(g3d, texture, this.a, this.au & 0xFF, this.av & 0xFF, this.b, this.bu & 0xFF, this.bv & 0xFF, this.c, this.cu & 0xFF, this.cv & 0xFF, DirectX7.fogc, texture.drawmode, sz2, this.la + 128, this.lb + 128, this.lc + 128, this.la + 128, this.lb + 128, this.lc + 128, this.la + 128, this.lb + 128, this.lc + 128, this.nx, this.ny, this.nz);
    }

    private static final int size(int a, int b, int c) {
        int t;
        if (b < a) {
            t = a;
            a = b;
            b = t;
        }
        if (c < a) {
            t = c;
            c = a;
            a = t;
        }
        if (c < b) {
            t = b;
            b = c;
            c = t;
        }
        return c - a;
    }
}

