/*
 * Decompiled with CFR 0.152.
 */
package com.Rendering.Meshes;

import com.Gameplay.Map.Light;
import com.Gameplay.Map.LightMapper;
import com.Gameplay.Map.Room;
import com.Math.MathUtils;
import com.Math.Matrix;
import com.Rendering.DirectX7;
import com.Rendering.Meshes.LightedPolygon3V;
import com.Rendering.Meshes.LightedPolygon4V;
import com.Rendering.Meshes.Morphing;
import com.Rendering.Meshes.Polygon3V;
import com.Rendering.Meshes.Polygon4V;
import com.Rendering.MultyTexture;
import com.Rendering.RenderObject;
import com.Rendering.RenderObjectBuffer;
import com.Rendering.TMPElement;
import com.Rendering.Texture;
import com.Rendering.Vertex;
import java.io.InputStream;
import java.util.Vector;

public class Mesh {
    private MultyTexture texture = null;
    private Vertex[] vertices;
    private RenderObject[] polygons;
    static RenderObjectBuffer buffer = new RenderObjectBuffer();
    static Matrix tmpMatrix = new Matrix();

    public Mesh() {
    }

    public static String getStringFromResource(String file) {
        InputStream var1 = null;
        try {
            int var2;
            var1 = new Object().getClass().getResourceAsStream(file);
            StringBuffer var5 = new StringBuffer();
            while ((var2 = var1.read()) != -1) {
                if (var2 == 13) continue;
                var2 = var2 >= 192 && var2 <= 255 ? var2 + 848 : var2;
                var5.append((char)var2);
            }
            var1.close();
            return var5.toString();
        }
        catch (Exception var4) {
            System.out.println("ERROR in getStr: " + var4);
            if (var1 != null) {
                try {
                    var1.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    private static Vector fragments(String str, char d) {
        Vector<String> var2 = new Vector<String>();
        int var5 = 0;
        int ends = 0;
        while (var5 < str.length()) {
            String var6;
            while (var5 < str.length()) {
                if (str.charAt(var5) == d && ends % 2 == 0) {
                    ++var5;
                    continue;
                }
                if (str.charAt(var5) != '\"') break;
                ++ends;
            }
            int var3 = var5;
            while (var5 < str.length() && (str.charAt(var5) != d || ends % 2 != 0)) {
                if (str.charAt(var5) == '\"') {
                    ++ends;
                }
                ++var5;
            }
            if (var3 >= var5 || (var6 = str.substring(var3, var5)) == null || var6.length() == 0) continue;
            var2.addElement(var6);
        }
        return var2;
    }

    public static String[] cutOnStrings(String str, char d) {
        Vector var2 = Mesh.fragments(str, d);
        Object[] var3 = new String[var2.size()];
        var2.copyInto(var3);
        return var3;
    }

    public static String[] cutOnStrings(String str, char d, char d2) {
        char d3 = d;
        if (str.indexOf(d2) >= 0) {
            d3 = d2;
        }
        Vector var2 = Mesh.fragments(str, d3);
        Object[] var3 = new String[var2.size()];
        var2.copyInto(var3);
        return var3;
    }

    public static int[] cutOnInts(String str, char d) {
        if (str == null) {
            return null;
        }
        Vector var3 = Mesh.fragments(str, d);
        int[] var4 = new int[var3.size()];
        for (int var2 = 0; var2 < var4.length; ++var2) {
            String str2 = Mesh.deleteExtremeSpaces((String)var3.elementAt(var2));
            var4[var2] = Integer.parseInt(str2);
        }
        return var4;
    }

    public static int[] cutOnInts(String str, char d, char d2) {
        if (str == null) {
            return null;
        }
        char d3 = d;
        if (str.indexOf(d2) >= 0) {
            d3 = d2;
        }
        Vector var3 = Mesh.fragments(str, d3);
        int[] var4 = new int[var3.size()];
        for (int var2 = 0; var2 < var4.length; ++var2) {
            String str2 = Mesh.deleteExtremeSpaces((String)var3.elementAt(var2));
            var4[var2] = Integer.parseInt(str2);
        }
        return var4;
    }

    public static String deleteExtremeSpaces(String s) {
        while (s.length() > 0 && s.charAt(0) == ' ') {
            s = s.substring(1, s.length());
        }
        while (s.length() > 0 && s.charAt(s.length() - 1) == ' ') {
            s = s.substring(0, s.length() - 1);
        }
        while (s.length() > 0 && s.charAt(s.length() - 1) == ';') {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public Mesh(Vertex[] vertices, RenderObject[] polygons) {
        this.vertices = vertices;
        this.polygons = polygons;
    }

    public Mesh(Vertex[] vertices, RenderObject[] polygons, MultyTexture tex) {
        this.vertices = vertices;
        this.polygons = polygons;
        this.texture = tex;
    }

    public void optimize() {
        int old = this.vertices.length;
        Vector<Vertex> buf = new Vector<Vertex>();
        for (int i = 0; i < this.vertices.length; ++i) {
            Vertex v = this.vertices[i];
            int s = Mesh.search(buf, v);
            if (s == -1) {
                buf.addElement(v);
                continue;
            }
            Mesh.replace(this.polygons, v, (Vertex)buf.elementAt(s));
        }
        this.vertices = new Vertex[buf.size()];
        buf.copyInto(this.vertices);
    }

    private static int search(Vector vertices, Vertex vertex) {
        int E = 10;
        for (int i = 0; i < vertices.size(); ++i) {
            Vertex v = (Vertex)vertices.elementAt(i);
            if (v == vertex || Math.abs(v.x - vertex.x) >= 10 || Math.abs(v.y - vertex.y) >= 10 || Math.abs(v.z - vertex.z) >= 10) continue;
            return i;
        }
        return -1;
    }

    private static void replace(RenderObject[] polygons, Vertex oldVertex, Vertex newVertex) {
        for (int i = 0; i < polygons.length; ++i) {
            RenderObject poly;
            if (polygons[i] instanceof Polygon3V) {
                poly = (Polygon3V)polygons[i];
                if (poly.a == oldVertex) {
                    poly.a = newVertex;
                }
                if (poly.b == oldVertex) {
                    poly.b = newVertex;
                }
                if (poly.c == oldVertex) {
                    poly.c = newVertex;
                }
            }
            if (!(polygons[i] instanceof Polygon4V)) continue;
            poly = (Polygon4V)polygons[i];
            if (((Polygon4V)poly).a == oldVertex) {
                ((Polygon4V)poly).a = newVertex;
            }
            if (((Polygon4V)poly).b == oldVertex) {
                ((Polygon4V)poly).b = newVertex;
            }
            if (((Polygon4V)poly).c == oldVertex) {
                ((Polygon4V)poly).c = newVertex;
            }
            if (((Polygon4V)poly).d != oldVertex) continue;
            ((Polygon4V)poly).d = newVertex;
        }
    }

    public void destroy() {
        int var1;
        this.texture = null;
        for (var1 = 0; var1 < this.polygons.length; ++var1) {
            this.polygons[var1] = null;
        }
        this.polygons = null;
        for (var1 = 0; var1 < this.vertices.length; ++var1) {
            this.vertices[var1] = null;
        }
        this.vertices = null;
    }

    public void setTexture(Texture texture) {
        this.texture = new MultyTexture(texture);
        for (int var1 = 0; var1 < this.polygons.length; ++var1) {
            if (this.polygons[var1] instanceof Polygon4V) {
                ((Polygon4V)this.polygons[var1]).tex = 0;
                continue;
            }
            ((Polygon3V)this.polygons[var1]).tex = 0;
        }
    }

    public void setTexture(MultyTexture texture) {
        this.texture = texture;
    }

    public void resetTexture() {
        this.texture = null;
    }

    public int maxX() {
        int var1 = Integer.MIN_VALUE;
        for (int var2 = 0; var2 < this.vertices.length; ++var2) {
            if (this.vertices[var2].x <= var1) continue;
            var1 = this.vertices[var2].x;
        }
        return var1;
    }

    public int maxY() {
        int var1 = Integer.MIN_VALUE;
        for (int var2 = 0; var2 < this.vertices.length; ++var2) {
            if (this.vertices[var2].y <= var1) continue;
            var1 = this.vertices[var2].y;
        }
        return var1;
    }

    public int maxZ() {
        int var1 = Integer.MIN_VALUE;
        for (int var2 = 0; var2 < this.vertices.length; ++var2) {
            if (this.vertices[var2].z <= var1) continue;
            var1 = this.vertices[var2].z;
        }
        return var1;
    }

    public int minX() {
        int var1 = Integer.MAX_VALUE;
        for (int var2 = 0; var2 < this.vertices.length; ++var2) {
            if (this.vertices[var2].x >= var1) continue;
            var1 = this.vertices[var2].x;
        }
        return var1;
    }

    public int minY() {
        int var1 = Integer.MAX_VALUE;
        for (int var2 = 0; var2 < this.vertices.length; ++var2) {
            if (this.vertices[var2].y >= var1) continue;
            var1 = this.vertices[var2].y;
        }
        return var1;
    }

    public int minZ() {
        int var1 = Integer.MAX_VALUE;
        for (int var2 = 0; var2 < this.vertices.length; ++var2) {
            if (this.vertices[var2].z >= var1) continue;
            var1 = this.vertices[var2].z;
        }
        return var1;
    }

    public MultyTexture getTexture() {
        return this.texture;
    }

    public Vertex[] getVertices() {
        return this.vertices;
    }

    public RenderObject[] getPoligons() {
        return this.polygons;
    }

    public RenderObject[] getPolygons() {
        return this.polygons;
    }

    void render(DirectX7 g3d) {
        this.render(g3d, 0, 0, g3d.width, g3d.height);
    }

    void render(DirectX7 g3d, int x1, int y1, int x2, int y2) {
        RenderObject[] elements = this.polygons;
        buffer.addRenderObjects(elements, this.texture, x1, y1, x2, y2);
        buffer.sort();
        TMPElement[] buffer2 = buffer.getBuffer();
        for (int i = buffer.getSize() - 1; i >= 0; --i) {
            TMPElement element = buffer2[i];
            element.obj.renderFast(g3d, element.tex);
        }
        buffer.reset();
    }

    public static void resetBuffer() {
        buffer.resetTex();
        buffer.reset();
    }

    public void applySz() {
        RenderObject[] elements = this.polygons;
        for (int i = 0; i < elements.length; ++i) {
            RenderObject obj = elements[i];
            if (obj instanceof Polygon4V) {
                obj.sz += this.texture.textures[((Polygon4V)obj).tex].addsz;
                continue;
            }
            if (!(obj instanceof Polygon3V)) continue;
            obj.sz += this.texture.textures[((Polygon3V)obj).tex].addsz;
        }
    }

    public void setAnimation(Morphing animation) {
        animation.interpolation(this.vertices);
    }

    public void updateLighting(Matrix transform, boolean smoothNormals, Room room) {
        Light[] lights = room.lights;
        if (lights == null) {
            return;
        }
        Vertex normal = new Vertex(0, 0, 0);
        DirectX7.transform(this, transform);
        tmpMatrix.set(transform);
        tmpMatrix.setPosition(0, 0, 0);
        for (int i = 0; i < this.polygons.length; ++i) {
            RenderObject p;
            RenderObject ro = this.polygons[i];
            if (ro instanceof LightedPolygon3V) {
                p = (LightedPolygon3V)ro;
                normal.set(p.nx, p.ny, p.nz);
                normal.transform(tmpMatrix);
                p.la = this.getVertexLit(p.la, normal, p.a, room);
                p.lb = this.getVertexLit(p.lb, normal, p.b, room);
                p.lc = this.getVertexLit(p.lc, normal, p.c, room);
                continue;
            }
            if (!(ro instanceof LightedPolygon4V)) continue;
            p = (LightedPolygon4V)ro;
            normal.set(((LightedPolygon4V)p).nx, ((LightedPolygon4V)p).ny, ((LightedPolygon4V)p).nz);
            normal.transform(tmpMatrix);
            ((LightedPolygon4V)p).la = this.getVertexLit(((LightedPolygon4V)p).la, normal, ((LightedPolygon4V)p).a, room);
            ((LightedPolygon4V)p).lb = this.getVertexLit(((LightedPolygon4V)p).lb, normal, ((LightedPolygon4V)p).b, room);
            ((LightedPolygon4V)p).lc = this.getVertexLit(((LightedPolygon4V)p).lc, normal, ((LightedPolygon4V)p).c, room);
            ((LightedPolygon4V)p).ld = this.getVertexLit(((LightedPolygon4V)p).ld, normal, ((LightedPolygon4V)p).d, room);
        }
    }

    private static final Vertex getNormal(Mesh mesh, Vertex v) {
        int count = 0;
        Vertex norm = new Vertex();
        for (int i = 0; i < mesh.polygons.length; ++i) {
            RenderObject p;
            RenderObject ro = mesh.polygons[i];
            if (ro instanceof LightedPolygon3V) {
                p = (LightedPolygon3V)ro;
                if (!(p.a.sx == v.sx && p.a.sy == v.sy && p.a.rz == v.rz || p.b.sx == v.sx && p.b.sy == v.sy && p.b.rz == v.rz) && (p.c.sx != v.sx || p.c.sy != v.sy || p.c.rz != v.rz)) continue;
                norm.x += p.nx;
                norm.y += p.ny;
                norm.z += p.nz;
                ++count;
                continue;
            }
            if (!(ro instanceof LightedPolygon4V)) continue;
            p = (LightedPolygon4V)ro;
            if (!(((LightedPolygon4V)p).a.sx == v.sx && ((LightedPolygon4V)p).a.sy == v.sy && ((LightedPolygon4V)p).a.rz == v.rz || ((LightedPolygon4V)p).b.sx == v.sx && ((LightedPolygon4V)p).b.sy == v.sy && ((LightedPolygon4V)p).b.rz == v.rz || ((LightedPolygon4V)p).c.sx == v.sx && ((LightedPolygon4V)p).c.sy == v.sy && ((LightedPolygon4V)p).c.rz == v.rz) && (((LightedPolygon4V)p).d.sx != v.sx || ((LightedPolygon4V)p).d.sy != v.sy || ((LightedPolygon4V)p).d.rz != v.rz)) continue;
            norm.x += ((LightedPolygon4V)p).nx;
            norm.y += ((LightedPolygon4V)p).ny;
            norm.z += ((LightedPolygon4V)p).nz;
            ++count;
        }
        if (count != 0) {
            norm.x /= count;
            norm.y /= count;
            norm.z /= count;
        }
        return norm;
    }

    private byte getVertexLit(byte orig, Vertex norm, Vertex v, Room room) {
        long lit = 0L;
        Light[] lights = room.lights;
        Vertex tmp = new Vertex(v.sx, v.sy, v.rz);
        for (int i = 0; i < lights.length; ++i) {
            Light light = lights[i];
            long distSqr = LightMapper.distanceSqr(tmp, light.pos);
            long intensity = (long)((light.color[0] + light.color[1] + light.color[2]) / 3 * 783225) / Math.max(1L, distSqr) * 8L;
            if (distSqr < 0L) {
                intensity = 0L;
            }
            if (intensity > 1L) {
                if (light.direction == null) {
                    intensity = intensity * (long)MathUtils.calcLight(norm.sx, norm.sy, norm.rz, v.sx - light.pos.x, v.sy - light.pos.y, v.rz - light.pos.z) / 255L;
                } else {
                    intensity = intensity * (long)MathUtils.calcLight(light.direction.x, light.direction.y, light.direction.z, v.sx - light.pos.x, v.sy - light.pos.y, v.rz - light.pos.z) / 255L;
                    intensity = intensity * (long)MathUtils.calcLight(norm.sx, norm.sy, norm.rz, v.sx - light.pos.x, v.sy - light.pos.y, v.rz - light.pos.z) / 255L;
                }
            }
            if (intensity <= 1L) continue;
            lit += intensity;
        }
        return (byte)Math.max(Math.min(127L, lit - 128L + (long)LightMapper.ambientLightMid), -128L);
    }
}

