/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mid.sound;

import com.nokia.mid.sound.SoundListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public class Sound {
    public static final int FORMAT_TONE = 1;
    public static final int FORMAT_WAV = 5;
    public static final int SOUND_PLAYING = 0;
    public static final int SOUND_STOPPED = 1;
    public static final int SOUND_UNINITIALIZED = 3;
    private int state = 3;
    private Helper helper = new Helper(this);
    private Player implement;
    private VolumeControl volume;
    private SoundListener listener;

    public static int getConcurrentSoundCount(int type) {
        return 1;
    }

    public static int[] getSupportedFormats() {
        return new int[]{1, 5};
    }

    public Sound(int frequency, long duration) {
        this.recreate(frequency, duration);
    }

    public Sound(byte[] src, int type) {
        this.recreate(src, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(int frequency, long duration) {
        Helper helper = this.helper;
        synchronized (helper) {
            this.recreate(frequency, duration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(byte[] src, int type) {
        if (src == null) {
            throw new NullPointerException("Sound: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (type == 1) {
            throw new IllegalArgumentException("Sound: \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445 FORMAT_TONE \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u044d\u0442\u043e\u0439 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0435\u0439. \u042d\u0442\u043e\u0442 \u0444\u043e\u0440\u043c\u0430\u0442 \u0443\u0441\u0442\u0430\u0440\u0435\u043b \u0438 \u0432 \u043d\u0430\u0441\u0442\u043e\u044f\u0449\u0435\u0435 \u0432\u0440\u0435\u043c\u044f \u043d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f.");
        }
        Helper helper = this.helper;
        synchronized (helper) {
            this.recreate(src, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Helper helper = this.helper;
        synchronized (helper) {
            Player implement = this.implement;
            if (implement != null) {
                implement.close();
                this.implement = null;
                this.volume = null;
                this.state = 3;
            }
        }
    }

    public void resume() {
        try {
            Player implement = this.implement;
            if (implement != null) {
                implement.start();
                this.state = 0;
            }
        }
        catch (MediaException e) {
            e.printRealStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play(int loopCount) {
        if (loopCount < 0) {
            throw new IllegalArgumentException("Sound.play: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 loop.");
        }
        if (loopCount >= 255) {
            return;
        }
        if (loopCount == 0) {
            loopCount = -1;
        }
        Helper helper = this.helper;
        synchronized (helper) {
            try {
                Player implement = this.implement;
                if (implement != null) {
                    implement.stop();
                    implement.setLoopCount(loopCount);
                    implement.start();
                    this.state = 0;
                }
            }
            catch (MediaException e) {
                e.printRealStackTrace();
            }
        }
    }

    public void stop() {
        try {
            Player implement = this.implement;
            if (implement != null) {
                implement.stop();
                this.state = 1;
            }
        }
        catch (MediaException e) {
            e.printRealStackTrace();
        }
    }

    public void setSoundListener(SoundListener listener) {
        this.listener = listener == this ? this.helper : listener;
    }

    public void setGain(int level) {
        level = level < 0 ? 0 : (level > 255 ? 255 : level);
        VolumeControl volume = this.volume;
        if (volume != null) {
            volume.setLevel(level * 100 / 255);
        }
    }

    public int getGain() {
        VolumeControl volume = this.volume;
        return volume != null ? volume.getLevel() * 255 / 100 : -1;
    }

    public int getState() {
        return this.state;
    }

    private void recreate(int frequency, long duration) {
        System.out.println("\u041c\u0435\u0442\u043e\u0434 com.nokia.mid.sound.Sound.init(int, long) \u043d\u0435 \u0440\u0435\u0430\u043b\u0438\u0437\u043e\u0432\u0430\u043d.");
    }

    private void recreate(byte[] src, int type) {
        if (src == null) {
            throw new NullPointerException("Sound: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        switch (type) {
            case 5: {
                try {
                    Player implement = this.implement;
                    if (implement != null) {
                        implement.close();
                    }
                    implement = Manager.createPlayer((InputStream)new ByteArrayInputStream(src), (String)"audio/x-wav");
                    implement.addPlayerListener((PlayerListener)this.helper);
                    implement.prefetch();
                    VolumeControl volume = (VolumeControl)implement.getControl("VolumeControl");
                    this.implement = implement;
                    this.volume = volume;
                    this.state = 1;
                    break;
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("Sound: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0434\u0435\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u0441\u043e\u0433\u043b\u0430\u0441\u043d\u043e \u0444\u043e\u0440\u043c\u0430\u0442\u0443 \u0434\u0430\u043d\u043d\u044b\u0445 FORMAT_WAV.");
                }
            }
            case 1: {
                throw new IllegalArgumentException("Sound: \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445 FORMAT_TONE \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u044d\u0442\u043e\u0439 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0435\u0439. \u042d\u0442\u043e\u0442 \u0444\u043e\u0440\u043c\u0430\u0442 \u0443\u0441\u0442\u0430\u0440\u0435\u043b \u0438 \u0432 \u043d\u0430\u0441\u0442\u043e\u044f\u0449\u0435\u0435 \u0432\u0440\u0435\u043c\u044f \u043d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f.");
            }
            default: {
                throw new IllegalArgumentException("Sound: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 type.");
            }
        }
    }

    private static final class Helper
    extends WeakReference
    implements PlayerListener,
    SoundListener {
        Helper(Sound thisSound) {
            super(thisSound);
        }

        public void playerUpdate(Player player, String event, Object data) {
            Sound thisSound = (Sound)this.get();
            if (thisSound == null) {
                return;
            }
            if ("started".equals(event) || "stopped".equals(event) || "closed".equals(event)) {
                SoundListener listener = thisSound.listener;
                if (listener != null) {
                    listener.soundStateChanged(thisSound, thisSound.state);
                }
                return;
            }
            if ("endOfMedia".equals(event)) {
                thisSound.state = 1;
                SoundListener listener = thisSound.listener;
                if (listener != null) {
                    listener.soundStateChanged(thisSound, 1);
                }
            }
        }

        public void soundStateChanged(Sound sound, int event) {
            Object thisSound = this.get();
            if (thisSound != null && thisSound instanceof SoundListener) {
                ((SoundListener)thisSound).soundStateChanged(sound, event);
            }
        }
    }
}

