/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import malik.emulator.util.StringBuilder;

public abstract class InputStream {
    public abstract int read() throws IOException;

    public void close() throws IOException {
    }

    public void reset() throws IOException {
        throw new IOException(new StringBuilder().append("InputStream.reset: \u043a\u043b\u0430\u0441\u0441 ").append(this.getClass().getCanonicalName()).append(" \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u043c\u0435\u0442\u043e\u0434 reset.").toString());
    }

    public void mark(int readLimit) {
    }

    public boolean markSupported() {
        return false;
    }

    public int available() throws IOException {
        return 0;
    }

    public int read(byte[] dst) throws IOException {
        if (dst == null) {
            throw new NullPointerException("InputStream.read: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        return this.read(dst, 0, dst.length);
    }

    public int read(byte[] dst, int offset, int length) throws IOException {
        if (dst == null) {
            throw new NullPointerException("InputStream.read: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Array.checkBound("InputStream.read", dst.length, offset, length);
        int result = 0;
        while (result < length) {
            try {
                int readed = this.read();
                if (readed < 0) {
                    if (result != 0) break;
                    --result;
                    break;
                }
                dst[offset++] = (byte)readed;
            }
            catch (IOException e) {
                if (result > 0) break;
                throw e;
            }
            ++result;
        }
        return result;
    }

    public long skip(long quantity) throws IOException {
        if (quantity <= 0L) {
            return 0L;
        }
        long result = 0L;
        while (result < quantity) {
            try {
                if (this.read() < 0) {
                    break;
                }
            }
            catch (IOException e) {
                if (result > 0L) break;
                throw e;
            }
            ++result;
        }
        return result;
    }
}

