/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import malik.emulator.util.StringBuilder;
import malik.emulator.util.ThreadTerminationListenerCollection;

public class Thread
implements Runnable {
    static final int CREATED = 0;
    static final int RUNNING = 1;
    static final int WAITING = 2;
    static final int SUSPENDED = 3;
    static final int TERMINATED = 4;
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    public static final int MAX_PRIORITY = 10;
    private static final int STACK_RESERVED = 2048;
    private static int LAST_NUM;
    static final int MAIN_THREAD_ID;
    private static final Thread[] THREADS;
    private boolean stackTrace;
    boolean interrupted;
    private int id;
    int state;
    private int priority;
    private int stackBottom;
    Scheduler.Task resumeTask;
    Scheduler.Task suspendTask;
    Monitor blockedBy;
    private final Runnable target;
    private final String name;
    private final Object monitor;

    static {
        MAIN_THREAD_ID = MalikSystem.getCurrentThreadID();
        THREADS = new Thread[Thread.getMaximumThreads()];
    }

    public static void yield() {
        int i = 0;
        ++i;
        ++i;
        ++i;
        ++i;
        ++i;
        ++i;
        ++i;
        ++i;
        ++i;
        ++i;
        ++i;
        ++i;
        ++i;
        ++i;
        ++i;
        ++i;
        ++i;
        ++i;
        ++i;
        ++i;
    }

    public static void sleep(long millis) throws InterruptedException {
        boolean error = false;
        boolean status = MalikSystem.enterMonopolyAccess();
        try {
            Thread thread = Thread.currentThread();
            if (thread.interrupted) {
                thread.interrupted = false;
                error = true;
            } else if (millis <= 0L) {
            } else {
                ResumeTask task = thread.new ResumeTask();
                thread.resumeTask = task;
                Scheduler.schedule(task, millis, 2);
                task = null;
                thread.suspend(false);
                if (thread.interrupted) {
                    thread.interrupted = false;
                    error = true;
                }
            }
        }
        finally {
            MalikSystem.leaveMonopolyAccess(status);
        }
        if (error) {
            throw new InterruptedException("Thread.sleep: \u043f\u043e\u0442\u043e\u043a \u0438\u0441\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0431\u044b\u043b \u043f\u0440\u0435\u0440\u0432\u0430\u043d.");
        }
    }

    public static int activeCount() {
        int result = 0;
        int i = THREADS.length;
        while (i-- > 0) {
            if (THREADS[i] == null) continue;
            ++result;
        }
        return result;
    }

    public static Thread currentThread() {
        return THREADS[MalikSystem.getCurrentThreadID()];
    }

    static void completeInit() {
        Thread.THREADS[Thread.MAIN_THREAD_ID] = new Thread(5, MAIN_THREAD_ID);
    }

    static void waitForInterrupt() throws InterruptedException {
        Thread thread = Thread.currentThread();
        if (thread.interrupted) {
            thread.interrupted = false;
            throw new InterruptedException("Thread.waitForInterrupt: \u043f\u043e\u0442\u043e\u043a \u0438\u0441\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0431\u044b\u043b \u043f\u0440\u0435\u0440\u0432\u0430\u043d.");
        }
        MalikSystem.syscall(0L, 14);
        if (thread.interrupted) {
            thread.interrupted = false;
            throw new InterruptedException("Thread.waitForInterrupt: \u043f\u043e\u0442\u043e\u043a \u0438\u0441\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0431\u044b\u043b \u043f\u0440\u0435\u0440\u0432\u0430\u043d.");
        }
    }

    private static void writeStackLimit(int address) {
        MalikSystem.setIntAt(address + 12, 266797311);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int nextThreadNumber() {
        Thread[] threadArray = THREADS;
        synchronized (THREADS) {
            int result = ++LAST_NUM;
            // ** MonitorExit[var1] (shouldn't be in output)
            return result;
        }
    }

    private static int getMaximumThreads() {
        return ((int)(MalikSystem.syscall(0L, 15) >> 32) & 0xFF) + 1;
    }

    public Thread() {
        this(null, null);
    }

    public Thread(String name) {
        this(null, name);
    }

    public Thread(Runnable target) {
        this(target, null);
    }

    public Thread(Runnable target, String name) {
        if (name == null || name.length() <= 0) {
            name = "\u041f\u043e\u0442\u043e\u043a \u0438\u0441\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f #".concat(Integer.toString(Thread.nextThreadNumber()));
        }
        this.id = -1;
        this.state = 0;
        this.priority = 5;
        this.stackBottom = 0;
        this.target = target;
        this.name = name;
        this.monitor = new Object();
    }

    private Thread(int priority, int id) {
        if (priority < 1 || priority > 10) {
            throw new IllegalArgumentException("Thread: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 priority \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        long answer = MalikSystem.syscall(0L, 6);
        int address = (int)answer;
        Thread.writeStackLimit(address + 2048);
        this.id = id;
        this.state = 1;
        this.priority = priority;
        this.stackBottom = address + (int)(answer >> 32) + 1;
        this.target = null;
        this.name = "\u0413\u043b\u0430\u0432\u043d\u044b\u0439 \u043f\u043e\u0442\u043e\u043a \u0438\u0441\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f";
        this.monitor = new Object();
        MalikSystem.syscall(id, priority << 1, 9);
    }

    public String toString() {
        return new StringBuilder().append("\u041f\u043e\u0442\u043e\u043a \u0438\u0441\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f[").append(this.name).append(", \u043f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442=").append(this.priority).append("]").toString();
    }

    public void run() {
    }

    public void start() {
        int error = 0;
        boolean flag = MalikSystem.enterMonopolyAccess();
        try {
            if (this.state != 0) {
                error = 1;
            } else {
                long answer = MalikSystem.syscall(MalikSystem.getMethodAddress("java/lang/Thread.execute()V"), MalikSystem.convertToReference(this), 0);
                if (answer == -1L) {
                    error = 2;
                } else {
                    int id;
                    int address = (int)(answer >> 32);
                    Thread.writeStackLimit(address + 2048);
                    this.id = id = (int)answer & 0xFF;
                    this.state = 1;
                    this.stackBottom = address + ((int)answer & 0xFFFFFF00) + 256;
                    MalikSystem.syscall(id, this.priority << 1, 9);
                    MalikSystem.syscall((long)id, 3);
                    Memory.setMultiThreaded();
                }
            }
        }
        finally {
            MalikSystem.leaveMonopolyAccess(flag);
        }
        switch (error) {
            case 1: {
                throw new IllegalThreadStateException(new StringBuilder().append("Thread.start: \u043f\u043e\u0442\u043e\u043a \u0438\u0441\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \"").append(this.name).append("\" \u0443\u0436\u0435 \u0431\u044b\u043b \u0437\u0430\u043f\u0443\u0449\u0435\u043d \u0440\u0430\u043d\u043d\u0435\u0435.").toString());
            }
            case 2: {
                throw new OutOfThreadsError("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043d\u043e\u0432\u044b\u0439 \u043f\u043e\u0442\u043e\u043a \u0438\u0441\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f: \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u043e\u0442\u043e\u043a\u043e\u0432 \u0438\u0441\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f.");
            }
        }
    }

    public void interrupt() {
        boolean status = MalikSystem.enterMonopolyAccess();
        try {
            this.interrupted = true;
            Scheduler.Task task = this.resumeTask;
            if (task != null) {
                this.resumeTask = null;
                this.resume();
                task.cancel();
            } else {
                task = this.suspendTask;
                if (task != null) {
                    this.suspendTask = null;
                    this.suspend(false);
                    task.cancel();
                } else {
                    Monitor monitor = this.blockedBy;
                    if (monitor != null) {
                        this.suspend(false);
                        monitor.wakeup();
                    }
                }
            }
        }
        finally {
            MalikSystem.leaveMonopolyAccess(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void join() throws InterruptedException {
        Object monitor;
        Object object = monitor = this.monitor;
        synchronized (monitor) {
            while (this.isAlive()) {
                monitor.wait(1000L);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public final void setPriority(int priority) {
        if (priority < 1 || priority > 10) {
            throw new IllegalArgumentException("Thread.setPriority: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 priority \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        boolean status = MalikSystem.enterMonopolyAccess();
        try {
            this.priority = priority;
            int state = this.state;
            if (state > 0 && state < 4) {
                MalikSystem.syscall(this.id, priority << 1, 9);
            }
        }
        finally {
            MalikSystem.leaveMonopolyAccess(status);
        }
    }

    public final boolean isAlive() {
        int state = this.state;
        return state > 0 && state < 4;
    }

    public final int getPriority() {
        return this.priority;
    }

    public final String getName() {
        return this.name;
    }

    final void execute() {
        int id = this.id;
        Thread.THREADS[id] = this;
        Throwable exitThrowable = null;
        try {
            Runnable target = this.target;
            (target == null ? this : target).run();
        }
        catch (Throwable e) {
            exitThrowable = e;
        }
        MalikInterrupt.disable();
        ThreadTerminationListenerCollection.instance.notifyListeners(this, exitThrowable);
        Thread.THREADS[id] = null;
        this.state = 4;
    }

    final void resume() {
        switch (this.state) {
            default: {
                return;
            }
            case 2: 
            case 3: 
        }
        this.state = 1;
        if (!this.stackTrace) {
            MalikSystem.syscall((long)this.id, 3);
        }
    }

    final void suspend(boolean wait) {
        switch (this.state) {
            default: {
                return;
            }
            case 1: {
                int n = this.state = wait ? 2 : 3;
                if (!this.stackTrace) {
                    MalikSystem.syscall((long)this.id, 2);
                }
                return;
            }
            case 2: 
            case 3: 
        }
        this.state = wait ? 2 : 3;
    }

    final void enterStackTrace() {
        int error;
        block13: {
            error = 0;
            boolean status = MalikSystem.enterMonopolyAccess();
            try {
                if (this.id != MalikSystem.getCurrentThreadID()) {
                    switch (this.state) {
                        default: {
                            break;
                        }
                        case 0: {
                            error = 1;
                            break block13;
                        }
                        case 1: {
                            MalikSystem.syscall((long)this.id, 2);
                            break;
                        }
                        case 4: {
                            error = 2;
                            break block13;
                        }
                    }
                }
                this.stackTrace = true;
            }
            finally {
                MalikSystem.leaveMonopolyAccess(status);
            }
        }
        switch (error) {
            case 1: {
                throw new IllegalThreadStateException("StackTracer.trace: \u043d\u0435\u043b\u044c\u0437\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0442\u0440\u0430\u0441\u0441\u0438\u0440\u043e\u0432\u043a\u0443 \u0441\u0442\u0430\u043a\u0430 \u0434\u043b\u044f \u043d\u0435\u0437\u0430\u043f\u0443\u0449\u0435\u043d\u043d\u043e\u0433\u043e \u043f\u043e\u0442\u043e\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f.", true);
            }
            case 2: {
                throw new IllegalThreadStateException("StackTracer.trace: \u043d\u0435\u043b\u044c\u0437\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0442\u0440\u0430\u0441\u0441\u0438\u0440\u043e\u0432\u043a\u0443 \u0441\u0442\u0430\u043a\u0430 \u0434\u043b\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u0432\u0448\u0435\u0433\u043e\u0441\u044f \u043f\u043e\u0442\u043e\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f.", true);
            }
        }
    }

    final void leaveStackTrace() {
        boolean flag = MalikSystem.enterMonopolyAccess();
        try {
            this.stackTrace = false;
            if (this.id != MalikSystem.getCurrentThreadID() && this.state == 1) {
                MalikSystem.syscall((long)this.id, 3);
            }
        }
        finally {
            MalikSystem.leaveMonopolyAccess(flag);
        }
    }

    final int getStackBottom() {
        return this.stackBottom;
    }

    final int getID() {
        return this.id;
    }

    static final class Monitor {
        private static final String NOT_OWNING = ": \u0442\u0435\u043a\u0443\u0449\u0438\u0439 \u043f\u043e\u0442\u043e\u043a \u0438\u0441\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043d\u0435 \u0432\u043b\u0430\u0434\u0435\u0435\u0442 \u044d\u0442\u0438\u043c \u0431\u043b\u043e\u043a\u0438\u0440\u0443\u044e\u0449\u0438\u043c \u043c\u043e\u043d\u0438\u0442\u043e\u0440\u043e\u043c \u0432 \u043d\u0430\u0441\u0442\u043e\u044f\u0449\u0438\u0439 \u043c\u043e\u043c\u0435\u043d\u0442.";
        static final String MESSAGE_NOT_OWNING_WAIT = "Object.wait: \u0442\u0435\u043a\u0443\u0449\u0438\u0439 \u043f\u043e\u0442\u043e\u043a \u0438\u0441\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043d\u0435 \u0432\u043b\u0430\u0434\u0435\u0435\u0442 \u044d\u0442\u0438\u043c \u0431\u043b\u043e\u043a\u0438\u0440\u0443\u044e\u0449\u0438\u043c \u043c\u043e\u043d\u0438\u0442\u043e\u0440\u043e\u043c \u0432 \u043d\u0430\u0441\u0442\u043e\u044f\u0449\u0438\u0439 \u043c\u043e\u043c\u0435\u043d\u0442.";
        static final String MESSAGE_NOT_OWNING_NOTIFY = "Object.notify: \u0442\u0435\u043a\u0443\u0449\u0438\u0439 \u043f\u043e\u0442\u043e\u043a \u0438\u0441\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043d\u0435 \u0432\u043b\u0430\u0434\u0435\u0435\u0442 \u044d\u0442\u0438\u043c \u0431\u043b\u043e\u043a\u0438\u0440\u0443\u044e\u0449\u0438\u043c \u043c\u043e\u043d\u0438\u0442\u043e\u0440\u043e\u043c \u0432 \u043d\u0430\u0441\u0442\u043e\u044f\u0449\u0438\u0439 \u043c\u043e\u043c\u0435\u043d\u0442.";
        static final String MESSAGE_NOT_OWNING_NOTIFY_ALL = "Object.notifyAll: \u0442\u0435\u043a\u0443\u0449\u0438\u0439 \u043f\u043e\u0442\u043e\u043a \u0438\u0441\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043d\u0435 \u0432\u043b\u0430\u0434\u0435\u0435\u0442 \u044d\u0442\u0438\u043c \u0431\u043b\u043e\u043a\u0438\u0440\u0443\u044e\u0449\u0438\u043c \u043c\u043e\u043d\u0438\u0442\u043e\u0440\u043e\u043c \u0432 \u043d\u0430\u0441\u0442\u043e\u044f\u0449\u0438\u0439 \u043c\u043e\u043c\u0435\u043d\u0442.";
        static final String MESSAGE_NOT_OWNING_MONITOR_EXIT = "\u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u044f monitorexit: \u0442\u0435\u043a\u0443\u0449\u0438\u0439 \u043f\u043e\u0442\u043e\u043a \u0438\u0441\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043d\u0435 \u0432\u043b\u0430\u0434\u0435\u0435\u0442 \u044d\u0442\u0438\u043c \u0431\u043b\u043e\u043a\u0438\u0440\u0443\u044e\u0449\u0438\u043c \u043c\u043e\u043d\u0438\u0442\u043e\u0440\u043e\u043c \u0432 \u043d\u0430\u0441\u0442\u043e\u044f\u0449\u0438\u0439 \u043c\u043e\u043c\u0435\u043d\u0442.";
        private int head;
        private int tail;
        private long ecount;
        private long notifies;
        private long[] ecounts;
        private Thread[] threads;
        private Thread owner;

        public void enter() {
            boolean status = MalikSystem.enterMonopolyAccess();
            try {
                Thread owner = this.owner;
                Thread current = Thread.currentThread();
                if (owner == null) {
                    this.owner = current;
                    this.ecount = 1L;
                } else if (owner == current) {
                    ++this.ecount;
                } else {
                    this.push(current, 1L);
                    current.suspend(false);
                }
            }
            finally {
                MalikSystem.leaveMonopolyAccess(status);
            }
        }

        public void wakeup() {
            if (this.owner == null) {
                this.pop();
            }
        }

        public void notifyWaiting(boolean all) throws IllegalMonitorStateException {
            boolean error = false;
            boolean status = MalikSystem.enterMonopolyAccess();
            try {
                if (this.owner != Thread.currentThread()) {
                    error = true;
                } else {
                    boolean notifying = false;
                    Thread[] tq = this.threads;
                    int capacity = this.threads != null ? tq.length : 0;
                    int h = this.head;
                    int i = this.tail;
                    while (i != h) {
                        Thread thread = tq[i];
                        if (thread.state == 2) {
                            thread.suspend(false);
                            Scheduler.Task task = thread.suspendTask;
                            if (task != null) {
                                thread.suspendTask = null;
                                task.cancel();
                                task = null;
                            }
                            if (!all) {
                                notifying = true;
                                break;
                            }
                        }
                        i = (i + 1) % capacity;
                    }
                    if (!all && !notifying) {
                        ++this.notifies;
                    }
                }
            }
            finally {
                MalikSystem.leaveMonopolyAccess(status);
            }
            if (error) {
                throw new IllegalMonitorStateException(all ? MESSAGE_NOT_OWNING_NOTIFY_ALL : MESSAGE_NOT_OWNING_NOTIFY, true);
            }
        }

        public void waitNotifying(long millis) throws IllegalMonitorStateException, InterruptedException {
            int error = 0;
            boolean flag = MalikSystem.enterMonopolyAccess();
            try {
                Thread owner = this.owner;
                if (owner != Thread.currentThread()) {
                    error = 1;
                } else if (owner.interrupted) {
                    owner.interrupted = false;
                    error = 2;
                } else {
                    long ecount = this.notifies;
                    if (ecount != 0L) {
                        this.notifies = ecount - 1L;
                    } else {
                        if (millis > 0L) {
                            Thread thread = owner;
                            thread.getClass();
                            SuspendTask task = thread.new SuspendTask(this);
                            owner.suspendTask = task;
                            Scheduler.schedule(task, millis, 2);
                            task = null;
                        }
                        ecount = this.ecount;
                        this.pop();
                        this.push(owner, ecount);
                        owner.blockedBy = this;
                        owner.suspend(true);
                        owner.blockedBy = null;
                        if (owner.interrupted) {
                            owner.interrupted = false;
                            error = 2;
                        }
                    }
                }
            }
            finally {
                MalikSystem.leaveMonopolyAccess(flag);
            }
            switch (error) {
                case 1: {
                    throw new IllegalMonitorStateException(MESSAGE_NOT_OWNING_WAIT, true);
                }
                case 2: {
                    throw new InterruptedException("Object.wait: \u043f\u043e\u0442\u043e\u043a \u0438\u0441\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0431\u044b\u043b \u043f\u0440\u0435\u0440\u0432\u0430\u043d.", true);
                }
            }
        }

        public void exit() throws IllegalMonitorStateException {
            boolean error = false;
            boolean flag = MalikSystem.enterMonopolyAccess();
            try {
                if (this.owner != Thread.currentThread()) {
                    error = true;
                } else if (--this.ecount == 0L) {
                    this.pop();
                }
            }
            finally {
                MalikSystem.leaveMonopolyAccess(flag);
            }
            if (error) {
                throw new IllegalMonitorStateException(MESSAGE_NOT_OWNING_MONITOR_EXIT, true);
            }
        }

        private void push(Thread thread, long ecount) {
            Thread[] otq;
            long[] oeq = this.ecounts;
            if (this.ecounts == null) {
                oeq = this.ecounts = new long[3];
                otq = this.threads = new Thread[3];
            } else {
                otq = this.threads;
            }
            int qhead = this.head;
            int ocapa = oeq.length;
            int qtail = this.tail;
            if ((qhead + 1) % ocapa == qtail) {
                int count;
                int ncapa = (ocapa << 1) - 1;
                long[] neq = new long[ncapa];
                Thread[] ntq = new Thread[ncapa];
                if (qhead < qtail) {
                    int quantity = ocapa - qtail;
                    count = qhead + quantity;
                    if (quantity > 0) {
                        MalikSystem.arraycopyf_long(oeq, qtail, neq, 0, quantity);
                        MalikSystem.arraycopyf_object(otq, qtail, ntq, 0, quantity);
                    }
                    if (qhead > 0) {
                        MalikSystem.arraycopyf_long(oeq, 0, neq, quantity, qhead);
                        MalikSystem.arraycopyf_object(otq, 0, ntq, quantity, qhead);
                    }
                } else {
                    count = qhead - qtail;
                    if (count > 0) {
                        MalikSystem.arraycopyf_long(oeq, qtail, neq, 0, count);
                        MalikSystem.arraycopyf_object(otq, qtail, ntq, 0, count);
                    }
                }
                oeq = neq;
                this.ecounts = neq;
                otq = ntq;
                this.threads = ntq;
                qhead = count;
                ocapa = ncapa;
                this.tail = 0;
            }
            oeq[qhead] = ecount;
            otq[qhead] = thread;
            this.head = (qhead + 1) % ocapa;
        }

        private void pop() {
            int qhead;
            long ecount = 0L;
            Thread thread = null;
            int h = qhead = this.head;
            int qtail = this.tail;
            if (qhead != qtail) {
                int state;
                long[] eq = this.ecounts;
                Thread[] tq = this.threads;
                int capacity = eq.length;
                do {
                    ecount = eq[qtail];
                    thread = tq[qtail];
                    eq[qtail] = 0L;
                    tq[qtail] = null;
                    qtail = (qtail + 1) % capacity;
                    state = thread.state;
                    if (state != 2) break;
                    eq[qhead] = ecount;
                    tq[qhead] = thread;
                    qhead = (qhead + 1) % capacity;
                } while (qtail != h);
                this.head = qhead;
                this.tail = qtail;
                if (state == 2) {
                    ecount = 0L;
                    thread = null;
                }
            }
            this.owner = thread;
            this.ecount = ecount;
            if (thread != null) {
                thread.resume();
            }
        }
    }

    private class ResumeTask
    extends Scheduler.Task {
        public void run() {
            Thread owner = Thread.this;
            if (owner.state == 3) {
                owner.resumeTask = null;
                owner.resume();
            }
        }
    }

    private class SuspendTask
    extends Scheduler.Task {
        private final Monitor monitor;

        public SuspendTask(Monitor monitor) {
            this.monitor = monitor;
        }

        public void run() {
            Thread owner = Thread.this;
            if (owner.state == 2) {
                owner.suspendTask = null;
                owner.suspend(false);
                this.monitor.wakeup();
            }
        }

        protected void cancelled() {
            this.monitor.wakeup();
        }
    }
}

