/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.io.cloud;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import malik.emulator.io.IOStream;
import malik.emulator.io.cloud.HandleInputStream;
import malik.emulator.io.cloud.HandleOutputStream;
import malik.emulator.io.vfs.ClosedFileException;
import malik.emulator.io.vfs.FileNotFoundException;
import malik.emulator.util.DataDescriptor;
import malik.emulator.util.StringBuilder;

public class FileIOStream
extends IOStream {
    private static final int NO_ERROR = 0;
    private static final int FILE_NOT_FOUND = 1;
    private static final int FILE_NAME_NOT_SPECIFIED = 3;
    private final int openError;
    private int handle;
    private final String fileName;
    private final HandleInputStream input;
    private final HandleOutputStream output;
    private final DataDescriptor descriptor;

    private static HandleInputStream createInput(String fileName, DataDescriptor descriptor, int handle) {
        return new HandleInputStream(fileName, descriptor, handle){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final long getFileSize() {
                long result;
                DataDescriptor dataDescriptor = this.descriptor;
                synchronized (dataDescriptor) {
                    int h = this.handle;
                    result = h == 0 ? -1L : MalikSystem.syscall((long)h, 21);
                }
                return result;
            }
        };
    }

    private static HandleOutputStream createOutput(String fileName, DataDescriptor descriptor, int handle) {
        return new HandleOutputStream(fileName, descriptor, handle){};
    }

    public FileIOStream(String fileName) {
        int e;
        int h;
        int len;
        if (fileName == null || (len = fileName.length()) <= 0) {
            h = 0;
            e = 3;
        } else {
            char[] name = new char[len + 1];
            fileName.getChars(0, len, name, 0);
            h = (int)MalikSystem.syscall(Array.getFirstElementAddress(name), 3, 16);
            e = h == 0 ? 1 : 0;
        }
        if (h == 0) {
            this.openError = e;
            this.fileName = fileName;
            this.input = null;
            this.output = null;
            this.descriptor = null;
            return;
        }
        DataDescriptor descriptor = new DataDescriptor();
        this.openError = 0;
        this.handle = h;
        this.fileName = fileName;
        this.input = FileIOStream.createInput(fileName, descriptor, h);
        this.output = FileIOStream.createOutput(fileName, descriptor, h);
        this.descriptor = descriptor;
    }

    FileIOStream(String fileName, int handle) {
        DataDescriptor descriptor = new DataDescriptor();
        this.openError = 0;
        this.handle = handle;
        this.fileName = fileName;
        this.input = FileIOStream.createInput(fileName, descriptor, handle);
        this.output = FileIOStream.createOutput(fileName, descriptor, handle);
        this.descriptor = descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.checkOpenError();
        boolean error = false;
        DataDescriptor dataDescriptor = this.descriptor;
        synchronized (dataDescriptor) {
            int h = this.handle;
            if (h != 0) {
                HandleInputStream in = this.input;
                HandleOutputStream out = this.output;
                int bufferPosition = out.position;
                if (bufferPosition > 0) {
                    out.position = 0;
                    if (!out.writeFile(bufferPosition)) {
                        error = true;
                    }
                }
                this.handle = 0;
                in.handle = 0;
                out.handle = 0;
                MalikSystem.syscall((long)h, 17);
            }
        }
        if (error) {
            throw new IOException("FileIOStream.close: \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0438\u0441\u0438 \u0444\u0430\u0439\u043b\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetInputStream() throws IOException {
        this.checkOpenError();
        boolean error = false;
        DataDescriptor dataDescriptor = this.descriptor;
        synchronized (dataDescriptor) {
            if (this.handle == 0) {
                error = true;
            } else {
                this.input.resetPosition();
            }
        }
        if (error) {
            throw new ClosedFileException("FileIOStream.resetInputStream: \u0444\u0430\u0439\u043b\u043e\u0432\u044b\u0439 \u043f\u043e\u0442\u043e\u043a \u0437\u0430\u043a\u0440\u044b\u0442.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void resetOutputStream() throws IOException {
        block10: {
            this.checkOpenError();
            error = 0;
            var2_2 = this.descriptor;
            synchronized (var2_2) {
                block9: {
                    h = this.handle;
                    if (h != 0) break block9;
                    error = 1;
                    break block10;
                }
                out = this.output;
                bufferPosition = out.position;
                if (bufferPosition <= 0) ** GOTO lbl-1000
                out.position = 0;
                if (!out.writeFile(bufferPosition)) {
                    error = 2;
                } else lbl-1000:
                // 2 sources

                {
                    delta = 0L;
                    delta = -MalikSystem.syscall(h, MalikSystem.getLocalVariableAddress(delta), 20);
                    MalikSystem.syscall(h, MalikSystem.getLocalVariableAddress(delta), 20);
                }
            }
        }
        switch (error) {
            case 1: {
                throw new ClosedFileException("FileIOStream.resetOutputStream: \u0444\u0430\u0439\u043b\u043e\u0432\u044b\u0439 \u043f\u043e\u0442\u043e\u043a \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            case 2: {
                throw new IOException("FileIOStream.resetOutputStream: \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0438\u0441\u0438 \u0444\u0430\u0439\u043b\u0430.");
            }
        }
    }

    public boolean truncateSupported() {
        return true;
    }

    public boolean positionSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public long truncate() throws IOException {
        block10: {
            this.checkOpenError();
            error = 0;
            var4_2 = this.descriptor;
            synchronized (var4_2) {
                block9: {
                    h = this.handle;
                    if (h != 0) break block9;
                    error = 1;
                    result = 0L;
                    break block10;
                }
                out = this.output;
                bufferPosition = out.position;
                if (bufferPosition <= 0) ** GOTO lbl-1000
                out.position = 0;
                if (!out.writeFile(bufferPosition)) {
                    error = 2;
                    result = 0L;
                } else lbl-1000:
                // 2 sources

                {
                    result = MalikSystem.syscall((long)h, 22);
                }
            }
        }
        switch (error) {
            case 1: {
                throw new ClosedFileException("FileIOStream.truncate: \u0444\u0430\u0439\u043b\u043e\u0432\u044b\u0439 \u043f\u043e\u0442\u043e\u043a \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            case 2: {
                throw new IOException("FileIOStream.truncate: \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0438\u0441\u0438 \u0444\u0430\u0439\u043b\u0430.");
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public long position(long delta) throws IOException {
        block10: {
            this.checkOpenError();
            error = 0;
            var6_3 = this.descriptor;
            synchronized (var6_3) {
                block9: {
                    h = this.handle;
                    if (h != 0) break block9;
                    error = 1;
                    result = 0L;
                    break block10;
                }
                out = this.output;
                bufferPosition = out.position;
                if (bufferPosition <= 0) ** GOTO lbl-1000
                out.position = 0;
                if (!out.writeFile(bufferPosition)) {
                    error = 2;
                    result = 0L;
                } else lbl-1000:
                // 2 sources

                {
                    result = MalikSystem.syscall(h, MalikSystem.getLocalVariableAddress(delta), 20);
                }
            }
        }
        switch (error) {
            case 1: {
                throw new ClosedFileException("FileIOStream.position: \u0444\u0430\u0439\u043b\u043e\u0432\u044b\u0439 \u043f\u043e\u0442\u043e\u043a \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            case 2: {
                throw new IOException("FileIOStream.position: \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0438\u0441\u0438 \u0444\u0430\u0439\u043b\u0430.");
            }
        }
        return result;
    }

    public InputStream getInputStream() throws IOException {
        this.checkOpenError();
        return this.input;
    }

    public OutputStream getOutputStream() throws IOException {
        this.checkOpenError();
        return this.output;
    }

    public void checkOpenError() throws IOException {
        String name = this.fileName;
        switch (this.openError) {
            case 1: {
                throw new FileNotFoundException(new StringBuilder().append("FileIOStream.checkOpenError: \u0444\u0430\u0439\u043b ").append(name).append(" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0438\u043b\u0438 \u0437\u0430\u043d\u044f\u0442.").toString(), name);
            }
            case 3: {
                throw new IOException("FileIOStream.checkOpenError: \u0438\u043c\u044f \u0444\u0430\u0439\u043b\u0430 \u043d\u0435 \u0431\u044b\u043b\u043e \u0437\u0430\u0434\u0430\u043d\u043e \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u044d\u0442\u043e\u0433\u043e \u044d\u043a\u0437\u0435\u043c\u043f\u043b\u044f\u0440\u0430 CloudFileStream.");
            }
        }
    }

    public boolean hasOpenError() {
        int e = this.openError;
        return e > 0 && e <= 3;
    }

    public final long getFileSize() {
        HandleInputStream in = this.input;
        return in == null ? -1L : in.getFileSize();
    }

    public final String getFileName() {
        return this.fileName;
    }
}

