/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.media.graphics;

import malik.emulator.media.graphics.Rectangle;

public class Clip
implements Rectangle {
    private int left;
    private int top;
    private int width;
    private int height;
    private int translateX;
    private int translateY;

    public Clip(int clipWidth, int clipHeight) {
        this.width = clipWidth;
        this.height = clipHeight;
    }

    public Clip(int clipLeft, int clipTop, int clipWidth, int clipHeight) {
        this.left = clipLeft;
        this.top = clipTop;
        this.width = clipWidth;
        this.height = clipHeight;
    }

    public Clip(int translateX, int translateY, int clipLeft, int clipTop, int clipWidth, int clipHeight) {
        this.left = clipLeft + translateX;
        this.top = clipTop + translateY;
        this.width = clipWidth;
        this.height = clipHeight;
        this.translateX = translateX;
        this.translateY = translateY;
    }

    public void translateReset() {
        this.translateX = 0;
        this.translateY = 0;
    }

    public void translate(int deltaX, int deltaY) {
        this.translateX += deltaX;
        this.translateY += deltaY;
    }

    public void translateTo(int rawX, int rawY) {
        this.translateX = rawX;
        this.translateY = rawY;
    }

    public void clipRect(int clipLeft, int clipTop, int clipWidth, int clipHeight) {
        int tmp;
        int left = this.left;
        int top = this.top;
        int right = left + this.width;
        int bottom = top + this.height;
        clipTop += this.translateY;
        if (left < (clipLeft += this.translateX)) {
            left = clipLeft;
        }
        if (top < clipTop) {
            top = clipTop;
        }
        if (right > (tmp = clipLeft + clipWidth)) {
            right = tmp;
        }
        if (bottom > (tmp = clipTop + clipHeight)) {
            bottom = tmp;
        }
        this.left = left;
        this.top = top;
        this.width = right - left;
        this.height = bottom - top;
    }

    public void clipRect(Rectangle clip) {
        int tmp;
        if (clip == null) {
            throw new NullPointerException("Clip.clipRect: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 clip \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int clipLeft = clip.getLeft();
        int clipTop = clip.getTop();
        int clipWidth = clip.getWidth();
        int clipHeight = clip.getHeight();
        int left = this.left;
        int top = this.top;
        int right = left + this.width;
        int bottom = top + this.height;
        clipTop += this.translateY;
        if (left < (clipLeft += this.translateX)) {
            left = clipLeft;
        }
        if (top < clipTop) {
            top = clipTop;
        }
        if (right > (tmp = clipLeft + clipWidth)) {
            right = tmp;
        }
        if (bottom > (tmp = clipTop + clipHeight)) {
            bottom = tmp;
        }
        this.left = left;
        this.top = top;
        this.width = right - left;
        this.height = bottom - top;
    }

    public void setClip(int clipLeft, int clipTop, int clipWidth, int clipHeight) {
        this.left = clipLeft + this.translateX;
        this.top = clipTop + this.translateY;
        this.width = clipWidth;
        this.height = clipHeight;
    }

    public void setClip(Rectangle clip) {
        if (clip == null) {
            throw new NullPointerException("Clip.setClip: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 clip \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int clipLeft = clip.getLeft();
        int clipTop = clip.getTop();
        int clipWidth = clip.getWidth();
        int clipHeight = clip.getHeight();
        this.left = clipLeft + this.translateX;
        this.top = clipTop + this.translateY;
        this.width = clipWidth;
        this.height = clipHeight;
    }

    public final int getLeft() {
        return this.left;
    }

    public final int getTop() {
        return this.top;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getTranslateX() {
        return this.translateX;
    }

    public final int getTranslateY() {
        return this.translateY;
    }

    public final int getClipLeft() {
        return this.left - this.translateX;
    }

    public final int getClipTop() {
        return this.top - this.translateY;
    }

    public final int getClipWidth() {
        return this.width;
    }

    public final int getClipHeight() {
        return this.height;
    }

    public final Rectangle getClipRect() {
        return new Rectangle(){

            public int getLeft() {
                return Clip.this.getClipLeft();
            }

            public int getTop() {
                return Clip.this.getClipTop();
            }

            public int getWidth() {
                return Clip.this.getClipWidth();
            }

            public int getHeight() {
                return Clip.this.getClipHeight();
            }
        };
    }
}

