/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.time;

import java.util.TimeZone;
import java.util.Vector;
import malik.emulator.time.BasicTimeZone;
import malik.emulator.util.StringBuilder;
import malik.emulator.util.TimeZoneCollection;

public class BasicTimeZoneCollection
implements TimeZoneCollection {
    private int count;
    private BasicTimeZone[] zones;
    private BasicTimeZone defaultZone;
    private final BasicTimeZone utc;
    private final Object monitor;

    public BasicTimeZoneCollection() {
        this((int)MalikSystem.syscall(1L, 12));
    }

    public BasicTimeZoneCollection(int defaultOffsetInMillis) {
        BasicTimeZone[] zones;
        BasicTimeZone defaultZone;
        int count;
        BasicTimeZone utc = new BasicTimeZone("GMT", this.getAllIDs(0), "\u0412\u0440\u0435\u043c\u044f \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 UTC", 0);
        if (defaultOffsetInMillis != 0) {
            count = 2;
            defaultZone = new BasicTimeZone(new StringBuilder().append("UTC").append(BasicTimeZone.offsetToString(defaultOffsetInMillis)).toString(), this.getAllIDs(defaultOffsetInMillis), "\u041c\u0435\u0441\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f", defaultOffsetInMillis);
            BasicTimeZone[] basicTimeZoneArray = new BasicTimeZone[3];
            basicTimeZoneArray[0] = utc;
            basicTimeZoneArray[1] = defaultZone;
            zones = basicTimeZoneArray;
        } else {
            count = 1;
            defaultZone = utc;
            zones = new BasicTimeZone[]{utc};
        }
        this.count = count;
        this.zones = zones;
        this.defaultZone = defaultZone;
        this.utc = utc;
        this.monitor = new Object();
    }

    public String[] getAvailableIDs() {
        BasicTimeZone[] zones = this.zones;
        Vector collection = new Vector();
        int len = this.count;
        int i = 0;
        while (i < len) {
            BasicTimeZone zone = zones[i];
            int idslen = zone.getIDsCount();
            int j = 0;
            while (j < idslen) {
                collection.addElement(zone.getID(j));
                ++j;
            }
            ++i;
        }
        Object[] result = new String[collection.size()];
        collection.copyInto(result);
        return result;
    }

    public TimeZone getDefault() {
        return this.defaultZone;
    }

    public TimeZone getTimeZone(String id) {
        BasicTimeZone[] zones = this.zones;
        int len = this.count;
        int i = 0;
        while (i < len) {
            BasicTimeZone zone = zones[i];
            if (zone.isID(id)) {
                return zone;
            }
            ++i;
        }
        return this.utc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(BasicTimeZone zone) {
        if (zone == null) {
            throw new NullPointerException("BasicTimeZoneCollection.add: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 zone \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Object object = this.monitor;
        synchronized (object) {
            int len = this.count;
            Object[] zones = this.zones;
            if (len == this.zones.length) {
                Object[] objectArray = zones;
                this.zones = new BasicTimeZone[(len << 1) + 1];
                zones = this.zones;
                Array.copy(objectArray, 0, this.zones, 0, len);
            }
            zones[len++] = zone;
            this.count = len;
        }
    }

    public void setDefault(BasicTimeZone zone) {
        if (zone == null) {
            throw new NullPointerException("BasicTimeZoneCollection.setDefault: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 zone \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        this.defaultZone = zone;
    }

    protected String[] getAllIDs(int offsetInMillis) {
        String[] stringArray;
        int ofs = offsetInMillis / 60000;
        boolean negative = ofs < 0;
        int hrs = negative ? -ofs : ofs;
        int min = hrs % 60;
        if ((hrs /= 60) < 10) {
            if (min <= 0) {
                String[] stringArray2 = new String[4];
                stringArray2[0] = hrs <= 0 ? "UTC" : null;
                stringArray2[1] = new String(new char[]{'U', 'T', 'C', negative ? (char)'-' : '+', (char)(hrs + 48)});
                stringArray2[2] = new String(new char[]{'U', 'T', 'C', negative ? (char)'-' : '+', '0', (char)(hrs + 48)});
                stringArray = stringArray2;
                stringArray2[3] = new String(new char[]{'U', 'T', 'C', negative ? (char)'-' : '+', (char)(hrs + 48), ':', '0', '0'});
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = new String(new char[]{'U', 'T', 'C', negative ? (char)'-' : '+', (char)(hrs + 48), ':', (char)(min / 10 + 48), (char)(min % 10 + 48)});
            }
        } else if (min <= 0) {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = new String(new char[]{'U', 'T', 'C', negative ? (char)'-' : '+', (char)(hrs / 10 % 10 + 48), (char)(hrs % 10 + 48)});
        } else {
            stringArray = null;
        }
        return stringArray;
    }
}

