/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;

public class ByteArrayInputStream
extends InputStream {
    protected int pos;
    protected int mark;
    protected int count;
    protected byte[] buf;
    private final Object monitor;

    public ByteArrayInputStream(byte[] buffer) {
        this.count = buffer == null ? 0 : buffer.length;
        this.buf = buffer;
        this.monitor = new Object();
    }

    public ByteArrayInputStream(byte[] buffer, int offset, int length) {
        long bounds = Array.intersectBound(buffer == null ? 0 : buffer.length, offset, length);
        offset = (int)bounds;
        length = (int)(bounds >> 32);
        this.pos = offset;
        this.count = offset + length;
        this.buf = buffer;
        this.monitor = new Object();
    }

    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.monitor;
        synchronized (object) {
            this.pos = this.mark;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(int readLimit) {
        Object object = this.monitor;
        synchronized (object) {
            this.mark = this.pos;
        }
    }

    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() {
        int result;
        Object object = this.monitor;
        synchronized (object) {
            result = this.count - this.pos;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() {
        int result;
        Object object = this.monitor;
        synchronized (object) {
            int p = this.pos;
            if (p >= this.count) {
                result = -1;
            } else {
                result = this.buf[p++] & 0xFF;
                this.pos = p;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] dst, int offset, int length) {
        int result;
        if (dst == null) {
            throw new NullPointerException("ByteArrayInputStream.read: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Array.checkBound("ByteArrayInputStream.read", dst.length, offset, length);
        Object object = this.monitor;
        synchronized (object) {
            int p = this.pos;
            int remaining = this.count - p;
            if (remaining <= 0) {
                result = -1;
            } else {
                result = length <= remaining ? length : remaining;
                Array.copy(this.buf, p, dst, offset, result);
                this.pos = p + result;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long quantity) {
        long result;
        if (quantity <= 0L) {
            return 0L;
        }
        Object object = this.monitor;
        synchronized (object) {
            int p = this.pos;
            long remaining = this.count - p;
            result = quantity <= remaining ? quantity : remaining;
            this.pos = p + (int)result;
        }
        return result;
    }
}

