/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;
import malik.emulator.i18n.Helper;
import malik.emulator.i18n.TextCodec;

public class PrintStream
extends OutputStream {
    private boolean error;
    private final char[] newline;
    private final TextCodec codec;
    private OutputStream out;

    public PrintStream(OutputStream stream) {
        String newline = System.getProperty("line.separator");
        if (newline == null) {
            newline = "\n";
        }
        this.newline = newline.toCharArray();
        this.codec = Helper.createTextCodec();
        this.out = stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        char[] cArray = this.newline;
        synchronized (this.newline) {
            OutputStream stream = this.out;
            this.out = null;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {
                    this.error = true;
                }
            }
            return;
        }
    }

    public void flush() {
        OutputStream stream = this.out;
        if (stream == null) {
            this.error = true;
            return;
        }
        try {
            stream.flush();
        }
        catch (IOException iOException) {
            this.error = true;
        }
    }

    public void write(int byteData) {
        OutputStream stream = this.out;
        if (stream == null) {
            this.error = true;
            return;
        }
        try {
            stream.write(byteData);
        }
        catch (IOException iOException) {
            this.error = true;
        }
    }

    public void write(byte[] src, int offset, int length) {
        OutputStream stream = this.out;
        if (stream == null) {
            this.error = true;
            return;
        }
        try {
            stream.write(src, offset, length);
        }
        catch (IOException iOException) {
            this.error = true;
        }
    }

    public void print(boolean value) {
        OutputStream stream = this.out;
        if (stream == null) {
            this.error = true;
            return;
        }
        this.write(stream, (value ? "true" : "false").toCharArray());
    }

    public void print(char value) {
        OutputStream stream = this.out;
        if (stream == null) {
            this.error = true;
            return;
        }
        this.write(stream, new char[]{value});
    }

    public void print(float value) {
        OutputStream stream = this.out;
        if (stream == null) {
            this.error = true;
            return;
        }
        this.write(stream, Float.toString(value).toCharArray());
    }

    public void print(double value) {
        OutputStream stream = this.out;
        if (stream == null) {
            this.error = true;
            return;
        }
        this.write(stream, Double.toString(value).toCharArray());
    }

    public void print(int value) {
        OutputStream stream = this.out;
        if (stream == null) {
            this.error = true;
            return;
        }
        this.write(stream, Integer.toString(value, 10).toCharArray());
    }

    public void print(long value) {
        OutputStream stream = this.out;
        if (stream == null) {
            this.error = true;
            return;
        }
        this.write(stream, Long.toString(value, 10).toCharArray());
    }

    public void print(char[] value) {
        if (value == null) {
            throw new NullPointerException("PrintStream.print: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 value \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        OutputStream stream = this.out;
        if (stream == null) {
            this.error = true;
            return;
        }
        this.write(stream, value);
    }

    public void print(Object value) {
        OutputStream stream = this.out;
        if (stream == null) {
            this.error = true;
            return;
        }
        String representation = value == null ? "null" : value.toString();
        if (representation == null) {
            representation = "null";
        }
        this.write(stream, representation.toCharArray());
    }

    public void print(String value) {
        OutputStream stream = this.out;
        if (stream == null) {
            this.error = true;
            return;
        }
        this.write(stream, (value == null ? "null" : value).toCharArray());
    }

    public void println() {
        OutputStream stream = this.out;
        if (stream == null) {
            this.error = true;
            return;
        }
        this.write(stream, this.newline);
    }

    public void println(boolean value) {
        OutputStream stream = this.out;
        if (stream == null) {
            this.error = true;
            return;
        }
        this.writeln(stream, value ? "true" : "false");
    }

    public void println(char value) {
        OutputStream stream = this.out;
        if (stream == null) {
            this.error = true;
            return;
        }
        char[] newline = this.newline;
        int lnlen = this.newline.length;
        char[] cArray = new char[lnlen + 1];
        char[] characters = cArray;
        cArray[0] = value;
        Array.copy(newline, 0, characters, 1, lnlen);
        this.write(stream, characters);
    }

    public void println(float value) {
        OutputStream stream = this.out;
        if (stream == null) {
            this.error = true;
            return;
        }
        this.writeln(stream, Float.toString(value));
    }

    public void println(double value) {
        OutputStream stream = this.out;
        if (stream == null) {
            this.error = true;
            return;
        }
        this.writeln(stream, Double.toString(value));
    }

    public void println(int value) {
        OutputStream stream = this.out;
        if (stream == null) {
            this.error = true;
            return;
        }
        this.writeln(stream, Integer.toString(value, 10));
    }

    public void println(long value) {
        OutputStream stream = this.out;
        if (stream == null) {
            this.error = true;
            return;
        }
        this.writeln(stream, Long.toString(value, 10));
    }

    public void println(char[] value) {
        if (value == null) {
            throw new NullPointerException("PrintStream.println: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 value \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        OutputStream stream = this.out;
        if (stream == null) {
            this.error = true;
            return;
        }
        char[] newline = this.newline;
        int lnlen = this.newline.length;
        int length = value.length;
        char[] characters = new char[lnlen + length];
        Array.copy(value, 0, characters, 0, length);
        Array.copy(newline, 0, characters, length, lnlen);
        this.write(stream, characters);
    }

    public void println(Object value) {
        OutputStream stream = this.out;
        if (stream == null) {
            this.error = true;
            return;
        }
        String representation = value == null ? "null" : value.toString();
        if (representation == null) {
            representation = "null";
        }
        this.writeln(stream, representation);
    }

    public void println(String value) {
        OutputStream stream = this.out;
        if (stream == null) {
            this.error = true;
            return;
        }
        this.writeln(stream, value == null ? "null" : value);
    }

    public boolean checkError() {
        OutputStream stream = this.out;
        if (stream == null) {
            this.error = true;
            return true;
        }
        try {
            stream.flush();
        }
        catch (IOException iOException) {
            this.error = true;
        }
        return this.error;
    }

    protected void setError() {
        this.error = true;
    }

    private void write(OutputStream stream, char[] characters) {
        byte[] data = this.codec.encode(characters, 0, characters.length);
        try {
            stream.write(data, 0, data.length);
        }
        catch (IOException iOException) {
            this.error = true;
        }
    }

    private void writeln(OutputStream stream, String representation) {
        int length = representation.length();
        char[] newline = this.newline;
        int lnlen = this.newline.length;
        char[] characters = new char[length + lnlen];
        representation.getChars(0, length, characters, 0);
        Array.copy(newline, 0, characters, length, lnlen);
        this.write(stream, characters);
    }
}

