/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.UnsupportedEncodingException;
import malik.emulator.i18n.Helper;

public final class String {
    private final int offset;
    private final int length;
    private final char[] chars;

    public static void checkBound(String method, int stringLength, int offset, int length) throws StringIndexOutOfBoundsException {
        int lim = offset + length;
        if (lim > stringLength || lim < offset || offset > stringLength || offset < 0) {
            throw new StringIndexOutOfBoundsException(method != null ? method.concat(": \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.") : "\u0418\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.", true);
        }
    }

    public static String valueOf(boolean value) {
        return value ? "true" : "false";
    }

    public static String valueOf(char value) {
        return new String(value);
    }

    public static String valueOf(float value) {
        return Float.toString(value);
    }

    public static String valueOf(double value) {
        return Double.toString(value);
    }

    public static String valueOf(int value) {
        return Integer.toString(value, 10);
    }

    public static String valueOf(long value) {
        return Long.toString(value, 10);
    }

    public static String valueOf(char[] src) {
        int len = src == null ? 0 : src.length;
        if (len > 0) {
            char[] cArray = src;
            src = new char[len];
            MalikSystem.arraycopyf_short(cArray, 0, src, 0, len);
        } else {
            src = null;
        }
        return new String(0, len, src);
    }

    public static String valueOf(char[] src, int offset, int length) {
        if (src == null) {
            throw new NullPointerException("String.valueOf: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Array.checkBound("String.valueOf", src.length, offset, length);
        if (length > 0) {
            char[] cArray = src;
            src = new char[length];
            MalikSystem.arraycopyf_short(cArray, offset, src, 0, length);
        } else {
            src = null;
        }
        return new String(0, length, src);
    }

    public static String valueOf(Object value) {
        return value == null ? "null" : value.toString();
    }

    public String() {
        this.offset = 0;
        this.length = 0;
        this.chars = null;
    }

    public String(char[] src) {
        if (src == null) {
            throw new NullPointerException("String: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int len = src.length;
        if (len > 0) {
            char[] cArray = src;
            src = new char[len];
            MalikSystem.arraycopyf_short(cArray, 0, src, 0, len);
        } else {
            src = null;
        }
        this.offset = 0;
        this.length = len;
        this.chars = src;
    }

    public String(char[] src, int offset, int length) {
        if (src == null) {
            throw new NullPointerException("String: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Array.checkBound("String", src.length, offset, length);
        if (length > 0) {
            char[] cArray = src;
            src = new char[length];
            MalikSystem.arraycopyf_short(cArray, offset, src, 0, length);
        } else {
            src = null;
        }
        this.offset = 0;
        this.length = length;
        this.chars = src;
    }

    public String(byte[] src) {
        char[] chars = src != null ? Helper.byteToCharArray(src, 0, src.length) : null;
        int len = chars == null ? 0 : chars.length;
        if (len <= 0) {
            chars = null;
        }
        this.offset = 0;
        this.length = len;
        this.chars = chars;
    }

    public String(byte[] src, String encoding) throws UnsupportedEncodingException {
        char[] chars = src != null ? Helper.byteToCharArray(src, 0, src.length, encoding) : null;
        int len = chars == null ? 0 : chars.length;
        if (len <= 0) {
            chars = null;
        }
        this.offset = 0;
        this.length = len;
        this.chars = chars;
    }

    public String(byte[] src, int offset, int length) {
        long bounds = Array.intersectBound(src == null ? 0 : src.length, offset, length);
        offset = (int)bounds;
        length = (int)(bounds >> 32);
        char[] chars = src != null ? Helper.byteToCharArray(src, offset, length) : null;
        int len = chars == null ? 0 : chars.length;
        if (len <= 0) {
            chars = null;
        }
        this.offset = 0;
        this.length = len;
        this.chars = chars;
    }

    public String(byte[] src, int offset, int length, String encoding) throws UnsupportedEncodingException {
        long bounds = Array.intersectBound(src == null ? 0 : src.length, offset, length);
        offset = (int)bounds;
        length = (int)(bounds >> 32);
        char[] chars = src != null ? Helper.byteToCharArray(src, offset, length, encoding) : null;
        int len = chars == null ? 0 : chars.length;
        if (len <= 0) {
            chars = null;
        }
        this.offset = 0;
        this.length = len;
        this.chars = chars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String(StringBuffer source) {
        if (source == null) {
            throw new NullPointerException("String: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 buffer \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Object object = source.monitor();
        synchronized (object) {
            this.offset = 0;
            this.length = source.length();
            this.chars = source.content();
            source.setShared();
        }
    }

    public String(String source) {
        if (source == null) {
            this.offset = 0;
            this.length = 0;
            this.chars = null;
            return;
        }
        this.offset = source.offset;
        this.length = source.length;
        this.chars = source.chars;
    }

    private String(char source) {
        this.offset = 0;
        this.length = 1;
        this.chars = new char[]{source};
    }

    private String(int offset, int length, char[] chars) {
        this.offset = offset;
        this.length = length;
        this.chars = chars;
    }

    public boolean equals(Object anot) {
        block2: {
            block3: {
                if (anot == this) break block2;
                if (!(anot instanceof String)) break block3;
                int len = this.length;
                String s = (String)anot;
                if (len == s.length && (this.offset == s.offset && this.chars == s.chars || this.regionMatches(false, 0, s, 0, len))) break block2;
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        char[] c = this.chars;
        int e = 1;
        int ofs = this.offset;
        int i = ofs + this.length;
        while (i-- > ofs) {
            result += e * c[i];
            e *= 31;
        }
        return result;
    }

    public String toString() {
        return this;
    }

    public void getChars(int beginIndex, int endIndex, char[] dst, int offset) {
        int len;
        if ((beginIndex | endIndex) < 0 || beginIndex > (len = this.length) || endIndex > len || beginIndex > endIndex) {
            throw new StringIndexOutOfBoundsException("String.getChars: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        if (dst == null) {
            throw new NullPointerException("String.getChars: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int length = endIndex - beginIndex;
        int lim = offset + length;
        len = dst.length;
        if (lim > len || lim < offset || offset > len || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("String.getChars: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        if (length > 0) {
            MalikSystem.arraycopyf_short(this.chars, this.offset + beginIndex, dst, offset, length);
        }
    }

    public boolean regionMatches(boolean ignoreCase, int thisOffset, String anot, int anotOffset, int length) {
        char c2;
        char c1;
        int len;
        int lim;
        if (anot == null || (lim = thisOffset + length) > (len = this.length) || lim < thisOffset || thisOffset > len || thisOffset < 0 || (lim = anotOffset + length) > (len = anot.length) || lim < anotOffset || anotOffset > len || anotOffset < 0) {
            return false;
        }
        thisOffset += this.offset;
        anotOffset += anot.offset;
        char[] thisChars = this.chars;
        char[] anotChars = anot.chars;
        do {
            if (length-- > 0) continue;
            return true;
        } while ((c1 = thisChars[thisOffset++]) == (c2 = anotChars[anotOffset++]) || ignoreCase && (Character.toUpperCase(c1) == Character.toUpperCase(c2) || Character.toLowerCase(c1) == Character.toLowerCase(c2)));
        return false;
    }

    public boolean equalsIgnoreCase(String anot) {
        int length;
        return anot != null && (length = this.length) == anot.length && this.regionMatches(true, 0, anot, 0, length);
    }

    public boolean endsWith(String suffix) {
        if (suffix == null) {
            throw new NullPointerException("String.endsWith: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 suffix \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        return this.startsWith(suffix, this.length - suffix.length);
    }

    public boolean startsWith(String prefix) {
        if (prefix == null) {
            throw new NullPointerException("String.startsWith: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 prefix \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        return this.startsWith(prefix, 0);
    }

    public boolean startsWith(String prefix, int offset) {
        int i;
        if (prefix == null) {
            throw new NullPointerException("String.startsWith: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 prefix \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (offset < 0 || offset > this.length - (i = prefix.length)) {
            return false;
        }
        char[] thisChars = this.chars;
        char[] anotChars = prefix.chars;
        int thisOffset = this.offset + offset;
        int anotOffset = prefix.offset;
        while (i-- > 0) {
            if (thisChars[thisOffset++] == anotChars[anotOffset++]) continue;
            return false;
        }
        return true;
    }

    public char charAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new StringIndexOutOfBoundsException("String.charAt: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 index \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return this.chars[this.offset + index];
    }

    public int length() {
        return this.length;
    }

    public int compareTo(String anot) {
        if (anot == null) {
            throw new NullPointerException("String.compareTo: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 anot \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int thisLength = this.length;
        int anotLength = anot.length;
        int lengthDiff = thisLength - anotLength;
        int thisOffset = this.offset;
        int anotOffset = anot.offset;
        char[] thisChars = this.chars;
        char[] anotChars = anot.chars;
        int i = 0;
        int j = 0;
        while (i < thisLength && j < anotLength) {
            char c2;
            char c1;
            int characterDiff;
            if ((characterDiff = (c1 = thisChars[thisOffset++]) - (c2 = anotChars[anotOffset++])) != 0) {
                return characterDiff;
            }
            ++i;
            ++j;
        }
        return lengthDiff;
    }

    public int indexOf(int character) {
        int ofs;
        int result;
        int len = this.length;
        return len <= 0 || character < 0 || character > 65535 || (result = MalikSystem.arrayfindf_short(this.chars, ofs = this.offset, character) - ofs) >= len ? -1 : result;
    }

    public int indexOf(int character, int startFromIndex) {
        int ofs;
        int result;
        int len;
        if (startFromIndex < 0) {
            startFromIndex = 0;
        }
        return startFromIndex >= (len = this.length) || character < 0 || character > 65535 || (result = MalikSystem.arrayfindf_short(this.chars, (ofs = this.offset) + startFromIndex, character) - ofs) >= len ? -1 : result;
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int startFromIndex) {
        int len;
        int lim;
        if (string == null) {
            throw new NullPointerException("String.indexOf: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 string \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (startFromIndex < 0) {
            startFromIndex = 0;
        }
        if (startFromIndex > (lim = this.length - (len = string.length))) {
            return -1;
        }
        if (len <= 0) {
            return startFromIndex;
        }
        char[] thisChars = this.chars;
        int thisOffset = this.offset + startFromIndex;
        char[] anotChars = string.chars;
        int anotOffset = string.offset;
        char first = string.chars[anotOffset];
        do {
            block8: {
                if (thisChars[thisOffset] == first) {
                    int i = thisOffset;
                    int j = anotOffset;
                    int k = len;
                    while (k-- > 1) {
                        if (thisChars[++i] == anotChars[++j]) {
                            continue;
                        }
                        break block8;
                    }
                    return startFromIndex;
                }
            }
            ++thisOffset;
        } while (++startFromIndex <= lim);
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public int lastIndexOf(int character) {
        void var3_4;
        int ofs;
        int result;
        int startFromIndex = this.length - 1;
        return startFromIndex < 0 || character < 0 || character > 65535 || (result = MalikSystem.arrayfindb_short(this.chars, (ofs = this.offset) + startFromIndex, character) - ofs) < 0 ? -1 : var3_4;
    }

    public int lastIndexOf(int character, int startFromIndex) {
        int ofs;
        int result;
        int len = this.length;
        if (startFromIndex >= len) {
            startFromIndex = len - 1;
        }
        return startFromIndex < 0 || character < 0 || character > 65535 || (result = MalikSystem.arrayfindb_short(this.chars, (ofs = this.offset) + startFromIndex, character) - ofs) < 0 ? -1 : result;
    }

    public char[] toCharArray() {
        int len = this.length;
        char[] result = new char[len];
        if (len > 0) {
            MalikSystem.arraycopyf_short(this.chars, this.offset, result, 0, len);
        }
        return result;
    }

    public byte[] getBytes() {
        return Helper.charToByteArray(this.chars, this.offset, this.length);
    }

    public byte[] getBytes(String encoding) throws UnsupportedEncodingException {
        return Helper.charToByteArray(this.chars, this.offset, this.length, encoding);
    }

    public String trim() {
        int o2;
        int o1;
        int ofs1 = o1 = this.offset;
        int ofs2 = o2 = this.length + ofs1 - 1;
        char[] c = this.chars;
        while (ofs2 >= ofs1 && c[ofs2] <= ' ') {
            --ofs2;
        }
        while (ofs1 <= ofs2 && c[ofs1] <= ' ') {
            ++ofs1;
        }
        return ofs1 > ofs2 ? "" : (o1 == ofs1 && o2 == ofs2 ? this : new String(ofs1, ofs2 - ofs1 + 1, c));
    }

    public String intern() {
        String result = StringPool.intern(this);
        return result != this ? result : (String)Memory.intern(this);
    }

    public String toLowerCase() {
        int ofs = this.offset;
        int len = this.length;
        int lim = ofs + len;
        char[] c = this.chars;
        int i = ofs;
        while (i < lim) {
            char ci = c[i];
            if (ci != Character.toLowerCase(ci)) break;
            ++i;
        }
        if (i >= lim) {
            return this;
        }
        char[] r = new char[len];
        int j = i - ofs;
        MalikSystem.arraycopyf_short(c, ofs, r, 0, j);
        while (j < len) {
            r[j] = Character.toLowerCase(c[i]);
            ++i;
            ++j;
        }
        return new String(0, len, r);
    }

    public String toUpperCase() {
        int ofs = this.offset;
        int len = this.length;
        int lim = ofs + len;
        char[] c = this.chars;
        int i = ofs;
        while (i < lim) {
            char ci = c[i];
            if (ci != Character.toUpperCase(ci)) break;
            ++i;
        }
        if (i >= lim) {
            return this;
        }
        char[] r = new char[len];
        int j = i - ofs;
        MalikSystem.arraycopyf_short(c, ofs, r, 0, j);
        while (j < len) {
            r[j] = Character.toUpperCase(c[i]);
            ++i;
            ++j;
        }
        return new String(0, len, r);
    }

    public String substring(int beginIndex) {
        int len;
        if (beginIndex < 0 || beginIndex > (len = this.length)) {
            throw new StringIndexOutOfBoundsException("String.substring: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 beginIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return beginIndex == len ? "" : (beginIndex == 0 ? this : new String(this.offset + beginIndex, len - beginIndex, this.chars));
    }

    public String substring(int beginIndex, int endIndex) {
        int len;
        if ((beginIndex | endIndex) < 0 || beginIndex > (len = this.length) || endIndex > len || beginIndex > endIndex) {
            throw new StringIndexOutOfBoundsException("String.substring: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return beginIndex == endIndex ? "" : (endIndex - beginIndex == len ? this : new String(this.offset + beginIndex, endIndex - beginIndex, this.chars));
    }

    public String replace(char oldCharacter, char newCharacter) {
        int len;
        if (oldCharacter == newCharacter || (len = this.length) <= 0) {
            return this;
        }
        int ofs = this.offset;
        int lim = ofs + len;
        char[] c = this.chars;
        int i = MalikSystem.arrayfindf_short(c, ofs, oldCharacter);
        if (i >= lim) {
            return this;
        }
        char[] r = new char[len];
        int j = i - ofs;
        MalikSystem.arraycopyf_short(c, ofs, r, 0, j);
        while (j < len) {
            char ci = c[i];
            r[j] = ci != oldCharacter ? ci : newCharacter;
            ++i;
            ++j;
        }
        return new String(0, len, r);
    }

    public String concat(String anot) {
        if (anot == null) {
            throw new NullPointerException("String.concat: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 anot \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int len2 = anot.length;
        if (len2 <= 0) {
            return this;
        }
        int len1 = this.length;
        if (len1 <= 0) {
            return anot;
        }
        int len = len1 + len2;
        char[] r = new char[len];
        MalikSystem.arraycopyf_short(this.chars, this.offset, r, 0, len1);
        MalikSystem.arraycopyf_short(anot.chars, anot.offset, r, len1, len2);
        return new String(0, len, r);
    }

    int getCharsAddress() {
        return this.length > 0 ? this.chars.getArrayAddress() + (this.offset << 1) : 0;
    }
}

