/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.application;

import java.util.Random;

public final class InputDevice {
    public static final int NUM_LOCK = 1;
    public static final int CAPS_LOCK = 2;
    public static final int SCROLL_LOCK = 4;
    public static final int KEYBOARD_TYPE_NONE = 0;
    public static final int KEYBOARD_TYPE_ALPHABETIC = 1;
    public static final int KEYBOARD_TYPE_NON_ALPHABETIC = 2;
    public static final int SOURCE_CLASS_NONE = 0;
    public static final int SOURCE_CLASS_BUTTON = 1;
    public static final int SOURCE_CLASS_POINTER = 2;
    public static final int SOURCE_CLASS_TRACKBALL = 4;
    public static final int SOURCE_CLASS_POSITION = 8;
    public static final int SOURCE_CLASS_JOYSTICK = 16;
    public static final int SOURCE_CLASS_MASK = 255;
    public static final int SOURCE_UNKNOWN = 0;
    public static final int SOURCE_ANY = -256;
    public static final int SOURCE_KEYBOARD = 257;
    public static final int SOURCE_DPAD = 513;
    public static final int SOURCE_GAMEPAD = 1025;
    public static final int SOURCE_TOUCHSCREEN = 4098;
    public static final int SOURCE_MOUSE = 8194;
    public static final int SOURCE_STYLUS = 16386;
    public static final int SOURCE_BLUETOOTH_STYLUS = 49154;
    public static final int SOURCE_TRACKBALL = 65540;
    public static final int SOURCE_MOUSE_RELATIVE = 131076;
    public static final int SOURCE_TOUCHPAD = 0x100008;
    public static final int SOURCE_JOYSTICK = 0x1000010;
    public static final int SOURCE_HDMI = 0x2000001;
    static final int ID_POINTING_STANDARD = 888888;
    static final int ID_KEYBOARD_STANDARD = 527078;
    static final int ID_KEYBOARD_VIRTUAL = 617388;
    private static int COUNT;
    private static InputDevice[] DEVICES;
    private static final Random ID_GENERATOR;
    private final boolean virtual;
    private final int id;
    private final int source;
    private final int keyboardType;
    private final int buttons;
    private final long[] keys;
    private final String name;

    static {
        long[] skeys = new long[]{288162202272080640L, 1152903908796923902L, -288230243007528960L, 2013265921L};
        long[] vkeys = new long[]{288162202272080640L, -17595809923074L, -288230105568575233L, 2013265921L};
        COUNT = 3;
        DEVICES = new InputDevice[]{new InputDevice(888888, false, 28674, 0, null, 115, "\u0421\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0443\u043a\u0430\u0437\u044b\u0432\u0430\u044e\u0449\u0435\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e"), new InputDevice(527078, false, 257, 1, skeys, 0, "\u0421\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u0430\u044f \u043a\u043b\u0430\u0432\u0438\u0430\u0442\u0443\u0440\u0430"), new InputDevice(617388, true, 257, 1, vkeys, 0, "\u0412\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u0430\u044f \u043a\u043b\u0430\u0432\u0438\u0430\u0442\u0443\u0440\u0430")};
        ID_GENERATOR = new Random();
    }

    public static int getKeyboardLightStatus() {
        return (int)MalikSystem.syscall(0L, 81);
    }

    public static int[] getIDs() {
        int len = COUNT;
        int[] result = new int[len];
        int i = len;
        while (i-- > 0) {
            result[i] = InputDevice.DEVICES[i].id;
        }
        return result;
    }

    public static InputDevice get(int id) {
        int i = COUNT;
        while (i-- > 0) {
            InputDevice device = DEVICES[i];
            if (id != device.id) continue;
            return device;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputDevice createVirtual(int source, int keyboardType, long[] keys, int buttons, String name) {
        InputDevice result;
        if (keyboardType < 0 || keyboardType > 2) {
            throw new IllegalArgumentException("InputDevice.createVirtual: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 keyboardType \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        Random random = ID_GENERATOR;
        synchronized (random) {
            int id;
            while (InputDevice.get(id = ID_GENERATOR.nextInt(1048575) + 1) != null) {
            }
            result = new InputDevice(id, true, source, keyboardType, keys, buttons, name);
            int len = COUNT;
            Object[] devices = DEVICES;
            if (len == DEVICES.length) {
                Object[] objectArray = devices;
                devices = new InputDevice[(len << 1) + 1];
                Array.copy(objectArray, 0, devices, 0, len);
                DEVICES = devices;
            }
            devices[len++] = result;
            COUNT = len;
        }
        return result;
    }

    private InputDevice(int id, boolean virtual, int source, int keyboardType, long[] keys, int buttons, String name) {
        this.virtual = virtual;
        this.id = id;
        this.source = source;
        this.keyboardType = keyboardType;
        this.buttons = buttons & 0xFFFF;
        long[] thisKeys = new long[4];
        this.keys = thisKeys;
        String string = this.name = name == null || name.length() <= 0 ? "\u0411\u0435\u0437\u044b\u043c\u044f\u043d\u043d\u043e\u0435 \u0432\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u043e\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e" : name;
        if (keys != null) {
            int keysLength = keys.length;
            Array.copy(keys, 0, thisKeys, 0, keysLength < 4 ? keysLength : 4);
        }
    }

    public String toString() {
        return this.name;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean hasMicrophone() {
        return false;
    }

    public boolean hasKey(int key) {
        return key >= 0 && key <= 255 && (this.keys[key >> 6] & 1L << key) != 0L;
    }

    public boolean hasButton(int button) {
        return button >= 0 && button <= 15 && (this.buttons & 1 << button) != 0;
    }

    public boolean sourceSupported(int source) {
        return (this.source & source) == source;
    }

    public int getKeyboardType() {
        return this.keyboardType;
    }

    public int getSource() {
        return this.source;
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }
}

