/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.io.cloud;

import java.io.IOException;
import malik.emulator.io.cloud.HandleInputStream;
import malik.emulator.util.DataDescriptor;

public class FileInputStream
extends HandleInputStream {
    private final long fileSize;

    public FileInputStream(String fileName) {
        super(fileName, 1);
        int h = this.handle;
        this.fileSize = h == 0 ? -1L : MalikSystem.syscall((long)h, 21);
    }

    FileInputStream(String fileName, int handle) {
        super(fileName, null, handle);
        this.fileSize = MalikSystem.syscall((long)handle, 21);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.checkOpenError();
        DataDescriptor dataDescriptor = this.descriptor;
        synchronized (dataDescriptor) {
            this.closeHandle();
        }
    }

    public final long getFileSize() {
        return this.fileSize;
    }

    protected void $finalize$() {
        this.closeHandle();
    }

    private void closeHandle() {
        int h = this.handle;
        if (h != 0) {
            MalikSystem.syscall((long)h, 17);
            this.handle = 0;
        }
    }
}

