/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.time;

import java.util.TimeZone;
import malik.emulator.util.StringBuilder;

public class BasicTimeZone
extends TimeZone {
    private final int offsetInMillis;
    private final String[] ids;
    private final String name;

    public static char[] offsetToString(int offsetInMillis) {
        int ofs = offsetInMillis / 60000;
        boolean negative = ofs < 0;
        int hrs = negative ? -ofs : ofs;
        int min = hrs % 60;
        return new char[]{negative ? (char)'-' : '+', (char)((hrs /= 60) / 10 % 10 + 48), (char)(hrs % 10 + 48), ':', (char)(min / 10 + 48), (char)(min % 10 + 48)};
    }

    public BasicTimeZone(String id) {
        this(id, null, null, 0);
    }

    public BasicTimeZone(String id, String[] ids, String name, int offsetInMillis) {
        super(id);
        Object[] copyids;
        if (ids == null) {
            copyids = null;
        } else {
            int len = ids.length;
            int copylen = 0;
            copyids = new String[len];
            int i = 0;
            while (i < len) {
                String currid = ids[i];
                if (currid != null) {
                    copyids[copylen++] = currid;
                }
                ++i;
            }
            if (copylen < len) {
                Object[] objectArray = copyids;
                copyids = new String[copylen];
                Array.copy(objectArray, 0, copyids, 0, copylen);
            }
        }
        this.offsetInMillis = offsetInMillis;
        this.ids = copyids;
        this.name = name;
    }

    public boolean equals(Object anot) {
        return anot == this || anot instanceof BasicTimeZone && this.offsetInMillis == ((BasicTimeZone)anot).offsetInMillis;
    }

    public boolean useDaylightTime() {
        return false;
    }

    public int hashCode() {
        return this.offsetInMillis;
    }

    public int getRawOffset() {
        return this.offsetInMillis;
    }

    public int getOffset(int era, int year, int month, int day, int weekday, int millis) {
        if (era < 0 || era > 1) {
            throw new IllegalArgumentException("BasicTimeZone.getOffset: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 era \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if (year <= 0) {
            throw new IllegalArgumentException("BasicTimeZone.getOffset: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 year \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        if (++month < 1 || month > 12) {
            throw new IllegalArgumentException("BasicTimeZone.getOffset: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 month \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        return this.offsetInMillis;
    }

    public String toString() {
        int offset = this.getRawOffset();
        return new StringBuilder().append(this.getName()).append(" (UTC").append(BasicTimeZone.offsetToString(offset)).append(")").toString();
    }

    public String toString(int era, int year, int month, int day, int weekday, int millis) {
        int offset = this.getOffset(era, year, month, day, weekday, millis);
        return new StringBuilder().append(this.getName()).append(" (UTC").append(BasicTimeZone.offsetToString(offset)).append(")").toString();
    }

    public String getName() {
        return this.name;
    }

    public final boolean isID(String id) {
        if (id == null) {
            return this.getID() == null;
        }
        if (id.equals(this.getID())) {
            return true;
        }
        String[] ids = this.ids;
        int len = this.ids == null ? 0 : ids.length;
        int i = 0;
        while (i < len) {
            if (id.equals(ids[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public final int getIDsCount() {
        String[] ids = this.ids;
        return this.ids != null ? ids.length + 1 : 1;
    }

    public final String getID(int index) {
        String[] ids;
        block3: {
            block2: {
                if (index < 0) break block2;
                ids = this.ids;
                if (index <= (this.ids == null ? 0 : ids.length)) break block3;
            }
            throw new IndexOutOfBoundsException("BasicTimeZone.getID: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 index \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return index == 0 ? this.getID() : ids[index - 1];
    }
}

