/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.util;

import malik.emulator.util.SystemDescriptor;

public final class DataDescriptor
extends SystemDescriptor {
    private int length;
    private int address;
    private int offset;
    private byte[] buffer;

    public void setDataInfo(int address, int length) {
        this.length = length;
        this.address = address;
        this.offset = 0;
        this.buffer = null;
    }

    public void setDataInfo(byte[] buffer, int offset, int length) {
        if (buffer == null) {
            throw new NullPointerException("DataDescriptor.setDataInfo: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 buffer \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Array.checkBound("DataDescriptor.setDataInfo", buffer.length, offset, length);
        this.length = length;
        this.address = Array.getFirstElementAddress(buffer) + offset;
        this.offset = offset;
        this.buffer = buffer;
    }

    public int getAddress() {
        return this.address;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }
}

