/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.util;

import malik.emulator.fileformats.DataHolder;

public abstract class Queue
implements DataHolder {
    protected int head;
    protected int tail;
    protected int capacity;

    protected Queue(int initialCapacity) {
        if (initialCapacity < 1) {
            initialCapacity = 1;
        }
        this.capacity = initialCapacity + 1;
    }

    public abstract void removeHeadElement();

    public void clear() {
        this.tail = 0;
        this.head = 0;
    }

    public final boolean isEmpty() {
        return this.tail == this.head;
    }

    public final int length() {
        int t = this.tail;
        int h = this.head;
        return t >= h ? t - h : t - h + this.capacity;
    }

    public final int capacity() {
        return this.capacity - 1;
    }

    protected void reset(int newCapacity) {
        int t = this.tail;
        int h = this.head;
        this.head = 0;
        this.tail = t >= h ? t - h : t - h + this.capacity;
        this.capacity = newCapacity;
    }

    protected int freeElements() {
        int t = this.tail;
        int h = this.head;
        return (t >= h ? this.capacity + h - t : h - t) - 1;
    }

    protected int nextIndex(int index, int capacity) {
        return (index + 1) % capacity;
    }

    protected int[] expand(int[] queue, int newCapacity) {
        if (queue == null) {
            throw new NullPointerException("Queue.expand: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 queue \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int len = this.capacity;
        if (queue.length != len) {
            throw new IllegalArgumentException("Queue.expand: \u0434\u043b\u0438\u043d\u0430 \u043e\u0447\u0435\u0440\u0435\u0434\u0438 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0437\u0430\u0434\u0430\u043d\u043d\u043e\u0439 \u0451\u043c\u043a\u043e\u0441\u0442\u0438.");
        }
        if (newCapacity <= len) {
            throw new IllegalArgumentException("Queue.expand: \u043d\u043e\u0432\u0430\u044f \u0451\u043c\u043a\u043e\u0441\u0442\u044c \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0431\u043e\u043b\u044c\u0448\u0435 \u043f\u0440\u0435\u0436\u043d\u0435\u0439.");
        }
        int[] result = new int[newCapacity];
        int t = this.tail;
        int h = this.head;
        if (t > h) {
            Array.copy(queue, h, result, 0, t - h);
        } else if (t < h) {
            int tmp = len - h;
            Array.copy(queue, h, result, 0, tmp);
            Array.copy(queue, 0, result, tmp, t);
        }
        return result;
    }

    protected long[] expand(long[] queue, int newCapacity) {
        if (queue == null) {
            throw new NullPointerException("Queue.expand: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 queue \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int len = this.capacity;
        if (queue.length != len) {
            throw new IllegalArgumentException("Queue.expand: \u0434\u043b\u0438\u043d\u0430 \u043e\u0447\u0435\u0440\u0435\u0434\u0438 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0437\u0430\u0434\u0430\u043d\u043d\u043e\u0439 \u0451\u043c\u043a\u043e\u0441\u0442\u0438.");
        }
        if (newCapacity <= len) {
            throw new IllegalArgumentException("Queue.expand: \u043d\u043e\u0432\u0430\u044f \u0451\u043c\u043a\u043e\u0441\u0442\u044c \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0431\u043e\u043b\u044c\u0448\u0435 \u043f\u0440\u0435\u0436\u043d\u0435\u0439.");
        }
        long[] result = new long[newCapacity];
        int t = this.tail;
        int h = this.head;
        if (t > h) {
            Array.copy(queue, h, result, 0, t - h);
        } else if (t < h) {
            int tmp = len - h;
            Array.copy(queue, h, result, 0, tmp);
            Array.copy(queue, 0, result, tmp, t);
        }
        return result;
    }

    protected Object[] expand(Object[] queue, int newCapacity) {
        if (queue == null) {
            throw new NullPointerException("Queue.expand: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 queue \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int len = this.capacity;
        if (queue.length != len) {
            throw new IllegalArgumentException("Queue.expand: \u0434\u043b\u0438\u043d\u0430 \u043e\u0447\u0435\u0440\u0435\u0434\u0438 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0437\u0430\u0434\u0430\u043d\u043d\u043e\u0439 \u0451\u043c\u043a\u043e\u0441\u0442\u0438.");
        }
        if (newCapacity <= len) {
            throw new IllegalArgumentException("Queue.expand: \u043d\u043e\u0432\u0430\u044f \u0451\u043c\u043a\u043e\u0441\u0442\u044c \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0431\u043e\u043b\u044c\u0448\u0435 \u043f\u0440\u0435\u0436\u043d\u0435\u0439.");
        }
        Object[] result = (Object[])Array.create(newCapacity, queue.getClass());
        int t = this.tail;
        int h = this.head;
        if (t > h) {
            Array.copy(queue, h, result, 0, t - h);
        } else if (t < h) {
            int tmp = len - h;
            Array.copy(queue, h, result, 0, tmp);
            Array.copy(queue, 0, result, tmp, t);
        }
        return result;
    }

    protected final void advanceHead(int head) {
        this.head = this.nextIndex(head, this.capacity);
    }

    protected final void advanceTail(int tail) {
        this.tail = this.nextIndex(tail, this.capacity);
    }
}

