/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.util;

public class RealValueRepresenter {
    public static final int MIN_ORDER_DIGITS = 2;
    public static final int MAX_ORDER_DIGITS = 4;
    public static final int FLOAT_ORDER_DIGITS = 2;
    public static final int DOUBLE_ORDER_DIGITS = 3;
    public static final int MIN_SIGNIFICAND_DIGITS = 6;
    public static final int MAX_SIGNIFICAND_DIGITS = 18;
    public static final int FLOAT_SIGNIFICAND_DIGITS = 7;
    public static final int DOUBLE_SIGNIFICAND_DIGITS = 15;
    protected final double limitValueWithFractialPart;
    protected final double limitValueWithoutExponent;
    protected final int orderDigits;
    protected final int significandDigits;
    protected final long minRepresentValue;
    protected final long maxRepresentValue;

    public static double pow10(double value, int power) {
        if (power == Integer.MIN_VALUE) {
            return value * 0.0;
        }
        if (power > 0) {
            return value / RealValueRepresenter.tab_04_00(power) / RealValueRepresenter.tab_08_05(power) / (power >= 512 ? 0.0 : 1.0);
        }
        if ((power = -power) > 0) {
            return value * RealValueRepresenter.tab_04_00(power) * RealValueRepresenter.tab_08_05(power) * (power >= 512 ? 0.0 : 1.0);
        }
        return value;
    }

    private static double tab_04_00(int pow) {
        switch (pow & 0x1F) {
            default: {
                return 0.0;
            }
            case 0: {
                return 1.0;
            }
            case 1: {
                return 0.1;
            }
            case 2: {
                return 0.01;
            }
            case 3: {
                return 0.001;
            }
            case 4: {
                return 1.0E-4;
            }
            case 5: {
                return 1.0E-5;
            }
            case 6: {
                return 1.0E-6;
            }
            case 7: {
                return 1.0E-7;
            }
            case 8: {
                return 1.0E-8;
            }
            case 9: {
                return 1.0E-9;
            }
            case 10: {
                return 1.0E-10;
            }
            case 11: {
                return 1.0E-11;
            }
            case 12: {
                return 1.0E-12;
            }
            case 13: {
                return 1.0E-13;
            }
            case 14: {
                return 1.0E-14;
            }
            case 15: {
                return 1.0E-15;
            }
            case 16: {
                return 1.0E-16;
            }
            case 17: {
                return 1.0E-17;
            }
            case 18: {
                return 1.0E-18;
            }
            case 19: {
                return 1.0E-19;
            }
            case 20: {
                return 1.0E-20;
            }
            case 21: {
                return 1.0E-21;
            }
            case 22: {
                return 1.0E-22;
            }
            case 23: {
                return 1.0E-23;
            }
            case 24: {
                return 1.0E-24;
            }
            case 25: {
                return 1.0E-25;
            }
            case 26: {
                return 1.0E-26;
            }
            case 27: {
                return 1.0E-27;
            }
            case 28: {
                return 1.0E-28;
            }
            case 29: {
                return 1.0E-29;
            }
            case 30: {
                return 1.0E-30;
            }
            case 31: 
        }
        return 1.0E-31;
    }

    private static double tab_08_05(int pow) {
        switch (pow >> 5 & 0xF) {
            default: {
                return 0.0;
            }
            case 0: {
                return 1.0;
            }
            case 1: {
                return 1.0E-32;
            }
            case 2: {
                return 1.0E-64;
            }
            case 3: {
                return 1.0E-96;
            }
            case 4: {
                return 1.0E-128;
            }
            case 5: {
                return 1.0E-160;
            }
            case 6: {
                return 1.0E-192;
            }
            case 7: {
                return 1.0E-224;
            }
            case 8: {
                return 1.0E-256;
            }
            case 9: {
                return 1.0E-288;
            }
            case 10: {
                return 1.0E-320;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
        }
        return 0.0;
    }

    public RealValueRepresenter(int significandDigits, int orderDigits) {
        long maxRepresentValue = 1L;
        if (orderDigits < 2) {
            orderDigits = 2;
        }
        if (orderDigits > 4) {
            orderDigits = 4;
        }
        if (significandDigits < 6) {
            significandDigits = 6;
        }
        if (significandDigits > 18) {
            significandDigits = 18;
        }
        int i = significandDigits;
        while (i-- > 0) {
            maxRepresentValue *= 10L;
        }
        this.limitValueWithFractialPart = RealValueRepresenter.pow10(1.0, significandDigits - 1);
        this.limitValueWithoutExponent = RealValueRepresenter.pow10(1.0, significandDigits);
        this.orderDigits = orderDigits;
        this.significandDigits = significandDigits;
        this.minRepresentValue = maxRepresentValue / 10L;
        this.maxRepresentValue = maxRepresentValue - 1L;
    }

    public boolean equals(Object anot) {
        block2: {
            block3: {
                if (anot == this) break block2;
                if (!(anot instanceof RealValueRepresenter)) break block3;
                RealValueRepresenter r = (RealValueRepresenter)anot;
                if (this.orderDigits == r.orderDigits && this.significandDigits == r.significandDigits) break block2;
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.orderDigits << 8 | this.significandDigits;
    }

    public float parseFloat(String string) throws NumberFormatException {
        if ("+Infinity".equals(string) || "Infinity".equals(string)) {
            return Float.POSITIVE_INFINITY;
        }
        if ("-Infinity".equals(string)) {
            return Float.NEGATIVE_INFINITY;
        }
        if ("NaN".equals(string)) {
            return Float.NaN;
        }
        double result = this.parse(string);
        if (result < -3.4028234663852886E38 || result > 3.4028234663852886E38) {
            throw new NumberFormatException("RealValueRepresenter.parse: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0447\u0438\u0441\u043b\u0430.");
        }
        return (float)result;
    }

    public double parseDouble(String string) throws NumberFormatException {
        if ("+Infinity".equals(string) || "Infinity".equals(string)) {
            return Double.POSITIVE_INFINITY;
        }
        if ("-Infinity".equals(string)) {
            return Double.NEGATIVE_INFINITY;
        }
        if ("NaN".equals(string)) {
            return Double.NaN;
        }
        return this.parse(string);
    }

    public int getOrderDigits() {
        return this.orderDigits;
    }

    public int getSignificandDigits() {
        return this.significandDigits;
    }

    public String toString(double value) {
        if (value != value) {
            return "NaN";
        }
        if (value == Double.POSITIVE_INFINITY) {
            return "Infinity";
        }
        if (value == Double.NEGATIVE_INFINITY) {
            return "-Infinity";
        }
        int len = 0;
        int i = 32;
        char[] buf = new char[32];
        Array.fill(buf, 0, i, 48);
        long intval = Double.doubleToLongBits(value);
        if (intval < 0L) {
            buf[len++] = 45;
            value = Double.longBitsToDouble(intval &= Long.MAX_VALUE);
        }
        if (intval != 0L) {
            char c;
            int dotpos;
            int order = (int)(0.3010299956639812 * Math.log2(value));
            int sigdig = this.significandDigits;
            boolean expform = value < 0.001 || value >= 1.0E7;
            if (expform) {
                if (order < 0) {
                    --order;
                }
                if ((intval = Math.round(RealValueRepresenter.pow10(value, sigdig - order - 1))) < this.minRepresentValue) {
                    intval *= 10L;
                    --order;
                }
                if (intval > this.maxRepresentValue) {
                    intval /= 10L;
                    ++order;
                }
                dotpos = len + 1;
            } else if (value < 1.0) {
                intval = Math.round(RealValueRepresenter.pow10(value, sigdig - 1));
                dotpos = len + 1;
            } else if (value < this.limitValueWithFractialPart) {
                intval = Math.round(RealValueRepresenter.pow10(value, sigdig - order - 1));
                if (intval < this.minRepresentValue) {
                    intval *= 10L;
                    --order;
                }
                if (intval > this.maxRepresentValue) {
                    intval /= 10L;
                    ++order;
                }
                dotpos = len + order + 1;
            } else {
                long tmp;
                intval = Math.round(value);
                if (intval > (tmp = this.maxRepresentValue)) {
                    intval = tmp;
                }
                dotpos = len + sigdig;
            }
            buf[dotpos] = 46;
            i = len + sigdig;
            while (i-- > len) {
                buf[i >= dotpos ? i + 1 : i] = (char)((int)(intval % 10L) + 48);
                intval /= 10L;
            }
            len += sigdig + 2;
            while ((c = buf[len - 1]) == '0' || c == '.') {
                --len;
                if (c != '.') continue;
                len += 2;
                break;
            }
            if (expform) {
                int j;
                buf[len++] = 69;
                if (order < 0) {
                    buf[len++] = 45;
                    order = -order;
                } else {
                    buf[len++] = 43;
                }
                i = j = len + this.orderDigits;
                while (i-- > len) {
                    buf[i] = (char)(order % 10 + 48);
                    order /= 10;
                }
                len = j;
            }
        } else {
            buf[(len += 3) - 2] = 46;
        }
        return new String(buf, 0, len);
    }

    /*
     * Unable to fully structure code
     */
    protected double parse(String string) throws NumberFormatException {
        block25: {
            block24: {
                block23: {
                    block21: {
                        block22: {
                            block20: {
                                if (string == null || (len = string.length()) <= 0) {
                                    throw new NumberFormatException("RealValueRepresenter.parse: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0447\u0438\u0441\u043b\u0430.");
                                }
                                negative = false;
                                result = 0.0;
                                order = 0;
                                frac = 0;
                                i = 0;
                                switch (string.charAt(0)) {
                                    default: {
                                        break;
                                    }
                                    case '-': {
                                        negative = true;
                                    }
                                    case ' ': 
                                    case '+': {
                                        ++i;
                                    }
                                }
                                if (i >= len || ((c = string.charAt(i)) < '0' || c > '9') && c != '.') break block20;
                                if (c == '.') break block21;
                                break block22;
                            }
                            throw new NumberFormatException("RealValueRepresenter.parse: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0447\u0438\u0441\u043b\u0430.");
                        }
                        result = c - 48;
                        ++i;
                        while (i < len && (c = string.charAt(i)) >= '0' && c <= '9') {
                            result = 10.0 * result + (double)(c - 48);
                            ++i;
                        }
                    }
                    if (i < len && string.charAt(i) == '.') {
                        ++i;
                        while (i < len && (c = string.charAt(i)) >= '0' && c <= '9') {
                            result = 10.0 * result + (double)(c - 48);
                            ++frac;
                            ++i;
                        }
                    }
                    if (negative) {
                        result = -result;
                        negative = false;
                    }
                    if (i >= len || (c = string.charAt(i)) != 'E' && c != 'e') break block23;
                    if (++i == len) {
                        throw new NumberFormatException("RealValueRepresenter.parse: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0447\u0438\u0441\u043b\u0430.");
                    }
                    switch (string.charAt(i)) {
                        default: {
                            break;
                        }
                        case '-': {
                            negative = true;
                        }
                        case '+': {
                            ++i;
                        }
                    }
                    if (i != len) ** GOTO lbl53
                    throw new NumberFormatException("RealValueRepresenter.parse: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0447\u0438\u0441\u043b\u0430.");
lbl-1000:
                    // 1 sources

                    {
                        if ((order = 10 * order + (c - 48)) > 9999) {
                            throw new NumberFormatException("RealValueRepresenter.parse: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0447\u0438\u0441\u043b\u0430.");
                        }
                        ++i;
lbl53:
                        // 2 sources

                        ** while (i < len && (c = string.charAt((int)i)) >= '0' && c <= '9')
                    }
lbl54:
                    // 1 sources

                    if (negative) {
                        order = -order;
                    }
                }
                if (i < len) break block24;
                result = RealValueRepresenter.pow10(result, order - frac);
                if (!(Math.abs(v0) > 1.7976931348623157E308)) break block25;
            }
            throw new NumberFormatException("RealValueRepresenter.parse: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0447\u0438\u0441\u043b\u0430.");
        }
        return result;
    }
}

