/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.fileformats.sound.synthetic.midilib;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import malik.emulator.fileformats.DataDecoder;
import malik.emulator.fileformats.DataHolder;
import malik.emulator.fileformats.InputAdapter;
import malik.emulator.fileformats.InvalidDataFormatException;
import malik.emulator.fileformats.sound.SoundDecoder;
import malik.emulator.fileformats.sound.synthetic.SoundDecoderSynthetic;

public final class MIDIDecoder
implements InputAdapter,
SoundDecoder,
DataHolder,
DataDecoder,
SoundDecoderSynthetic {
    public static final long MIDI_SIGNATURE = 5572193417670164486L;
    private static final int MTRK_SIGNATURE = 1297379947;
    private static final int DEFAULT_TEMPO = 500000;
    private static final int MAX_TRACKS = 32;
    private boolean stopped;
    private int ppqn;
    private long[] messages;
    private Track[] tracks;

    public void loadFromInputStream(InputStream stream) throws IOException, InvalidDataFormatException {
        this.loadFromDataStream(new DataInputStream(stream));
    }

    public void loadFromDataStream(DataInputStream stream) throws IOException, InvalidDataFormatException {
        this.clear();
        stream.readUnsignedShort();
        int ntracks = stream.readUnsignedShort();
        if (ntracks > 32) {
            throw new InvalidDataFormatException("\u0414\u0435\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 MIDI-\u0444\u0430\u0439\u043b\u043e\u0432: \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0442\u0440\u0435\u043a\u043e\u0432 \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u043f\u0440\u0435\u0432\u044b\u0448\u0430\u0442\u044c 32.");
        }
        if (ntracks <= 0) {
            throw new InvalidDataFormatException("\u0414\u0435\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 MIDI-\u0444\u0430\u0439\u043b\u043e\u0432: \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0442\u0440\u0435\u043a\u043e\u0432 \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043d\u0443\u043b\u0435\u0432\u044b\u043c.");
        }
        short ppqn = stream.readShort();
        if (ppqn <= 0) {
            throw new InvalidDataFormatException("\u0414\u0435\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 MIDI-\u0444\u0430\u0439\u043b\u043e\u0432: \u0432\u0440\u0435\u043c\u044f \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 SMPTE \u0438 \u043d\u0443\u043b\u0435\u0432\u043e\u0435 PPQN \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u044e\u0442\u0441\u044f.");
        }
        Track[] tracks = new Track[ntracks];
        int i = 0;
        while (i < ntracks) {
            int type = stream.readInt();
            int len = stream.readInt();
            if (len <= 0) {
                throw new InvalidDataFormatException("\u0414\u0435\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 MIDI-\u0444\u0430\u0439\u043b\u043e\u0432: \u0434\u043b\u0438\u043d\u0430 \u0431\u043b\u043e\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0439.");
            }
            if (type != 1297379947) {
                stream.skipBytes(len);
            } else {
                byte[] trackBytes = new byte[len];
                stream.readFully(trackBytes);
                tracks[i] = new Track(trackBytes);
            }
            ++i;
        }
        this.stopped = false;
        this.ppqn = ppqn;
        this.messages = null;
        this.tracks = tracks;
    }

    public void stopLoading() {
        this.stopped = true;
    }

    public void clear() {
        this.messages = null;
        this.tracks = null;
    }

    public boolean isEmpty() {
        return this.messages == null && this.tracks == null;
    }

    public long[] getMessages() {
        long[] result;
        block29: {
            int len;
            boolean stop;
            block28: {
                result = this.messages;
                if (this.messages != null) break block29;
                Track[] tracks = this.tracks;
                if (this.tracks == null) {
                    return null;
                }
                result = new long[15];
                stop = false;
                len = 1;
                try {
                    int ntracks = tracks.length;
                    int ntracksEnds = 0;
                    long currentTimeInDelta = 0L;
                    double currentTimeInMillis = 0.0;
                    double ppqn = this.ppqn;
                    double tempo = 500000.0;
                    int i = ntracks;
                    while (i-- > 0) {
                        if (this.stopped) {
                            stop = true;
                            break block28;
                        }
                        tracks[i].readDeltaTime();
                    }
                    while (true) {
                        double dtimeInMillis;
                        long dtimeInDelta;
                        int dataByte2;
                        int dataByte1;
                        int statusByte;
                        Track currentTrack;
                        block31: {
                            block34: {
                                block33: {
                                    block32: {
                                        block30: {
                                            if (this.stopped) {
                                                stop = true;
                                                break;
                                            }
                                            currentTrack = tracks[0];
                                            long minDeltaTime = currentTrack.eventTimeInDelta;
                                            int i2 = 1;
                                            while (i2 < ntracks) {
                                                if (this.stopped) {
                                                    stop = true;
                                                    break block28;
                                                }
                                                Track curTrack = tracks[i2];
                                                long curDeltaTime = curTrack.eventTimeInDelta;
                                                if (curDeltaTime < minDeltaTime) {
                                                    currentTrack = curTrack;
                                                    minDeltaTime = curDeltaTime;
                                                }
                                                ++i2;
                                            }
                                            statusByte = currentTrack.read();
                                            if (statusByte < 0) break block28;
                                            if ((statusByte & 0x80) == 0) {
                                                statusByte = currentTrack.lastStatusByte;
                                                currentTrack.seek(-1);
                                            } else if (statusByte != 255) {
                                                currentTrack.lastStatusByte = statusByte;
                                            }
                                            if ((statusByte < 128 || statusByte >= 192) && (statusByte < 224 || statusByte >= 240)) break block30;
                                            dataByte1 = currentTrack.read();
                                            dataByte2 = currentTrack.read();
                                            break block31;
                                        }
                                        if (statusByte < 192 || statusByte >= 224) break block32;
                                        dataByte1 = currentTrack.read();
                                        dataByte2 = 0;
                                        break block31;
                                    }
                                    if (statusByte == 240 || statusByte == 247) {
                                        currentTrack.seek(currentTrack.readVolatileLengthValue());
                                        currentTrack.readDeltaTime();
                                        continue;
                                    }
                                    if (statusByte == 241 || statusByte == 243) {
                                        currentTrack.seek(1);
                                        currentTrack.readDeltaTime();
                                        continue;
                                    }
                                    if (statusByte == 242) {
                                        currentTrack.seek(2);
                                        currentTrack.readDeltaTime();
                                        continue;
                                    }
                                    if (statusByte != 255) break block33;
                                    switch (currentTrack.read()) {
                                        default: {
                                            currentTrack.seek(currentTrack.readVolatileLengthValue());
                                            currentTrack.readDeltaTime();
                                            break;
                                        }
                                        case -1: {
                                            break block28;
                                        }
                                        case 47: {
                                            if (currentTrack.read() != 0) {
                                                break block28;
                                            }
                                            break block34;
                                        }
                                        case 81: {
                                            int dataByte3;
                                            statusByte = currentTrack.readVolatileLengthValue();
                                            if (statusByte >= 3 && ((dataByte1 = currentTrack.read()) | (dataByte2 = currentTrack.read()) | (dataByte3 = currentTrack.read())) >= 0) {
                                                tempo = dataByte1 << 16 | dataByte2 << 8 | dataByte3;
                                                currentTrack.seek(statusByte - 3);
                                                currentTrack.readDeltaTime();
                                                break;
                                            }
                                            break block28;
                                        }
                                    }
                                    continue;
                                }
                                currentTrack.readDeltaTime();
                                continue;
                            }
                            if (++ntracksEnds < ntracks) {
                                currentTrack.endOfTrack();
                                continue;
                            }
                            dtimeInDelta = currentTrack.eventTimeInDelta - currentTimeInDelta;
                            dtimeInMillis = 0.001 * (double)dtimeInDelta * tempo / ppqn;
                            currentTimeInDelta += dtimeInDelta;
                            currentTimeInMillis += dtimeInMillis;
                            if (len == result.length) {
                                long[] lArray = result;
                                result = new long[(len << 1) + 1];
                                Array.copy((long[])lArray, (int)0, (long[])result, (int)0, (int)len);
                            }
                            result[len++] = (long)currentTimeInMillis << 24 | 0xFF2F00L;
                            break;
                        }
                        dtimeInDelta = currentTrack.eventTimeInDelta - currentTimeInDelta;
                        dtimeInMillis = 0.001 * (double)dtimeInDelta * tempo / ppqn;
                        currentTimeInDelta += dtimeInDelta;
                        currentTimeInMillis += dtimeInMillis;
                        if (len == result.length) {
                            long[] lArray = result;
                            result = new long[(len << 1) + 1];
                            Array.copy((long[])lArray, (int)0, (long[])result, (int)0, (int)len);
                        }
                        result[len++] = (long)currentTimeInMillis << 24 | (long)(statusByte << 16) | (long)(dataByte1 << 8) | (long)dataByte2;
                        currentTrack.readDeltaTime();
                    }
                }
                catch (RuntimeException e) {
                    e.printRealStackTrace();
                }
            }
            if (stop) {
                return null;
            }
            if (len < result.length) {
                long[] lArray = result;
                result = new long[len];
                Array.copy((long[])lArray, (int)0, (long[])result, (int)0, (int)len);
            }
            this.messages = result;
            this.tracks = null;
        }
        return result;
    }

    private static final class Track
    extends ByteArrayInputStream {
        public int lastStatusByte;
        public long eventTimeInDelta;

        public Track(byte[] stream) {
            super(stream);
        }

        public void seek(int delta) {
            this.pos += delta;
        }

        public void endOfTrack() {
            this.eventTimeInDelta = Long.MAX_VALUE;
        }

        public void readDeltaTime() {
            this.eventTimeInDelta += (long)this.readVolatileLengthValue();
        }

        public int readVolatileLengthValue() {
            int result = 0;
            int position = this.pos;
            byte[] stream = this.buf;
            int len = stream != null ? stream.length : 0;
            int i = 4;
            while (position >= 0 && position < len && i-- > 0) {
                int b = stream[position++] & 0xFF;
                result = result << 7 | b & 0x7F;
                if ((b & 0x80) == 0) break;
            }
            this.pos = position;
            return result;
        }
    }
}

