/*
 * Decompiled with CFR 0.152.
 */
package javax.bluetooth;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.bluetooth.NULL;
import javax.bluetooth.UUID;

public class DataElement {
    public static final int NULL = 0;
    public static final int U_INT_1 = 8;
    public static final int U_INT_2 = 9;
    public static final int U_INT_4 = 10;
    public static final int U_INT_8 = 11;
    public static final int U_INT_16 = 12;
    public static final int INT_1 = 16;
    public static final int INT_2 = 17;
    public static final int INT_4 = 18;
    public static final int INT_8 = 19;
    public static final int INT_16 = 20;
    public static final int UUID = 24;
    public static final int STRING = 32;
    public static final int BOOL = 40;
    public static final int DATSEQ = 48;
    public static final int DATALT = 56;
    public static final int URL = 64;
    private static final Class DATA_ELEMENT_ARRAY1D_CLASS;
    private int type;
    private int count;
    private Object value;
    private Object lock;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Ljavax.bluetooth.DataElement;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DATA_ELEMENT_ARRAY1D_CLASS = clazz;
    }

    public DataElement(boolean value) {
        this.type = 40;
        this.value = value ? Boolean.TRUE : Boolean.FALSE;
    }

    public DataElement(int type) {
        switch (type) {
            default: {
                throw new IllegalArgumentException("DataElement: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 type.");
            }
            case 0: {
                this.type = type;
                this.value = javax.bluetooth.NULL.INSTANCE;
                break;
            }
            case 48: 
            case 56: {
                this.type = type;
                this.count = 0;
                this.value = new DataElement[2];
                this.lock = new Object();
            }
        }
    }

    public DataElement(int type, long value) {
        switch (type) {
            default: {
                throw new IllegalArgumentException("DataElement: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 type.");
            }
            case 8: {
                if (value >= 0L && value <= 255L) break;
                throw new IllegalArgumentException("DataElement: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 value.");
            }
            case 9: {
                if (value >= 0L && value <= 65535L) break;
                throw new IllegalArgumentException("DataElement: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 value.");
            }
            case 10: {
                if (value >= 0L && value <= 0xFFFFFFFFL) break;
                throw new IllegalArgumentException("DataElement: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 value.");
            }
            case 16: {
                if (value >= -128L && value <= 127L) break;
                throw new IllegalArgumentException("DataElement: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 value.");
            }
            case 17: {
                if (value >= -32768L && value <= 32767L) break;
                throw new IllegalArgumentException("DataElement: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 value.");
            }
            case 18: {
                if (value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE) break;
                throw new IllegalArgumentException("DataElement: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 value.");
            }
            case 19: 
        }
        this.type = type;
        this.value = new Long(value);
    }

    public DataElement(int type, Object value) {
        switch (type) {
            default: {
                throw new IllegalArgumentException("DataElement: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 type.");
            }
            case 32: 
            case 64: {
                if (!(value instanceof String)) {
                    throw new IllegalArgumentException("DataElement: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 value.");
                }
                this.type = type;
                this.value = value;
                break;
            }
            case 24: {
                if (!(value instanceof UUID)) {
                    throw new IllegalArgumentException("DataElement: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 value.");
                }
                this.type = type;
                this.value = value;
                break;
            }
            case 12: 
            case 20: {
                if (!(value instanceof byte[]) || ((byte[])value).length != 16) {
                    throw new IllegalArgumentException("DataElement: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 value.");
                }
                this.type = type;
                byte[] copy = new byte[16];
                this.value = copy;
                Array.copy((byte[])((byte[])value), (int)0, (byte[])copy, (int)0, (int)16);
                break;
            }
            case 11: {
                if (!(value instanceof byte[]) || ((byte[])value).length != 8) {
                    throw new IllegalArgumentException("DataElement: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 value.");
                }
                this.type = type;
                byte[] copy = new byte[8];
                this.value = copy;
                Array.copy((byte[])((byte[])value), (int)0, (byte[])copy, (int)0, (int)8);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addElement(DataElement element) {
        if (element == null) {
            throw new NullPointerException("DataElement.addElement: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 element \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        DATA_ELEMENT_ARRAY1D_CLASS.cast(this.value);
        Object object = this.lock;
        synchronized (object) {
            int len = this.count;
            Object[] value = (DataElement[])this.value;
            if (len == value.length) {
                Object[] objectArray = value;
                value = new DataElement[len << 1];
                Array.copy((Object[])objectArray, (int)0, (Object[])value, (int)0, (int)len);
                this.value = value;
            }
            value[len] = element;
            this.count = len + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertElementAt(DataElement element, int index) {
        if (element == null) {
            throw new NullPointerException("DataElement.insertElementAt: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 element \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        DATA_ELEMENT_ARRAY1D_CLASS.cast(this.value);
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            int len = this.count;
            if (index > len || index < 0) {
                error = true;
            } else {
                int c;
                Object[] value = (DataElement[])this.value;
                if (len == value.length) {
                    Object[] objectArray = value;
                    value = new DataElement[len << 1];
                    Array.copy((Object[])objectArray, (int)0, (Object[])value, (int)0, (int)len);
                    this.value = value;
                }
                if ((c = len - index) > 0) {
                    Array.copy((Object[])value, (int)index, (Object[])value, (int)(index + 1), (int)c);
                }
                value[index] = element;
                this.count = len + 1;
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("DataElement.insertElementAt: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 index \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeElement(DataElement element) {
        boolean result;
        if (element == null) {
            throw new NullPointerException("DataElement.insertElementAt: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 element \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        DATA_ELEMENT_ARRAY1D_CLASS.cast(this.value);
        Object object = this.lock;
        synchronized (object) {
            result = false;
            int len = this.count;
            Object[] value = (DataElement[])this.value;
            int i = 0;
            while (i < len) {
                if (value[i] == element) {
                    result = true;
                    break;
                }
                ++i;
            }
            if (result) {
                int c = len - i - 1;
                if (c > 0) {
                    Array.copy((Object[])value, (int)(i + 1), (Object[])value, (int)i, (int)c);
                }
                this.count = len - 1;
            }
        }
        return result;
    }

    public int getSize() {
        DATA_ELEMENT_ARRAY1D_CLASS.cast(this.value);
        return this.count;
    }

    public int getDataType() {
        return this.type;
    }

    public boolean getBoolean() {
        return (Boolean)this.value;
    }

    public long getLong() {
        return (Long)this.value;
    }

    public Object getValue() {
        switch (this.type) {
            default: {
                throw new ClassCastException("DataElement.getValue: \u0442\u0438\u043f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0437\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0435\u043c\u043e\u043c\u0443.");
            }
            case 24: 
            case 32: 
            case 64: {
                return this.value;
            }
            case 48: 
            case 56: {
                return new Enumerator();
            }
            case 11: 
            case 12: 
            case 20: 
        }
        byte[] value = (byte[])this.value;
        int len = value.length;
        byte[] result = new byte[len];
        Array.copy((byte[])value, (int)0, (byte[])result, (int)0, (int)len);
        return result;
    }

    private final class Enumerator
    implements Enumeration {
        private int index;

        Enumerator() {
        }

        public boolean hasMoreElements() {
            return this.index < DataElement.this.count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object nextElement() {
            Object result;
            boolean error = false;
            DataElement thisDataElement = DataElement.this;
            Object object = thisDataElement.lock;
            synchronized (object) {
                int i = this.index;
                if (i >= thisDataElement.count) {
                    error = true;
                    result = null;
                } else {
                    this.index = i + 1;
                    result = ((Object[])thisDataElement.value)[i];
                }
            }
            if (error) {
                throw new NoSuchElementException("DataElement: \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435 \u043e\u0441\u0442\u0430\u043b\u043e\u0441\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0434\u043b\u044f \u043f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f.");
            }
            return result;
        }
    }
}

