/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Character {
    public static final char MIN_VALUE = '\u0000';
    public static final char MAX_VALUE = '\uffff';
    public static final int MIN_RADIX = 2;
    public static final int MAX_RADIX = 36;
    private final int value;

    public static boolean isLowerCase(char character) {
        return character >= 'a' && character <= 'z' || character >= '\u00df' && character <= '\u00f6' || character >= '\u00f8' && character <= '\u00ff' || character >= '\u0430' && character <= '\u045f';
    }

    public static boolean isUpperCase(char character) {
        return character >= 'A' && character <= 'Z' || character >= '\u00c0' && character <= '\u00d6' || character >= '\u00d8' && character <= '\u00de' || character >= '\u0400' && character <= '\u042f';
    }

    public static boolean isDigit(char character) {
        return character >= '0' && character <= '9';
    }

    public static char toLowerCase(char character) {
        return (char)(Character.isUpperCase((char)character) ? (character >= 1024 && character <= 1039 ? character + 80 : character + 32) : character);
    }

    public static char toUpperCase(char character) {
        return (char)(Character.isLowerCase((char)character) ? (character >= 1104 && character <= 1119 ? character - 80 : character - 32) : character);
    }

    public static int digit(char character, int radix) {
        int result = -1;
        if (radix >= 2 && radix <= 36) {
            if (character >= '0' && character <= '9') {
                result = character - 48;
            } else if (character >= 'a' && character <= 'z' || character >= 'A' && character <= 'Z') {
                result = (character & 0x1F) + 9;
            }
        }
        return result >= radix ? -1 : result;
    }

    static char getDigitRepresentation(int digit) {
        return (char)(digit >= 0 && digit <= 9 ? digit + 48 : (digit >= 10 && digit < 36 ? digit + 87 : 63));
    }

    public Character(char value) {
        this.value = value;
    }

    public boolean equals(Object anot) {
        return anot == this || anot instanceof Character && this.value == ((Character)anot).value;
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public char charValue() {
        return (char)this.value;
    }
}

