/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.DataInputStream;
import java.io.IOException;
import malik.emulator.application.Run;
import malik.emulator.io.cloud.FileInputStream;
import malik.emulator.util.StackTraceElement;

final class StackTracer {
    private static final int EIP = 0;
    private static final int ESP = 256;
    private static boolean INITIALIZED = false;
    private static int ELEMENTS_COUNT;
    private static long ELEMENTS_OFFSET;
    private static long[] STRINGS_OFFSETS;
    private static String[] STRINGS;
    private static DataInputStream DATA_STREAM;
    private static FileInputStream FILE_STREAM;
    private static final Object MONITOR;

    static {
        MONITOR = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StackTraceElement[] trace(Thread thread) {
        StackTraceElement[] result;
        if (thread == null) {
            throw new NullPointerException("StackTracer.trace: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 thread \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Object object = MONITOR;
        synchronized (object) {
            try {
                Throwable.disableStackTrace();
                try {
                    if (!INITIALIZED) {
                        StackTracer.initialize();
                    }
                    thread.enterStackTrace();
                    try {
                        int stackItemKind;
                        boolean anotherThread = true;
                        int index = 0;
                        int len = 0;
                        int id = thread.getID() & 0xFF;
                        int a = (int)MalikSystem.syscall((long)(0x100 | id), 7);
                        int b = thread.getStackBottom();
                        if (thread == Thread.currentThread()) {
                            anotherThread = false;
                            --len;
                            a += 16;
                        }
                        int address = a;
                        while (address < b) {
                            stackItemKind = MalikSystem.getIntAt(address + 12);
                            if (stackItemKind == 2115010047 || stackItemKind == 2115010303) {
                                ++len;
                            }
                            address += 16;
                        }
                        result = new StackTraceElement[len];
                        if (anotherThread && index < len) {
                            result[index++] = StackTracer.getElement((int)MalikSystem.syscall((long)id, 7));
                        }
                        address = a;
                        while (address < b) {
                            stackItemKind = MalikSystem.getIntAt(address + 12);
                            if (stackItemKind == 2115010047 || stackItemKind == 2115010303) {
                                result[index++] = StackTracer.getElement(MalikSystem.getIntAt(address) - 1);
                                if (index >= len) {
                                    break;
                                }
                            }
                            address += 16;
                        }
                    }
                    finally {
                        thread.leaveStackTrace();
                    }
                }
                finally {
                    Throwable.enableStackTrace();
                }
            }
            catch (IOException iOException) {
                result = null;
            }
        }
        return result;
    }

    private static void initialize() throws IOException {
        FILE_STREAM = new FileInputStream(Run.instance.getAppProperty("Programme-Executable").concat(".bindbg"));
        DATA_STREAM = new DataInputStream(FILE_STREAM);
        FILE_STREAM.mark(Integer.MAX_VALUE);
        int len = DATA_STREAM.readInt();
        STRINGS = new String[len];
        STRINGS_OFFSETS = new long[len];
        long offset = 4L;
        int i = 0;
        while (i < len) {
            StackTracer.STRINGS_OFFSETS[i] = offset;
            offset += FILE_STREAM.skip(DATA_STREAM.readUnsignedShort()) + 2L;
            ++i;
        }
        ELEMENTS_OFFSET = offset;
        ELEMENTS_COUNT = FILE_STREAM.available() / 18;
        INITIALIZED = true;
    }

    private static void seek(long offset) throws IOException {
        FILE_STREAM.reset();
        FILE_STREAM.skip(offset);
    }

    private static int getElementAddress(int index) throws IOException {
        if (index < 0) {
            return Integer.MIN_VALUE;
        }
        if (index >= ELEMENTS_COUNT) {
            return Integer.MAX_VALUE;
        }
        StackTracer.seek(ELEMENTS_OFFSET + (long)index * 18L);
        return DATA_STREAM.readInt();
    }

    private static String getStringAt(int index) throws IOException {
        if (index < 0 || index >= STRINGS.length) {
            return "";
        }
        String result = STRINGS[index];
        if (result == null) {
            StackTracer.seek(STRINGS_OFFSETS[index]);
            result = StackTracer.STRINGS[index] = DATA_STREAM.readUTF();
        }
        return result;
    }

    private static StackTraceElement getElement(int address) throws IOException {
        int addressGuess;
        int address1;
        int limitGuess;
        int limit1;
        block8: {
            limit1 = 0;
            limitGuess = ELEMENTS_COUNT >> 1;
            int limit2 = ELEMENTS_COUNT;
            while (true) {
                address1 = StackTracer.getElementAddress(limit1);
                int address2 = StackTracer.getElementAddress(limit2);
                addressGuess = StackTracer.getElementAddress(limitGuess);
                if (limitGuess - limit1 <= 1 && limit2 - limitGuess <= 1) break block8;
                if (address >= address1 && address < addressGuess) {
                    limit2 = limitGuess;
                    limitGuess = limit1 + limit2 >> 1;
                    continue;
                }
                if (address < addressGuess || address >= address2) break;
                limit1 = limitGuess;
                limitGuess = limit1 + limit2 >> 1;
            }
            return null;
        }
        if (address >= addressGuess) {
            if (limitGuess < 0 || limitGuess >= ELEMENTS_COUNT) {
                return null;
            }
            StackTracer.seek(ELEMENTS_OFFSET + (long)limitGuess * 18L + 4L);
        } else if (address >= address1) {
            if (limit1 < 0 || limit1 >= ELEMENTS_COUNT) {
                return null;
            }
            StackTracer.seek(ELEMENTS_OFFSET + (long)limit1 * 18L + 4L);
        } else {
            return null;
        }
        int classNameIndex = DATA_STREAM.readInt();
        int methodNameIndex = DATA_STREAM.readInt();
        int sourceNameIndex = DATA_STREAM.readInt();
        int lineNumber = DATA_STREAM.readUnsignedShort();
        return new StackTraceElement(StackTracer.getStringAt(classNameIndex), StackTracer.getStringAt(methodNameIndex), StackTracer.getStringAt(sourceNameIndex), lineNumber);
    }

    private StackTracer() {
    }
}

