/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.media.graphics;

import malik.emulator.media.graphics.Rectangle;
import malik.emulator.util.StringBuilder;

public final class RectangularRegion
implements Rectangle {
    private final int left;
    private final int top;
    private final int width;
    private final int height;

    public RectangularRegion(int left, int top, int width, int height) {
        this.left = left;
        this.top = top;
        this.width = width;
        this.height = height;
    }

    public RectangularRegion(Rectangle region) {
        if (region == null) {
            this.left = 0;
            this.top = 0;
            this.width = 0;
            this.height = 0;
            return;
        }
        this.left = region.getLeft();
        this.top = region.getTop();
        this.width = region.getWidth();
        this.height = region.getHeight();
    }

    public boolean equals(Object anot) {
        block2: {
            block3: {
                if (anot == this) break block2;
                if (!(anot instanceof RectangularRegion)) break block3;
                RectangularRegion r = (RectangularRegion)anot;
                if (this.left == r.left && this.top == r.top && this.width == r.width && this.height == r.height) break block2;
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        int l = this.left;
        int t = this.top;
        int w = this.width;
        int h = this.height;
        t = t << 8 | t >>> 24;
        w = w << 16 | w >>> 16;
        h = h << 24 | h >>> 8;
        return l ^ t ^ w ^ h;
    }

    public String toString() {
        return new StringBuilder().append("\u041f\u0440\u044f\u043c\u043e\u0443\u0433\u043e\u043b\u044c\u043d\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c[\u043e\u0442\u0441\u0442\u0443\u043f=").append(this.left).append(":").append(this.top).append(", \u0440\u0430\u0437\u043c\u0435\u0440=").append(this.width).append("\u00d7").append(this.height).append("]").toString();
    }

    public int getLeft() {
        return this.left;
    }

    public int getTop() {
        return this.top;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean intersectsWith(int left, int top, int width, int height) {
        int aLeft = this.left;
        int aTop = this.top;
        int aRight = aLeft + this.width;
        int aBottom = aTop + this.height;
        int bLeft = left;
        int bTop = top;
        int bRight = bLeft + width;
        int bBottom = bTop + height;
        return aLeft < bRight && aTop < bBottom && aRight > bLeft && aBottom > bTop;
    }

    public boolean intersectsWith(Rectangle region) {
        if (region == null) {
            throw new NullPointerException("RectangularRegion.intersectsWith: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 region \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        return this.intersectsWith(region.getLeft(), region.getTop(), region.getWidth(), region.getHeight());
    }

    public RectangularRegion intersection(int left, int top, int width, int height) {
        int tmp;
        boolean f = true;
        int l = this.left;
        int t = this.top;
        int r = l + this.width;
        int b = t + this.height;
        if (l < left) {
            l = left;
            f = false;
        }
        if (t < top) {
            t = top;
            f = false;
        }
        if (r > (tmp = left + width)) {
            r = tmp;
            f = false;
        }
        if (b > (tmp = top + height)) {
            b = tmp;
            f = false;
        }
        return f ? this : new RectangularRegion(l, t, r - l, b - t);
    }

    public RectangularRegion intersection(Rectangle region) {
        if (region == null) {
            throw new NullPointerException("RectangularRegion.intersection: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 region \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        return this.intersection(region.getLeft(), region.getTop(), region.getWidth(), region.getHeight());
    }

    public RectangularRegion union(int left, int top, int width, int height) {
        int tmp;
        boolean f = true;
        int l = this.left;
        int t = this.top;
        int r = l + this.width;
        int b = t + this.height;
        if (l > left) {
            l = left;
            f = false;
        }
        if (t > top) {
            t = top;
            f = false;
        }
        if (r < (tmp = left + width)) {
            r = tmp;
            f = false;
        }
        if (b < (tmp = top + height)) {
            b = tmp;
            f = false;
        }
        return f ? this : new RectangularRegion(l, t, r - l, b - t);
    }

    public RectangularRegion union(Rectangle region) {
        if (region == null) {
            throw new NullPointerException("RectangularRegion.union: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 region \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        return this.union(region.getLeft(), region.getTop(), region.getWidth(), region.getHeight());
    }
}

