/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.lang.ref.WeakReference;
import javax.microedition.lcdui.Choice;
import javax.microedition.lcdui.ChoiceElement;
import javax.microedition.lcdui.ChoiceElementDetailsScreen;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.MIDletProxy;
import malik.emulator.media.graphics.RasterCanvas;

public class ChoiceGroup
extends Item
implements Choice {
    private static final Command[] SELECT = new Command[]{new Command("\u041e\u0442\u043c\u0435\u0442\u0438\u0442\u044c \u0432\u0441\u0435", 8, 0), new Command("\u0421\u043d\u044f\u0442\u044c \u0432\u0441\u0435", 8, 0), new Command("\u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0432\u0441\u0435", 8, 0)};
    private static final Command BACK = new Command("\u041d\u0430\u0437\u0430\u0434", 2, 0);
    private static final Command POPUP_COMMAND = new Command("\u0412\u044b\u0431\u0440\u0430\u0442\u044c\u2026", 4, 0);
    private static final String POPUP_LABEL = "\u0412\u044b\u0431\u0440\u0430\u0442\u044c\u2026";
    private boolean controlFocused;
    private int type;
    private int fitPolicy;
    private int contentWidth;
    private int contentHeight;
    private int checkboxFocused;
    private int checkboxPressed;
    private int checkedElementIndex;
    private int focusedElementIndex;
    private int elementsCount;
    private Element[] elements;
    private Command selectCommand;
    private List popupList;
    private Displayable sourceScreen;
    private Object lock;

    public ChoiceGroup(String label, int type) {
        this(0, label, null, null, type, new String[0], null);
    }

    public ChoiceGroup(String label, int type, String[] elements, Image[] icons) {
        this(0, label, null, null, type, elements, icons);
    }

    public ChoiceGroup(int layout, String label, Command[] commands, ItemCommandListener listener, int type, String[] elements, Image[] icons) {
        super(layout, -1, -1, label, type == 2 ? Displayable.concatCommands(SELECT, commands) : commands, elements == null || elements.length == 0 ? null : (type == 4 ? POPUP_COMMAND : List.CHECK_COMMAND), listener);
        if (type != 1 && type != 2 && type != 4) {
            throw new IllegalArgumentException("ChoiceGroup: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 type.");
        }
        if (elements == null) {
            throw new NullPointerException("ChoiceGroup: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 elements \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int len = elements.length;
        Object[] lines = new String[len];
        Array.copy((Object[])elements, (int)0, (Object[])lines, (int)0, (int)len);
        int i = len;
        while (i-- > 0) {
            if (lines[i] != null) continue;
            throw new NullPointerException("ChoiceGroup: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 elements \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0443\u043b\u0435\u0432\u044b\u0435 \u0441\u0441\u044b\u043b\u043a\u0438.");
        }
        if (icons != null && icons.length != len) {
            throw new IllegalArgumentException("ChoiceGroup: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 icons \u0438\u043c\u0435\u0435\u0442 \u0434\u043b\u0438\u043d\u0443, \u043e\u0442\u043b\u0438\u0447\u043d\u0443\u044e \u043e\u0442 \u0434\u043b\u0438\u043d\u044b \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 elements.");
        }
        Font font = Font.getFont(0, 0, 8);
        i = len;
        Element[] list = new Element[i];
        while (i-- > 0) {
            list[i] = new Element(type == 1 && i == 0, font, (String)lines[i], icons == null ? null : icons[i]);
        }
        Command[] popupCommands = new Command[]{BACK};
        this.type = type;
        this.fitPolicy = 0;
        this.checkboxFocused = -1;
        this.checkboxPressed = -1;
        this.checkedElementIndex = 0;
        this.focusedElementIndex = 0;
        this.elementsCount = len;
        this.elements = list;
        this.selectCommand = type != 4 ? List.CHECK_COMMAND : POPUP_COMMAND;
        this.popupList = type != 4 ? null : new List(false, POPUP_LABEL, null, popupCommands, List.SELECT_COMMAND, new PopupCommandHandler(this), 3, elements, icons);
        this.lock = new Object();
    }

    public void setFitPolicy(int policy) {
        if (policy != 0 && policy != 1 && policy != 2) {
            throw new IllegalArgumentException("ChoiceGroup.setFitPolicy: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 policy.");
        }
        this.fitPolicy = policy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedIndex(int elementIndex, boolean selected) {
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            if (elementIndex < 0 || elementIndex >= this.elementsCount) {
                error = true;
            } else {
                switch (this.type) {
                    case 1: {
                        int checked = this.checkedElementIndex;
                        if (elementIndex == checked) break;
                        this.checkedElementIndex = elementIndex;
                        Element[] list = this.elements;
                        Element elem = this.elements[elementIndex];
                        this.elements[elementIndex].selected = true;
                        Element prev = list[checked];
                        list[checked].selected = false;
                        if (!elem.visible && !prev.visible) break;
                        this.notifyPaint();
                        break;
                    }
                    case 2: {
                        Element elem = this.elements[elementIndex];
                        if (elem.selected == selected) break;
                        elem.selected = selected;
                        if (!elem.visible) break;
                        this.notifyPaint();
                        break;
                    }
                    case 4: {
                        if (elementIndex == this.focusedElementIndex) break;
                        this.focusedElementIndex = elementIndex;
                        this.notifyPaint();
                    }
                }
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("ChoiceGroup.setSelectedIndex: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedFlags(boolean[] selected) {
        if (selected == null) {
            throw new NullPointerException("ChoiceGroup.setSelectedFlags: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 selected \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            int len = this.elementsCount;
            if (selected.length < len) {
                error = true;
            } else {
                switch (this.type) {
                    case 1: {
                        int checked;
                        int elementIndex = -1;
                        int i = 0;
                        while (i < len) {
                            if (selected[i]) {
                                elementIndex = i;
                                break;
                            }
                            ++i;
                        }
                        if (elementIndex < 0 || elementIndex == (checked = this.checkedElementIndex)) break;
                        this.checkedElementIndex = elementIndex;
                        Element[] list = this.elements;
                        Element elem = this.elements[elementIndex];
                        this.elements[elementIndex].selected = true;
                        Element prev = list[checked];
                        list[checked].selected = false;
                        if (!elem.visible && !prev.visible) break;
                        this.notifyPaint();
                        break;
                    }
                    case 2: {
                        boolean needRepaint = false;
                        Element[] list = this.elements;
                        int i = len;
                        while (i-- > 0) {
                            Element elem = list[i];
                            boolean sel = selected[i];
                            if (elem.selected == sel) continue;
                            elem.selected = sel;
                            if (!elem.visible) continue;
                            needRepaint = true;
                        }
                        if (!needRepaint) break;
                        this.notifyPaint();
                        break;
                    }
                    case 4: {
                        int elementIndex = -1;
                        int i = 0;
                        while (i < len) {
                            if (selected[i]) {
                                elementIndex = i;
                                break;
                            }
                            ++i;
                        }
                        if (elementIndex < 0 || elementIndex == this.focusedElementIndex) break;
                        this.focusedElementIndex = elementIndex;
                        this.notifyPaint();
                    }
                }
            }
        }
        if (error) {
            throw new IllegalArgumentException("ChoiceGroup.setSelectedFlags: \u0434\u043b\u0438\u043d\u0430 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 selected \u043c\u0435\u043d\u044c\u0448\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0430 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0441\u043f\u0438\u0441\u043a\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFont(int elementIndex, Font font) {
        Font f = font != null ? font : Font.getFont(0, 0, 8);
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            if (elementIndex < 0 || elementIndex >= this.elementsCount) {
                error = true;
            } else {
                Element elem = this.elements[elementIndex];
                if (f != elem.font) {
                    elem.font = f;
                    this.correctTruncated(elem);
                    if (this.type == 4) {
                        this.popupList.setFont(elementIndex, font);
                    }
                    this.notifyUpdate();
                }
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("ChoiceGroup.setFont: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(int elementIndex, String text, Image icon) {
        if (text == null) {
            throw new NullPointerException("ChoiceGroup.set: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 text \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            if (elementIndex < 0 || elementIndex >= this.elementsCount) {
                error = true;
            } else {
                Element elem = this.elements[elementIndex];
                this.elements[elementIndex].text = text;
                elem.icon = icon;
                this.correctTruncated(elem);
                if (this.type == 4) {
                    this.popupList.set(elementIndex, text, icon);
                }
                this.notifyUpdate();
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("ChoiceGroup.set: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(int elementIndex, String text, Image icon) {
        if (text == null) {
            throw new NullPointerException("ChoiceGroup.insert: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 text \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            int len;
            if (elementIndex < 0 || elementIndex > (len = this.elementsCount)) {
                error = true;
            } else {
                int t;
                int i;
                Object[] list = this.elements;
                if (len == this.elements.length) {
                    Object[] objectArray = list;
                    this.elements = new Element[(len << 1) + 1];
                    list = this.elements;
                    Array.copy((Object[])objectArray, (int)0, (Object[])this.elements, (int)0, (int)len);
                }
                if ((i = len - elementIndex) > 0) {
                    Array.copy((Object[])list, (int)elementIndex, (Object[])list, (int)(elementIndex + 1), (int)i);
                }
                list[elementIndex] = new Element((t = this.type) == 1 && len == 0, Font.getFont(0, 0, 8), text, icon);
                this.elementsCount = ++len;
                this.checkboxPressed = -1;
                this.checkboxFocused = -1;
                if (len > 1) {
                    i = this.checkedElementIndex;
                    if (i >= elementIndex) {
                        this.checkedElementIndex = i + 1;
                    }
                    if ((i = this.focusedElementIndex) >= elementIndex) {
                        this.focusedElementIndex = i + 1;
                    }
                } else {
                    super.setDefaultCommand(this.selectCommand);
                }
                if (t == 4) {
                    this.popupList.insert(elementIndex, text, icon);
                }
                this.notifyUpdate();
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("ChoiceGroup.insert: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(int elementIndex) {
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            int len;
            if (elementIndex < 0 || elementIndex >= (len = this.elementsCount)) {
                error = true;
            } else {
                Object[] list = this.elements;
                int i = len - elementIndex - 1;
                if (i > 0) {
                    Array.copy((Object[])list, (int)(elementIndex + 1), (Object[])list, (int)elementIndex, (int)i);
                }
                list[--len] = null;
                this.elementsCount = len;
                this.checkboxPressed = -1;
                this.checkboxFocused = -1;
                int t = this.type;
                if (len > 0) {
                    i = this.checkedElementIndex;
                    if (i > elementIndex) {
                        this.checkedElementIndex = i - 1;
                    } else if (i == elementIndex) {
                        i = i == len ? i - 1 : i;
                        this.checkedElementIndex = i;
                        if (t == 1) {
                            ((ChoiceElement)list[i]).selected = true;
                        }
                    }
                    i = this.focusedElementIndex;
                    if (i == elementIndex && i == len || i > elementIndex) {
                        this.focusedElementIndex = i - 1;
                    }
                } else {
                    super.removeCommand(this.selectCommand);
                }
                if (t == 4) {
                    this.popupList.delete(elementIndex);
                }
                this.notifyUpdate();
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("ChoiceGroup.delete: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() {
        Object object = this.lock;
        synchronized (object) {
            int len = this.elementsCount;
            if (len > 0) {
                Element[] list = this.elements;
                int i = len;
                while (i-- > 0) {
                    list[i] = null;
                }
                this.elementsCount = 0;
                this.checkboxPressed = -1;
                this.checkboxFocused = -1;
                this.checkedElementIndex = 0;
                this.focusedElementIndex = 0;
                super.removeCommand(this.selectCommand);
                if (this.type == 4) {
                    this.popupList.deleteAll();
                }
                this.notifyUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSelected(int elementIndex) {
        boolean result = false;
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            if (elementIndex < 0 || elementIndex >= this.elementsCount) {
                error = true;
            } else {
                switch (this.type) {
                    case 1: {
                        result = this.checkedElementIndex == elementIndex;
                        break;
                    }
                    case 2: {
                        result = this.elements[elementIndex].selected;
                        break;
                    }
                    case 4: {
                        result = this.focusedElementIndex == elementIndex;
                    }
                }
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("ChoiceGroup.isSelected: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int append(String text, Image icon) {
        int result;
        if (text == null) {
            throw new NullPointerException("ChoiceGroup.append: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 text \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Object object = this.lock;
        synchronized (object) {
            int len = this.elementsCount;
            Object[] list = this.elements;
            if (len == this.elements.length) {
                Object[] objectArray = list;
                this.elements = new Element[(len << 1) + 1];
                list = this.elements;
                Array.copy((Object[])objectArray, (int)0, (Object[])this.elements, (int)0, (int)len);
            }
            result = len;
            int t = this.type;
            list[result] = new Element(t == 1 && len == 0, Font.getFont(0, 0, 8), text, icon);
            this.elementsCount = ++len;
            this.checkboxPressed = -1;
            this.checkboxFocused = -1;
            if (len == 1) {
                super.setDefaultCommand(this.selectCommand);
            }
            if (t == 4) {
                this.popupList.append(text, icon);
            }
            this.notifyUpdate();
        }
        return result;
    }

    public int size() {
        return this.elementsCount;
    }

    public int getFitPolicy() {
        return this.fitPolicy;
    }

    public int getSelectedIndex() {
        if (this.elementsCount == 0) {
            return -1;
        }
        switch (this.type) {
            default: {
                return -1;
            }
            case 1: {
                return this.checkedElementIndex;
            }
            case 4: 
        }
        return this.focusedElementIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSelectedFlags(boolean[] selected) {
        if (selected == null) {
            throw new NullPointerException("ChoiceGroup.getSelectedFlags: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 selected \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int result = 0;
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            int len = this.elementsCount;
            if (selected.length < len) {
                error = true;
            } else {
                switch (this.type) {
                    case 1: {
                        result = len > 0 ? 1 : 0;
                        int f = this.checkedElementIndex;
                        int i = len;
                        while (i-- > 0) {
                            boolean bl = selected[i] = i == f;
                        }
                        break;
                    }
                    case 2: {
                        result = 0;
                        Element[] list = this.elements;
                        int i = len;
                        while (i-- > 0) {
                            selected[i] = list[i].selected;
                            if (!selected[i]) continue;
                            ++result;
                        }
                        break;
                    }
                    case 4: {
                        result = len > 0 ? 1 : 0;
                        int f = this.focusedElementIndex;
                        int i = len;
                        while (i-- > 0) {
                            boolean bl = selected[i] = i == f;
                        }
                        break;
                    }
                }
            }
        }
        if (error) {
            throw new IllegalArgumentException("ChoiceGroup.getSelectedFlags: \u0434\u043b\u0438\u043d\u0430 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 selected \u043c\u0435\u043d\u044c\u0448\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0430 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0441\u043f\u0438\u0441\u043a\u0430.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Font getFont(int elementIndex) {
        Font result;
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            if (elementIndex < 0 || elementIndex >= this.elementsCount) {
                error = true;
                result = null;
            } else {
                result = this.elements[elementIndex].font;
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("ChoiceGroup.getFont: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(int elementIndex) {
        Image result;
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            if (elementIndex < 0 || elementIndex >= this.elementsCount) {
                error = true;
                result = null;
            } else {
                result = this.elements[elementIndex].icon;
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("ChoiceGroup.getImage: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(int elementIndex) {
        String result;
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            if (elementIndex < 0 || elementIndex >= this.elementsCount) {
                error = true;
                result = null;
            } else {
                result = this.elements[elementIndex].text;
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("ChoiceGroup.getString: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paintContent(Graphics render, int contentWidth, int contentHeight) {
        Object object = this.lock;
        synchronized (object) {
            boolean cfocused = this.controlFocused;
            int pressed = this.checkboxPressed;
            int focused = this.focusedElementIndex;
            int len = this.elementsCount;
            Element[] list = this.elements;
            int t = this.type;
            if (t == 4) {
                if (len > 0) {
                    int leftMarginText;
                    int i = cfocused ? (pressed >= 0 ? 1 : 3) : 0;
                    render.setColor(RasterCanvas.getSystemColor((int)(i + 36)));
                    render.drawElementOfGUI(4, i, 0, 0, 0, contentWidth, contentHeight);
                    i = i == 1 ? 1 : 0;
                    Element elem = list[focused];
                    Image icon = elem.icon;
                    if (icon == null) {
                        leftMarginText = 3;
                    } else {
                        leftMarginText = 30;
                        render.drawStretchRegion(icon, 0, 0, icon.getWidth(), icon.getHeight(), 0, i + 3, i + (contentHeight - 24 >> 1), 24, 24, 0);
                    }
                    Font font = elem.font;
                    render.setFont(font);
                    render.drawString(elem.truncated, i + leftMarginText, i + (contentHeight - font.getHeight() >> 1), 0);
                    int s = List.CHECKBOX_WIDTH > 7 ? 7 : (List.CHECKBOX_WIDTH - 1 & 1) + 1;
                    int x = i + contentWidth - s - 3;
                    int y = i + (contentHeight - s >> 1) + 2;
                    i = s;
                    while (i-- > 0) {
                        render.drawLine(x, y, x + s - 1, y);
                        if ((i & 1) == 0) {
                            ++x;
                            s -= 2;
                        }
                        ++y;
                    }
                }
            } else {
                int top = render.getClipY();
                int bottom = top + render.getClipHeight();
                int leftMarginCheckbox = 3;
                int leftMarginIcon = 3 + List.CHECKBOX_WIDTH + 3;
                int leftMarginText = leftMarginIcon + 27;
                int topMarginElement = 0;
                int i = 0;
                while (i < len) {
                    Element elem = list[i];
                    int elementHeight = elem.getHeight();
                    elem.top = topMarginElement;
                    elem.bottom = topMarginElement + elementHeight;
                    elem.visible = topMarginElement < bottom && topMarginElement + elementHeight > top;
                    if (elem.visible) {
                        if (cfocused && i == focused) {
                            render.drawElementOfGUI(1, 0, 0, 0, 0, contentWidth, elementHeight);
                        }
                        int topMarginCheckbox = elementHeight - List.CHECKBOX_HEIGHT >> 1;
                        switch (t) {
                            case 1: {
                                render.drawElementOfGUI(12, elem.selected ? 1 : 0, i == pressed ? 1 : 0, leftMarginCheckbox, topMarginCheckbox, List.CHECKBOX_WIDTH, List.CHECKBOX_HEIGHT);
                                break;
                            }
                            case 2: {
                                render.drawElementOfGUI(15, elem.selected ? 1 : 0, i == pressed ? 1 : 0, leftMarginCheckbox, topMarginCheckbox, List.CHECKBOX_WIDTH, List.CHECKBOX_HEIGHT);
                            }
                        }
                        Image icon = elem.icon;
                        if (icon != null) {
                            render.drawStretchRegion(icon, 0, 0, icon.getWidth(), icon.getHeight(), 0, leftMarginIcon, elementHeight - 24 >> 1, 24, 24, 0);
                        }
                        Font font = elem.font;
                        render.setFont(font);
                        render.drawString(elem.truncated, icon != null ? leftMarginText : leftMarginIcon, elementHeight - font.getHeight() >> 1, 0);
                    }
                    render.translate(0, elementHeight);
                    topMarginElement += elementHeight;
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onSizeChanged(int contentWidth, int contentHeight) {
        this.contentWidth = contentWidth;
        this.contentHeight = contentHeight;
        Object object = this.lock;
        synchronized (object) {
            Element[] list = this.elements;
            int i = this.elementsCount;
            while (i-- > 0) {
                this.correctTruncated(list[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onKeyPressed(int key, int charCode) {
        MIDletProxy proxy = MIDletProxy.getInstance();
        if (key == proxy.getKeyUsedAs(35)) {
            Object object = this.lock;
            synchronized (object) {
                int i = this.focusedElementIndex;
                if (i >= 0 && i < this.elementsCount) {
                    ChoiceElementDetailsScreen.show(proxy.getEmulatorScreen(), super.getLabel(), this.elements[i], this.getOwner());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onContentPointerPressed(int x, int y, int button) {
        Object object = this.lock;
        synchronized (object) {
            int i;
            if (button == 0 && (i = this.getElementIndex(x, y)) >= 0) {
                if (this.type == 4 || x < List.CHECKBOX_WIDTH + 6) {
                    this.checkboxFocused = i;
                    this.checkboxPressed = i;
                }
                this.focusedElementIndex = i;
                this.notifyPaint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onContentPointerDragged(int x, int y) {
        Object object = this.lock;
        synchronized (object) {
            int f = this.checkboxFocused;
            if (f >= 0) {
                this.checkboxPressed = f == (this.type == 4 || x < List.CHECKBOX_WIDTH + 6 ? this.getElementIndex(x, y) : -1) ? f : -1;
                if (this.checkboxPressed != this.checkboxPressed) {
                    this.notifyPaint();
                }
            } else {
                int i = this.getElementIndex(x, y);
                if (i >= 0) {
                    this.focusedElementIndex = i;
                    this.notifyPaint();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onContentPointerReleased(int x, int y, int button) {
        Object object = this.lock;
        synchronized (object) {
            if (button == 0) {
                int f = this.checkboxPressed;
                this.checkboxFocused = -1;
                this.checkboxPressed = -1;
                if (f >= 0 && f < this.elementsCount) {
                    switch (this.type) {
                        case 1: {
                            Element[] list = this.elements;
                            int i = this.checkedElementIndex;
                            this.elements[this.checkedElementIndex].selected = false;
                            this.checkedElementIndex = f;
                            list[f].selected = true;
                            this.notifyPaint();
                            if (i == f) break;
                            super.notifyStateChanged();
                            break;
                        }
                        case 2: {
                            Element elem = this.elements[f];
                            this.elements[f].selected = !elem.selected;
                            this.notifyPaint();
                            super.notifyStateChanged();
                            break;
                        }
                        case 4: {
                            this.showPopupList();
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCommandAction(Command command) {
        if (command == SELECT[0]) {
            Object object = this.lock;
            synchronized (object) {
                boolean need = false;
                Element[] list = this.elements;
                int i = this.elementsCount;
                while (i-- > 0) {
                    Element elem = list[i];
                    if (elem.selected) continue;
                    need = true;
                    elem.selected = true;
                }
                if (need) {
                    this.notifyPaint();
                    super.notifyStateChanged();
                }
            }
            return;
        }
        if (command == SELECT[1]) {
            Object object = this.lock;
            synchronized (object) {
                boolean need = false;
                Element[] list = this.elements;
                int i = this.elementsCount;
                while (i-- > 0) {
                    Element elem = list[i];
                    if (!elem.selected) continue;
                    need = true;
                    elem.selected = false;
                }
                if (need) {
                    this.notifyPaint();
                    super.notifyStateChanged();
                }
            }
            return;
        }
        if (command == SELECT[2]) {
            Object object = this.lock;
            synchronized (object) {
                boolean need = false;
                Element[] list = this.elements;
                int i = this.elementsCount;
                while (i-- > 0) {
                    need = true;
                    Element elem = list[i];
                    boolean bl = list[i].selected = !elem.selected;
                }
                if (need) {
                    this.notifyPaint();
                    super.notifyStateChanged();
                }
            }
            return;
        }
        if (command == POPUP_COMMAND) {
            Object object = this.lock;
            synchronized (object) {
                this.showPopupList();
            }
            return;
        }
        if (command == List.CHECK_COMMAND) {
            Object object = this.lock;
            synchronized (object) {
                int f = this.focusedElementIndex;
                if (f >= 0 && f < this.elementsCount) {
                    switch (this.type) {
                        case 1: {
                            Element[] list = this.elements;
                            int i = this.checkedElementIndex;
                            this.elements[this.checkedElementIndex].selected = false;
                            this.checkedElementIndex = f;
                            list[f].selected = true;
                            this.notifyPaint();
                            if (i == f) break;
                            super.notifyStateChanged();
                            break;
                        }
                        case 2: {
                            Element elem = this.elements[f];
                            this.elements[f].selected = !elem.selected;
                            this.notifyPaint();
                            super.notifyStateChanged();
                        }
                    }
                }
            }
            return;
        }
        super.onCommandAction(command);
    }

    void onTraverseOut() {
        this.controlFocused = false;
        this.notifyPaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean onTraverseNeedStayOn(int direction, int viewportWidth, int viewportHeight, int[] visibleRectangle) {
        boolean cfocused = this.controlFocused;
        this.controlFocused = true;
        if (!cfocused) {
            this.notifyPaint();
        }
        if (this.checkboxFocused >= 0) {
            return true;
        }
        switch (direction) {
            case 2: 
            case 5: {
                if (this.type == 4) {
                    return !cfocused;
                }
                int labelHeight = super.getPreferredHeight() - this.contentHeight;
                if (!cfocused) {
                    Object object = this.lock;
                    synchronized (object) {
                        int elt;
                        int tmp;
                        int vrt;
                        int focused = this.focusedElementIndex;
                        int vrh = visibleRectangle[3];
                        Element elem = this.elements[focused];
                        int elh = elem.getHeight();
                        if (vrh < elh) {
                            visibleRectangle[3] = vrh = elh;
                        }
                        if ((vrt = visibleRectangle[1]) > (tmp = labelHeight + (elt = elem.top))) {
                            visibleRectangle[1] = tmp;
                        } else {
                            tmp = labelHeight + elt + elh - vrh;
                            if (vrt < tmp) {
                                visibleRectangle[1] = tmp;
                            }
                        }
                        this.notifyPaint();
                    }
                    return true;
                }
                return false;
            }
            case 1: {
                boolean result;
                if (this.type == 4) {
                    return !cfocused;
                }
                int labelHeight = super.getPreferredHeight() - this.contentHeight;
                Object object = this.lock;
                synchronized (object) {
                    int focused;
                    boolean bl = cfocused ? (focused = this.focusedElementIndex) > 0 : (result = (focused = this.elementsCount) > 0);
                    if (bl) {
                        this.focusedElementIndex = --focused;
                        int vrt = visibleRectangle[1];
                        Element elem = this.elements[focused];
                        int tmp = labelHeight + elem.top;
                        if (vrt > tmp) {
                            visibleRectangle[1] = tmp;
                        } else {
                            tmp = labelHeight + elem.bottom - visibleRectangle[3];
                            if (vrt < tmp) {
                                visibleRectangle[1] = tmp;
                            }
                        }
                        this.notifyPaint();
                    }
                }
                return result;
            }
            case 6: {
                boolean result;
                if (this.type == 4) {
                    return !cfocused;
                }
                int labelHeight = super.getPreferredHeight() - this.contentHeight;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    int focused;
                    if (cfocused) {
                        focused = this.focusedElementIndex;
                        bl = focused < this.elementsCount - 1;
                    } else {
                        focused = -1;
                        bl = result = this.elementsCount > -1 + 1;
                    }
                    if (bl) {
                        this.focusedElementIndex = ++focused;
                        int vrt = visibleRectangle[1];
                        Element elem = this.elements[focused];
                        int tmp = labelHeight + elem.top;
                        if (vrt > tmp) {
                            visibleRectangle[1] = tmp;
                        } else {
                            tmp = labelHeight + elem.bottom - visibleRectangle[3];
                            if (vrt < tmp) {
                                visibleRectangle[1] = tmp;
                            }
                        }
                        this.notifyPaint();
                    }
                }
                return result;
            }
        }
        return true;
    }

    boolean keyHandling(int key) {
        return key == MIDletProxy.getInstance().getKeyUsedAs(35);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getPreferredContentWidth(int contentHeight, int containerClientWidth) {
        int result = 0;
        Object object = this.lock;
        synchronized (object) {
            Element[] list = this.elements;
            int i = this.elementsCount;
            while (i-- > 0) {
                int tmp = list[i].getWidth();
                if (result >= tmp) continue;
                result = tmp;
            }
        }
        return result < containerClientWidth ? result : containerClientWidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getPreferredContentHeight(int contentWidth) {
        int result = 0;
        Object object = this.lock;
        synchronized (object) {
            if (this.type == 4) {
                Element[] list = this.elements;
                int i = this.elementsCount;
                while (i-- > 0) {
                    int tmp = list[i].getHeight();
                    if (result >= tmp) continue;
                    result = tmp;
                }
            } else {
                Element[] list = this.elements;
                int i = this.elementsCount;
                while (i-- > 0) {
                    result += list[i].getHeight();
                }
            }
        }
        return result;
    }

    private void showPopupList() {
        List screen = this.popupList;
        if (screen != null && (this.sourceScreen = this.getOwner()) != null) {
            int i = this.focusedElementIndex;
            if (i >= 0 && i < screen.size()) {
                screen.setSelectedIndex(i, true);
            }
            MIDletProxy.getInstance().getEmulatorScreen().setCurrent(screen);
        }
    }

    private void showSourceScreen() {
        Display display = MIDletProxy.getInstance().getEmulatorScreen();
        Displayable next = this.sourceScreen;
        if (next.isSystem()) {
            display.setCurrent(next);
        } else {
            display.hideSystemScreen();
        }
        this.sourceScreen = null;
    }

    private void invokeNotifyStateChanged() {
        super.notifyStateChanged();
    }

    private void correctTruncated(Element elem) {
        int t = this.type;
        elem.truncated = Displayable.truncate(elem.text, elem.font, this.contentWidth - (t != 4 ? List.CHECKBOX_WIDTH + 3 : 0) - (elem.icon != null ? 27 : 0) - (t == 4 ? 16 : 6));
    }

    private int getElementIndex(int x, int y) {
        if (x < 0 || x >= this.contentWidth || y < 0 || y >= this.contentHeight) {
            return -1;
        }
        if (this.type == 4) {
            return this.focusedElementIndex;
        }
        int a = 0;
        int b = this.elementsCount - 1;
        Element[] list = this.elements;
        while (a <= b) {
            int c = a + b >> 1;
            Element elem = list[c];
            if (y < elem.top) {
                b = c - 1;
                continue;
            }
            if (y >= elem.bottom) {
                a = c + 1;
                continue;
            }
            return c;
        }
        return -1;
    }

    private static final class Element
    extends ChoiceElement {
        public boolean visible;
        public int top;
        public int bottom;
        public String truncated;

        Element(boolean selected, Font font, String text, Image icon) {
            super(selected, font, text, icon);
        }

        public int getWidth() {
            return List.CHECKBOX_WIDTH + this.font.stringWidth(this.text) + (this.icon != null ? 36 : 9);
        }

        public int getHeight() {
            return Math.max(this.icon != null ? 24 : 0, Math.max(this.font.getHeight(), List.CHECKBOX_HEIGHT)) + 6;
        }
    }

    private static final class PopupCommandHandler
    extends WeakReference
    implements CommandListener {
        PopupCommandHandler(ChoiceGroup thisItem) {
            super(thisItem);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commandAction(Command command, Displayable screen) {
            List list;
            ChoiceGroup thisItem = (ChoiceGroup)this.get();
            if (thisItem == null || screen != (list = thisItem.popupList)) {
                return;
            }
            if (command == List.SELECT_COMMAND) {
                Object object = thisItem.lock;
                synchronized (object) {
                    int i = thisItem.focusedElementIndex;
                    int n = Math.max(list.getSelectedIndex(), 0);
                    thisItem.focusedElementIndex = n;
                    int f = n;
                    thisItem.showSourceScreen();
                    if (i != f) {
                        thisItem.invokeNotifyStateChanged();
                    }
                }
                return;
            }
            if (command == BACK) {
                Object object = thisItem.lock;
                synchronized (object) {
                    thisItem.showSourceScreen();
                }
            }
        }
    }
}

