/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;
import malik.emulator.media.graphics.GraphicBuffer;
import malik.emulator.media.graphics.RasterCanvas;
import malik.emulator.media.text.RasterFont;

public class Graphics {
    public static final int HCENTER = 1;
    public static final int VCENTER = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int TOP = 16;
    public static final int BOTTOM = 32;
    public static final int BASELINE = 64;
    public static final int SOLID = 0;
    public static final int DOTTED = 1;
    private int translateX;
    private int translateY;
    private int clipLeft;
    private int clipTop;
    private int clipWidth;
    private int clipHeight;
    private int color;
    private int stroke;
    private Object[] extensions;
    private Object lock;
    private Font font;
    private RasterCanvas canvas;

    static int spriteTransformToMalik(int transform) {
        switch (transform) {
            default: {
                return -1;
            }
            case 0: {
                return 0;
            }
            case 5: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 6: {
                return 3;
            }
            case 2: {
                return 4;
            }
            case 7: {
                return 5;
            }
            case 1: {
                return 6;
            }
            case 4: 
        }
        return 7;
    }

    Graphics(GraphicBuffer buffer) {
        this.clipWidth = buffer.getWidth();
        this.clipHeight = buffer.getHeight();
        this.lock = new Object();
        this.font = Font.getDefaultFont();
        this.canvas = new RasterCanvas(buffer);
    }

    Graphics(RasterCanvas canvas) {
        this.clipWidth = canvas.getWidth();
        this.clipHeight = canvas.getHeight();
        this.lock = new Object();
        this.font = Font.getDefaultFont();
        this.canvas = canvas;
    }

    public void copyArea(int left, int top, int width, int height, int x, int y, int anchor) {
        int ty;
        RasterCanvas canvas = this.canvas;
        if (canvas.isOpaque()) {
            throw new IllegalStateException("Graphics.copyArea: \u044d\u0442\u0430 \u0440\u0430\u0441\u0442\u0440\u043e\u0432\u0430\u044f \u043a\u0430\u043d\u0432\u0430 \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u0442 \u044d\u043a\u0440\u0430\u043d \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430, \u043f\u043e\u044d\u0442\u043e\u043c\u0443 \u0435\u0451 \u043f\u0438\u043a\u0441\u0435\u043b\u044b \u0447\u0438\u0442\u0430\u0442\u044c \u043d\u0435\u043b\u044c\u0437\u044f.");
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        int tx = this.translateX;
        int lim = (left += tx) + width;
        int len = canvas.getWidth();
        if (lim > len || lim < left || left > len || left < 0 || (lim = (top += (ty = this.translateY)) + height) > (len = canvas.getHeight()) || lim < top || top > len || top < 0) {
            throw new IllegalArgumentException("Graphics.copyArea: \u0437\u0430\u0434\u0430\u043d\u043d\u0430\u044f \u043f\u0440\u044f\u043c\u043e\u0443\u0433\u043e\u043b\u044c\u043d\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u044b \u0440\u0430\u0441\u0442\u0440\u043e\u0432\u043e\u0439 \u043a\u0430\u043d\u0432\u044b.");
        }
        switch (anchor) {
            default: {
                throw new IllegalArgumentException("Graphics.copyArea: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 anchor.");
            }
            case 0: 
            case 20: {
                break;
            }
            case 6: {
                y -= height / 2;
                break;
            }
            case 36: {
                y -= height;
                break;
            }
            case 17: {
                x -= width / 2;
                break;
            }
            case 3: {
                x -= width / 2;
                y -= height / 2;
                break;
            }
            case 33: {
                x -= width / 2;
                y -= height;
                break;
            }
            case 24: {
                x -= width;
                break;
            }
            case 10: {
                x -= width;
                y -= height / 2;
                break;
            }
            case 40: {
                x -= width;
                y -= height;
            }
        }
        canvas.copyArea(this.clipLeft, this.clipTop, this.clipWidth, this.clipHeight, left, top, width, height, x + tx, y + ty);
    }

    public void drawImage(Image src, int x, int y, int anchor) {
        if (src == null) {
            throw new NullPointerException("Graphics.drawImage: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        GraphicBuffer buffer = src.getBuffer();
        int width = buffer.getWidth();
        int height = buffer.getHeight();
        switch (anchor) {
            default: {
                throw new IllegalArgumentException("Graphics.drawImage: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 anchor.");
            }
            case 0: 
            case 20: {
                break;
            }
            case 6: {
                y -= height / 2;
                break;
            }
            case 36: {
                y -= height;
                break;
            }
            case 17: {
                x -= width / 2;
                break;
            }
            case 3: {
                x -= width / 2;
                y -= height / 2;
                break;
            }
            case 33: {
                x -= width / 2;
                y -= height;
                break;
            }
            case 24: {
                x -= width;
                break;
            }
            case 10: {
                x -= width;
                y -= height / 2;
                break;
            }
            case 40: {
                x -= width;
                y -= height;
            }
        }
        this.canvas.drawPixelsArea(this.clipLeft, this.clipTop, this.clipWidth, this.clipHeight, buffer, 0, 0, width, height, 0, x + this.translateX, y + this.translateY, width, height, true);
    }

    public void drawRegion(Image src, int left, int top, int width, int height, int transform, int x, int y, int anchor) {
        int dstHeight;
        int dstWidth;
        RasterCanvas canvas;
        if (src == null) {
            throw new NullPointerException("Graphics.drawRegion: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        GraphicBuffer buffer = src.getBuffer();
        if (buffer == (canvas = this.canvas).getBuffer()) {
            throw new IllegalArgumentException("Graphics.drawRegion: \u043d\u0435\u043b\u044c\u0437\u044f \u0440\u0438\u0441\u043e\u0432\u0430\u0442\u044c \u0440\u0435\u0433\u0438\u043e\u043d \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f \u043d\u0430 \u044d\u0442\u043e\u043c \u0436\u0435 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0438.");
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        int lim = left + width;
        int len = buffer.getWidth();
        if (lim > len || lim < left || left > len || left < 0 || (lim = top + height) > (len = buffer.getHeight()) || lim < top || top > len || top < 0) {
            throw new IllegalArgumentException("Graphics.drawRegion: \u0437\u0430\u0434\u0430\u043d\u043d\u0430\u044f \u043f\u0440\u044f\u043c\u043e\u0443\u0433\u043e\u043b\u044c\u043d\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u044b \u0440\u0430\u0441\u0442\u0440\u043e\u0432\u043e\u0439 \u043a\u0430\u043d\u0432\u044b.");
        }
        if ((transform = Graphics.spriteTransformToMalik(transform)) < 0) {
            throw new IllegalArgumentException("Graphics.drawRegion: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 transform.");
        }
        if ((transform & 1) == 0) {
            dstWidth = width;
            dstHeight = height;
        } else {
            dstWidth = height;
            dstHeight = width;
        }
        switch (anchor) {
            default: {
                throw new IllegalArgumentException("Graphics.drawRegion: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 anchor.");
            }
            case 0: 
            case 20: {
                break;
            }
            case 6: {
                y -= dstHeight / 2;
                break;
            }
            case 36: {
                y -= dstHeight;
                break;
            }
            case 17: {
                x -= dstWidth / 2;
                break;
            }
            case 3: {
                x -= dstWidth / 2;
                y -= dstHeight / 2;
                break;
            }
            case 33: {
                x -= dstWidth / 2;
                y -= dstHeight;
                break;
            }
            case 24: {
                x -= dstWidth;
                break;
            }
            case 10: {
                x -= dstWidth;
                y -= dstHeight / 2;
                break;
            }
            case 40: {
                x -= dstWidth;
                y -= dstHeight;
            }
        }
        canvas.drawPixelsArea(this.clipLeft, this.clipTop, this.clipWidth, this.clipHeight, buffer, left, top, width, height, transform, x + this.translateX, y + this.translateY, dstWidth, dstHeight, true);
    }

    public void drawStretchRegion(Image src, int left, int top, int width, int height, int transform, int x, int y, int dstWidth, int dstHeight, int anchor) {
        RasterCanvas canvas;
        if (src == null) {
            throw new NullPointerException("Graphics.drawStretchRegion: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        GraphicBuffer buffer = src.getBuffer();
        if (buffer == (canvas = this.canvas).getBuffer()) {
            throw new IllegalArgumentException("Graphics.drawStretchRegion: \u043d\u0435\u043b\u044c\u0437\u044f \u0440\u0438\u0441\u043e\u0432\u0430\u0442\u044c \u0440\u0435\u0433\u0438\u043e\u043d \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f \u043d\u0430 \u044d\u0442\u043e\u043c \u0436\u0435 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0438.");
        }
        if (width <= 0 || height <= 0 || dstWidth <= 0 || dstHeight <= 0) {
            return;
        }
        int lim = left + width;
        int len = buffer.getWidth();
        if (lim > len || lim < left || left > len || left < 0 || (lim = top + height) > (len = buffer.getHeight()) || lim < top || top > len || top < 0) {
            throw new IllegalArgumentException("Graphics.drawStretchRegion: \u0437\u0430\u0434\u0430\u043d\u043d\u0430\u044f \u043f\u0440\u044f\u043c\u043e\u0443\u0433\u043e\u043b\u044c\u043d\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u044b \u0440\u0430\u0441\u0442\u0440\u043e\u0432\u043e\u0439 \u043a\u0430\u043d\u0432\u044b.");
        }
        if ((transform = Graphics.spriteTransformToMalik(transform)) < 0) {
            throw new IllegalArgumentException("Graphics.drawStretchRegion: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 transform.");
        }
        switch (anchor) {
            default: {
                throw new IllegalArgumentException("Graphics.drawStretchRegion: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 anchor.");
            }
            case 0: 
            case 20: {
                break;
            }
            case 6: {
                y -= dstHeight / 2;
                break;
            }
            case 36: {
                y -= dstHeight;
                break;
            }
            case 17: {
                x -= dstWidth / 2;
                break;
            }
            case 3: {
                x -= dstWidth / 2;
                y -= dstHeight / 2;
                break;
            }
            case 33: {
                x -= dstWidth / 2;
                y -= dstHeight;
                break;
            }
            case 24: {
                x -= dstWidth;
                break;
            }
            case 10: {
                x -= dstWidth;
                y -= dstHeight / 2;
                break;
            }
            case 40: {
                x -= dstWidth;
                y -= dstHeight;
            }
        }
        canvas.drawPixelsArea(this.clipLeft, this.clipTop, this.clipWidth, this.clipHeight, buffer, left, top, width, height, transform, x + this.translateX, y + this.translateY, dstWidth, dstHeight, true);
    }

    public void drawRGB(int[] src, int offset, int scanlength, int left, int top, int width, int height, boolean alpha) {
        int length;
        int i;
        if (src == null) {
            throw new NullPointerException("Graphics.drawRGB: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        if (scanlength >= 0) {
            i = 0;
            length = width + (height - 1) * scanlength;
        } else {
            i = -scanlength * (height - 1);
            length = width + i;
        }
        int lim = (offset -= i) + length;
        int len = src.length;
        if (lim > len || lim < offset || offset > len || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Graphics.drawRGB: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        this.canvas.drawPixelsArea(this.clipLeft, this.clipTop, this.clipWidth, this.clipHeight, src, offset += i, scanlength, width, height, 0, left + this.translateX, top + this.translateY, width, height, alpha);
    }

    public void drawElementOfGUI(int type, int subtype, int state, int left, int top, int width, int height) {
        if (width <= 0 || height <= 0) {
            return;
        }
        this.canvas.drawElementOfGUI(this.clipLeft, this.clipTop, this.clipWidth, this.clipHeight, type, subtype, state, left + this.translateX, top + this.translateY, width, height);
    }

    public void drawCharacter(int charCode, int x, int y, int anchor) {
        Font font = this.font;
        RasterFont rfont = font.getReference();
        switch (anchor) {
            default: {
                throw new IllegalArgumentException("Graphics.drawCharacter: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 anchor.");
            }
            case 0: 
            case 20: {
                y += rfont.getBaselinePosition();
                break;
            }
            case 68: {
                break;
            }
            case 36: {
                y -= rfont.getBaselineHeight();
                break;
            }
            case 17: {
                x -= rfont.charWidth(charCode) / 2;
                y += rfont.getBaselinePosition();
                break;
            }
            case 65: {
                x -= rfont.charWidth(charCode) / 2;
                break;
            }
            case 33: {
                x -= rfont.charWidth(charCode) / 2;
                y -= rfont.getBaselineHeight();
                break;
            }
            case 24: {
                x -= rfont.charWidth(charCode);
                y += rfont.getBaselinePosition();
                break;
            }
            case 72: {
                x -= rfont.charWidth(charCode);
                break;
            }
            case 40: {
                x -= rfont.charWidth(charCode);
                y -= rfont.getBaselineHeight();
            }
        }
        this.canvas.drawCharacter(this.clipLeft, this.clipTop, this.clipWidth, this.clipHeight, charCode, x + this.translateX, y + this.translateY, this.color, rfont, font.isUnderlined(), false, false);
    }

    public void drawCharacters(int[] src, int offset, int length, int x, int y, int anchor) {
        if (src == null) {
            throw new NullPointerException("Graphics.drawCharacters: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = offset + length;
        int len = src.length;
        if (lim > len || lim < offset || offset > len || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Graphics.drawCharacters: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        Font font = this.font;
        RasterFont rfont = font.getReference();
        switch (anchor) {
            default: {
                throw new IllegalArgumentException("Graphics.drawCharacters: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 anchor.");
            }
            case 0: 
            case 20: {
                y += rfont.getBaselinePosition();
                break;
            }
            case 68: {
                break;
            }
            case 36: {
                y -= rfont.getBaselineHeight();
                break;
            }
            case 17: {
                x -= rfont.charsWidth(src, offset, length) / 2;
                y += rfont.getBaselinePosition();
                break;
            }
            case 65: {
                x -= rfont.charsWidth(src, offset, length) / 2;
                break;
            }
            case 33: {
                x -= rfont.charsWidth(src, offset, length) / 2;
                y -= rfont.getBaselineHeight();
                break;
            }
            case 24: {
                x -= rfont.charsWidth(src, offset, length);
                y += rfont.getBaselinePosition();
                break;
            }
            case 72: {
                x -= rfont.charsWidth(src, offset, length);
                break;
            }
            case 40: {
                x -= rfont.charsWidth(src, offset, length);
                y -= rfont.getBaselineHeight();
            }
        }
        this.canvas.drawString(this.clipLeft, this.clipTop, this.clipWidth, this.clipHeight, src, offset, length, x + this.translateX, y + this.translateY, this.color, rfont, font.isUnderlined(), false, false);
    }

    public void drawChar(char src, int x, int y, int anchor) {
        Font font = this.font;
        RasterFont rfont = font.getReference();
        switch (anchor) {
            default: {
                throw new IllegalArgumentException("Graphics.drawChar: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 anchor.");
            }
            case 0: 
            case 20: {
                y += rfont.getBaselinePosition();
                break;
            }
            case 68: {
                break;
            }
            case 36: {
                y -= rfont.getBaselineHeight();
                break;
            }
            case 17: {
                x -= rfont.charWidth((int)src) / 2;
                y += rfont.getBaselinePosition();
                break;
            }
            case 65: {
                x -= rfont.charWidth((int)src) / 2;
                break;
            }
            case 33: {
                x -= rfont.charWidth((int)src) / 2;
                y -= rfont.getBaselineHeight();
                break;
            }
            case 24: {
                x -= rfont.charWidth((int)src);
                y += rfont.getBaselinePosition();
                break;
            }
            case 72: {
                x -= rfont.charWidth((int)src);
                break;
            }
            case 40: {
                x -= rfont.charWidth((int)src);
                y -= rfont.getBaselineHeight();
            }
        }
        this.canvas.drawCharacter(this.clipLeft, this.clipTop, this.clipWidth, this.clipHeight, (int)src, x + this.translateX, y + this.translateY, this.color, rfont, font.isUnderlined(), false, false);
    }

    public void drawChars(char[] src, int offset, int length, int x, int y, int anchor) {
        if (src == null) {
            throw new NullPointerException("Graphics.drawChars: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = offset + length;
        int len = src.length;
        if (lim > len || lim < offset || offset > len || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Graphics.drawChars: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        Font font = this.font;
        RasterFont rfont = font.getReference();
        switch (anchor) {
            default: {
                throw new IllegalArgumentException("Graphics.drawChars: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 anchor.");
            }
            case 0: 
            case 20: {
                y += rfont.getBaselinePosition();
                break;
            }
            case 68: {
                break;
            }
            case 36: {
                y -= rfont.getBaselineHeight();
                break;
            }
            case 17: {
                x -= rfont.charsWidth(src, offset, length) / 2;
                y += rfont.getBaselinePosition();
                break;
            }
            case 65: {
                x -= rfont.charsWidth(src, offset, length) / 2;
                break;
            }
            case 33: {
                x -= rfont.charsWidth(src, offset, length) / 2;
                y -= rfont.getBaselineHeight();
                break;
            }
            case 24: {
                x -= rfont.charsWidth(src, offset, length);
                y += rfont.getBaselinePosition();
                break;
            }
            case 72: {
                x -= rfont.charsWidth(src, offset, length);
                break;
            }
            case 40: {
                x -= rfont.charsWidth(src, offset, length);
                y -= rfont.getBaselineHeight();
            }
        }
        this.canvas.drawString(this.clipLeft, this.clipTop, this.clipWidth, this.clipHeight, src, offset, length, x + this.translateX, y + this.translateY, this.color, rfont, font.isUnderlined(), false, false);
    }

    public void drawString(String src, int x, int y, int anchor) {
        if (src == null) {
            throw new NullPointerException("Graphics.drawString: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Font font = this.font;
        RasterFont rfont = font.getReference();
        int length = src.length();
        switch (anchor) {
            default: {
                throw new IllegalArgumentException("Graphics.drawString: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 anchor.");
            }
            case 0: 
            case 20: {
                y += rfont.getBaselinePosition();
                break;
            }
            case 68: {
                break;
            }
            case 36: {
                y -= rfont.getBaselineHeight();
                break;
            }
            case 17: {
                x -= rfont.substringWidth(src, 0, length) / 2;
                y += rfont.getBaselinePosition();
                break;
            }
            case 65: {
                x -= rfont.substringWidth(src, 0, length) / 2;
                break;
            }
            case 33: {
                x -= rfont.substringWidth(src, 0, length) / 2;
                y -= rfont.getBaselineHeight();
                break;
            }
            case 24: {
                x -= rfont.substringWidth(src, 0, length);
                y += rfont.getBaselinePosition();
                break;
            }
            case 72: {
                x -= rfont.substringWidth(src, 0, length);
                break;
            }
            case 40: {
                x -= rfont.substringWidth(src, 0, length);
                y -= rfont.getBaselineHeight();
            }
        }
        this.canvas.drawString(this.clipLeft, this.clipTop, this.clipWidth, this.clipHeight, src, 0, length, x + this.translateX, y + this.translateY, this.color, rfont, font.isUnderlined(), false, false);
    }

    public void drawSubstring(String src, int offset, int length, int x, int y, int anchor) {
        if (src == null) {
            throw new NullPointerException("Graphics.drawSubstring: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = offset + length;
        int len = src.length();
        if (lim > len || lim < offset || offset > len || offset < 0) {
            throw new StringIndexOutOfBoundsException("Graphics.drawSubstring: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        Font font = this.font;
        RasterFont rfont = font.getReference();
        switch (anchor) {
            default: {
                throw new IllegalArgumentException("Graphics.drawSubstring: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 anchor.");
            }
            case 0: 
            case 20: {
                y += rfont.getBaselinePosition();
                break;
            }
            case 68: {
                break;
            }
            case 36: {
                y -= rfont.getBaselineHeight();
                break;
            }
            case 17: {
                x -= rfont.substringWidth(src, offset, length) / 2;
                y += rfont.getBaselinePosition();
                break;
            }
            case 65: {
                x -= rfont.substringWidth(src, offset, length) / 2;
                break;
            }
            case 33: {
                x -= rfont.substringWidth(src, offset, length) / 2;
                y -= rfont.getBaselineHeight();
                break;
            }
            case 24: {
                x -= rfont.substringWidth(src, offset, length);
                y += rfont.getBaselinePosition();
                break;
            }
            case 72: {
                x -= rfont.substringWidth(src, offset, length);
                break;
            }
            case 40: {
                x -= rfont.substringWidth(src, offset, length);
                y -= rfont.getBaselineHeight();
            }
        }
        this.canvas.drawString(this.clipLeft, this.clipTop, this.clipWidth, this.clipHeight, src, offset, length, x + this.translateX, y + this.translateY, this.color, rfont, font.isUnderlined(), false, false);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        int clipHeight;
        RasterCanvas canvas = this.canvas;
        int tmp = this.clipLeft;
        int clipLeft = Math.max(tmp, 0);
        int clipRight = Math.min(tmp + this.clipWidth, canvas.getWidth());
        tmp = this.clipTop;
        int clipTop = Math.max(tmp, 0);
        int clipBottom = Math.min(tmp + this.clipHeight, canvas.getHeight());
        int clipWidth = clipRight - clipLeft;
        if (clipWidth <= 0 || (clipHeight = clipBottom - clipTop) <= 0) {
            return;
        }
        int color = this.color | (canvas.isOpaque() ? 0 : -16777216);
        tmp = this.translateX;
        x1 += tmp;
        x2 += tmp;
        tmp = this.translateY;
        y1 += tmp;
        y2 += tmp;
        if (x1 == x2) {
            if (y1 <= y2) {
                canvas.drawVertLine(clipLeft, clipTop, clipWidth, clipHeight, x1, y1, y2 - y1 + 1, color, false);
                return;
            }
            canvas.drawVertLine(clipLeft, clipTop, clipWidth, clipHeight, x2, y2, y1 - y2 + 1, color, false);
            return;
        }
        if (y1 == y2) {
            if (x1 <= x2) {
                canvas.drawHorzLine(clipLeft, clipTop, clipWidth, clipHeight, x1, y1, x2 - x1 + 1, color, false);
                return;
            }
            canvas.drawHorzLine(clipLeft, clipTop, clipWidth, clipHeight, x2, y2, x1 - x2 + 1, color, false);
            return;
        }
        int x = x1;
        int y = y1;
        int xerr = 0;
        int yerr = 0;
        int dx = x2 - x1;
        int incx = dx == 0 ? 0 : (dx < 0 ? -1 : 1);
        int dy = y2 - y1;
        int incy = dy == 0 ? 0 : (dy < 0 ? -1 : 1);
        dx = dx < 0 ? -dx : dx;
        dy = dy < 0 ? -dy : dy;
        int d = dx >= dy ? dx : dy;
        GraphicBuffer buffer = canvas.getBuffer();
        int ofs = buffer.getOffset();
        int scan = buffer.getScanlength();
        int[] pixels = buffer.getPixels();
        int i = 0;
        while (i <= d) {
            yerr += dy;
            if ((xerr += dx) > d) {
                xerr -= d;
                x += incx;
            }
            if (yerr > d) {
                yerr -= d;
                y += incy;
            }
            if (x >= clipLeft && x < clipRight && y >= clipTop && y < clipBottom) {
                pixels[ofs + x + y * scan] = color;
            }
            ++i;
        }
    }

    public void drawRect(int left, int top, int width, int height) {
        int clipHeight;
        int clipWidth;
        if (width < 0 || height < 0 || (clipWidth = this.clipWidth) <= 0 || (clipHeight = this.clipHeight) <= 0) {
            return;
        }
        int clipLeft = this.clipLeft;
        int clipTop = this.clipTop;
        int color = this.color;
        RasterCanvas canvas = this.canvas;
        left += this.translateX;
        top += this.translateY;
        if (height == 0) {
            canvas.drawHorzLine(clipLeft, clipTop, clipWidth, clipHeight, left, top, width + 1, color, false);
            return;
        }
        if (width == 0) {
            canvas.drawVertLine(clipLeft, clipTop, clipWidth, clipHeight, left, top, height + 1, color, false);
            return;
        }
        canvas.drawHorzLine(clipLeft, clipTop, clipWidth, clipHeight, left, top, width, color, false);
        canvas.drawVertLine(clipLeft, clipTop, clipWidth, clipHeight, left, top + 1, height, color, false);
        canvas.drawVertLine(clipLeft, clipTop, clipWidth, clipHeight, left + width, top, height, color, false);
        canvas.drawHorzLine(clipLeft, clipTop, clipWidth, clipHeight, left + 1, top + height, width, color, false);
    }

    public void drawRoundRect(int left, int top, int width, int height, int arcWidth, int arcHeight) {
        int tmp2;
        int clipHeight;
        int clipWidth;
        if (width < 0 || height < 0 || (clipWidth = this.clipWidth) <= 0 || (clipHeight = this.clipHeight) <= 0) {
            return;
        }
        int clipLeft = this.clipLeft;
        int clipTop = this.clipTop;
        int color = this.color;
        RasterCanvas canvas = this.canvas;
        left += this.translateX;
        top += this.translateY;
        if (arcWidth <= 0 || arcHeight <= 0) {
            if (height == 0) {
                canvas.drawHorzLine(clipLeft, clipTop, clipWidth, clipHeight, left, top, width + 1, color, false);
                return;
            }
            if (width == 0) {
                canvas.drawVertLine(clipLeft, clipTop, clipWidth, clipHeight, left, top, height + 1, color, false);
                return;
            }
            canvas.drawHorzLine(clipLeft, clipTop, clipWidth, clipHeight, left, top, width, color, false);
            canvas.drawVertLine(clipLeft, clipTop, clipWidth, clipHeight, left, top + 1, height, color, false);
            canvas.drawVertLine(clipLeft, clipTop, clipWidth, clipHeight, left + width, top, height, color, false);
            canvas.drawHorzLine(clipLeft, clipTop, clipWidth, clipHeight, left + 1, top + height, width, color, false);
            return;
        }
        int tmp1 = width >> 1;
        if (arcWidth > tmp1) {
            arcWidth = tmp1;
        }
        if (arcHeight > (tmp2 = height >> 1)) {
            arcHeight = tmp2;
        }
        tmp1 = left + arcWidth;
        tmp2 = width - (arcWidth << 1) + 1;
        canvas.drawHorzLine(clipLeft, clipTop, clipWidth, clipHeight, tmp1, top, tmp2, color, false);
        canvas.drawHorzLine(clipLeft, clipTop, clipWidth, clipHeight, tmp1, top + height, tmp2, color, false);
        tmp1 = top + arcHeight;
        tmp2 = height - (arcHeight << 1) + 1;
        canvas.drawVertLine(clipLeft, clipTop, clipWidth, clipHeight, left, tmp1, tmp2, color, false);
        canvas.drawVertLine(clipLeft, clipTop, clipWidth, clipHeight, left + width, tmp1, tmp2, color, false);
        double r = (double)arcWidth / (double)arcHeight;
        long s = (long)arcHeight * (long)arcHeight;
        int d = arcHeight;
        int k = arcWidth;
        int i = 1;
        while (i < arcHeight) {
            int j = (int)Math.intPart((double)((double)arcWidth - r * Math.sqrt(s - (long)(--d) * (long)d))) + 1;
            int x1 = left + j;
            int y1 = top + i;
            tmp1 = k == j ? 1 : k - j;
            canvas.drawHorzLine(clipLeft, clipTop, clipWidth, clipHeight, x1, y1, tmp1, color, false);
            int y2 = top + height - i;
            canvas.drawHorzLine(clipLeft, clipTop, clipWidth, clipHeight, x1, y2, tmp1, color, false);
            int x2 = left + width - j - tmp1 + 1;
            canvas.drawHorzLine(clipLeft, clipTop, clipWidth, clipHeight, x2, y1, tmp1, color, false);
            canvas.drawHorzLine(clipLeft, clipTop, clipWidth, clipHeight, x2, y2, tmp1, color, false);
            k = j;
            ++i;
        }
    }

    public void drawArc(int left, int top, int width, int height, int startAngle, int arcAngle) {
        System.out.println("\u041c\u0435\u0442\u043e\u0434 javax.microedition.lcdui.Graphics.drawArc(int, int, int, int, int, int) \u043d\u0435 \u0440\u0435\u0430\u043b\u0438\u0437\u043e\u0432\u0430\u043d.");
    }

    public void fillTriangle(int x1, int y1, int x2, int y2, int x3, int y3) {
        int clipHeight;
        int clipWidth = this.clipWidth;
        if (clipWidth <= 0 || (clipHeight = this.clipHeight) <= 0) {
            return;
        }
        int clipLeft = this.clipLeft;
        int clipTop = this.clipTop;
        int color = this.color;
        RasterCanvas canvas = this.canvas;
        int tmp = this.translateX;
        x1 += tmp;
        x2 += tmp;
        x3 += tmp;
        tmp = this.translateY;
        y2 += tmp;
        if ((y1 += tmp) > (y3 += tmp)) {
            tmp = y1;
            y1 = y3;
            y3 = tmp;
            tmp = x1;
            x1 = x3;
            x3 = tmp;
        }
        if (y1 > y2) {
            tmp = y1;
            y1 = y2;
            y2 = tmp;
            tmp = x1;
            x1 = x2;
            x2 = tmp;
        }
        if (y2 > y3) {
            tmp = y2;
            y2 = y3;
            y3 = tmp;
            tmp = x2;
            x2 = x3;
            x3 = tmp;
        }
        int ix = x1;
        int ixerr = 0;
        int iyerr = 0;
        int idx = x2 - x1;
        int iincx = idx == 0 ? 0 : (idx < 0 ? -1 : 1);
        int idy = y2 - y1;
        int iincy = idy == 0 ? 0 : (idy < 0 ? -1 : 1);
        idx = idx < 0 ? -idx : idx;
        idy = idy < 0 ? -idy : idy;
        int id = idx >= idy ? idx : idy;
        int jx = x1;
        int jxerr = 0;
        int jyerr = 0;
        int jdx = x3 - x1;
        int jincx = jdx == 0 ? 0 : (jdx < 0 ? -1 : 1);
        int jdy = y3 - y1;
        int jincy = jdy == 0 ? 0 : (jdy < 0 ? -1 : 1);
        jdx = jdx < 0 ? -jdx : jdx;
        jdy = jdy < 0 ? -jdy : jdy;
        int jd = jdx >= jdy ? jdx : jdy;
        int y = y1;
        while (y <= y3) {
            if (y == y2) {
                ix = x2;
                ixerr = 0;
                iyerr = 0;
                idx = x3 - x2;
                iincx = idx == 0 ? 0 : (idx < 0 ? -1 : 1);
                idy = y3 - y2;
                iincy = idy == 0 ? 0 : (idy < 0 ? -1 : 1);
                idx = idx < 0 ? -idx : idx;
                idy = idy < 0 ? -idy : idy;
                int n = id = idx >= idy ? idx : idy;
            }
            if (ix <= jx) {
                canvas.drawHorzLine(clipLeft, clipTop, clipWidth, clipHeight, ix, y, jx - ix + 1, color, false);
            } else {
                canvas.drawHorzLine(clipLeft, clipTop, clipWidth, clipHeight, jx, y, ix - jx + 1, color, false);
            }
            while (iincy > 0) {
                iyerr += idy;
                if ((ixerr += idx) > id) {
                    ixerr -= id;
                    ix += iincx;
                }
                if (iyerr <= id) continue;
                iyerr -= id;
                break;
            }
            while (jincy > 0) {
                jyerr += jdy;
                if ((jxerr += jdx) > jd) {
                    jxerr -= jd;
                    jx += jincx;
                }
                if (jyerr <= jd) continue;
                jyerr -= jd;
                break;
            }
            ++y;
        }
    }

    public void fillRect(int left, int top, int width, int height) {
        int clipHeight;
        int clipWidth;
        if (width <= 0 || height <= 0 || (clipWidth = this.clipWidth) <= 0 || (clipHeight = this.clipHeight) <= 0) {
            return;
        }
        this.canvas.fillRect(this.clipLeft, this.clipTop, clipWidth, clipHeight, left + this.translateX, top + this.translateY, width, height, this.color, false);
    }

    public void fillRoundRect(int left, int top, int width, int height, int arcWidth, int arcHeight) {
        int clipHeight;
        int clipWidth;
        if (width <= 0 || height <= 0 || (clipWidth = this.clipWidth) <= 0 || (clipHeight = this.clipHeight) <= 0) {
            return;
        }
        int clipLeft = this.clipLeft;
        int clipTop = this.clipTop;
        int color = this.color;
        RasterCanvas canvas = this.canvas;
        left += this.translateX;
        top += this.translateY;
        if (arcWidth <= 0 || arcHeight <= 0) {
            canvas.fillRect(clipLeft, clipTop, clipWidth, clipHeight, left, top, width, height, color, false);
            return;
        }
        int tmp = width >> 1;
        if (arcWidth > tmp) {
            arcWidth = tmp;
        }
        if (arcHeight > (tmp = height >> 1)) {
            arcHeight = tmp;
        }
        if ((tmp = height - (arcHeight << 1)) > 0) {
            canvas.fillRect(clipLeft, clipTop, clipWidth, clipHeight, left, top + arcHeight, width, tmp, color, false);
        }
        double r = (double)arcWidth / (double)arcHeight;
        long s = (long)arcHeight * (long)arcHeight;
        int d = arcHeight;
        int i = 0;
        while (i < arcHeight) {
            int j = (int)Math.intPart((double)((double)arcWidth - r * Math.sqrt(s - (long)d * (long)d))) + (i != 0 ? 1 : 0);
            int x = left + j;
            tmp = width - (j << 1);
            canvas.drawHorzLine(clipLeft, clipTop, clipWidth, clipHeight, x, top + i, tmp, color, false);
            canvas.drawHorzLine(clipLeft, clipTop, clipWidth, clipHeight, x, top + height - i - 1, tmp, color, false);
            --d;
            ++i;
        }
    }

    public void fillArc(int left, int top, int width, int height, int startAngle, int arcAngle) {
        System.out.println("\u041c\u0435\u0442\u043e\u0434 javax.microedition.lcdui.Graphics.fillArc(int, int, int, int, int, int) \u043d\u0435 \u0440\u0435\u0430\u043b\u0438\u0437\u043e\u0432\u0430\u043d.");
    }

    public void reset() {
        RasterCanvas canvas = this.canvas;
        this.translateX = 0;
        this.translateY = 0;
        this.clipLeft = 0;
        this.clipTop = 0;
        this.clipWidth = canvas.getWidth();
        this.clipHeight = canvas.getHeight();
        this.color = 0;
        this.stroke = 0;
        this.font = Font.getDefaultFont();
    }

    public void translate(int deltaX, int deltaY) {
        this.translateX += deltaX;
        this.translateY += deltaY;
    }

    public void clipRect(int left, int top, int width, int height) {
        int clipLeft = this.clipLeft;
        int clipTop = this.clipTop;
        int clipWidth = this.clipWidth;
        int clipHeight = this.clipHeight;
        this.clipLeft = Math.max(left += this.translateX, clipLeft);
        this.clipWidth = Math.min(left + width, clipLeft + clipWidth) - this.clipLeft;
        this.clipTop = Math.max(top += this.translateY, clipTop);
        this.clipHeight = Math.min(top + height, clipTop + clipHeight) - this.clipTop;
    }

    public void setClip(int left, int top, int width, int height) {
        this.clipLeft = left + this.translateX;
        this.clipTop = top + this.translateY;
        this.clipWidth = width;
        this.clipHeight = height;
    }

    public void setColor(int color) {
        this.color = color & 0xFFFFFF;
    }

    public void setColor(int red, int green, int blue) {
        if (((red | green | blue) & 0xFFFFFF00) != 0) {
            throw new IllegalArgumentException("Graphics.setColor: \u0432\u0441\u0435 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0432 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0435 \u043e\u0442 0 \u0434\u043e 255.");
        }
        this.color = red << 16 | green << 8 | blue;
    }

    public void setGrayScale(int value) {
        if ((value & 0xFFFFFF00) != 0) {
            throw new IllegalArgumentException("Graphics.setGrayScale: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 value \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0432 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0435 \u043e\u0442 0 \u0434\u043e 255.");
        }
        this.color = value << 16 | value << 8 | value;
    }

    public void setStrokeStyle(int stroke) {
        if (stroke != 0 && stroke != 1) {
            throw new IllegalArgumentException("Graphics.setStrokeStyle: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 stroke.");
        }
        this.stroke = stroke;
    }

    public void setFont(Font font) {
        this.font = font == null ? Font.getDefaultFont() : font;
    }

    public int getTranslateX() {
        return this.translateX;
    }

    public int getTranslateY() {
        return this.translateY;
    }

    public int getClipX() {
        return this.clipLeft - this.translateX;
    }

    public int getClipY() {
        return this.clipTop - this.translateY;
    }

    public int getClipWidth() {
        return this.clipWidth;
    }

    public int getClipHeight() {
        return this.clipHeight;
    }

    public int getColor() {
        return this.color;
    }

    public int getRedComponent() {
        return this.color >> 16 & 0xFF;
    }

    public int getGreenComponent() {
        return this.color >> 8 & 0xFF;
    }

    public int getBlueComponent() {
        return this.color & 0xFF;
    }

    public int getGrayScale() {
        int c = this.color;
        return 76 * (c >> 16 & 0xFF) + 152 * (c >> 8 & 0xFF) + 28 * (c & 0xFF) >> 8;
    }

    public int getStrokeStyle() {
        return this.stroke;
    }

    public int getDisplayColor(int color) {
        return color & 0xFFFFFF;
    }

    public Font getFont() {
        return this.font;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addExtension(Object extension) {
        if (extension == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            Object[] extensions = this.extensions;
            if (this.extensions == null) {
                this.extensions = new Object[2];
                extensions = this.extensions;
            }
            if (this.indexOfExtension(extensions) < 0) {
                int i = this.indexOfExtension(null);
                if (i < 0) {
                    Object[] objectArray = extensions;
                    i = extensions.length;
                    this.extensions = new Object[i << 1];
                    extensions = this.extensions;
                    Array.copy((Object[])objectArray, (int)0, (Object[])this.extensions, (int)0, (int)i);
                }
                extensions[i] = extension;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeExtension(Class extensionClass) {
        if (extensionClass == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            Object[] extensions = this.extensions;
            int i = this.extensions != null ? extensions.length : 0;
            while (i-- > 0) {
                Object extension = extensions[i];
                if (extension == null || !extensionClass.isAssignableFrom(extension.getClass())) continue;
                extensions[i] = null;
            }
        }
    }

    public final Object getExtension(Class extensionClass) {
        if (extensionClass == null) {
            throw new NullPointerException("Graphics.getExtension: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 extensionClass \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Object[] extensions = this.extensions;
        int i = this.extensions != null ? extensions.length : 0;
        while (i-- > 0) {
            Object extension = extensions[i];
            if (extension == null || !extensionClass.isAssignableFrom(extension.getClass())) continue;
            return extension;
        }
        return null;
    }

    public final GraphicBuffer getBuffer() {
        return this.canvas.getBuffer();
    }

    public final RasterCanvas getCanvas() {
        return this.canvas;
    }

    private int indexOfExtension(Object extension) {
        Object[] extensions = this.extensions;
        int i = this.extensions.length;
        while (i-- > 0) {
            if (extensions[i] != extension) continue;
            return i;
        }
        return -1;
    }
}

