/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandEnumeration;
import javax.microedition.lcdui.CommandEnumerationWithCheck;
import javax.microedition.lcdui.Container;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.GraphicsClipRestricted;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.TextOutputMultilined;
import malik.emulator.media.graphics.RasterCanvas;

public abstract class Item {
    public static final int PLAIN = 0;
    public static final int HYPERLINK = 1;
    public static final int BUTTON = 2;
    public static final int LAYOUT_DEFAULT = 0;
    public static final int LAYOUT_LEFT = 1;
    public static final int LAYOUT_RIGHT = 2;
    public static final int LAYOUT_CENTER = 3;
    public static final int LAYOUT_TOP = 16;
    public static final int LAYOUT_BOTTOM = 32;
    public static final int LAYOUT_VCENTER = 48;
    public static final int LAYOUT_NEWLINE_BEFORE = 256;
    public static final int LAYOUT_NEWLINE_AFTER = 512;
    public static final int LAYOUT_SHRINK = 1024;
    public static final int LAYOUT_EXPAND = 2048;
    public static final int LAYOUT_VSHRINK = 4096;
    public static final int LAYOUT_VEXPAND = 8192;
    public static final int LAYOUT_2 = 16384;
    static final int LEFT = 0;
    static final int TOP = 1;
    static final int WIDTH = 2;
    static final int HEIGHT = 3;
    private static final int LAYOUT_MASK = -32564;
    private static final ItemUpdateEventStream STREAM;
    private boolean needRecompute;
    private boolean focusedClient;
    private boolean visible;
    private int layout;
    private int left;
    private int top;
    private int width;
    private int height;
    private int minWidth;
    private int minHeight;
    private int lockedWidth;
    private int lockedHeight;
    private int contentLeft;
    private int contentTop;
    private int contentWidth;
    private int contentHeight;
    private int commandsCount;
    private Command[] commandsInItem;
    private Command defaultCommand;
    private ItemCommandListener listener;
    private String label;
    private Reference owningReference;
    private TextOutputMultilined lines;
    private Helper helper;
    private Object lock;

    static {
        ItemUpdateEventStream stream;
        STREAM = stream = new ItemUpdateEventStream();
        new Thread((Runnable)stream, "\u041f\u043e\u0442\u043e\u043a, \u043f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u0435\u0441\u043a\u0438 \u0432\u044b\u0437\u044b\u0432\u0430\u044e\u0449\u0438\u0439 \u043c\u0435\u0442\u043e\u0434 Item.onUpdate().").start();
    }

    Item(int layout, int lockedWidth, int lockedHeight, String label, Command[] commands, Command defaultCommand, ItemCommandListener listener) {
        if ((layout & 0xFFFF80CC) != 0) {
            throw new IllegalArgumentException("Item: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 layout.");
        }
        if (lockedWidth < -1 || lockedHeight < -1) {
            throw new IllegalArgumentException("Item: \u043f\u0440\u0435\u0434\u043f\u043e\u0447\u0438\u0442\u0430\u0435\u043c\u044b\u0435 \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u043d\u0435 \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 -1.");
        }
        Object[] c = null;
        int len = commands == null ? 0 : commands.length;
        if (len > 0) {
            c = new Command[len];
            Array.copy((Object[])commands, (int)0, (Object[])c, (int)0, (int)len);
            int i = defaultCommand != null ? -1 : 0;
            while (i < len) {
                Object cmd = i < 0 ? defaultCommand : c[i];
                if (cmd == null && i >= 0) {
                    throw new NullPointerException("Item: \u043e\u0434\u0438\u043d \u0438\u0437 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 commands \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
                }
                int j = i + 1;
                while (j < len) {
                    if (c[j] == cmd) {
                        throw new IllegalArgumentException("Item: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 commands \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0440\u0430\u0432\u043d\u044b\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b \u0438\u043b\u0438 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b, \u0440\u0430\u0432\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0443 defaultCommand.");
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.needRecompute = true;
        this.layout = layout;
        this.lockedWidth = lockedWidth;
        this.lockedHeight = lockedHeight;
        this.commandsCount = len;
        this.commandsInItem = c;
        this.defaultCommand = defaultCommand;
        this.listener = listener;
        this.label = label;
        this.lines = new TextOutputMultilined(0);
        this.helper = new Helper(this);
        this.lock = new Object();
        this.updateLines(label);
    }

    public void notifyStateChanged() {
        Container owner = this.getOwner();
        if (!(owner instanceof Form)) {
            throw new IllegalStateException("Item.notifyStateChanged: \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043e\u043f\u043e\u0432\u0435\u0441\u0442\u0438\u0442\u044c \u043e\u0431 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0438 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0433\u043e, \u0435\u0441\u043b\u0438 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u043d\u0435 \u043d\u0430 \u0444\u043e\u0440\u043c\u0435.");
        }
        ((Form)owner).notifyItemStateChanged(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommand(Command command) {
        boolean commandsChanged;
        Container owner = this.getOwner();
        if (owner instanceof Alert) {
            throw new IllegalStateException("Item.addCommand: \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043a\u043e\u043c\u0430\u043d\u0434\u0443, \u0435\u0441\u043b\u0438 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u043d\u0430 \u0434\u0438\u0430\u043b\u043e\u0433\u043e\u0432\u043e\u043c \u044d\u043a\u0440\u0430\u043d\u0435.");
        }
        if (command == null) {
            throw new NullPointerException("Item.addCommand: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 command \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Object object = this.getCommands().getMonitor();
        synchronized (object) {
            int len;
            Command[] c;
            commandsChanged = false;
            if (command != this.defaultCommand && (c = Displayable.addCommand(this.commandsInItem, len = this.commandsCount, command)) != null) {
                this.commandsCount = len + 1;
                this.commandsInItem = c;
                commandsChanged = true;
            }
        }
        if (!commandsChanged || owner == null || !owner.isFocused(this)) {
            return;
        }
        owner.updateCommands();
        owner.callSeriallyPaintScreen(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCommand(Command command) {
        Container owner;
        boolean commandsChanged;
        Object object = this.getCommands().getMonitor();
        synchronized (object) {
            commandsChanged = false;
            if (command != null && command == this.defaultCommand) {
                this.defaultCommand = null;
                commandsChanged = true;
            } else {
                int len = this.commandsCount;
                Command[] c = Displayable.removeCommand(this.commandsInItem, len, command);
                if (c != null) {
                    this.commandsCount = len - 1;
                    this.commandsInItem = c;
                    commandsChanged = true;
                }
            }
        }
        if (!commandsChanged || (owner = this.getOwner()) == null || !owner.isFocused(this)) {
            return;
        }
        owner.updateCommands();
        owner.callSeriallyPaintScreen(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultCommand(Command command) {
        boolean commandsChanged;
        Container owner = this.getOwner();
        if (owner instanceof Alert) {
            throw new IllegalStateException("Item.setDefaultCommand: \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043e\u0441\u043d\u043e\u0432\u043d\u0443\u044e \u043a\u043e\u043c\u0430\u043d\u0434\u0443, \u0435\u0441\u043b\u0438 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u043d\u0430 \u0434\u0438\u0430\u043b\u043e\u0433\u043e\u0432\u043e\u043c \u044d\u043a\u0440\u0430\u043d\u0435.");
        }
        Object object = this.getCommands().getMonitor();
        synchronized (object) {
            Command currentDefault = this.defaultCommand;
            commandsChanged = currentDefault != command;
            if (commandsChanged) {
                Command[] c;
                int len;
                int count = len = this.commandsCount;
                Command[] inItem = this.commandsInItem;
                if (command != null && (c = Displayable.removeCommand(inItem, len, command)) != null) {
                    count = --len;
                    inItem = c;
                }
                if (currentDefault != null && (c = Displayable.addCommand(inItem, len, currentDefault)) != null) {
                    count = len + 1;
                    inItem = c;
                }
                this.commandsCount = count;
                this.commandsInItem = inItem;
                this.defaultCommand = command;
            }
        }
        if (!commandsChanged || owner == null || !owner.isFocused(this)) {
            return;
        }
        owner.updateCommands();
        owner.callSeriallyPaintScreen(4);
    }

    public void setItemCommandListener(ItemCommandListener listener) {
        this.listener = listener == this ? this.helper : listener;
        this.notifyPaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreferredSize(int lockedWidth, int lockedHeight) {
        if (this.getOwner() instanceof Alert) {
            throw new IllegalStateException("Item.setPreferredSize: \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u0440\u0435\u0434\u043f\u043e\u0447\u0438\u0442\u0430\u0435\u043c\u044b\u0435 \u0440\u0430\u0437\u043c\u0435\u0440\u044b, \u0435\u0441\u043b\u0438 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u043d\u0430 \u0434\u0438\u0430\u043b\u043e\u0433\u043e\u0432\u043e\u043c \u044d\u043a\u0440\u0430\u043d\u0435.");
        }
        if (lockedWidth < -1 || lockedHeight < -1) {
            throw new IllegalArgumentException("Item.setPreferredSize: \u043f\u0440\u0435\u0434\u043f\u043e\u0447\u0438\u0442\u0430\u0435\u043c\u044b\u0435 \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u043d\u0435 \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 -1.");
        }
        Object object = this.lock;
        synchronized (object) {
            this.lockedWidth = lockedWidth;
            this.lockedHeight = lockedHeight;
        }
        this.notifyUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLayout(int layout) {
        boolean layoutChanged;
        if (this.getOwner() instanceof Alert) {
            throw new IllegalStateException("Item.setLayout: \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0440\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430, \u0435\u0441\u043b\u0438 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u043d\u0430 \u0434\u0438\u0430\u043b\u043e\u0433\u043e\u0432\u043e\u043c \u044d\u043a\u0440\u0430\u043d\u0435.");
        }
        if ((layout & 0xFFFF80CC) != 0) {
            throw new IllegalArgumentException("Item.setLayout: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 layout.");
        }
        Object object = this.lock;
        synchronized (object) {
            layoutChanged = this.layout != layout;
            if (layoutChanged) {
                this.layout = layout;
            }
        }
        if (!layoutChanged) {
            return;
        }
        this.notifyUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLabel(String label) {
        boolean labelChanged;
        if (this.getOwner() instanceof Alert) {
            throw new IllegalStateException("Item.setLabel: \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043c\u0435\u0442\u043a\u0443 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430, \u0435\u0441\u043b\u0438 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u043d\u0430 \u0434\u0438\u0430\u043b\u043e\u0433\u043e\u0432\u043e\u043c \u044d\u043a\u0440\u0430\u043d\u0435.");
        }
        Object object = this.lock;
        synchronized (object) {
            String oldLabel = this.label;
            boolean bl = oldLabel == null ? label != null : (labelChanged = !oldLabel.equals(label));
            if (bl) {
                this.label = label;
                this.updateLines(label);
            }
        }
        if (!labelChanged) {
            return;
        }
        this.notifyUpdate();
    }

    public int getMinimumWidth() {
        return this.minWidth;
    }

    public int getMinimumHeight() {
        return this.minHeight;
    }

    public int getPreferredWidth() {
        return this.width;
    }

    public int getPreferredHeight() {
        return this.height;
    }

    public int getLayout() {
        return this.layout;
    }

    public String getLabel() {
        return this.label;
    }

    abstract void paintContent(Graphics var1, int var2, int var3);

    abstract int getPreferredContentWidth(int var1, int var2);

    abstract int getPreferredContentHeight(int var1);

    void onUpdate() {
    }

    void onShow() {
    }

    void onHide() {
    }

    void onSizeChanged(int contentWidth, int contentHeight) {
    }

    void onKeyPressed(int key, int charCode) {
    }

    void onKeyRepeated(int key, int charCode) {
    }

    void onKeyReleased(int key) {
    }

    void onContentPointerPressed(int x, int y, int button) {
    }

    void onContentPointerDragged(int x, int y) {
    }

    void onContentPointerReleased(int x, int y, int button) {
    }

    void onCommandAction(Command command) {
        ItemCommandListener listener = this.listener;
        if (listener == null) {
            return;
        }
        listener.commandAction(command, this);
    }

    void onTraverseOut() {
    }

    boolean onTraverseNeedStayOn(int direction, int viewportWidth, int viewportHeight, int[] visibleRectangle) {
        return false;
    }

    boolean keyHandling(int key) {
        return false;
    }

    boolean isMatchForAlert() {
        CommandEnumerationWithCheck e;
        return this.getOwner() == null && (e = this.getCommands()).getCommandsCount() == 0 && e.getDefaultCommand() == null && this.lockedWidth == -1 && this.lockedHeight == -1 && this.layout == 0 && this.listener == null && this.label == null;
    }

    boolean isMatchForButton() {
        return this.getCommands().getDefaultCommand() != null && this.listener != null;
    }

    boolean isMatchForHyperlink() {
        return this.getCommands().getDefaultCommand() != null && this.listener != null;
    }

    int getMinimumContentWidth(int containerClientWidth) {
        return this.getPreferredContentWidth(-1, containerClientWidth);
    }

    int getMinimumContentHeight() {
        return this.getPreferredContentHeight(-1);
    }

    CommandEnumerationWithCheck getCommands() {
        return this.helper;
    }

    final void onPointerPressed(int x, int y, int button) {
        int t;
        int l = this.contentLeft;
        if (x >= l && y >= (t = this.contentTop) && x < l + this.contentWidth && y < t + this.contentHeight) {
            this.focusedClient = true;
            this.onContentPointerPressed(x - l, y - t, button);
        }
    }

    final void onPointerDragged(int x, int y) {
        if (this.focusedClient) {
            this.onContentPointerDragged(x - this.contentLeft, y - this.contentTop);
        }
    }

    final void onPointerReleased(int x, int y, int button) {
        if (this.focusedClient) {
            this.focusedClient = false;
            this.onContentPointerReleased(x - this.contentLeft, y - this.contentTop, button);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onPaint(GraphicsClipRestricted render) {
        int h;
        Font labelFont = Font.getFont(0, 1, 8);
        render.setFont(labelFont);
        render.setColor(RasterCanvas.getSystemColor((int)40));
        Object object = this.lock;
        synchronized (object) {
            String labelText = this.label;
            if (labelText != null && labelText.length() > 0) {
                int s = labelFont.getHeight();
                int ct = render.getClipY();
                int cb = ct + render.getClipHeight();
                TextOutputMultilined labelLines = this.lines;
                int len = labelLines.getLinesCount();
                char[] labelChars = labelLines.getChars();
                int t = 0;
                int i = 0;
                while (i < len) {
                    if (t < cb && t + s > ct) {
                        render.drawChars(labelChars, labelLines.getLineStart(i), labelLines.getLineLength(i), 0, t, 0);
                    }
                    t += s;
                    ++i;
                }
            }
        }
        int w = this.contentWidth;
        if (w <= 0 || (h = this.contentHeight) <= 0) {
            return;
        }
        render.setColor(0);
        render.setFont(Font.getDefaultFont());
        render.translate(this.contentLeft, this.contentTop);
        render.restrictClipRect(0, 0, w, h);
        if (render.getClipWidth() <= 0 || render.getClipHeight() <= 0) {
            return;
        }
        this.paintContent(render, w, h);
    }

    final void notifyCommandAction(Command command) {
        Container screen;
        if (command == null || (screen = this.getOwner()) == null) {
            return;
        }
        screen.callSeriallyCommandAction(command);
    }

    final void notifyPaint() {
        Container owner = this.getOwner();
        if (owner == null) {
            return;
        }
        owner.callSeriallyPaintScreen(4);
    }

    final void notifyUpdate() {
        Container owner;
        block3: {
            block2: {
                if (this.needRecompute) break block2;
                this.needRecompute = true;
                if (true && (owner = this.getOwner()) != null) break block3;
            }
            return;
        }
        owner.notifyPlaceItems();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void computeSizes(int containerClientWidth) {
        int lockedHeight;
        int lockedWidth;
        if (!this.needRecompute) {
            return;
        }
        this.needRecompute = false;
        int labelWidth = 0;
        int labelHeight = 0;
        Object object = this.lock;
        synchronized (object) {
            Font labelFont = Font.getFont(0, 1, 8);
            TextOutputMultilined labelLines = this.lines;
            labelLines.split(labelFont, containerClientWidth);
            String labelText = this.label;
            if (labelText != null && labelText.length() > 0) {
                int len = labelLines.getLinesCount();
                labelHeight = labelFont.getHeight() * len;
                char[] labelChars = labelLines.getChars();
                int i = 0;
                while (i < len) {
                    int tmp = labelFont.charsWidth(labelChars, labelLines.getLineStart(i), labelLines.getLineLength(i));
                    if (labelWidth < tmp) {
                        labelWidth = tmp;
                    }
                    ++i;
                }
            }
            lockedWidth = this.lockedWidth;
            lockedHeight = this.lockedHeight;
        }
        try {
            int currContentHeight;
            int currContentWidth;
            int minContentWidth = Math.max(this.getMinimumContentWidth(containerClientWidth), 0);
            int minContentHeight = Math.max(this.getMinimumContentHeight(), 0);
            if (lockedWidth < 0) {
                if (lockedHeight < 0) {
                    if (containerClientWidth > minContentWidth) {
                        int pch2;
                        int pch1 = Math.max(this.getPreferredContentHeight(containerClientWidth), 0);
                        if (pch1 < (pch2 = Math.max(this.getPreferredContentHeight(minContentWidth), 0))) {
                            currContentWidth = containerClientWidth;
                            currContentHeight = Math.max(pch1, minContentHeight);
                        } else {
                            currContentWidth = minContentWidth;
                            currContentHeight = Math.max(pch2, minContentHeight);
                        }
                    } else {
                        currContentWidth = minContentWidth;
                        currContentHeight = Math.max(this.getPreferredContentHeight(currContentWidth), minContentHeight);
                    }
                } else {
                    currContentHeight = Math.max(minContentHeight, lockedHeight - labelHeight);
                    currContentWidth = Math.max(this.getPreferredContentWidth(currContentHeight, containerClientWidth), minContentWidth);
                }
            } else {
                currContentWidth = Math.max(minContentWidth, Math.max(lockedWidth, labelWidth));
                currContentHeight = Math.max(this.getPreferredContentHeight(currContentWidth), lockedHeight < 0 ? minContentHeight : Math.max(minContentHeight, lockedHeight - labelHeight));
            }
            currContentWidth = Math.max(labelWidth, currContentWidth);
            minContentWidth = Math.max(labelWidth, minContentWidth);
            boolean needInvokeSizeChanged = this.contentWidth != currContentWidth || this.contentHeight != currContentHeight;
            this.width = currContentWidth;
            this.height = labelHeight + currContentHeight;
            this.minWidth = minContentWidth;
            this.minHeight = labelHeight + minContentHeight;
            this.contentLeft = 0;
            this.contentTop = labelHeight;
            this.contentWidth = currContentWidth;
            this.contentHeight = currContentHeight;
            if (needInvokeSizeChanged) {
                this.onSizeChanged(currContentWidth, currContentHeight);
            }
        }
        catch (RuntimeException e) {
            e.printRealStackTrace();
        }
    }

    final void startUpdating() {
        STREAM.add(this);
    }

    final void stopUpdating() {
        STREAM.remove(this);
    }

    final void setVisible(boolean visible) {
        this.visible = visible;
    }

    final void setPosition(int left, int top) {
        this.left = left;
        this.top = top;
    }

    final void setOwner(Container owner) {
        this.owningReference = owner == null ? null : owner.getOwningReference();
    }

    final boolean isVisible() {
        return this.visible;
    }

    final int getLeft() {
        return this.left;
    }

    final int getTop() {
        return this.top;
    }

    final int getWidth() {
        return this.width;
    }

    final int getHeight() {
        return this.height;
    }

    final int getRealLayout() {
        return this.layout;
    }

    final Object getMonitor() {
        return this.lock;
    }

    final Container getOwner() {
        Reference ref = this.owningReference;
        return ref == null ? null : (Container)ref.get();
    }

    private void updateLines(String label) {
        int len;
        TextOutputMultilined labelLines = this.lines;
        labelLines.setText(label);
        if (label == null || (len = label.length()) <= 0 || label.charAt(len - 1) == ':') {
            return;
        }
        labelLines.append(":");
    }

    private static final class Helper
    extends WeakReference
    implements ItemCommandListener,
    CommandEnumerationWithCheck,
    CommandEnumeration {
        Helper(Item thisItem) {
            super(thisItem);
        }

        public void commandAction(Command command, Item item) {
            Object thisItem = this.get();
            if (!(thisItem instanceof ItemCommandListener)) {
                return;
            }
            ((ItemCommandListener)thisItem).commandAction(command, item);
        }

        public boolean hasCommand(Command command) {
            Item thisItem = (Item)this.get();
            if (thisItem == null) {
                return false;
            }
            if (command == thisItem.defaultCommand) {
                return true;
            }
            Command[] c = thisItem.commandsInItem;
            int i = thisItem.commandsCount;
            while (i-- > 0) {
                if (c[i] != command) continue;
                return true;
            }
            return false;
        }

        public int getCommandsCount() {
            Item thisItem = (Item)this.get();
            return thisItem == null ? 0 : thisItem.commandsCount;
        }

        public Command getCommand(int index) {
            Item thisItem = (Item)this.get();
            if (thisItem == null || index < 0 || index >= thisItem.commandsCount) {
                throw new IndexOutOfBoundsException("Item.getCommands: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
            }
            return thisItem.commandsInItem[index];
        }

        public Command getDefaultCommand() {
            Item thisItem = (Item)this.get();
            return thisItem == null ? null : thisItem.defaultCommand;
        }

        public Object getMonitor() {
            Container owner;
            Item thisItem = (Item)this.get();
            return thisItem == null ? this : ((owner = thisItem.getOwner()) == null ? thisItem.getMonitor() : owner.getCommandsMonitor());
        }
    }

    private static final class ItemUpdateEventStream
    implements Runnable {
        private int count;
        private Item[] items = new Item[8];

        ItemUpdateEventStream() {
        }

        public synchronized void run() {
            while (true) {
                Item item;
                this.waitEvent();
                int count = this.count;
                Item[] items = this.items;
                int i = count;
                while (i-- > 0) {
                    item = items[i];
                    item.onUpdate();
                    if (i != 0) continue;
                    item.notifyPaint();
                }
                item = null;
            }
        }

        public synchronized void add(Item item) {
            int count = this.count;
            Object[] items = this.items;
            int i = count;
            while (i-- > 0) {
                if (items[i] != item) continue;
                return;
            }
            if (count == items.length) {
                Object[] objectArray = items;
                this.items = new Item[count << 1];
                items = this.items;
                Array.copy((Object[])objectArray, (int)0, (Object[])this.items, (int)0, (int)count);
            }
            items[count++] = item;
            this.count = count;
            this.notify();
        }

        public synchronized void remove(Item item) {
            int i;
            Object[] items;
            int count;
            block2: {
                count = this.count;
                items = this.items;
                i = count;
                while (i-- > 0) {
                    if (items[i] != item) continue;
                    break block2;
                }
                return;
            }
            int index = i;
            i = count - index - 1;
            if (i > 0) {
                Array.copy((Object[])items, (int)(index + 1), (Object[])items, (int)index, (int)i);
            }
            items[--count] = null;
            this.count = count;
            this.notify();
        }

        private void waitEvent() {
            while (true) {
                try {
                    this.wait(this.count > 0 ? 100L : 0L);
                }
                catch (InterruptedException e) {
                    e.printRealStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

