/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.lang.ref.WeakReference;
import javax.microedition.lcdui.CharList;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Input;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.MIDletProxy;
import javax.microedition.lcdui.TextOutputMultilined;
import malik.emulator.io.j2me.input.AvailableInputModes;
import malik.emulator.io.j2me.input.CharDestination;
import malik.emulator.io.j2me.input.InputMode;

public final class TextInput
extends TextOutputMultilined
implements CharDestination,
Input {
    public static final char DEFAULT_PASSWORD_CHAR = '\u2022';
    public static final int DEFAULT_CHAR_ARRAY_LENGTH = 1024;
    private static String CLIP_BOARD;
    private static final char[][] CHARACTER_SUBSETS_CHARS;
    private static final String[] CHARACTER_SUBSETS_NAMES;
    private static final Command[] ADDITIONAL_CAPABILITIES_COMMANDS;
    private boolean shiftPressed;
    private boolean changed;
    private int caretPosition;
    private int maxLength;
    private int constraints;
    private char[] content;
    private InputMode mode;

    static {
        CHARACTER_SUBSETS_CHARS = new char[][]{"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray(), "\u0410\u0411\u0412\u0413\u0414\u0415\u0401\u0416\u0417\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042a\u042b\u042c\u042d\u042e\u042f\u0430\u0431\u0432\u0433\u0434\u0435\u0451\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044b\u044c\u044d\u044e\u044f".toCharArray(), "\u0400\u0401\u0402\u0403\u0404\u0405\u0406\u0407\u0408\u0409\u040a\u040b\u040c\u040d\u040e\u040f\u0410\u0411\u0412\u0413\u0414\u0415\u0416\u0417\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042a\u042b\u042c\u042d\u042e\u042f\u0430\u0431\u0432\u0433\u0434\u0435\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044b\u044c\u044d\u044e\u044f\u0450\u0451\u0452\u0453\u0454\u0455\u0456\u0457\u0458\u0459\u045a\u045b\u045c\u045d\u045e\u045f".toCharArray(), " !\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~\u00a1\u00a3\u00a4\u00a5\u00a7\u00bf\u20ac".toCharArray()};
        CHARACTER_SUBSETS_NAMES = new String[]{"\u0411\u0430\u0437\u043e\u0432\u0430\u044f \u043b\u0430\u0442\u0438\u043d\u0438\u0446\u0430", "\u041a\u0438\u0440\u0438\u043b\u043b\u0438\u0446\u0430 (\u0440\u0443\u0441\u0441\u043a\u0438\u0439 \u044f\u0437\u044b\u043a)", "\u041a\u0438\u0440\u0438\u043b\u043b\u0438\u0446\u0430 (\u0432\u0441\u044f)", "\u041f\u0440\u043e\u0447\u0438\u0435 \u0441\u0438\u043c\u0432\u043e\u043b\u044b"};
        ADDITIONAL_CAPABILITIES_COMMANDS = new Command[]{new Command("\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u0441\u0438\u043c\u0432\u043e\u043b", 1, 0), new Command("\u041f\u0435\u0440\u0435\u043d\u043e\u0441 \u0441\u0442\u0440\u043e\u043a\u0438", 1, 0), new Command("\u042f\u0437\u044b\u043a \u0432\u0432\u043e\u0434\u0430", 1, 0), new Command("\u0421\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c", 1, 0), new Command("\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c", 1, 0)};
    }

    public static boolean isConstraintsValid(int constraints) {
        return (constraints & 0xFFFF) <= 5 && constraints >>> 16 < 64;
    }

    public static boolean isConstraintsMatch(int constraints, String src) {
        if (!TextInput.isConstraintsValid(constraints)) {
            throw new IllegalArgumentException("TextInput.isConstraintsMatch: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 constraints.");
        }
        if (src == null) {
            return true;
        }
        int length = src.length();
        switch (constraints & 0xFFFF) {
            case 0: 
            case 1: 
            case 4: {
                return true;
            }
            case 2: {
                int i = 0;
                while (i < length) {
                    switch (src.charAt(i)) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            break;
                        }
                        case '-': {
                            if (i <= 0) break;
                            return false;
                        }
                        default: {
                            return false;
                        }
                    }
                    ++i;
                }
                return true;
            }
            case 3: {
                int i = 0;
                while (i < length) {
                    switch (src.charAt(i)) {
                        case '#': 
                        case '*': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            break;
                        }
                        case '+': {
                            if (i <= 0) break;
                            return false;
                        }
                        default: {
                            return false;
                        }
                    }
                    ++i;
                }
                return true;
            }
            case 5: {
                boolean f = false;
                int i = 0;
                while (i < length) {
                    switch (src.charAt(i)) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            break;
                        }
                        case '.': {
                            if (f) {
                                return false;
                            }
                            f = true;
                            break;
                        }
                        case '-': {
                            if (i <= 0) break;
                            return false;
                        }
                        default: {
                            return false;
                        }
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean isConstraintsMatch(int constraints, char[] src, int offset, int length) {
        if (!TextInput.isConstraintsValid(constraints)) {
            throw new IllegalArgumentException("TextInput.isConstraintsMatch: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 constraints.");
        }
        if (src == null) {
            return true;
        }
        int lim = offset + length;
        int len = src.length;
        if (lim > len || lim < offset || offset > len || offset < 0) {
            throw new IndexOutOfBoundsException("TextInput.isConstraintsMatch: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        switch (constraints & 0xFFFF) {
            case 0: 
            case 1: 
            case 4: {
                return true;
            }
            case 2: {
                int j = offset;
                int i = 0;
                while (i < length) {
                    switch (src[j]) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            break;
                        }
                        case '-': {
                            if (i <= 0) break;
                            return false;
                        }
                        default: {
                            return false;
                        }
                    }
                    ++j;
                    ++i;
                }
                return true;
            }
            case 3: {
                int j = offset;
                int i = 0;
                while (i < length) {
                    switch (src[j]) {
                        case '#': 
                        case '*': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            break;
                        }
                        case '+': {
                            if (i <= 0) break;
                            return false;
                        }
                        default: {
                            return false;
                        }
                    }
                    ++j;
                    ++i;
                }
                return true;
            }
            case 5: {
                boolean f = false;
                int j = offset;
                int i = 0;
                while (i < length) {
                    switch (src[j]) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            break;
                        }
                        case '.': {
                            if (f) {
                                return false;
                            }
                            f = true;
                            break;
                        }
                        case '-': {
                            if (i <= 0) break;
                            return false;
                        }
                        default: {
                            return false;
                        }
                    }
                    ++j;
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean isAdditionalCapabilitiesCommand(Command command) {
        int i = ADDITIONAL_CAPABILITIES_COMMANDS.length;
        while (i-- > 0) {
            if (ADDITIONAL_CAPABILITIES_COMMANDS[i] != command) continue;
            return true;
        }
        return false;
    }

    public static Command[] getAdditionalCapabilitiesCommands(int constraints, boolean lineSeparatorAllowed) {
        Command[] result;
        int len = constraints & 0xFFFF;
        boolean any = len == 0 || len == 1 || len == 4;
        switch (constraints >> 16 & 3) {
            default: {
                result = new Command[]{};
                break;
            }
            case 2: {
                result = new Command[]{ADDITIONAL_CAPABILITIES_COMMANDS[3]};
                break;
            }
            case 1: {
                if (!any) {
                    result = new Command[]{ADDITIONAL_CAPABILITIES_COMMANDS[4]};
                    break;
                }
                if (lineSeparatorAllowed) {
                    result = new Command[]{ADDITIONAL_CAPABILITIES_COMMANDS[0], ADDITIONAL_CAPABILITIES_COMMANDS[1], ADDITIONAL_CAPABILITIES_COMMANDS[2], ADDITIONAL_CAPABILITIES_COMMANDS[4]};
                    break;
                }
                result = new Command[]{ADDITIONAL_CAPABILITIES_COMMANDS[0], ADDITIONAL_CAPABILITIES_COMMANDS[2], ADDITIONAL_CAPABILITIES_COMMANDS[4]};
                break;
            }
            case 0: {
                if (!any) {
                    result = new Command[]{ADDITIONAL_CAPABILITIES_COMMANDS[3], ADDITIONAL_CAPABILITIES_COMMANDS[4]};
                    break;
                }
                if (lineSeparatorAllowed) {
                    len = ADDITIONAL_CAPABILITIES_COMMANDS.length;
                    result = new Command[len];
                    Array.copy((Object[])ADDITIONAL_CAPABILITIES_COMMANDS, (int)0, (Object[])result, (int)0, (int)len);
                    break;
                }
                result = new Command[]{ADDITIONAL_CAPABILITIES_COMMANDS[0], ADDITIONAL_CAPABILITIES_COMMANDS[2], ADDITIONAL_CAPABILITIES_COMMANDS[3], ADDITIONAL_CAPABILITIES_COMMANDS[4]};
            }
        }
        return result;
    }

    private static void fillPasswordChars(char[] dst) {
        int i = dst.length;
        while (i-- > 0) {
            dst[i] = 8226;
        }
    }

    private static boolean isCapsLockPressed() {
        return ((int)MalikSystem.syscall((long)0L, (int)81) & 2) != 0;
    }

    public TextInput(String text, int maxLength, int constraints) {
        this(text, maxLength, constraints, 1024);
    }

    public TextInput(String text, int maxLength, int constraints, int charArrayLength) {
        if (text == null) {
            text = "";
        }
        if (charArrayLength < 1024) {
            charArrayLength = 1024;
        }
        if (maxLength <= 0) {
            throw new IllegalArgumentException("TextInput: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 maxLength \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        if (!TextInput.isConstraintsValid(constraints)) {
            throw new IllegalArgumentException("TextInput: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 constraints.");
        }
        if (!TextInput.isConstraintsMatch(constraints, text)) {
            throw new IllegalArgumentException("TextInput: \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0442\u0435\u043a\u0441\u0442 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u043c \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f\u043c.");
        }
        int len = text.length();
        if (len > maxLength) {
            throw new IllegalArgumentException("TextInput: \u0434\u043b\u0438\u043d\u0430 \u0442\u0435\u043a\u0441\u0442\u0430 \u0431\u043e\u043b\u044c\u0448\u0435 \u0437\u0430\u0434\u0430\u043d\u043d\u043e\u0439 \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0439 \u0434\u043b\u0438\u043d\u044b.");
        }
        if (maxLength > charArrayLength) {
            maxLength = charArrayLength;
        }
        len = Math.min(len, maxLength);
        char[] chars = new char[charArrayLength];
        char[] content = new char[charArrayLength];
        if ((constraints & 0x10000) != 0) {
            TextInput.fillPasswordChars(chars);
        } else {
            text.getChars(0, len, chars, 0);
        }
        text.getChars(0, len, content, 0);
        this.length = len;
        this.chars = chars;
        this.maxLength = maxLength;
        this.constraints = constraints;
        this.content = content;
        this.mode = AvailableInputModes.getSystemInputMode();
    }

    public void clear() {
        this.length = 0;
        this.caretPosition = 0;
    }

    public void setText(String text) {
        this.setString(text);
    }

    public void append(String data) {
        if (data == null) {
            return;
        }
        this.insert(data, this.length);
    }

    public void append(char[] data, int offset, int length) {
        if (data == null) {
            return;
        }
        this.insert(data, offset, length, this.length);
    }

    public void append(int data, int radix, boolean upperCase) {
        int value;
        int i = 33;
        int len = 33;
        char[] c = new char[33];
        boolean negative = data < 0;
        int n = value = negative ? data : -data;
        if (radix < 2 || radix > 36) {
            radix = 10;
        }
        do {
            int digit;
            c[--i] = (char)((digit = -(value % radix)) < 10 ? digit + 48 : digit + (upperCase ? 55 : 87));
        } while ((value /= radix) != 0);
        if (negative) {
            c[--i] = 45;
        }
        this.insert(c, i, len - i, this.length);
    }

    public void insert(char src) {
        int curLength;
        int newLength;
        int constraints = this.constraints;
        if ((constraints & 0x20000) != 0 || (newLength = (curLength = this.length) + 1) > this.maxLength) {
            return;
        }
        char[] content = this.content;
        int apos = this.caretPosition;
        int bpos = apos + 1;
        int remLength = curLength - apos;
        if (remLength > 0) {
            Array.copy((char[])content, (int)apos, (char[])content, (int)bpos, (int)remLength);
        }
        content[apos] = src;
        if (!TextInput.isConstraintsMatch(constraints, content, 0, newLength)) {
            if (remLength > 0) {
                Array.copy((char[])content, (int)bpos, (char[])content, (int)apos, (int)remLength);
            }
            return;
        }
        if ((constraints & 0x10000) == 0 && newLength > 0) {
            Array.copy((char[])content, (int)0, (char[])this.chars, (int)0, (int)newLength);
        }
        this.length = newLength;
        this.changed = true;
        this.caretPosition = bpos;
    }

    public void insert(String src) {
        int curLength;
        int newLength;
        int length = src == null ? 0 : src.length();
        if (length == 0) {
            this.changed = true;
            return;
        }
        int constraints = this.constraints;
        if ((constraints & 0x20000) != 0 || (newLength = (curLength = this.length) + length) > this.maxLength) {
            return;
        }
        char[] content = this.content;
        int apos = this.caretPosition;
        int bpos = apos + length;
        int remLength = curLength - apos;
        if (remLength > 0) {
            Array.copy((char[])content, (int)apos, (char[])content, (int)bpos, (int)remLength);
        }
        src.getChars(0, length, content, apos);
        if (!TextInput.isConstraintsMatch(constraints, content, 0, newLength)) {
            if (remLength > 0) {
                Array.copy((char[])content, (int)bpos, (char[])content, (int)apos, (int)remLength);
            }
            return;
        }
        if ((constraints & 0x10000) == 0 && newLength > 0) {
            Array.copy((char[])content, (int)0, (char[])this.chars, (int)0, (int)newLength);
        }
        this.length = newLength;
        this.changed = true;
        this.caretPosition = bpos;
    }

    public void insert(String src, int position) {
        int constraints;
        if (src == null) {
            throw new NullPointerException("TextInput.insert: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int curLength = this.length;
        int length = src.length();
        int newLength = curLength + length;
        if (newLength > this.maxLength) {
            throw new IllegalArgumentException("TextInput.insert: \u0434\u043b\u0438\u043d\u0430 \u0442\u0435\u043a\u0441\u0442\u0430 \u0431\u043e\u043b\u044c\u0448\u0435 \u0437\u0430\u0434\u0430\u043d\u043d\u043e\u0439 \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0439 \u0434\u043b\u0438\u043d\u044b.");
        }
        char[] content = this.content;
        int apos = position < 0 ? 0 : (position > curLength ? curLength : position);
        int bpos = apos + length;
        int remLength = curLength - apos;
        if (remLength > 0) {
            Array.copy((char[])content, (int)apos, (char[])content, (int)bpos, (int)remLength);
        }
        if (length > 0) {
            src.getChars(0, length, content, apos);
        }
        if (!TextInput.isConstraintsMatch(constraints = this.constraints, content, 0, newLength)) {
            if (remLength > 0) {
                Array.copy((char[])content, (int)bpos, (char[])content, (int)apos, (int)remLength);
            }
            throw new IllegalArgumentException("TextInput.insert: \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0442\u0435\u043a\u0441\u0442 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u043c \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f\u043c.");
        }
        if ((constraints & 0x10000) == 0 && newLength > 0) {
            Array.copy((char[])content, (int)0, (char[])this.chars, (int)0, (int)newLength);
        }
        this.length = newLength;
    }

    public void insert(char[] src, int offset, int length, int position) {
        int constraints;
        if (src == null) {
            throw new NullPointerException("TextInput.insert: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = offset + length;
        int len = src.length;
        if (lim > len || lim < offset || offset > len || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("TextInput.insert: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int curLength = this.length;
        int newLength = curLength + length;
        if (newLength > this.maxLength) {
            throw new IllegalArgumentException("TextInput.insert: \u0434\u043b\u0438\u043d\u0430 \u0442\u0435\u043a\u0441\u0442\u0430 \u0431\u043e\u043b\u044c\u0448\u0435 \u0437\u0430\u0434\u0430\u043d\u043d\u043e\u0439 \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0439 \u0434\u043b\u0438\u043d\u044b.");
        }
        char[] content = this.content;
        int apos = position < 0 ? 0 : (position > curLength ? curLength : position);
        int bpos = apos + length;
        int remLength = curLength - apos;
        if (remLength > 0) {
            Array.copy((char[])content, (int)apos, (char[])content, (int)bpos, (int)remLength);
        }
        if (length > 0) {
            Array.copy((char[])src, (int)offset, (char[])content, (int)apos, (int)length);
        }
        if (!TextInput.isConstraintsMatch(constraints = this.constraints, content, 0, newLength)) {
            if (remLength > 0) {
                Array.copy((char[])content, (int)bpos, (char[])content, (int)apos, (int)remLength);
            }
            throw new IllegalArgumentException("TextInput.insert: \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0442\u0435\u043a\u0441\u0442 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u043c \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f\u043c.");
        }
        if ((constraints & 0x10000) == 0 && newLength > 0) {
            Array.copy((char[])content, (int)0, (char[])this.chars, (int)0, (int)newLength);
        }
        this.length = newLength;
    }

    public void delete(int offset, int length) {
        int newLength;
        int lim = offset + length;
        int len = this.length;
        if (lim > len || lim < offset || offset > len || offset < 0) {
            throw new StringIndexOutOfBoundsException("TextInput.delete: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int curLength = len;
        char[] content = this.content;
        int apos = offset;
        int bpos = apos + length;
        int remLength = len - bpos;
        if (remLength > 0) {
            Array.copy((char[])content, (int)bpos, (char[])content, (int)apos, (int)remLength);
        }
        if (this.caretPosition > (newLength = curLength - length)) {
            this.caretPosition = newLength;
        }
        if ((this.constraints & 0x10000) == 0 && newLength > 0) {
            Array.copy((char[])content, (int)0, (char[])this.chars, (int)0, (int)newLength);
        }
        this.length = newLength;
    }

    public void setString(String src) {
        int newLength;
        if (src == null) {
            src = "";
        }
        if ((newLength = src.length()) > this.maxLength) {
            throw new IllegalArgumentException("TextInput.setString: \u0434\u043b\u0438\u043d\u0430 \u0442\u0435\u043a\u0441\u0442\u0430 \u0431\u043e\u043b\u044c\u0448\u0435 \u0437\u0430\u0434\u0430\u043d\u043d\u043e\u0439 \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0439 \u0434\u043b\u0438\u043d\u044b.");
        }
        int constraints = this.constraints;
        if (!TextInput.isConstraintsMatch(constraints, src)) {
            throw new IllegalArgumentException("TextInput.setString: \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0442\u0435\u043a\u0441\u0442 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u043c \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f\u043c.");
        }
        if (newLength > 0) {
            src.getChars(0, newLength, this.content, 0);
        }
        if (this.caretPosition > newLength) {
            this.caretPosition = newLength;
        }
        if ((constraints & 0x10000) == 0 && newLength > 0) {
            src.getChars(0, newLength, this.chars, 0);
        }
        this.length = newLength;
    }

    public void setChars(char[] src, int offset, int length) {
        if (src == null) {
            this.setString(null);
            return;
        }
        int lim = offset + length;
        int len = src.length;
        if (lim > len || lim < offset || offset > len || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("TextInput.setChars: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        char[] tmp = new char[length];
        Array.copy((char[])src, (int)offset, (char[])tmp, (int)0, (int)length);
        int newLength = length;
        if (newLength > this.maxLength) {
            throw new IllegalArgumentException("TextInput.setChars: \u0434\u043b\u0438\u043d\u0430 \u0442\u0435\u043a\u0441\u0442\u0430 \u0431\u043e\u043b\u044c\u0448\u0435 \u0437\u0430\u0434\u0430\u043d\u043d\u043e\u0439 \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0439 \u0434\u043b\u0438\u043d\u044b.");
        }
        int constraints = this.constraints;
        if (!TextInput.isConstraintsMatch(constraints, tmp, 0, newLength)) {
            throw new IllegalArgumentException("TextInput.setChars: \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0442\u0435\u043a\u0441\u0442 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u043c \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f\u043c.");
        }
        if (newLength > 0) {
            Array.copy((char[])tmp, (int)0, (char[])this.content, (int)0, (int)newLength);
        }
        if (this.caretPosition > newLength) {
            this.caretPosition = newLength;
        }
        if ((constraints & 0x10000) == 0 && newLength > 0) {
            Array.copy((char[])tmp, (int)0, (char[])this.chars, (int)0, (int)newLength);
        }
        this.length = newLength;
    }

    public void setConstraints(int constraints) {
        int oldConstraints = this.constraints;
        if (oldConstraints == constraints) {
            return;
        }
        if (!TextInput.isConstraintsValid(constraints)) {
            throw new IllegalArgumentException("TextInput.setConstraints: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 constraints.");
        }
        char[] content = this.content;
        int len = this.length;
        if (!TextInput.isConstraintsMatch(constraints, this.content, 0, len)) {
            len = 0;
            this.length = 0;
            this.caretPosition = 0;
        }
        if ((oldConstraints & 0x10000) == 0 && (constraints & 0x10000) != 0) {
            TextInput.fillPasswordChars(this.chars);
        }
        if ((oldConstraints & 0x10000) != 0 && (constraints & 0x10000) == 0 && len > 0) {
            Array.copy((char[])content, (int)0, (char[])this.chars, (int)0, (int)len);
        }
        this.constraints = constraints;
    }

    public void setInitialInputMode(String characterSubset) {
        this.mode = AvailableInputModes.getInputMode(characterSubset);
    }

    public int setMaxSize(int maxLength) {
        if (maxLength <= 0) {
            throw new IllegalArgumentException("TextInput.setMaxSize: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 maxLength.");
        }
        int tmp = this.content.length;
        if (maxLength > tmp) {
            maxLength = tmp;
        }
        if (this.caretPosition > maxLength) {
            this.caretPosition = maxLength;
        }
        if (this.length > maxLength) {
            this.length = maxLength;
        }
        this.maxLength = maxLength;
        return this.maxLength;
    }

    public int size() {
        return this.length;
    }

    public int getChars(char[] dst) {
        if (dst == null) {
            throw new NullPointerException("TextInput.getChars: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int result = this.length;
        if (dst.length < result) {
            throw new ArrayIndexOutOfBoundsException("TextInput.getChars: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 dst \u0438\u043c\u0435\u0435\u0442 \u043c\u0430\u043b\u0435\u043d\u044c\u043a\u0443\u044e \u0434\u043b\u0438\u043d\u0443, \u043d\u0435 \u043f\u043e\u0437\u0432\u043e\u043b\u044f\u044e\u0449\u0443\u044e \u0443\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u0432\u0441\u0435 \u0441\u0438\u043c\u0432\u043e\u043b\u044b.");
        }
        Array.copy((char[])this.content, (int)0, (char[])dst, (int)0, (int)result);
        return result;
    }

    public int getConstraints() {
        return this.constraints;
    }

    public int getCaretPosition() {
        return this.caretPosition;
    }

    public int getMaxSize() {
        return this.maxLength;
    }

    public String getString() {
        return new String(this.content, 0, this.length).intern();
    }

    public void keyPressed(int key, int charCode) {
        InputMode mode;
        this.changed = false;
        switch (key) {
            case 9: {
                return;
            }
            case 16: 
            case 160: 
            case 161: {
                this.shiftPressed = true;
                return;
            }
            case 8: {
                int tmp;
                if ((this.constraints & 0x20000) == 0 && (tmp = this.caretPosition) > 0) {
                    this.changed = true;
                    this.caretPosition = --tmp;
                    this.delete(tmp, 1);
                }
                return;
            }
            case 13: {
                this.insert('\n');
                return;
            }
        }
        if ((this.constraints & 0x20000) == 0 && charCode > 0 && (mode = this.mode) != null) {
            boolean shift = this.shiftPressed;
            mode.keyPressedHandle(shift, shift ^ TextInput.isCapsLockPressed(), key, charCode, this);
        }
    }

    public void keyReleased(int key) {
        switch (key) {
            case 16: 
            case 160: 
            case 161: {
                this.shiftPressed = false;
            }
        }
    }

    public void setCaretPosition(int caretPosition) {
        int tmp;
        this.caretPosition = caretPosition < 0 ? 0 : (caretPosition > (tmp = this.length) ? tmp : caretPosition);
    }

    public void setInputMode(InputMode mode) {
        this.mode = mode == null ? AvailableInputModes.getSystemInputMode() : mode;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public int getCaretLine() {
        return this.getLineAt(this.caretPosition);
    }

    public InputMode getInputMode() {
        return this.mode;
    }

    public class AdditionalCapabilities
    implements CommandListener {
        private CharList[] screensWithChars = new CharList[TextInput.access$0().length];
        private List screenSelectCharset;
        private List screenSelectLanguage;
        private Displayable sourceScreen;
        private CharDestination destination;
        private CommandListener listener;
        private Command back;
        private Command insert;

        public AdditionalCapabilities(CharDestination destination) {
            this.destination = destination;
            this.listener = new InputCommandHandler(this);
        }

        public void commandAction(Command command, Displayable screen) {
            Display display = MIDletProxy.getInstance().getEmulatorScreen();
            Command[] additional = ADDITIONAL_CAPABILITIES_COMMANDS;
            if (command == additional[0]) {
                this.sourceScreen = screen;
                display.setCurrent(this.getScreenSelectCharset());
                return;
            }
            if (command == additional[1]) {
                this.destination.insert('\n');
                return;
            }
            if (command == additional[2]) {
                this.sourceScreen = screen;
                display.setCurrent(this.getScreenSelectLanguage());
                return;
            }
            if (command == additional[3]) {
                String content = TextInput.this.getString();
                if (content.length() > 0) {
                    CLIP_BOARD = content;
                }
                return;
            }
            if (command == additional[4]) {
                this.destination.insert(CLIP_BOARD);
                return;
            }
            List list = this.screenSelectCharset;
            if (screen == list) {
                if (command == List.SELECT_COMMAND) {
                    display.setCurrent(this.getScreenWithChars(list.getSelectedIndex()));
                    return;
                }
                if (command == this.back) {
                    Displayable source = this.sourceScreen;
                    if (source != null && source.isSystem()) {
                        display.setCurrent(source);
                    } else {
                        display.hideSystemScreen();
                    }
                    this.sourceScreen = null;
                }
                return;
            }
            list = this.screenSelectLanguage;
            if (screen == list) {
                if (command == List.SELECT_COMMAND) {
                    TextInput.this.setInputMode(AvailableInputModes.getInputModeAt(list.getSelectedIndex()));
                    Displayable source = this.sourceScreen;
                    if (source != null && source.isSystem()) {
                        display.setCurrent(source);
                    } else {
                        display.hideSystemScreen();
                    }
                    this.sourceScreen = null;
                    return;
                }
                if (command == this.back) {
                    Displayable source = this.sourceScreen;
                    if (source != null && source.isSystem()) {
                        display.setCurrent(source);
                    } else {
                        display.hideSystemScreen();
                    }
                    this.sourceScreen = null;
                }
                return;
            }
            if (screen instanceof CharList) {
                if (command == this.insert) {
                    CharList charList = (CharList)screen;
                    this.destination.insert(charList.getChar(charList.getSelectedIndex()));
                    return;
                }
                if (command == this.back) {
                    display.setCurrent(this.getScreenSelectCharset());
                }
            }
        }

        private Command getBack() {
            Command result = this.back;
            if (result == null) {
                result = this.back = new Command("\u041d\u0430\u0437\u0430\u0434", 2, 0);
            }
            return result;
        }

        private Command getInsert() {
            Command result = this.insert;
            if (result == null) {
                result = this.insert = new Command("\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c", 4, 0);
            }
            return result;
        }

        private List getScreenSelectCharset() {
            List result = this.screenSelectCharset;
            if (result == null) {
                String title = "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043d\u0430\u0431\u043e\u0440 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432:";
                Command[] commands = new Command[]{this.getBack()};
                result = this.screenSelectCharset = new List(false, title, null, commands, List.SELECT_COMMAND, this.listener, 3, CHARACTER_SUBSETS_NAMES, null);
            }
            return result;
        }

        private List getScreenSelectLanguage() {
            List result = this.screenSelectLanguage;
            if (result == null) {
                String title = "\u042f\u0437\u044b\u043a \u0432\u0432\u043e\u0434\u0430";
                Command[] commands = new Command[]{this.getBack()};
                result = this.screenSelectLanguage = new List(false, title, null, commands, List.SELECT_COMMAND, this.listener, 3, new String[0], null);
                int i = 0;
                while (i < AvailableInputModes.getCount()) {
                    result.append(AvailableInputModes.getInputModeAt(i).getLocalizedName(), null);
                    ++i;
                }
            }
            return result;
        }

        private CharList getScreenWithChars(int index) {
            CharList[] screens = this.screensWithChars;
            CharList result = this.screensWithChars[index];
            if (result == null) {
                String title = CHARACTER_SUBSETS_NAMES[index];
                Command[] commands = new Command[]{this.getBack()};
                result = screens[index] = new CharList(false, title, null, commands, this.getInsert(), this.listener, CHARACTER_SUBSETS_CHARS[index]);
            }
            return result;
        }
    }

    private static final class InputCommandHandler
    extends WeakReference
    implements CommandListener {
        InputCommandHandler(CommandListener thisListener) {
            super(thisListener);
        }

        public void commandAction(Command command, Displayable screen) {
            CommandListener thisListener = (CommandListener)this.get();
            if (thisListener == null) {
                return;
            }
            thisListener.commandAction(command, screen);
        }
    }
}

