/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandEnumeration;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.MIDletProxy;
import javax.microedition.lcdui.Ticker;
import malik.emulator.media.graphics.RasterCanvas;

public abstract class Displayable {
    static final int ALL = -1;
    static final int TITLE = 1;
    static final int TICKER = 2;
    static final int CLIENT = 4;
    static final int COMMANDS = 8;
    static final int GUI_ELEMENT_TITLE = 0;
    static final int GUI_ELEMENT_TICKER = 1;
    static final int GUI_ELEMENT_CLIENT = 2;
    static final int GUI_ELEMENT_COMMANDS = 3;
    static final int MODE_WITHOUT_TICKER = 0;
    static final int MODE_WITH_TICKER = 1;
    static final int MODE_FULL_SCREEN = 2;
    private static final int MENU_SPIN_WIDTH = 16;
    private static final int MENU_SPIN_HEIGHT = 16;
    private static final int MENU_MAX_ELEMENTS = 7;
    private static final int MENU_OUTER_MARGIN = 4;
    private static final int MENU_INNER_MARGIN = 6;
    private static final int[] DEVICE_KEYS_FOR_COMMANDS;
    private static final int[] COMMAND_TYPES_FOR_SOFT2;
    private static final Command[] MENU_PANEL_COMMANDS;
    private static final Command MENU;
    private static final Command BACK;
    private static final Command SELECT;
    private static final TickerScrolling TICKER_SCROLLING;
    private boolean system;
    private boolean needSizeChanged;
    private boolean staySizeChanged;
    private boolean menuOpened;
    private int menuFirstIndex;
    private int menuSelectedIndex;
    private int mode;
    private int repaintElements;
    private int commandFocused;
    private int commandPressed;
    private int commandsCount;
    private Command[] commandsInScreen;
    private Command[] commandsOnPanel;
    private Command[] commandsOnMenu;
    private Command defaultCommand;
    private CommandListener listener;
    private CommandEnumeration commandsEnumeration;
    private Ticker ticker;
    private String title;
    private Object lock;

    static {
        Command menu = new Command("\u041c\u0435\u043d\u044e", 1, 0);
        Command back = new Command("\u041d\u0430\u0437\u0430\u0434", 2, 0);
        Command select = new Command("\u0412\u044b\u0431\u0440\u0430\u0442\u044c", 4, 0);
        DEVICE_KEYS_FOR_COMMANDS = new int[]{37, 43, 39};
        COMMAND_TYPES_FOR_SOFT2 = new int[]{2, 3, 6, 7};
        Command[] commandArray = new Command[3];
        commandArray[1] = select;
        commandArray[2] = back;
        MENU_PANEL_COMMANDS = commandArray;
        MENU = menu;
        BACK = back;
        SELECT = select;
        TICKER_SCROLLING = new TickerScrolling();
    }

    static void tickerStart() {
        new Thread((Runnable)TICKER_SCROLLING, "\u041f\u0440\u043e\u043a\u0440\u0443\u0442\u043a\u0430 \u0431\u0435\u0433\u0443\u0449\u0438\u0445 \u0441\u0442\u0440\u043e\u043a").start();
    }

    static void tickerStop() {
        TICKER_SCROLLING.terminate();
    }

    static void tickerUpdate() {
        TICKER_SCROLLING.update();
    }

    static Command[] addCommand(Command[] list, int count, Command command) {
        int c;
        if (command == null) {
            return null;
        }
        if (list == null || (c = list.length) == 0) {
            count = 0;
            list = new Command[3];
        } else {
            int i = count;
            while (i-- > 0) {
                if (list[i] != command) continue;
                return null;
            }
            if (count == c) {
                Object[] objectArray = list;
                list = new Command[(c << 1) + 1];
                Array.copy((Object[])objectArray, (int)0, (Object[])list, (int)0, (int)c);
            }
        }
        list[count] = command;
        return list;
    }

    static Command[] removeCommand(Command[] list, int count, Command command) {
        if (command == null) {
            return null;
        }
        int i = list == null || list.length <= 0 ? 0 : count;
        while (i-- > 0) {
            int c;
            if (list[i] != command) continue;
            if ((c = --count - i) > 0) {
                Array.copy((Object[])list, (int)(i + 1), (Object[])list, (int)i, (int)c);
            }
            list[count] = null;
            return list;
        }
        return null;
    }

    static Command[] concatCommands(Command[] list1, Command[] list2) {
        int len2;
        int len1 = list1 == null ? 0 : list1.length;
        int n = len2 = list2 == null ? 0 : list2.length;
        if (len1 <= 0) {
            return list2;
        }
        if (len2 <= 0) {
            return list1;
        }
        Object[] result = new Command[len1 + len2];
        Array.copy((Object[])list1, (int)0, (Object[])result, (int)0, (int)len1);
        Array.copy((Object[])list2, (int)0, (Object[])result, (int)len1, (int)len2);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    static String truncate(String text, Font font, int width) {
        char[] c;
        int len;
        if (text == null || (len = text.length()) <= 0) {
            return "";
        }
        if (width < 0) {
            return text;
        }
        if (font == null) {
            font = Font.getDefaultFont();
        }
        int pos = len;
        int i = 0;
        while (i < len) {
            if (text.charAt(i) < ' ') {
                pos = i;
                break;
            }
            ++i;
        }
        if (pos < len) {
            len = pos + 1;
            c = new char[len];
            text.getChars(0, pos, c, 0);
            c[pos] = 8230;
        } else {
            if (font.stringWidth(text) <= width) {
                return text;
            }
            char[] cArray = text.toCharArray();
            c = cArray;
            cArray[len - 1] = 8230;
        }
        while (len > 1 && font.charsWidth(c, 0, len) > width) {
            c[--len - 1] = 8230;
        }
        return new String(c, 0, len).intern();
    }

    private static Command findCommand(CommandEnumeration enumeration, int type, Command ignore) {
        Command result = null;
        int priority = Integer.MAX_VALUE;
        int i = enumeration.getCommandsCount();
        while (i-- > 0) {
            int p;
            Command command = enumeration.getCommand(i);
            if (command == null || command == ignore || command.getRealType() != type || (p = command.getRealPriority()) > priority) continue;
            result = command;
            priority = p;
        }
        return result;
    }

    Displayable(boolean system, boolean fullScreenMode, String title, Ticker ticker, Command[] commands, Command defaultCommand, CommandListener listener) {
        Object[] c = null;
        int len = commands == null ? 0 : commands.length;
        if (len > 0) {
            c = new Command[len];
            Array.copy((Object[])commands, (int)0, (Object[])c, (int)0, (int)len);
            int i = defaultCommand != null ? -1 : 0;
            while (i < len) {
                Object cmd = i < 0 ? defaultCommand : c[i];
                if (cmd == null && i >= 0) {
                    throw new NullPointerException("Displayable: \u043e\u0434\u0438\u043d \u0438\u0437 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u0430 commands \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
                }
                int j = i + 1;
                while (j < len) {
                    if (c[j] == cmd) {
                        throw new IllegalArgumentException("Displayable: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 commands \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0440\u0430\u0432\u043d\u044b\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b \u0438\u043b\u0438 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b, \u0440\u0430\u0432\u043d\u044b\u0435 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u0443 defaultCommand.");
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.system = system;
        this.needSizeChanged = true;
        this.mode = fullScreenMode && listener == null ? 2 : (ticker != null ? 1 : 0);
        this.commandFocused = -1;
        this.commandPressed = -1;
        this.commandsCount = len;
        this.commandsInScreen = c;
        this.commandsOnPanel = new Command[3];
        this.defaultCommand = defaultCommand;
        this.listener = listener;
        this.commandsEnumeration = new CommandEnumerator();
        this.ticker = ticker;
        this.title = title;
        this.lock = new Object();
        this.placeCommandsNeedRepaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommand(Command command) {
        if (command == null) {
            throw new NullPointerException("Displayable.addCommand: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 command \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        boolean changed = false;
        Object object = this.lock;
        synchronized (object) {
            int len;
            Command[] c;
            if (command != this.defaultCommand && (c = Displayable.addCommand(this.commandsInScreen, len = this.commandsCount, command)) != null) {
                this.commandsCount = len + 1;
                this.commandsInScreen = c;
                changed = true;
            }
        }
        if (changed) {
            this.updateCommands();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCommand(Command command) {
        if (command == null) {
            return;
        }
        boolean changed = false;
        Object object = this.lock;
        synchronized (object) {
            if (command == this.defaultCommand) {
                this.defaultCommand = null;
                changed = true;
            } else {
                int len = this.commandsCount;
                Command[] c = Displayable.removeCommand(this.commandsInScreen, len, command);
                if (c != null) {
                    this.commandsCount = len - 1;
                    this.commandsInScreen = c;
                    changed = true;
                }
            }
        }
        if (changed) {
            this.updateCommands();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCommandListener(CommandListener listener) {
        boolean changedmode;
        this.listener = listener;
        if (listener == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.mode = this.ticker != null ? 1 : 0;
            changedmode = this.mode != this.mode;
        }
        if (changedmode) {
            Displayable.tickerUpdate();
            this.callSeriallySizeChanged();
            this.callSeriallyMenuClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTitle(String title) {
        boolean changed = false;
        Object object = this.lock;
        synchronized (object) {
            String current = this.title;
            if (title == null || title.length() <= 0 ? current != null && current.length() > 0 : current == null || current.length() <= 0 || !current.equals(title)) {
                this.title = title;
                changed = true;
            }
        }
        if (changed) {
            this.callSeriallyPaintScreen(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTicker(Ticker ticker) {
        boolean changed = false;
        boolean changedmode = false;
        Object object = this.lock;
        synchronized (object) {
            if (ticker != this.ticker) {
                this.ticker = ticker;
                int currmode = this.mode;
                changedmode = currmode != 2 && currmode != (this.mode = ticker != null ? 1 : 0);
                changed = true;
            }
        }
        if (changed) {
            Displayable.tickerUpdate();
            if (changedmode) {
                this.callSeriallySizeChanged();
            }
            this.callSeriallyPaintScreen(ticker != null ? (changedmode ? 6 : 2) : 4);
        }
    }

    public boolean isShown() {
        return MIDletProxy.getInstance().getEmulatorScreen().isShown(this);
    }

    public int getWidth() {
        return this.getClientWidth();
    }

    public int getHeight() {
        return this.getClientHeight();
    }

    public String getTitle() {
        return this.title;
    }

    public Ticker getTicker() {
        return this.ticker;
    }

    public final boolean isSystem() {
        return this.system;
    }

    protected void sizeChanged(int width, int height) {
    }

    abstract void paint(Graphics var1);

    void paintTitle(Graphics render, int width, int height, String title) {
        render.setColor(RasterCanvas.getSystemColor((int)9));
        render.drawElementOfGUI(6, 1, 0, 0, 0, width, height);
        render.drawString(title, 2, 2, 0);
    }

    void paintTicker(Graphics render, int width, int height, Ticker ticker) {
        render.setColor(RasterCanvas.getSystemColor((int)41));
        render.drawElementOfGUI(13, 0, 0, 0, 0, width, height);
        render.drawString(ticker.getDisplayedText(), ticker.getPosition(), 2, 0);
    }

    void paintClient(Graphics render, int width, int height, int clipLeft, int clipTop, int clipWidth, int clipHeight) {
        Display display = MIDletProxy.getInstance().getEmulatorScreen();
        int x = display.getGUIElementLeft(this, 2);
        int y = this.mode == 2 ? display.getGUIElementTop(this, 2) : display.getGUIElementTop(this, 0) + display.getGUIElementHeight(this, 0);
        render.drawElementOfGUI(6, 5, 0, x - render.getTranslateX(), y - render.getTranslateY(), display.getWidth() - x, display.getHeight() - y);
        Graphics clientRender = this.getClientContext();
        clientRender.reset();
        clientRender.translate(this.getClientLeft(), this.getClientTop());
        clientRender.setClip(clipLeft, clipTop, clipWidth, clipHeight);
        this.paint(clientRender);
    }

    void paintCommands(Graphics render, int width, int height, Command[] commands, int pressedIndex, Font defaultCommandFont) {
        Display display = MIDletProxy.getInstance().getEmulatorScreen();
        int x = display.getGUIElementLeft(this, 2);
        int y = this.mode == 2 ? display.getGUIElementTop(this, 2) : display.getGUIElementTop(this, 0) + display.getGUIElementHeight(this, 0);
        render.drawElementOfGUI(6, 5, 0, x - render.getTranslateX(), y - render.getTranslateY(), display.getWidth() - x, display.getHeight() - y);
        int q3 = width;
        int q1 = width / 3;
        int q2 = q3 - q1;
        this.paintCommand(render, 0, 0, q1, height, commands[0], false, pressedIndex == 0);
        this.paintCommand(render, q2, 0, q3 - q2, height, commands[2], false, pressedIndex == 2);
        render.setFont(defaultCommandFont);
        this.paintCommand(render, q1, 0, q2 - q1, height, commands[1], true, pressedIndex == 1);
    }

    void paintCommand(Graphics render, int left, int top, int width, int height, Command command, boolean asDefault, boolean asPressed) {
        if (command == null) {
            return;
        }
        int ofs = asPressed ? 1 : (asDefault ? 3 : 0);
        render.drawElementOfGUI(4, ofs, 0, left, top, width, height);
        render.setColor(RasterCanvas.getSystemColor((int)(36 + ofs)));
        render.drawString(command.getTruncatedLabel(render.getFont(), width - 4), left + width / 2 + (asPressed ? 1 : 0), top + (asDefault ? -1 : 1) + (asPressed ? 3 : 2), 17);
    }

    void onShow() {
    }

    void onHide() {
    }

    void onSizeChanged(int width, int height) {
        this.sizeChanged(width, height);
    }

    void onKeyPressed(int key, int charCode) {
        int i = this.getCommandUnderKey(key);
        Command[] c = this.commandsOnPanel;
        if (i < 0 || i >= c.length || c[i] == null) {
            return;
        }
        this.commandPressed = i;
        this.callSeriallyPaintScreen(8);
    }

    void onKeyRepeated(int key, int charCode) {
    }

    void onKeyReleased(int key) {
        Command command;
        int i = this.commandPressed;
        if (i < 0) {
            return;
        }
        this.commandPressed = -1;
        this.callSeriallyPaintScreen(8);
        if (i != this.getCommandUnderKey(key) || (command = this.commandsOnPanel[i]) == null) {
            return;
        }
        this.callSeriallyCommandAction(command);
    }

    void onPointerPressed(int x, int y, int button) {
        if (button != 0) {
            return;
        }
        int i = this.getCommandUnderPointer(x, y);
        Command[] c = this.commandsOnPanel;
        if (i < 0 || i >= c.length || c[i] == null) {
            return;
        }
        this.commandPressed = this.commandFocused = i;
        this.callSeriallyPaintScreen(8);
    }

    void onPointerDragged(int x, int y) {
        int f = this.commandFocused;
        if (f < 0 || this.commandPressed == (this.commandPressed = this.getCommandUnderPointer(x, y) != f ? -1 : f)) {
            return;
        }
        this.callSeriallyPaintScreen(8);
    }

    void onPointerReleased(int x, int y, int button) {
        if (button != 0) {
            return;
        }
        int i = this.commandPressed;
        this.commandFocused = -1;
        this.commandPressed = -1;
        if (i < 0) {
            return;
        }
        this.callSeriallyPaintScreen(8);
        Command command = this.commandsOnPanel[i];
        if (command == null) {
            return;
        }
        this.callSeriallyCommandAction(command);
    }

    void onPaint(Graphics render, int guiElements, int clipLeft, int clipTop, int clipWidth, int clipHeight) {
        int height;
        int width;
        Display display = MIDletProxy.getInstance().getEmulatorScreen();
        int mode = this.mode;
        if (mode != 2) {
            Ticker ticker;
            if ((guiElements & 1) != 0) {
                render.translate(display.getGUIElementLeft(this, 0), display.getGUIElementTop(this, 0));
                width = display.getGUIElementWidth(this, 0);
                height = display.getGUIElementHeight(this, 0);
                render.setFont(this.getGUIElementFont(0));
                render.setClip(0, 0, width, height);
                this.paintTitle(render, width, height, this.getDisplayedTitle(this.title));
                render.reset();
            }
            if ((guiElements & 2) != 0 && mode == 1 && (ticker = this.ticker) != null) {
                render.translate(display.getGUIElementLeft(this, 1), display.getGUIElementTop(this, 1));
                width = display.getGUIElementWidth(this, 1);
                height = display.getGUIElementHeight(this, 1);
                render.setFont(this.getGUIElementFont(1));
                render.setClip(0, 0, width, height);
                this.paintTicker(render, width, height, ticker);
                render.reset();
            }
            if ((guiElements & 8) != 0) {
                render.translate(display.getGUIElementLeft(this, 3), display.getGUIElementTop(this, 3));
                width = display.getGUIElementWidth(this, 3);
                height = display.getGUIElementHeight(this, 3);
                render.setFont(this.getGUIElementFont(3));
                render.setClip(0, 0, width, height);
                this.paintCommands(render, width, height, this.commandsOnPanel, this.commandPressed, this.getDefaultCommandFont());
                render.reset();
            }
        }
        if ((guiElements & 4) != 0) {
            render.translate(display.getGUIElementLeft(this, 2), display.getGUIElementTop(this, 2));
            width = display.getGUIElementWidth(this, 2);
            height = display.getGUIElementHeight(this, 2);
            render.setFont(this.getGUIElementFont(2));
            render.setClip(0, 0, width, height);
            this.paintClient(render, width, height, clipLeft, clipTop, clipWidth, clipHeight);
        }
    }

    void onCommandAction(Command command) {
        if (command == MENU) {
            this.menuOpened = true;
            this.callSeriallyPaintScreen();
            return;
        }
        if (command == BACK) {
            this.menuOpened = false;
            this.callSeriallyPaintScreen();
            return;
        }
        if (command == SELECT) {
            int i;
            this.menuOpened = false;
            this.callSeriallyPaintScreen();
            Command[] c = this.commandsOnMenu;
            if (this.commandsOnMenu == null || (i = this.menuSelectedIndex) < 0 || i >= c.length || (command = c[i]) == null) {
                return;
            }
            this.callSeriallyCommandAction(command);
            return;
        }
        CommandListener listener = this.listener;
        if (listener != null) {
            listener.commandAction(command, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDefaultCommand(Command command) {
        boolean changed = false;
        Object object = this.lock;
        synchronized (object) {
            if (command != this.defaultCommand) {
                this.defaultCommand = command;
                changed = true;
            }
        }
        if (changed) {
            this.updateCommands();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFullScreenMode(boolean fullScreenMode) {
        boolean changedmode;
        Object object = this.lock;
        synchronized (object) {
            this.mode = fullScreenMode && this.listener == null ? 2 : (this.ticker != null ? 1 : 0);
            changedmode = this.mode != this.mode;
        }
        if (changedmode) {
            Displayable.tickerUpdate();
            this.callSeriallySizeChanged();
            this.callSeriallyMenuClose();
        }
    }

    boolean keyHandling(int key) {
        return this.getCommandUnderKey(key) >= 0;
    }

    boolean coordinateHandling(int x, int y) {
        return this.getCommandUnderPointer(x, y) >= 0;
    }

    int getPanelCommandIndex(int x, int y, int width, int height) {
        int q1 = width / 3;
        int q2 = width - q1;
        return x >= q2 && x < width ? 2 : (x >= q1 && x < q2 ? 1 : (x >= 0 && x < q1 ? 0 : -1));
    }

    int getClientLeft() {
        return 0;
    }

    int getClientTop() {
        return 0;
    }

    int getClientWidth() {
        return MIDletProxy.getInstance().getEmulatorScreen().getGUIElementWidth(this, 2);
    }

    int getClientHeight() {
        return MIDletProxy.getInstance().getEmulatorScreen().getGUIElementHeight(this, 2);
    }

    Font getGUIElementFont(int guiElement) {
        return MIDletProxy.getInstance().getEmulatorScreen().getGUIElementFont(guiElement);
    }

    Font getDefaultCommandFont() {
        return MIDletProxy.getInstance().getEmulatorScreen().getDefaultCommandFont();
    }

    CommandEnumeration getCommands() {
        return this.commandsEnumeration;
    }

    final void eventShow() {
        if (this.needSizeChanged) {
            this.callSeriallySizeChanged();
        }
        this.menuOpened = false;
        this.repaintElements = -1;
        this.commandFocused = -1;
        this.commandPressed = -1;
        this.onShow();
    }

    final void eventHide() {
        this.menuOpened = false;
        this.onHide();
    }

    final void eventKeyPressed(int key, int charCode) {
        if (this.menuOpened) {
            this.menuKeyPressed(key);
            return;
        }
        this.onKeyPressed(key, charCode);
    }

    final void eventKeyRepeated(int key, int charCode) {
        if (this.menuOpened) {
            this.menuKeyRepeated(key);
            return;
        }
        this.onKeyRepeated(key, charCode);
    }

    final void eventKeyReleased(int key) {
        if (this.menuOpened) {
            this.menuKeyReleased(key);
            return;
        }
        this.onKeyReleased(key);
    }

    final void eventPointerPressed(int x, int y, int button) {
        if (this.menuOpened) {
            this.menuPointerPressed(x, y, button);
            return;
        }
        this.onPointerPressed(x, y, button);
    }

    final void eventPointerDragged(int x, int y) {
        if (this.menuOpened) {
            this.menuPointerDragged(x, y);
            return;
        }
        this.onPointerDragged(x, y);
    }

    final void eventPointerReleased(int x, int y, int button) {
        if (this.menuOpened) {
            this.menuPointerReleased(x, y, button);
            return;
        }
        this.onPointerReleased(x, y, button);
    }

    final void eventPaint(Graphics render, int guiElements) {
        this.eventPaint(render, guiElements, 0, 0, this.getClientWidth(), this.getClientHeight());
    }

    final void eventPaint(Graphics render, int guiElements, int clipLeft, int clipTop, int clipWidth, int clipHeight) {
        if (this.menuOpened) {
            this.menuPaint(render, guiElements, clipLeft, clipTop, clipWidth, clipHeight);
            return;
        }
        this.onPaint(render, guiElements, clipLeft, clipTop, clipWidth, clipHeight);
    }

    final void callSerially(Runnable event) {
        MIDletProxy.getInstance().getEmulatorScreen().callSeriallyEvent(this, event);
    }

    final void callSeriallySizeChanged() {
        if (!this.staySizeChanged) {
            this.staySizeChanged = true;
            this.callSerially(new SizeChangedEvent());
        }
    }

    final void callSeriallyPaintScreen() {
        int rge = this.repaintElements;
        this.repaintElements = rge | 0xFFFFFFFF;
        if (rge == 0) {
            MIDletProxy.getInstance().getEmulatorScreen().callSeriallyPaint(this);
        }
    }

    final void callSeriallyPaintScreen(int guiElements) {
        int rge = this.repaintElements;
        this.repaintElements = rge | guiElements;
        if (rge == 0) {
            MIDletProxy.getInstance().getEmulatorScreen().callSeriallyPaint(this);
        }
    }

    final void callSeriallyPaintClient(int left, int top, int width, int height) {
        this.repaintElements |= 4;
        MIDletProxy.getInstance().getEmulatorScreen().callSeriallyPaint(this, left, top, width, height);
    }

    final void callSeriallyCommandAction(Command command) {
        Displayable displayable = this;
        displayable.getClass();
        this.callSerially(displayable.new CommandActionEvent(command));
    }

    final void clearRepaintElements() {
        this.repaintElements = 0;
    }

    final void updateCommands() {
        if (this.placeCommandsNeedRepaint()) {
            this.callSeriallyPaintScreen(this.menuOpened ? 4 : 8);
        }
    }

    final boolean isReallyShown() {
        return MIDletProxy.getInstance().getEmulatorScreen().isShown(this);
    }

    final int getMode() {
        return this.mode;
    }

    final int getRepaintElements() {
        return this.repaintElements;
    }

    final Graphics getClientContext() {
        return MIDletProxy.getInstance().getEmulatorScreen().getClientGraphicsFor(this);
    }

    final Object getCommandsMonitor() {
        return this.lock;
    }

    private void menuKeyPressed(int key) {
        if (this.menuMoveCursor(key)) {
            return;
        }
        int i = this.getCommandUnderKey(key);
        Command[] c = MENU_PANEL_COMMANDS;
        if (i < 0 || i >= c.length || c[i] == null) {
            return;
        }
        this.commandPressed = i;
        this.callSeriallyPaintScreen(8);
    }

    private void menuKeyRepeated(int key) {
        this.menuMoveCursor(key);
    }

    private void menuKeyReleased(int key) {
        Command command;
        int i = this.commandPressed;
        if (i < 0) {
            return;
        }
        this.commandPressed = -1;
        this.callSeriallyPaintScreen(8);
        if (i != this.getCommandUnderKey(key) || (command = MENU_PANEL_COMMANDS[i]) == null) {
            return;
        }
        this.callSeriallyCommandAction(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void menuPointerPressed(int x, int y, int button) {
        if (button != 0) {
            return;
        }
        int i = this.getCommandUnderPointer(x, y);
        if (i < 0) {
            Display display = MIDletProxy.getInstance().getEmulatorScreen();
            int s = Math.max(display.getGUIElementFont(3).getHeight(), 1);
            x -= display.getGUIElementLeft(this, 2);
            y -= display.getGUIElementTop(this, 2);
            int width = display.getGUIElementWidth(this, 2);
            int height = display.getGUIElementHeight(this, 2);
            Object object = this.getCommands().getMonitor();
            synchronized (object) {
                int ofs = this.menuFirstIndex;
                int len = this.getMenuCapacity();
                Command[] c = this.commandsOnMenu;
                int length = this.commandsOnMenu == null ? 0 : c.length;
                int l = width - 26;
                int t = height - 42;
                int w = 16;
                int h = 16;
                if (ofs > 0 && x >= l && x < l + w && y >= t && y < t + h) {
                    this.menuFirstIndex = ofs - 1;
                    this.callSeriallyPaintScreen(4);
                } else if (ofs < length - len && x >= l && x < l + w && y >= (t += 16) && y < t + h) {
                    this.menuFirstIndex = ofs + 1;
                    this.callSeriallyPaintScreen(4);
                } else {
                    l = 4;
                    h = s * len;
                    t = height - h - 10;
                    w = width - 42;
                    if (x >= l && x < l + w && y >= t && y < t + h) {
                        this.commandPressed = -2;
                        this.menuSelectedIndex = ofs + (y - t) / s;
                        if (this.menuSelectedIndex != this.menuSelectedIndex) {
                            this.callSeriallyPaintScreen(4);
                        }
                    }
                }
            }
            return;
        }
        Command[] c = MENU_PANEL_COMMANDS;
        if (i >= c.length || c[i] == null) {
            return;
        }
        this.commandPressed = this.commandFocused = i;
        this.callSeriallyPaintScreen(8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void menuPointerDragged(int x, int y) {
        int p = this.commandPressed;
        if (p == -2) {
            Display display = MIDletProxy.getInstance().getEmulatorScreen();
            int s = Math.max(display.getGUIElementFont(3).getHeight(), 1);
            x -= display.getGUIElementLeft(this, 2);
            y -= display.getGUIElementTop(this, 2);
            int width = display.getGUIElementWidth(this, 2);
            int height = display.getGUIElementHeight(this, 2);
            Object object = this.getCommands().getMonitor();
            synchronized (object) {
                int ofs = this.menuFirstIndex;
                int len = this.getMenuCapacity();
                int l = 4;
                int h = s * len;
                int t = height - h - 10;
                int w = width - 42;
                if (x >= l && x < l + w && y >= t && y < t + h && (this.menuSelectedIndex = ofs + (y - t) / s) != this.menuSelectedIndex) {
                    this.callSeriallyPaintScreen(4);
                }
            }
            return;
        }
        int f = this.commandFocused;
        if (f < 0 || p == (this.commandPressed = this.getCommandUnderPointer(x, y) != f ? -1 : f)) {
            return;
        }
        this.callSeriallyPaintScreen(8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void menuPointerReleased(int x, int y, int button) {
        if (button != 0) {
            return;
        }
        int i = this.commandPressed;
        if (i == -1) {
            Display display = MIDletProxy.getInstance().getEmulatorScreen();
            int s = Math.max(display.getGUIElementFont(3).getHeight(), 1);
            int l = display.getGUIElementLeft(this, 2);
            int t = display.getGUIElementTop(this, 2);
            int w = display.getGUIElementWidth(this, 2);
            int h = display.getGUIElementHeight(this, 2);
            Object object = this.getCommands().getMonitor();
            synchronized (object) {
                l += 4;
                int n = h;
                h = s * this.getMenuCapacity() + 12;
                t += n - h - 4;
            }
            if (!(x >= l && x < l + (w -= 8) && y >= t && y < t + h || x >= (l = display.getGUIElementLeft(this, 3)) && x < l + display.getGUIElementWidth(this, 3) && y >= (t = display.getGUIElementTop(this, 3)) && y < t + display.getGUIElementHeight(this, 3))) {
                this.menuOpened = false;
                this.callSeriallyPaintScreen();
            }
            return;
        }
        this.commandFocused = -1;
        this.commandPressed = -1;
        if (i < 0) {
            return;
        }
        this.callSeriallyPaintScreen(8);
        Command command = MENU_PANEL_COMMANDS[i];
        if (command == null) {
            return;
        }
        this.callSeriallyCommandAction(command);
    }

    private void menuPaint(Graphics render, int guiElements, int clipLeft, int clipTop, int clipWidth, int clipHeight) {
        int height;
        int width;
        int left;
        int top;
        RasterCanvas canvas = render.getCanvas();
        Display display = MIDletProxy.getInstance().getEmulatorScreen();
        this.onPaint(render, guiElements & 0xFFFFFFF7, clipLeft, clipTop, clipWidth, clipHeight);
        int mode = this.mode;
        if (mode != 2) {
            if ((guiElements & 1) != 0) {
                top = display.getGUIElementTop(this, 0);
                left = display.getGUIElementLeft(this, 0);
                width = display.getGUIElementWidth(this, 0);
                height = display.getGUIElementHeight(this, 0);
                canvas.fillRect(left, top, width, height, left, top, width, height, Integer.MIN_VALUE, true);
            }
            if ((guiElements & 2) != 0 && mode == 1 && this.ticker != null) {
                top = display.getGUIElementTop(this, 1);
                left = display.getGUIElementLeft(this, 1);
                width = display.getGUIElementWidth(this, 1);
                height = display.getGUIElementHeight(this, 1);
                canvas.fillRect(left, top, width, height, left, top, width, height, Integer.MIN_VALUE, true);
            }
            if ((guiElements & 8) != 0) {
                render.reset();
                render.translate(display.getGUIElementLeft(this, 3), display.getGUIElementTop(this, 3));
                width = display.getGUIElementWidth(this, 3);
                height = display.getGUIElementHeight(this, 3);
                render.setFont(this.getGUIElementFont(3));
                render.setClip(0, 0, width, height);
                this.paintCommands(render, width, height, MENU_PANEL_COMMANDS, this.commandPressed, this.getDefaultCommandFont());
            }
        }
        if ((guiElements & 4) != 0) {
            top = display.getGUIElementTop(this, 2);
            left = display.getGUIElementLeft(this, 2);
            width = display.getGUIElementWidth(this, 2);
            height = display.getGUIElementHeight(this, 2);
            canvas.fillRect(left, top, width, height, left, top, width, height, Integer.MIN_VALUE, true);
            Graphics clientRender = this.getClientContext();
            clientRender.reset();
            clientRender.setFont(this.getGUIElementFont(3));
            this.menuPaint(clientRender, width, height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void menuPaint(Graphics render, int width, int height) {
        Command command;
        int lim;
        int len;
        int length;
        Command[] c;
        int s;
        Font font;
        int ofs;
        int sel;
        int l = 4;
        int t = 4;
        int w = width - 8;
        int h = height - 8;
        Object object = this.getCommands().getMonitor();
        synchronized (object) {
            sel = this.menuSelectedIndex;
            ofs = this.menuFirstIndex;
            font = render.getFont();
            s = Math.max(font.getHeight(), 1);
            int cap = (h - 12) / s;
            c = this.commandsOnMenu;
            length = this.commandsOnMenu == null ? 0 : c.length;
            len = Math.min(Math.min(cap, length), 7);
            int b = length - len;
            if (ofs > b) {
                this.menuFirstIndex = ofs = Math.max(b, 0);
            }
        }
        h = s * len + 12;
        t = height - h - 4;
        render.setColor(RasterCanvas.getSystemColor((int)4));
        render.fillRect(l, t, w, h);
        l += 6;
        w -= 34;
        h -= 12;
        render.setColor(RasterCanvas.getSystemColor((int)7));
        int ti = (t += 6) + s * len;
        int i = lim = ofs + len;
        while (i-- > ofs) {
            ti -= s;
            if (i == sel || (command = c[i]) == null) continue;
            render.drawString(command.getTruncatedLabel(font, w - 4), l + 2, ti, 20);
        }
        if (sel >= ofs && sel < lim && (command = c[sel]) != null) {
            ti = t + s * (sel - ofs);
            render.setColor(RasterCanvas.getSystemColor((int)13));
            render.fillRect(l, ti, w, s);
            render.setColor(RasterCanvas.getSystemColor((int)14));
            render.drawString(command.getTruncatedLabel(font, w - 4), l + 2, ti, 20);
        }
        if (ofs > 0 || lim < length) {
            l += w + 6;
            w = 16;
            render.drawElementOfGUI(14, 0, ofs > 0 ? 0 : 2, l, t + h - 32, 16, 16);
            render.drawElementOfGUI(14, 1, lim < length ? 0 : 2, l, t + h - 16, 16, 16);
        }
    }

    private void callSeriallyMenuClose() {
        Displayable displayable = this;
        displayable.getClass();
        this.callSerially(displayable.new CommandActionEvent(BACK));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean placeCommandsNeedRepaint() {
        boolean result;
        CommandEnumeration enumeration = this.getCommands();
        Object object = enumeration.getMonitor();
        synchronized (object) {
            Command[] b;
            int placed = 1;
            Command[] c = null;
            Command center = enumeration.getDefaultCommand();
            if (center == null && (center = Displayable.findCommand(enumeration, 4, null)) != null) {
                ++placed;
            }
            Command right = null;
            int len = COMMAND_TYPES_FOR_SOFT2.length;
            int i = 0;
            while (i < len) {
                right = Displayable.findCommand(enumeration, COMMAND_TYPES_FOR_SOFT2[i], center);
                if (right != null) {
                    ++placed;
                    break;
                }
                ++i;
            }
            Command left = null;
            len = enumeration.getCommandsCount();
            if (len == placed) {
                i = len;
                while (i-- > 0) {
                    Command command = enumeration.getCommand(i);
                    if (command == null || command == center || command == right) continue;
                    left = command;
                    break;
                }
            } else if (len > placed) {
                left = MENU;
                c = new Command[len - placed + 1];
                int j = 0;
                i = 0;
                while (i < len) {
                    Command command = enumeration.getCommand(i);
                    if (command != null && command != center && command != right) {
                        c[j++] = command;
                    }
                    ++i;
                }
            }
            len = c == null ? 0 : c.length;
            boolean m = this.menuOpened;
            if (!m) {
                b = this.commandsOnPanel;
                result = this.commandsOnPanel[0] != left || b[1] != center || b[2] != right;
            } else {
                b = this.commandsOnMenu;
                result = (this.commandsOnMenu == null ? 0 : b.length) != len;
                if (!result) {
                    i = len;
                    while (i-- > 0) {
                        if (b[i] == c[i]) continue;
                        result = true;
                        break;
                    }
                }
            }
            this.commandsOnMenu = c;
            b = this.commandsOnPanel;
            this.commandsOnPanel[0] = left;
            b[1] = center;
            b[2] = right;
            i = this.menuSelectedIndex;
            if (i >= len && i != (this.menuSelectedIndex = Math.max(0, len - 1)) && m) {
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean menuMoveCursor(int key) {
        MIDletProxy proxy = MIDletProxy.getInstance();
        if (key == proxy.getKeyUsedAs(38)) {
            Object object = this.getCommands().getMonitor();
            synchronized (object) {
                Command[] c = this.commandsOnMenu;
                int length = this.commandsOnMenu == null ? 0 : c.length;
                if (length > 0) {
                    int first = this.menuFirstIndex;
                    this.menuSelectedIndex = (this.menuSelectedIndex + length - 1) % length;
                    int index = this.menuSelectedIndex;
                    if (first > index) {
                        this.menuFirstIndex = index;
                    } else if (first <= (index -= this.getMenuCapacity())) {
                        this.menuFirstIndex = index + 1;
                    }
                    this.callSeriallyPaintScreen(4);
                }
            }
            return true;
        }
        if (key == proxy.getKeyUsedAs(36)) {
            Object object = this.getCommands().getMonitor();
            synchronized (object) {
                Command[] c = this.commandsOnMenu;
                int length = this.commandsOnMenu == null ? 0 : c.length;
                if (length > 0) {
                    int first = this.menuFirstIndex;
                    this.menuSelectedIndex = (this.menuSelectedIndex + 1) % length;
                    int index = this.menuSelectedIndex;
                    if (first > index) {
                        this.menuFirstIndex = index;
                    } else if (first <= (index -= this.getMenuCapacity())) {
                        this.menuFirstIndex = index + 1;
                    }
                    this.callSeriallyPaintScreen(4);
                }
            }
            return true;
        }
        return false;
    }

    private int getMenuCapacity() {
        Display display = MIDletProxy.getInstance().getEmulatorScreen();
        int h = display.getGUIElementHeight(this, 2) - 8;
        int s = Math.max(display.getGUIElementFont(3).getHeight(), 1);
        int cap = (h - 12) / s;
        Command[] c = this.commandsOnMenu;
        int length = this.commandsOnMenu == null ? 0 : c.length;
        return Math.min(Math.min(cap, length), 7);
    }

    private int getCommandUnderKey(int key) {
        if (this.mode == 2) {
            return -1;
        }
        MIDletProxy proxy = MIDletProxy.getInstance();
        int i = DEVICE_KEYS_FOR_COMMANDS.length;
        while (i-- > 0) {
            if (key != proxy.getKeyUsedAs(DEVICE_KEYS_FOR_COMMANDS[i])) continue;
            return i;
        }
        return -1;
    }

    private int getCommandUnderPointer(int x, int y) {
        int h;
        int t;
        int w;
        int l;
        Display display = MIDletProxy.getInstance().getEmulatorScreen();
        return this.mode == 2 || x < (l = display.getGUIElementLeft(this, 3)) || x >= (w = display.getGUIElementWidth(this, 3)) + l || y < (t = display.getGUIElementTop(this, 3)) || y >= (h = display.getGUIElementHeight(this, 3)) + t ? -1 : this.getPanelCommandIndex(x - l, y - t, w, h);
    }

    private String getDisplayedTitle(String title) {
        Display display = MIDletProxy.getInstance().getEmulatorScreen();
        return Displayable.truncate(title, this.getGUIElementFont(0), display.getGUIElementWidth(this, 0) - 4);
    }

    private class CommandActionEvent
    implements Runnable {
        private Command command;

        public CommandActionEvent(Command command) {
            this.command = command;
        }

        public void run() {
            Displayable.this.onCommandAction(this.command);
        }
    }

    private final class CommandEnumerator
    implements CommandEnumeration {
        public int getCommandsCount() {
            return Displayable.this.commandsCount;
        }

        public Command getCommand(int index) {
            Displayable screen;
            if (index < 0 || index >= (screen = Displayable.this).commandsCount) {
                throw new IndexOutOfBoundsException("Displayable.getCommands: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
            }
            return screen.commandsInScreen[index];
        }

        public Command getDefaultCommand() {
            return Displayable.this.defaultCommand;
        }

        public Object getMonitor() {
            return Displayable.this.getCommandsMonitor();
        }
    }

    private class SizeChangedEvent
    implements Runnable {
        public void run() {
            Displayable screen = Displayable.this;
            screen.staySizeChanged = false;
            if (!screen.isReallyShown()) {
                screen.needSizeChanged = true;
                return;
            }
            screen.needSizeChanged = false;
            screen.onSizeChanged(screen.getClientWidth(), screen.getClientHeight());
        }
    }

    private static class TickerScrolling
    implements Runnable {
        private boolean terminated;

        /*
         * Unable to fully structure code
         */
        public void run() {
            tickerScrollingEvent = new Event();
            display = MIDletProxy.getInstance().getEmulatorScreen();
            while (true) {
                this.waitEvent();
                if (this.terminated) break;
                screen = display.getShownScreen();
                if (screen != null) ** GOTO lbl15
                continue;
lbl-1000:
                // 1 sources

                {
                    tickerScrollingEvent.set(screen);
                    try {
                        Thread.sleep(Display.getMinimumPeriod());
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printRealStackTrace();
                    }
lbl15:
                    // 3 sources

                    ** while (display.isShown((Displayable)screen) && Displayable.access$0((Displayable)screen) != null)
                }
lbl16:
                // 1 sources

            }
        }

        public synchronized void update() {
            this.notify();
        }

        public synchronized void terminate() {
            this.terminated = true;
            this.notify();
        }

        private synchronized void waitEvent() {
            while (true) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printRealStackTrace();
                    continue;
                }
                break;
            }
        }

        private static class Event
        implements Runnable {
            private boolean queued;
            private Displayable screen;

            public void run() {
                Ticker ticker;
                Displayable screen = this.screen;
                Ticker ticker2 = ticker = screen != null ? screen.ticker : null;
                if (ticker != null && screen.isReallyShown() && screen.getMode() == 1) {
                    ticker.scroll();
                    screen.callSeriallyPaintScreen(2);
                }
                this.queued = false;
                this.screen = null;
            }

            public void set(Displayable screen) {
                if (this.queued) {
                    return;
                }
                this.queued = true;
                this.screen = screen;
                screen.callSerially(this);
            }
        }
    }
}

