/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import malik.emulator.fileformats.InvalidDataFormatException;
import malik.emulator.fileformats.graphics.ImageDecoder;
import malik.emulator.io.j2me.ImplementationManager;
import malik.emulator.io.jar.ResourceNotFoundException;
import malik.emulator.media.graphics.GraphicBuffer;
import malik.emulator.media.graphics.RasterCanvas;

public class Image {
    private static final long MAX_AREA = 0x100000L;
    private boolean mutable;
    private GraphicBuffer buffer;

    public static Image createImage(int width, int height) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Image.createImage: \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c\u0438.");
        }
        long area = (long)width * (long)height;
        if (area > 0x100000L) {
            throw new IllegalArgumentException("Image.createImage: \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u043e\u0447\u0435\u043d\u044c \u0431\u043e\u043b\u044c\u0448\u0438\u0435.");
        }
        int i = (int)area;
        int[] pixels = new int[i];
        while (i-- > 0) {
            pixels[i] = -1;
        }
        return new Image(new GraphicBuffer(pixels, 0, width, width, height), true);
    }

    public static Image createImage(Image src) {
        if (src == null) {
            throw new NullPointerException("Image.createImage: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (!src.mutable) {
            return src;
        }
        GraphicBuffer buffer = src.buffer;
        int width = buffer.getWidth();
        int height = buffer.getHeight();
        int area = width * height;
        int[] pixels = new int[area];
        Array.copy((int[])buffer.getPixels(), (int)0, (int[])pixels, (int)0, (int)area);
        return new Image(new GraphicBuffer(pixels, 0, width, width, height));
    }

    public static Image createImage(Image src, int left, int top, int width, int height, int transform) {
        GraphicBuffer graphicBuffer;
        int h;
        int w;
        block10: {
            block9: {
                if (src == null) {
                    throw new NullPointerException("Image.createImage: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
                }
                if (width <= 0 || height <= 0) {
                    throw new IllegalArgumentException("Image.createImage: \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c\u0438.");
                }
                int lim = left + width;
                int len = w = src.getWidth();
                if (lim > w || lim < left || left > len || left < 0) break block9;
                lim = top + height;
                len = h = src.getHeight();
                if (lim <= h && lim >= top && top <= len && top >= 0) break block10;
            }
            throw new IllegalArgumentException("Image.createImage: \u0437\u0430\u0434\u0430\u043d\u043d\u0430\u044f \u043f\u0440\u044f\u043c\u043e\u0443\u0433\u043e\u043b\u044c\u043d\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u044b \u0438\u0441\u0445\u043e\u0434\u043d\u043e\u0433\u043e \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f.");
        }
        if ((transform = Graphics.spriteTransformToMalik(transform)) < 0) {
            throw new IllegalArgumentException("Image.createImage: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 transform.");
        }
        if (!src.mutable && left == 0 && top == 0 && width == w && height == h && transform == 0) {
            return src;
        }
        if ((transform & 1) == 0) {
            w = width;
            h = height;
            GraphicBuffer graphicBuffer2 = new GraphicBuffer(new int[width * height], 0, width, w, h);
            graphicBuffer = graphicBuffer2;
        } else {
            w = height;
            h = width;
            GraphicBuffer graphicBuffer3 = new GraphicBuffer(new int[width * height], 0, height, w, h);
            graphicBuffer = graphicBuffer3;
        }
        GraphicBuffer buffer = graphicBuffer;
        new RasterCanvas(buffer).drawPixelsArea(0, 0, w, h, src.buffer, left, top, width, height, transform, 0, 0, w, h, true);
        return new Image(buffer);
    }

    public static Image createImage(byte[] src, int offset, int length) {
        ImageDecoder decoder;
        if (src == null) {
            throw new NullPointerException("Image.createImage: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = offset + length;
        int len = src.length;
        if (lim > len || lim < offset || offset > len || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Image.createImage: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(src, offset, length);
            decoder = ImplementationManager.getImageDecoder(stream);
            if (decoder == null) {
                throw new IllegalArgumentException("Image.createImage: \u043e\u0448\u0438\u0431\u043a\u0430 \u0434\u0435\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f.");
            }
            decoder.loadFromInputStream((InputStream)stream);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Image.createImage: \u043e\u0448\u0438\u0431\u043a\u0430 \u0434\u0435\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f.");
        }
        if (decoder.isEmpty()) {
            throw new IllegalArgumentException("Image.createImage: \u043e\u0448\u0438\u0431\u043a\u0430 \u0434\u0435\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f.");
        }
        int[] pixels = decoder.getPixels();
        int i = decoder.getWidth();
        GraphicBuffer buffer = new GraphicBuffer(pixels, 0, i, i, decoder.getHeight());
        if (!decoder.isAlphaSupported()) {
            i = pixels.length;
            while (i-- > 0) {
                int n = i;
                pixels[n] = pixels[n] | 0xFF000000;
            }
        }
        return new Image(buffer);
    }

    public static Image createImage(InputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("Image.createImage: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 stream \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        ImageDecoder decoder = ImplementationManager.getImageDecoder(stream);
        if (decoder == null) {
            throw new InvalidDataFormatException("Image.createImage: \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f.");
        }
        decoder.loadFromInputStream(stream);
        if (decoder.isEmpty()) {
            throw new InvalidDataFormatException("Image.createImage: \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f.");
        }
        int[] pixels = decoder.getPixels();
        int i = decoder.getWidth();
        GraphicBuffer buffer = new GraphicBuffer(pixels, 0, i, i, decoder.getHeight());
        if (!decoder.isAlphaSupported()) {
            i = pixels.length;
            while (i-- > 0) {
                int n = i;
                pixels[n] = pixels[n] | 0xFF000000;
            }
        }
        return new Image(buffer);
    }

    public static Image createImage(String resourceName) throws IOException {
        if (resourceName == null) {
            throw new NullPointerException("Image.createImage: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 resourceName \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        InputStream stream = resourceName.getClass().getResourceAsStream(resourceName.length() <= 0 || resourceName.charAt(0) != '/' ? (resourceName = "/".concat(resourceName)) : resourceName);
        if (stream == null) {
            throw new ResourceNotFoundException("Image.createImage: \u0440\u0435\u0441\u0443\u0440\u0441 " + resourceName + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d.");
        }
        ImageDecoder decoder = ImplementationManager.getImageDecoder(stream);
        if (decoder == null) {
            throw new InvalidDataFormatException("Image.createImage: \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f.");
        }
        decoder.loadFromInputStream(stream);
        if (decoder.isEmpty()) {
            throw new InvalidDataFormatException("Image.createImage: \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f.");
        }
        int[] pixels = decoder.getPixels();
        int i = decoder.getWidth();
        GraphicBuffer buffer = new GraphicBuffer(pixels, 0, i, i, decoder.getHeight());
        if (!decoder.isAlphaSupported()) {
            i = pixels.length;
            while (i-- > 0) {
                int n = i;
                pixels[n] = pixels[n] | 0xFF000000;
            }
        }
        return new Image(buffer);
    }

    public static Image createRGBImage(int[] src, int width, int height, boolean alpha) {
        if (src == null) {
            throw new NullPointerException("Image.createRGBImage: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Image.createRGBImage: \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c\u0438.");
        }
        long area = (long)width * (long)height;
        if (area > 0x100000L) {
            throw new IllegalArgumentException("Image.createRGBImage: \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u043e\u0447\u0435\u043d\u044c \u0431\u043e\u043b\u044c\u0448\u0438\u0435.");
        }
        if (area > (long)src.length) {
            throw new ArrayIndexOutOfBoundsException("Image.createRGBImage: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int i = (int)area;
        int[] pixels = new int[i];
        Array.copy((int[])src, (int)0, (int[])pixels, (int)0, (int)i);
        if (!alpha) {
            while (i-- > 0) {
                int n = i;
                pixels[n] = pixels[n] | 0xFF000000;
            }
        }
        return new Image(new GraphicBuffer(pixels, 0, width, width, height));
    }

    private Image(GraphicBuffer buffer) {
        this.mutable = false;
        this.buffer = buffer;
    }

    private Image(GraphicBuffer buffer, boolean mutable) {
        this.mutable = mutable;
        this.buffer = buffer;
    }

    public void getRGB(int[] dst, int offset, int scanlength, int left, int top, int width, int height) {
        int length;
        int i;
        if (dst == null) {
            throw new NullPointerException("Image.getRGB: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        int lim = left + width;
        GraphicBuffer buffer = this.buffer;
        int len = buffer.getWidth();
        if (lim > len || lim < left || left > len || left < 0 || (lim = top + height) > (len = buffer.getHeight()) || lim < top || top > len || top < 0) {
            throw new IllegalArgumentException("Image.getRGB: \u0437\u0430\u0434\u0430\u043d\u043d\u0430\u044f \u043f\u0440\u044f\u043c\u043e\u0443\u0433\u043e\u043b\u044c\u043d\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u044b \u0440\u0430\u0441\u0442\u0440\u043e\u0432\u043e\u0439 \u043a\u0430\u043d\u0432\u044b.");
        }
        if (Math.abs(scanlength) < width) {
            throw new IllegalArgumentException("Image.getRGB: \u0434\u043b\u0438\u043d\u0430 \u043b\u0438\u043d\u0438\u0438 \u0441\u043a\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 \u0448\u0438\u0440\u0438\u043d\u044b.");
        }
        if (scanlength >= 0) {
            i = 0;
            length = width + (height - 1) * scanlength;
        } else {
            i = -scanlength * (height - 1);
            length = width + i;
        }
        lim = (offset -= i) + length;
        len = dst.length;
        if (lim > len || lim < offset || offset > len || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Image.getRGB: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int[] src = buffer.getPixels();
        int srcScan = buffer.getScanlength();
        int srcLine = buffer.getOffset() + left + top * srcScan;
        int dstLine = offset += i;
        i = 0;
        while (i < height) {
            Array.copy((int[])src, (int)srcLine, (int[])dst, (int)dstLine, (int)width);
            srcLine += srcScan;
            dstLine += scanlength;
            ++i;
        }
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public int getWidth() {
        return this.buffer.getWidth();
    }

    public int getHeight() {
        return this.buffer.getHeight();
    }

    public Graphics getGraphics() {
        if (!this.mutable) {
            throw new IllegalStateException("Image.getGraphics: \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u043d\u0435\u0438\u0437\u043c\u0435\u043d\u044f\u0435\u043c\u043e.");
        }
        return new Graphics(this.buffer);
    }

    public final GraphicBuffer getBuffer() {
        return this.buffer;
    }
}

