/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.ScrollBar;
import javax.microedition.lcdui.ScrollBarPaintHelper;
import javax.microedition.lcdui.ScrollBarStyle;

public class ScrollBarSystem
implements ScrollBarStyle {
    private static final int SLIDER_MIN_LENGTH = 7;
    private static final int DEFAULT_SIZE = 16;
    private static final int NONE = 0;
    private static final int BACKWARD = 1;
    private static final int TRACK_BACK = 2;
    private static final int SLIDER = 3;
    private static final int TRACK_FORW = 4;
    private static final int FORWARD = 5;
    private static final int HORIZONTAL = 0;
    private static final int VERTICAL = 8;
    private int step;
    private int prev;
    private int focused;
    private int pressed;

    public ScrollBarSystem() {
        this.step = 16;
    }

    public ScrollBarSystem(int step) {
        this.step = step < 1 ? 1 : step;
    }

    public void paintHorzScrollBar(Graphics render, ScrollBar scrollbar, int length, int width) {
        int page;
        int w = Math.min(16, width);
        int range = scrollbar.getRange();
        if (range <= 0 || (page = scrollbar.getPage()) <= 0 || range <= page) {
            if (length < 32) {
                int a = length / 2;
                int b = length - a;
                render.drawElementOfGUI(10, 2, 2, 0, 0, a, w);
                render.drawElementOfGUI(10, 3, 2, a, 0, b, w);
                return;
            }
            render.drawElementOfGUI(10, 2, 2, 0, 0, 16, w);
            render.drawElementOfGUI(10, 7, 2, 16, 0, length - 32, w);
            render.drawElementOfGUI(10, 3, 2, length - 16, 0, 16, w);
            return;
        }
        int p = this.pressed;
        if (length < 39) {
            if (length < 32) {
                int a = length / 2;
                int b = length - a;
                render.drawElementOfGUI(10, 2, p == 1 ? 1 : 0, 0, 0, a, w);
                render.drawElementOfGUI(10, 3, p == 5 ? 1 : 0, a, 0, b, w);
                return;
            }
            render.drawElementOfGUI(10, 2, p == 1 ? 1 : 0, 0, 0, 16, w);
            render.drawElementOfGUI(10, 7, 0, 16, 0, length - 32, w);
            render.drawElementOfGUI(10, 3, p == 5 ? 1 : 0, length - 16, 0, 16, w);
            return;
        }
        int tmp = length - 32;
        int b = ScrollBarPaintHelper.getSliderLength(page, range, tmp, 7);
        int a = ScrollBarPaintHelper.getSliderPosition(scrollbar.getPosition(), page, range, tmp, b) + 16;
        b = a + b;
        tmp = length - 16;
        render.drawElementOfGUI(10, 2, p == 1 ? 1 : 0, 0, 0, 16, w);
        render.drawElementOfGUI(10, 6, p == 2 ? 1 : 0, 16, 0, a - 16, w);
        render.drawElementOfGUI(10, 4, p == 3 ? 1 : 0, a, 0, b - a, w);
        render.drawElementOfGUI(10, 7, p == 4 ? 1 : 0, b, 0, tmp - b, w);
        render.drawElementOfGUI(10, 3, p == 5 ? 1 : 0, tmp, 0, 16, w);
    }

    public void paintVertScrollBar(Graphics render, ScrollBar scrollbar, int length, int width) {
        int page;
        int w = Math.min(16, width);
        int range = scrollbar.getRange();
        if (range <= 0 || (page = scrollbar.getPage()) <= 0 || range <= page) {
            if (length < 32) {
                int a = length / 2;
                int b = length - a;
                render.drawElementOfGUI(10, 0, 2, 0, 0, w, a);
                render.drawElementOfGUI(10, 1, 2, 0, a, w, b);
                return;
            }
            render.drawElementOfGUI(10, 0, 2, 0, 0, w, 16);
            render.drawElementOfGUI(10, 9, 2, 0, 16, w, length - 32);
            render.drawElementOfGUI(10, 1, 2, 0, length - 16, w, 16);
            return;
        }
        int p = this.pressed;
        if (length < 39) {
            if (length < 32) {
                int a = length / 2;
                int b = length - a;
                render.drawElementOfGUI(10, 0, p == 9 ? 1 : 0, 0, 0, w, a);
                render.drawElementOfGUI(10, 1, p == 13 ? 1 : 0, 0, a, w, b);
                return;
            }
            render.drawElementOfGUI(10, 0, p == 9 ? 1 : 0, 0, 0, w, 16);
            render.drawElementOfGUI(10, 9, 0, 0, 16, w, length - 32);
            render.drawElementOfGUI(10, 1, p == 13 ? 1 : 0, 0, length - 16, w, 16);
            return;
        }
        int tmp = length - 32;
        int b = ScrollBarPaintHelper.getSliderLength(page, range, tmp, 7);
        int a = ScrollBarPaintHelper.getSliderPosition(scrollbar.getPosition(), page, range, tmp, b) + 16;
        b = a + b;
        tmp = length - 16;
        render.drawElementOfGUI(10, 0, p == 9 ? 1 : 0, 0, 0, w, 16);
        render.drawElementOfGUI(10, 8, p == 10 ? 1 : 0, 0, 16, w, a - 16);
        render.drawElementOfGUI(10, 5, p == 11 ? 1 : 0, 0, a, w, b - a);
        render.drawElementOfGUI(10, 9, p == 12 ? 1 : 0, 0, b, w, tmp - b);
        render.drawElementOfGUI(10, 1, p == 13 ? 1 : 0, 0, tmp, w, 16);
    }

    public void onHorzScrollBarPointerPressed(ScrollBar scrollbar, int length, int width, int x, int y, int button) {
        int page = scrollbar.getPage();
        int f = this.getScrollBarFocused(scrollbar, page, length, width, x, y);
        switch (f) {
            case 1: {
                scrollbar.scroll(-this.step);
                break;
            }
            case 2: {
                scrollbar.scroll(-page);
                break;
            }
            case 3: {
                this.prev = x;
                break;
            }
            case 4: {
                scrollbar.scroll(page);
                break;
            }
            case 5: {
                scrollbar.scroll(this.step);
                break;
            }
            default: {
                f = 0;
            }
        }
        scrollbar.repaintOwner();
        this.focused = f |= 0;
        this.pressed = f;
    }

    public void onHorzScrollBarPointerDragged(ScrollBar scrollbar, int length, int width, int x, int y) {
        int f = this.focused;
        if (f == 3) {
            int p = this.prev;
            int range = scrollbar.getRange();
            scrollbar.scroll((int)((double)(x - p) * (double)range / (double)(length -= 32)));
            this.prev = x;
            return;
        }
        if (f == 0 || this.pressed == (this.pressed = this.getScrollBarFocused(scrollbar, scrollbar.getPage(), length, width, x, y) != f ? 0 : f)) {
            return;
        }
        scrollbar.repaintOwner();
    }

    public void onHorzScrollBarPointerReleased(ScrollBar scrollbar, int length, int width, int x, int y, int button) {
        int p;
        if (this.focused == 3) {
            p = this.prev;
            int range = scrollbar.getRange();
            scrollbar.scroll((int)((double)(x - p) * (double)range / (double)(length -= 32)));
        }
        p = this.pressed;
        this.focused = 0;
        this.pressed = 0;
        if (p == 0) {
            return;
        }
        scrollbar.repaintOwner();
    }

    public void onVertScrollBarPointerPressed(ScrollBar scrollbar, int length, int width, int x, int y, int button) {
        int page = scrollbar.getPage();
        int f = this.getScrollBarFocused(scrollbar, page, length, width, y, x);
        switch (f) {
            case 1: {
                scrollbar.scroll(-this.step);
                break;
            }
            case 2: {
                scrollbar.scroll(-page);
                break;
            }
            case 3: {
                this.prev = y;
                break;
            }
            case 4: {
                scrollbar.scroll(page);
                break;
            }
            case 5: {
                scrollbar.scroll(this.step);
                break;
            }
            default: {
                f = 0;
            }
        }
        scrollbar.repaintOwner();
        this.focused = f |= 8;
        this.pressed = f;
    }

    public void onVertScrollBarPointerDragged(ScrollBar scrollbar, int length, int width, int x, int y) {
        int f = this.focused;
        if (f == 11) {
            int p = this.prev;
            int range = scrollbar.getRange();
            scrollbar.scroll((int)((double)(y - p) * (double)range / (double)(length -= 32)));
            this.prev = y;
            return;
        }
        if (f == 0 || this.pressed == (this.pressed = (8 | this.getScrollBarFocused(scrollbar, scrollbar.getPage(), length, width, y, x)) != f ? 0 : f)) {
            return;
        }
        scrollbar.repaintOwner();
    }

    public void onVertScrollBarPointerReleased(ScrollBar scrollbar, int length, int width, int x, int y, int button) {
        int p;
        if (this.focused == 11) {
            p = this.prev;
            int range = scrollbar.getRange();
            scrollbar.scroll((int)((double)(y - p) * (double)range / (double)(length -= 32)));
        }
        p = this.pressed;
        this.focused = 0;
        this.pressed = 0;
        if (p == 0) {
            return;
        }
        scrollbar.repaintOwner();
    }

    public int getHorzScrollBarWidth() {
        return 16;
    }

    public int getVertScrollBarWidth() {
        return 16;
    }

    public void setStep(int step) {
        this.step = step < 1 ? 1 : step;
    }

    public final int getStep() {
        return this.step;
    }

    private int getScrollBarFocused(ScrollBar scrollbar, int page, int length, int width, int inLen, int inWid) {
        int result;
        int range = scrollbar.getRange();
        if (range <= 0 || page <= 0 || range <= page || inWid < 0 || inWid >= Math.min(16, width)) {
            return 0;
        }
        if (length < 39) {
            if (length < 32) {
                int a = length / 2;
                result = inLen >= 0 && inLen < a ? 1 : (inLen >= a && inLen < length ? 5 : 0);
            } else {
                result = inLen >= 0 && inLen < 16 ? 1 : (inLen >= length - 16 && inLen < length ? 5 : 0);
            }
        } else {
            int tmp = length - 32;
            int b = ScrollBarPaintHelper.getSliderLength(page, range, tmp, 7);
            int a = ScrollBarPaintHelper.getSliderPosition(scrollbar.getPosition(), page, range, tmp, b) + 16;
            b = a + b;
            tmp = length - 16;
            result = inLen >= 0 && inLen < 16 ? 1 : (inLen >= 16 && inLen < a ? 2 : (inLen >= a && inLen < b ? 3 : (inLen >= b && inLen < tmp ? 4 : (inLen >= tmp && inLen < length ? 5 : 0))));
        }
        return result;
    }
}

