/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

public class TextOutput {
    protected int length;
    protected char[] chars;

    public TextOutput() {
    }

    public TextOutput(int capacity) {
        this.chars = new char[capacity];
    }

    public String toString() {
        char[] c = this.chars;
        return this.chars == null ? "" : new String(c, 0, this.length).intern();
    }

    public void clear() {
        this.length = 0;
    }

    public void setText(String text) {
        int len;
        if (text == null || (len = text.length()) <= 0) {
            this.length = 0;
            return;
        }
        char[] c = this.chars;
        if ((this.chars == null ? 0 : c.length) < len) {
            c = this.chars = new char[len];
        }
        text.getChars(0, len, c, 0);
        this.length = len;
    }

    public void append(String data) {
        int length;
        if (data == null || (length = data.length()) <= 0) {
            return;
        }
        int len = this.length;
        int newLength = len + length;
        char[] c = this.chars;
        if (this.chars == null) {
            c = this.chars = new char[length];
        } else if (newLength > c.length) {
            char[] cArray = c;
            c = this.chars = new char[Math.max(len << 1, newLength)];
            Array.copy((char[])cArray, (int)0, (char[])this.chars, (int)0, (int)len);
        }
        data.getChars(0, length, c, len);
        this.length = newLength;
    }

    public void append(char[] data, int offset, int length) {
        if (data == null || length <= 0) {
            return;
        }
        int len = this.length;
        int newLength = len + length;
        char[] c = this.chars;
        if (this.chars == null) {
            c = this.chars = new char[length];
        } else if (newLength > c.length) {
            char[] cArray = c;
            c = this.chars = new char[Math.max(len << 1, newLength)];
            Array.copy((char[])cArray, (int)0, (char[])this.chars, (int)0, (int)len);
        }
        Array.copy((char[])data, (int)offset, (char[])c, (int)len, (int)length);
        this.length = newLength;
    }

    public void append(int data, int radix, boolean upperCase) {
        int value;
        int length;
        if (radix < 2 || radix > 36) {
            radix = 10;
        }
        if (data > 0) {
            length = 0;
            value = -data;
        } else {
            length = 1;
            value = data;
        }
        while (value != 0) {
            ++length;
            value /= radix;
        }
        int len = this.length;
        int newLength = len + length;
        char[] c = this.chars;
        if (this.chars == null) {
            c = this.chars = new char[length];
        } else if (newLength > c.length) {
            char[] cArray = c;
            c = this.chars = new char[Math.max(len << 1, newLength)];
            Array.copy((char[])cArray, (int)0, (char[])this.chars, (int)0, (int)len);
        }
        value = data > 0 ? -data : data;
        int i = newLength;
        while (i-- > len) {
            int digit;
            c[i] = (char)(data < 0 && i == len ? 45 : ((digit = -(value % radix)) < 10 ? digit + 48 : digit + (upperCase ? 55 : 87)));
            value /= radix;
        }
        this.length = newLength;
    }

    public final int getLength() {
        return this.length;
    }

    public final char[] getChars() {
        return this.chars;
    }
}

