/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.rms;

import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.Record;
import javax.microedition.rms.RecordComparator;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordFilter;
import javax.microedition.rms.RecordListener;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;

final class Enumerator
implements RecordListener,
RecordEnumeration {
    private boolean destroyed = false;
    private boolean nowCreated = true;
    private boolean autoRebuild;
    private int current;
    private int count;
    private Record[] records;
    private RecordStore store;
    private RecordFilter filter;
    private RecordComparator comparator;
    private Object lock;

    Enumerator(RecordStore store, RecordFilter filter, RecordComparator comparator, boolean autoRebuild) {
        this.autoRebuild = autoRebuild;
        this.store = store;
        this.filter = filter;
        this.comparator = comparator;
        this.lock = new Object();
        this.rebuild();
        if (!autoRebuild) {
            return;
        }
        store.addRecordListener(this);
    }

    public void recordAdded(RecordStore store, int recordId) {
        if (store != this.store) {
            return;
        }
        this.rebuild();
    }

    public void recordDeleted(RecordStore store, int recordId) {
        if (store != this.store) {
            return;
        }
        this.rebuild();
    }

    public void recordChanged(RecordStore store, int recordId) {
        if (store != this.store) {
            return;
        }
        this.rebuild();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.lock;
        synchronized (object) {
            this.checkDestroyed();
            this.store.removeRecordListener(this);
            this.destroyed = true;
            this.nowCreated = false;
            this.autoRebuild = false;
            this.current = 0;
            this.count = 0;
            this.records = null;
            this.store = null;
            this.filter = null;
            this.comparator = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuild() {
        Object lock;
        Object object = lock = this.lock;
        synchronized (lock) {
            Record[] source;
            int sourceCount;
            boolean opened;
            this.checkDestroyed();
            RecordStore store = this.store;
            RecordFilter filter = this.filter;
            RecordComparator comparator = this.comparator;
            // ** MonitorExit[var14_2] (shouldn't be in output)
            object = RecordStore.getMonitor();
            synchronized (object) {
                opened = store.isRecordStoreOpened();
                if (opened) {
                    sourceCount = store.getRecordsCount();
                    source = store.getRecords();
                } else {
                    sourceCount = 0;
                    source = null;
                }
            }
            if (source == null || !opened) {
                return;
            }
            int rebuildedCount = 0;
            Record[] rebuilded = new Record[sourceCount];
            try {
                Record r1;
                int i = 0;
                while (i < sourceCount) {
                    r1 = source[i];
                    if (r1 != null && filter.matches(r1.getData())) {
                        rebuilded[rebuildedCount++] = r1;
                    }
                    ++i;
                }
                i = 0;
                while (i < rebuildedCount - 1) {
                    r1 = rebuilded[i];
                    int j = i + 1;
                    while (j < rebuildedCount) {
                        Record r2 = rebuilded[j];
                        if (comparator.compare(r2.getData(), r1.getData()) < 0) {
                            rebuilded[i] = r2;
                            rebuilded[j] = r1;
                            r1 = r2;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                return;
            }
            object = lock;
            synchronized (object) {
                this.checkDestroyed();
                this.nowCreated = true;
                this.count = rebuildedCount;
                this.records = rebuilded;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.checkDestroyed();
            this.nowCreated = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keepUpdated(boolean autoRebuild) {
        Object object = this.lock;
        synchronized (object) {
            this.checkDestroyed();
            if (this.autoRebuild != autoRebuild) {
                this.autoRebuild = autoRebuild;
                if (this.autoRebuild) {
                    this.store.addRecordListener(this);
                } else {
                    this.store.removeRecordListener(this);
                }
            }
        }
        if (autoRebuild) {
            this.rebuild();
        }
    }

    public boolean isKeptUpdated() {
        this.checkDestroyed();
        return this.autoRebuild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNextElement() {
        boolean result;
        Object object = this.lock;
        synchronized (object) {
            this.checkDestroyed();
            result = this.nowCreated ? this.count > 0 : this.current < this.count - 1;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPreviousElement() {
        boolean result;
        Object object = this.lock;
        synchronized (object) {
            this.checkDestroyed();
            result = this.nowCreated ? this.count > 0 : this.current > 0;
        }
        return result;
    }

    public int numRecords() {
        this.checkDestroyed();
        return this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int nextRecordId() throws InvalidRecordIDException {
        int result;
        Object object = this.lock;
        synchronized (object) {
            this.checkDestroyed();
            result = this.records[this.checkAvailableRecord(true)].getRecordID();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int previousRecordId() throws InvalidRecordIDException {
        int result;
        Object object = this.lock;
        synchronized (object) {
            this.checkDestroyed();
            result = this.records[this.checkAvailableRecord(false)].getRecordID();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] nextRecord() throws RecordStoreException, RecordStoreNotOpenException, InvalidRecordIDException {
        byte[] result;
        Object object = this.lock;
        synchronized (object) {
            this.checkDestroyed();
            this.checkOpenedRecordStore();
            byte[] data = this.records[this.checkAvailableRecord(true)].getData();
            int length = data.length;
            result = new byte[length];
            Array.copy((byte[])data, (int)0, (byte[])result, (int)0, (int)length);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] previousRecord() throws RecordStoreException, RecordStoreNotOpenException, InvalidRecordIDException {
        byte[] result;
        Object object = this.lock;
        synchronized (object) {
            this.checkDestroyed();
            this.checkOpenedRecordStore();
            byte[] data = this.records[this.checkAvailableRecord(false)].getData();
            int length = data.length;
            result = new byte[length];
            Array.copy((byte[])data, (int)0, (byte[])result, (int)0, (int)length);
        }
        return result;
    }

    private void checkDestroyed() {
        if (this.destroyed) {
            throw new IllegalStateException("RecordEnumeration: \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u0437\u043e\u0432\u0430 \u043c\u0435\u0442\u043e\u0434\u0430 destroy().");
        }
    }

    private void checkOpenedRecordStore() throws RecordStoreNotOpenException {
        RecordStore store = this.store;
        if (!store.isRecordStoreOpened()) {
            throw new RecordStoreNotOpenException("RecordEnumeration: \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 " + store.getRecordStoreName() + " \u043d\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u043e.");
        }
    }

    private int checkAvailableRecord(boolean moveToNext) throws InvalidRecordIDException {
        int result;
        int cnt = this.count;
        if (this.nowCreated) {
            if (cnt == 0) {
                throw new InvalidRecordIDException("RecordEnumeration: \u0432 \u043f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0438 \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435 \u043e\u0441\u0442\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u043f\u0438\u0441\u0435\u0439.");
            }
            this.nowCreated = false;
            this.current = moveToNext ? 0 : cnt - 1;
            result = this.current;
        } else {
            int curr = this.current;
            if (curr == (moveToNext ? cnt - 1 : 0)) {
                throw new InvalidRecordIDException("RecordEnumeration: \u0432 \u043f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0438 \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435 \u043e\u0441\u0442\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u043f\u0438\u0441\u0435\u0439.");
            }
            this.current = moveToNext ? curr + 1 : curr - 1;
            result = this.current;
        }
        return result;
    }
}

