/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;

public class DataInputStream
extends InputStream
implements DataInput {
    protected InputStream in;

    public static String readUTF(DataInput stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("DataInputStream.readUTF: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 stream \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int length = stream.readUnsignedShort();
        if (length == 0) {
            return "";
        }
        int strlen = 0;
        char[] result = new char[length];
        byte[] b = new byte[length];
        stream.readFully(b);
        int i = 0;
        while (i < length) {
            int b1 = b[i] & 0xFF;
            switch (b1 >> 4) {
                default: {
                    throw new UTFDataFormatException("DataInputStream.readUTF: \u043e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0434\u0430\u043d\u043d\u044b\u0445, \u0437\u0430\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0445 \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u043e\u0439 UTF-8.");
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++i;
                    result[strlen++] = (char)b1;
                    break;
                }
                case 12: 
                case 13: {
                    byte b2;
                    if ((i += 2) > length || ((b2 = b[i - 1]) & 0xC0) != 128) {
                        throw new UTFDataFormatException("DataInputStream.readUTF: \u043e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0434\u0430\u043d\u043d\u044b\u0445, \u0437\u0430\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0445 \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u043e\u0439 UTF-8.");
                    }
                    result[strlen++] = (char)((b1 & 0x1F) << 6 | b2 & 0x3F);
                    break;
                }
                case 14: {
                    byte b3;
                    byte b2;
                    if ((i += 3) > length || ((b2 = b[i - 2]) & 0xC0) != 128 || ((b3 = b[i - 1]) & 0xC0) != 128) {
                        throw new UTFDataFormatException("DataInputStream.readUTF: \u043e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0434\u0430\u043d\u043d\u044b\u0445, \u0437\u0430\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0445 \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u043e\u0439 UTF-8.");
                    }
                    result[strlen++] = (char)((b1 & 0xF) << 12 | (b2 & 0x3F) << 6 | b3 & 0x3F);
                }
            }
        }
        return new String(result, 0, strlen);
    }

    public DataInputStream(InputStream stream) {
        this.in = stream;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public void reset() throws IOException {
        this.in.reset();
    }

    public void mark(int readLimit) {
        this.in.mark(readLimit);
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public int read() throws IOException {
        return this.in.read();
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public long skip(long bytesCount) throws IOException {
        return this.in.skip(bytesCount);
    }

    public final int read(byte[] dst) throws IOException {
        return this.in.read(dst);
    }

    public final int read(byte[] dst, int offset, int length) throws IOException {
        return this.in.read(dst, offset, length);
    }

    public final void readFully(byte[] dst) throws IOException {
        if (dst == null) {
            throw new NullPointerException("DataInputStream.readFully: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int length = dst.length;
        int p = 0;
        while (p < length) {
            int c = this.read(dst, p, length - p);
            if (c < 0) {
                throw new EOFException("DataInputStream: \u0434\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442 \u043a\u043e\u043d\u0435\u0446 \u0434\u0430\u043d\u043d\u044b\u0445.");
            }
            p += c;
        }
    }

    public final void readFully(byte[] dst, int offset, int length) throws IOException {
        if (dst == null) {
            throw new NullPointerException("DataInputStream.readFully: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = offset + length;
        int len = dst.length;
        if (lim > len || lim < offset || offset > len || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("DataInputStream.readFully: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int p = 0;
        while (p < length) {
            int c = this.read(dst, offset + p, length - p);
            if (c < 0) {
                throw new EOFException("DataInputStream: \u0434\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442 \u043a\u043e\u043d\u0435\u0446 \u0434\u0430\u043d\u043d\u044b\u0445.");
            }
            p += c;
        }
    }

    public final boolean readBoolean() throws IOException {
        return this.readUnsignedByte() != 0;
    }

    public final char readChar() throws IOException {
        return (char)this.readUnsignedShort();
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final byte readByte() throws IOException {
        return (byte)this.readUnsignedByte();
    }

    public final short readShort() throws IOException {
        return (short)this.readUnsignedShort();
    }

    public final int readUnsignedByte() throws IOException {
        int b = this.read();
        if (b < 0) {
            throw new EOFException("DataInputStream: \u0434\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442 \u043a\u043e\u043d\u0435\u0446 \u0434\u0430\u043d\u043d\u044b\u0445.");
        }
        return b;
    }

    public final int readUnsignedShort() throws IOException {
        int b2;
        int b1 = this.read();
        if ((b1 | (b2 = this.read())) < 0) {
            throw new EOFException("DataInputStream: \u0434\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442 \u043a\u043e\u043d\u0435\u0446 \u0434\u0430\u043d\u043d\u044b\u0445.");
        }
        return b1 << 8 | b2;
    }

    public final int readInt() throws IOException {
        int b4;
        int b3;
        int b2;
        int b1 = this.read();
        if ((b1 | (b2 = this.read()) | (b3 = this.read()) | (b4 = this.read())) < 0) {
            throw new EOFException("DataInputStream: \u0434\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442 \u043a\u043e\u043d\u0435\u0446 \u0434\u0430\u043d\u043d\u044b\u0445.");
        }
        return b1 << 24 | b2 << 16 | b3 << 8 | b4;
    }

    public final long readLong() throws IOException {
        int b8;
        int b7;
        int b6;
        int b5;
        int b4;
        int b3;
        int b2;
        int b1 = this.read();
        if ((b1 | (b2 = this.read()) | (b3 = this.read()) | (b4 = this.read()) | (b5 = this.read()) | (b6 = this.read()) | (b7 = this.read()) | (b8 = this.read())) < 0) {
            throw new EOFException("DataInputStream: \u0434\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442 \u043a\u043e\u043d\u0435\u0446 \u0434\u0430\u043d\u043d\u044b\u0445.");
        }
        return (long)b1 << 56 | (long)b2 << 48 | (long)b3 << 40 | (long)b4 << 32 | (long)b5 << 24 | (long)b6 << 16 | (long)b7 << 8 | (long)b8;
    }

    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public final int skipBytes(int bytesCount) throws IOException {
        int skiped;
        int result = 0;
        while (result < bytesCount && (skiped = (int)this.skip(bytesCount - result)) > 0) {
            result += skiped;
        }
        return result;
    }
}

