/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.time;

import java.util.Calendar;
import malik.emulator.time.DateTimeFormat;
import malik.emulator.time.DefaultFormat;
import malik.emulator.time.StandardFormat;

public final class GregorianCalendar
extends Calendar {
    private static final byte[][] DAYS = new byte[][]{{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}, {31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}};
    private static final DateTimeFormat DEFAULT_FORMAT = new DefaultFormat();
    private static final DateTimeFormat STANDARD_FORMAT = new StandardFormat();

    public static boolean isLeapYear(int year) {
        return year % (year % 100 == 0 ? 400 : 4) == 0;
    }

    public static int getDayOfWeek(int year, int month, int day) {
        return (int)(((GregorianCalendar.computeTime(year, month, day, 0, 0, 0, 0, 0) + 62135596800000L) / 86400000L + 1L) % 7L);
    }

    public static int getNumOfDays(int year, int month) {
        return DAYS[GregorianCalendar.isLeapYear(year) ? 1 : 0][month - 1];
    }

    public static long computeFields(long time, int offset) {
        byte dur;
        long i = (time += (long)offset + 62135596800000L) % 86400000L;
        int hour = (int)(i / 3600000L);
        int minute = (int)((i %= 3600000L) / 60000L);
        int millis = (int)(i %= 60000L);
        i = time / 86400000L;
        int j = (int)(i / 146097L * 400L);
        if ((i %= 146097L) == 146096L) {
            j += 399;
            i = 365L;
        } else {
            j += (int)(i / 36524L * 100L);
            j += (int)((i %= 36524L) / 1461L * 4L);
            if ((i %= 1461L) == 1460L) {
                j += 3;
                i = 365L;
            } else {
                j += (int)(i / 365L);
                i %= 365L;
            }
        }
        int year = ++j;
        byte[] months = DAYS[GregorianCalendar.isLeapYear(j) ? 1 : 0];
        j = 0;
        while (i >= (long)(dur = months[j])) {
            i -= (long)dur;
            ++j;
        }
        int month = j + 1;
        int day = (int)i + 1;
        return (long)year << 48 | (long)month << 40 | (long)day << 32 | (long)hour << 24 | (long)minute << 16 | (long)millis;
    }

    public static long computeTime(long fields, int offset) {
        int ms = (int)fields & 0xFFFF;
        return GregorianCalendar.computeTime((int)(fields >>> 48), (byte)(fields >>> 40), (byte)(fields >>> 32), (byte)(fields >>> 24), (byte)(fields >>> 16), ms / 1000, ms % 1000, offset);
    }

    public static long computeTime(int year, int month, int day, int hour, int minute, int second, int millis, int offset) {
        int leap = GregorianCalendar.isLeapYear(year--) ? 1 : 0;
        long result = -62135596800000L;
        result += 12622780800000L * (long)(year / 400);
        result += 3155673600000L * (long)((year %= 400) / 100);
        result += 126230400000L * (long)((year %= 100) / 4);
        result += 31536000000L * (long)(year %= 4);
        byte[] months = DAYS[leap];
        int i = month - 1;
        while (i-- > 0) {
            result += 86400000L * (long)months[i];
        }
        return result + 86400000L * (long)(day - 1) + 3600000L * (long)hour + 60000L * (long)minute + 1000L * (long)second + (long)millis - (long)offset;
    }

    public static DateTimeFormat getDefaultFormat() {
        return DEFAULT_FORMAT;
    }

    public static DateTimeFormat getStandardFormat() {
        return STANDARD_FORMAT;
    }

    public String toString() {
        return this.toString(DEFAULT_FORMAT);
    }

    public String toString(DateTimeFormat format) {
        this.getTimeInMillis();
        this.computeFields();
        int[] f = this.fields;
        return format.represent(1, this.fields[1], f[2], f[5], f[7], f[11], f[12], f[13], f[14], this.getTimeZone());
    }

    protected void computeFields() {
        byte dur;
        long time = this.time + (long)this.getTimeZone().getRawOffset() + 62135596800000L;
        long i = time % 86400000L;
        int[] f = this.fields;
        this.fields[11] = (int)(i / 3600000L);
        int h = this.fields[11];
        f[9] = h < 12 ? 0 : 1;
        f[10] = (h %= 12) == 0 ? 12 : h;
        f[12] = (int)((i %= 3600000L) / 60000L);
        f[13] = (int)((i %= 60000L) / 1000L);
        f[14] = (int)(i %= 1000L);
        i = time / 86400000L;
        int j = (int)(i / 146097L * 400L);
        if ((i %= 146097L) == 146096L) {
            j += 399;
            i = 365L;
        } else {
            j += (int)(i / 36524L * 100L);
            j += (int)((i %= 36524L) / 1461L * 4L);
            if ((i %= 1461L) == 1460L) {
                j += 3;
                i = 365L;
            } else {
                j += (int)(i / 365L);
                i %= 365L;
            }
        }
        f[1] = ++j;
        byte[] months = DAYS[GregorianCalendar.isLeapYear(j) ? 1 : 0];
        j = 0;
        while (i >= (long)(dur = months[j])) {
            i -= (long)dur;
            ++j;
        }
        f[2] = j;
        f[5] = (int)i + 1;
        f[7] = ((int)(time / 86400000L % 7L) + 1) % 7 + 1;
    }

    protected void computeTime() {
        int[] f = this.fields;
        this.correctTime();
        this.time = GregorianCalendar.computeTime(f[1], f[2] + 1, f[5], f[11], f[12], f[13], f[14], this.getTimeZone().getRawOffset());
    }

    private void correctTime() {
        boolean[] sets = this.isSet;
        int[] f = this.fields;
        if (sets[11]) {
            int hour;
            f[11] = hour = Math.abs(f[11] % 24);
            f[9] = hour < 12 ? 0 : 1;
            sets[11] = false;
            return;
        }
        if (sets[9]) {
            int ampm = f[9];
            if (ampm != 0 && ampm != 1) {
                f[9] = f[11] < 12 ? 0 : 1;
            }
            sets[9] = false;
        }
        if (sets[10]) {
            int hour = f[10];
            if (hour > 12) {
                f[11] = hour % 12 + 12;
                f[10] = hour % 12;
                f[9] = 1;
            } else {
                f[11] = f[9] == 1 ? hour + 12 : hour;
            }
            sets[10] = false;
        }
    }
}

