/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.compression.zlib;

import malik.emulator.compression.zlib.Deflate;
import malik.emulator.compression.zlib.GZIPException;
import malik.emulator.compression.zlib.ZStream;

public final class Deflater
extends ZStream {
    private boolean finished;

    public Deflater() {
    }

    public Deflater(int level) throws GZIPException {
        this(level, 15, false);
    }

    public Deflater(int level, boolean nowrap) throws GZIPException {
        this(level, 15, nowrap);
    }

    public Deflater(int level, int bits) throws GZIPException {
        this(level, bits, false);
    }

    public Deflater(int level, int bits, boolean nowrap) throws GZIPException {
        int ret = this.init(level, bits, nowrap);
        if (ret != 0) {
            throw new GZIPException(String.valueOf(Integer.toString(ret)) + ": " + this.msg);
        }
    }

    public Deflater(int level, int bits, int memlevel) throws GZIPException {
        int ret = this.init(level, bits, memlevel);
        if (ret != 0) {
            throw new GZIPException(String.valueOf(Integer.toString(ret)) + ": " + this.msg);
        }
    }

    public int deflate(int flush) {
        if (this.dstate == null) {
            return -2;
        }
        int ret = this.dstate.deflate(flush);
        if (ret == 1) {
            this.finished = true;
        }
        return ret;
    }

    public int init(int level) {
        return this.init(level, 15);
    }

    public int init(int level, boolean nowrap) {
        return this.init(level, 15, nowrap);
    }

    public int init(int level, int bits) {
        return this.init(level, bits, false);
    }

    public int init(int level, int bits, int memlevel) {
        this.finished = false;
        this.dstate = new Deflate(this);
        return this.dstate.deflateInit(level, bits, memlevel);
    }

    public int init(int level, int bits, boolean nowrap) {
        this.finished = false;
        this.dstate = new Deflate(this);
        return this.dstate.deflateInit(level, nowrap ? -bits : bits);
    }

    public int setDictionary(byte[] dictionary, int dictLength) {
        return this.dstate == null ? -2 : this.dstate.deflateSetDictionary(dictionary, dictLength);
    }

    public int params(int level, int strategy) {
        return this.dstate == null ? -2 : this.dstate.deflateParams(level, strategy);
    }

    public int copy(Deflater src) {
        this.finished = src.finished;
        return Deflate.deflateCopy(this, src);
    }

    public int end() {
        this.finished = true;
        if (this.dstate == null) {
            return -2;
        }
        int result = this.dstate.deflateEnd();
        this.dstate = null;
        this.free();
        return result;
    }

    public boolean finished() {
        return this.finished;
    }
}

