/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.microedition.system;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.CustomBackgroundScreen;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Ticker;
import malik.emulator.application.KeyboardEvent;
import malik.emulator.application.PointerEvent;
import malik.emulator.media.graphics.SystemFont;
import malik.emulator.microedition.DeviceSettings;
import malik.emulator.microedition.lcdui.InputStringBuilder;
import malik.emulator.microedition.lcdui.MultilinedStringBuilder;
import malik.emulator.microedition.system.ConsoleCommand;
import malik.emulator.microedition.system.SystemManager;

public final class Console
extends CustomBackgroundScreen {
    private static final char SPACE = ' ';
    private static final int COLS = 128;
    private static final int ROWS = 512;
    private static final int BACK_COLOR = 0x101010;
    private static final int TITLE_COLOR = 0xC0D0C0;
    private static final int PANEL_COLOR = 0xFFFFFF;
    private static final int TICKER_COLOR = 0x809080;
    public static final int DEFAULT_COLOR = 0xC0C0C0;
    static final Command BACK = new Command("\u041d\u0430\u0437\u0430\u0434", 2, Integer.MIN_VALUE);
    static final Command EXECUTE = new Command("\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c", 4, Integer.MIN_VALUE);
    private static final ConsoleCommand HELP_COMMAND = new ConsoleCommand("?", "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435:\n ?\n ? <\u043a\u043e\u043c\u0430\u043d\u0434\u0430>\n\u0412\u0430\u0440\u0438\u0430\u043d\u0442 \u0431\u0435\u0437 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u0430 \u0432\u044b\u0434\u0430\u0441\u0442 \u043e\u0431\u0449\u0443\u044e \u0441\u043f\u0440\u0430\u0432\u043a\u0443 \u043f\u043e \u043a\u043e\u043d\u0441\u043e\u043b\u0438.\n\u0412\u0430\u0440\u0438\u0430\u043d\u0442 \u0441 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u043e\u043c \u0432\u044b\u0434\u0430\u0441\u0442 \u0441\u043f\u0440\u0430\u0432\u043a\u0443 \u043f\u043e \u043a\u043e\u043c\u0430\u043d\u0434\u0435, \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u0439 \u0432 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u0435."){

        protected void execute(String[] arguments, Console console) {
            if (arguments.length > 0) {
                String name = arguments[0];
                ConsoleCommand command = console.getConsoleCommand(name);
                if (command == null || command.hidden) {
                    console.println("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u0430: ".concat(name));
                    return;
                }
                console.println(command.help);
                return;
            }
            console.printHelp();
        }
    };
    private static final ConsoleCommand CLEAR_COMMAND = new ConsoleCommand("\u043e\u0447\u0438\u0441\u0442\u0438\u0442\u044c", "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435:\n \u043e\u0447\u0438\u0441\u0442\u0438\u0442\u044c\n\u041e\u0447\u0438\u0449\u0430\u0435\u0442 \u043a\u043e\u043d\u0441\u043e\u043b\u044c \u043e\u0442 \u0442\u0435\u043a\u0441\u0442\u0430."){

        protected void execute(String[] arguments, Console console) {
            console.clear();
        }
    };
    private boolean shiftPressed;
    private int size;
    private int index;
    private int count;
    private int lines;
    private int focused;
    private int scrollHorz;
    private int scrollVert;
    private final int lineHeight;
    private final char[] buffer;
    private final char[] chars;
    private final short[] attrs;
    private final short[] sizes;
    private final String[] history;
    private ConsoleCommand[] commands;
    private final InputStringBuilder entered;
    private final Font font;
    CommandListener listener;
    final SystemManager manager;
    private final Object monitor;

    private static int getLength(short[] attrs, int offset) {
        int len = attrs.length;
        short attr = attrs[offset++];
        int result = 1;
        while (offset < len && attrs[offset++] == attr) {
            ++result;
        }
        return result;
    }

    private static int getLineEndIndex(String string, int startFromIndex, int defaultValue) {
        int result1 = string.indexOf(13, startFromIndex);
        int result2 = string.indexOf(10, startFromIndex);
        return result1 >= 0 ? (result2 >= 0 ? (result1 >= result2 ? result2 : result1) : result1) : (result2 >= 0 ? result2 : defaultValue);
    }

    private static String toString(char[] src, int offset, int length) {
        int len = length;
        char[] str = new char[len];
        Array.copy((char[])src, (int)offset, (char[])str, (int)0, (int)len);
        int i = len - 1;
        while (i-- > 0) {
            char next;
            if (str[i] != '\\' || (next = str[i + 1]) != '\"' && next != '\\' && next != 'n') continue;
            Array.copy((char[])str, (int)(i + 1), (char[])str, (int)i, (int)(len-- - i - 1));
            if (next != 'n') continue;
            str[i] = 10;
        }
        return new String(str, 0, len);
    }

    Console(String title, Ticker ticker, boolean fullScreen, SystemManager manager) {
        super(title, ticker, fullScreen);
        InputStringBuilder entered;
        SystemFont sfont = SystemFont.get((String)"Console");
        Font font = sfont == SystemFont.getDefault() ? Font.getFont((int)0, (int)0, (int)8) : Font.getFont((SystemFont)sfont, (int)0, (int)0, (int)8);
        this.count = 2;
        this.focused = -1;
        this.lineHeight = font.getHeight();
        this.buffer = new char[4096];
        this.chars = new char[65536];
        this.attrs = new short[65536];
        this.sizes = new short[512];
        this.history = new String[100];
        ConsoleCommand[] list = new ConsoleCommand[7];
        this.commands = list;
        this.entered = entered = new InputStringBuilder(null, 4096, 0);
        this.font = font;
        this.manager = manager;
        this.monitor = entered;
        list[0] = HELP_COMMAND;
        list[1] = CLEAR_COMMAND;
        InputStringBuilder inputStringBuilder = entered;
        inputStringBuilder.getClass();
        InputStringBuilder.AdditionalCapabilities owner = new InputStringBuilder.AdditionalCapabilities(inputStringBuilder, false, entered){

            public void commandAction(Command command, Displayable screen) {
                Console parent = Console.this;
                if (command == BACK) {
                    parent.manager.switchToApplicationDisplay();
                    return;
                }
                if (command == EXECUTE) {
                    parent.executeEnteredCommand();
                    return;
                }
                if (super.isMyOwnedCommand(command) || screen != parent) {
                    super.commandAction(command, screen);
                    if (this.parentBuilder().isModified()) {
                        parent.requestPaint();
                    }
                    return;
                }
                CommandListener listener = parent.listener;
                if (listener != null) {
                    listener.commandAction(command, screen);
                }
            }

            public Command[] getMyOwnedCommands() {
                Object[] result = super.getMyOwnedCommands();
                if (result == null) {
                    return new Command[]{BACK, EXECUTE};
                }
                Object[] objectArray = result;
                int len = result.length;
                result = new Command[len + 2];
                Array.copy((Object[])objectArray, (int)0, (Object[])result, (int)2, (int)len);
                result[0] = BACK;
                result[1] = EXECUTE;
                return result;
            }
        };
        super.setCommandListener((CommandListener)owner);
        Command[] commands = owner.getMyOwnedCommands();
        int len = commands == null ? 0 : commands.length;
        int i = 0;
        while (i < len) {
            Command command = commands[i];
            if (command != null) {
                super.addCommand(command);
            }
            ++i;
        }
    }

    public void setCommandListener(CommandListener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConsoleCommand(ConsoleCommand command) {
        if (command == null) {
            throw new NullPointerException("Console.addConsoleCommand: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 command \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Object object = this.monitor;
        synchronized (object) {
            Object[] list = this.commands;
            int len = this.count;
            if (this.commands.length == len) {
                Object[] objectArray = list;
                list = new ConsoleCommand[(len << 1) + 1];
                Array.copy((Object[])objectArray, (int)0, (Object[])list, (int)0, (int)len);
                this.commands = list;
            }
            list[len++] = command;
            this.count = len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.monitor;
        synchronized (object) {
            this.lines = 0;
            Array.fill((short[])this.sizes, (int)0, (int)512, (int)0);
            this.updateScrollVert();
        }
        this.repaint();
    }

    public void print(String string) {
        this.write(string == null ? "null" : string, false, 0xC0C0C0);
    }

    public void print(String string, int color) {
        this.write(string == null ? "null" : string, false, color);
    }

    public void println(String string) {
        this.write(string == null ? "null" : string, true, 0xC0C0C0);
    }

    public void println(String string, int color) {
        this.write(string == null ? "null" : string, true, color);
    }

    protected void paintBackground(Graphics render, int width, int height, byte visibleElements, byte drawingElements) {
        int elementHeight;
        int elementTop = 0;
        render.setColor(0x101010);
        if ((visibleElements & 8) != 0) {
            elementHeight = this.getTickerHeight();
            if ((drawingElements & 8) != 0) {
                render.fillRect(0, elementTop, width, elementHeight);
            }
            elementTop += elementHeight;
        }
        if ((visibleElements & 4) != 0) {
            elementHeight = this.getTitleHeight();
            if ((drawingElements & 4) != 0) {
                render.fillRect(0, elementTop, width, elementHeight);
            }
            elementTop += elementHeight;
        }
        if ((visibleElements & 1) != 0) {
            elementHeight = this.getPanelHeight();
            if ((drawingElements & 1) != 0) {
                render.fillRect(0, height - elementHeight, width, elementHeight);
            }
            elementHeight = height - elementTop - elementHeight;
        } else {
            elementHeight = height - elementTop;
        }
        if ((drawingElements & 2) != 0) {
            render.fillRect(0, elementTop, width, elementHeight);
        }
    }

    protected void paintTicker(Graphics render, int width, int height, Ticker ticker) {
        render.setColor(0x809080);
        render.drawString(ticker.getDisplayedString(), ticker.getPosition(), 0, 0);
    }

    protected void paintTitle(Graphics render, int width, int height, String title) {
        int posX = width - 1;
        int posY = height - 1;
        render.setColor(0xC0D0C0);
        render.drawLine(0, 0, posX, 0);
        render.drawLine(0, posY, posX, posY);
        render.drawString(MultilinedStringBuilder.truncate((String)title, (Font)render.getFont(), (int)width), 0, 2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintClient(Graphics render, int width, int height) {
        int line = this.lineHeight;
        char[] buffer = this.buffer;
        Font font = this.font;
        InputStringBuilder entered = this.entered;
        render.setClip(0, 0, width, height -= line + 1);
        int sh = this.scrollHorz;
        int sv = this.scrollVert;
        render.translate(-sh, -sv);
        int temp = render.getClipY();
        int srow = temp / line;
        int frow = (temp + render.getClipHeight() - 1) / line;
        render.setFont(font);
        Object object = this.monitor;
        synchronized (object) {
            int lines = this.lines;
            char[] chars = this.chars;
            short[] attrs = this.attrs;
            short[] sizes = this.sizes;
            int top = srow * line;
            int index = srow;
            int offset = srow * 128;
            while (index <= frow && index <= lines) {
                int left = 0;
                short length = sizes[index];
                int lim = offset + length;
                int begin = offset;
                while (begin < lim) {
                    int limit;
                    short c = attrs[begin];
                    int end = begin + Console.getLength(attrs, begin);
                    if (end > (limit = offset + length)) {
                        end = limit;
                    }
                    render.setColor((c & 0xF800) << 8 | (c & 0xE000) << 3 | (c & 0x7E0) << 5 | (c & 0x600) >> 1 | (c & 0x1F) << 3 | (c & 0x1C) >> 2);
                    int strlen = end - begin;
                    render.drawChars(chars, begin, strlen, left, top, 0);
                    left += font.charsWidth(chars, begin, strlen);
                    begin = end;
                }
                top += line;
                ++index;
                offset += 128;
            }
        }
        render.translate(sh, sv + height);
        render.setClip(0, 0, width, line + 1);
        render.setColor(0xFFFFFF);
        render.drawLine(0, 0, width - 1, 0);
        int len = entered.length();
        entered.copy(0, len, buffer, 0);
        int pos = entered.getCaretPosition();
        int ow = font.charsWidth(buffer, 0, len);
        int cw = font.charsWidth(buffer, 0, pos);
        int tx = (width >> 1) - cw - 1;
        if (tx + (ow + 1) < width) {
            tx = width - ow - 1;
        }
        if (tx > 0) {
            tx = 0;
        }
        render.translate(tx, 1);
        render.drawChars(buffer, 0, len, 1, 0, 0);
        render.drawLine(cw, 0, cw, line - 1);
    }

    protected void paintPanel(Graphics render, int width, int height, Command[] commands, int pressedCommandIndex) {
        int p1 = width / 3;
        int p2 = width - p1;
        this.paintCommand(render, 0, 0, p1, height, commands[0], false, pressedCommandIndex == 0);
        this.paintCommand(render, p1, 0, p2 - p1, height, commands[1], true, pressedCommandIndex == 1);
        this.paintCommand(render, p2, 0, width - p2, height, commands[2], false, pressedCommandIndex == 2);
    }

    protected void showNotify() {
        this.shiftPressed = false;
    }

    protected void keyboardNotify(KeyboardEvent event) {
        int key = event.getKey();
        int action = event.getAction();
        InputStringBuilder entered = this.entered;
        DeviceSettings settings = this.manager.getSettings();
        boolean bl = this.shiftPressed = event.isKeyPressed(16) || event.isKeyPressed(160) || event.isKeyPressed(161);
        if (key == settings.getKeyUsedAs(38)) {
            if (action == 6 || action == 5) {
                int size = this.size;
                int index = this.index;
                index = index <= 0 ? size : index - 1;
                this.index = index;
                entered.clear();
                if (index < size) {
                    entered.append(this.history[index]);
                }
                if (entered.isModified()) {
                    this.repaint();
                }
            }
            return;
        }
        if (key == settings.getKeyUsedAs(36)) {
            if (action == 6 || action == 5) {
                int index = this.index;
                int size = this.size;
                index = index >= size ? 0 : index + 1;
                this.index = index;
                entered.clear();
                if (index < size) {
                    entered.append(this.history[index]);
                }
                if (entered.isModified()) {
                    this.repaint();
                }
            }
            return;
        }
        if (key == settings.getKeyUsedAs(40)) {
            if (action == 6 || action == 5) {
                entered.setCaretPosition(entered.getCaretPosition() - 1);
                if (entered.isModified()) {
                    this.repaint();
                }
            }
            return;
        }
        if (key == settings.getKeyUsedAs(41)) {
            if (action == 6 || action == 5) {
                entered.setCaretPosition(entered.getCaretPosition() + 1);
                if (entered.isModified()) {
                    this.repaint();
                }
            }
            return;
        }
        entered.keyboardEvent(event);
        if (entered.isModified()) {
            this.repaint();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void pointerNotify(PointerEvent event) {
        int action = event.getAction();
        switch (action) {
            case 10: 
            case 14: {
                int caretCol;
                int line;
                switch (event.getButton()) {
                    case 14: {
                        if (this.shiftPressed) {
                            this.scroll(-16, 0);
                        } else {
                            this.scroll(0, -this.lineHeight);
                        }
                        this.repaint();
                        return;
                    }
                    case 15: {
                        if (this.shiftPressed) {
                            this.scroll(16, 0);
                        } else {
                            this.scroll(0, this.lineHeight);
                        }
                        this.repaint();
                        return;
                    }
                }
                if (action == 14) {
                    return;
                }
                int y = event.getY();
                if (y < (line = super.getHeight() - this.lineHeight - 1)) {
                    this.focused = 0;
                    return;
                }
                if (y <= line) return;
                int width = super.getWidth();
                char[] buffer = this.buffer;
                Font font = this.font;
                InputStringBuilder entered = this.entered;
                int len = entered.length();
                entered.copy(0, len, buffer, 0);
                int pos = entered.getCaretPosition();
                int ow = font.charsWidth(buffer, 0, len);
                int cw = font.charsWidth(buffer, 0, pos);
                int tx = (width >> 1) - cw - 1;
                if (tx + (ow + 1) < width) {
                    tx = width - ow - 1;
                }
                if (tx > 0) {
                    tx = 0;
                }
                int charsWidth = event.getX() - tx;
                int w1 = 0;
                int i = 1;
                while (true) {
                    if (i > len) {
                        caretCol = len;
                        break;
                    }
                    int w2 = font.charsWidth(buffer, 0, i);
                    if (charsWidth >= w1 && charsWidth < w2) {
                        caretCol = charsWidth - w1 <= w2 - charsWidth ? i - 1 : i;
                        break;
                    }
                    w1 = w2;
                    ++i;
                }
                entered.setCaretPosition(caretCol);
                if (!entered.isModified()) return;
                this.repaint();
                return;
            }
            case 11: {
                if (this.focused != 0) return;
                this.focused = -1;
                this.scroll(event.historicalX(1) - event.getX(), event.historicalY(1) - event.getY());
                this.repaint();
                return;
            }
        }
        if (this.focused != 0) return;
        this.scroll(event.historicalX(1) - event.getX(), event.historicalY(1) - event.getY());
        this.repaint();
    }

    protected int getPanelCommandIndex(int x, int y, int width, int height) {
        if (x >= 0 && x < width && y >= 0 && y < height) {
            int p1 = width / 3;
            int p2 = width - p1;
            return x < p1 ? 0 : (x < p2 ? 1 : 2);
        }
        return -1;
    }

    protected int getTickerHeight() {
        return this.getTickerFont().getHeight() + 1;
    }

    protected int getTitleHeight() {
        return this.getTitleFont().getHeight() + 4;
    }

    protected int getPanelHeight() {
        return this.getDefaultCommandFont().getHeight() + 5;
    }

    void requestPaint() {
        this.repaint();
    }

    void printHelp() {
        int len = this.count;
        ConsoleCommand[] list = this.commands;
        this.write("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u043a\u043e\u043c\u0430\u043d\u0434\u044b:", true, 0xC0C0C0);
        int i = 0;
        while (i < len) {
            ConsoleCommand command = list[i];
            if (!command.hidden) {
                this.write(" ".concat(command.name), true, 0xC0C0C0);
            }
            ++i;
        }
        this.write("\u041a\u043e\u043c\u0430\u043d\u0434\u0430\n ? <\u043a\u043e\u043c\u0430\u043d\u0434\u0430>\n\u0432\u044b\u0432\u0435\u0434\u0435\u0442 \u0441\u043f\u0440\u0430\u0432\u043a\u0443 \u043f\u043e \u0437\u0430\u0434\u0430\u043d\u043d\u043e\u0439 \u043a\u043e\u043c\u0430\u043d\u0434\u0435.\n\u041a\u043e\u043c\u0430\u043d\u0434\u044b \u0432\u0432\u043e\u0434\u044f\u0442\u0441\u044f \u0441 \u0443\u0447\u0451\u0442\u043e\u043c \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430, \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u044b \u0440\u0430\u0437\u0434\u0435\u043b\u044f\u044e\u0442\u0441\u044f \u043f\u0440\u043e\u0431\u0435\u043b\u0430\u043c\u0438.\n\u0410\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u044b \u0441 \u043f\u0440\u043e\u0431\u0435\u043b\u0430\u043c\u0438 \u0441\u043b\u0435\u0434\u0443\u0435\u0442 \u0437\u0430\u043a\u043b\u044e\u0447\u0430\u0442\u044c \u0432 \u043a\u0430\u0432\u044b\u0447\u043a\u0438 \"\u2026\".\n\u041f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u044e\u0442\u0441\u044f escape-\u043f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438: \\n, \\\" \u0438 \\\\.\n\u0421 \u043f\u043e\u043c\u043e\u0449\u044c\u044e \u0441\u0442\u0440\u0435\u043b\u043e\u043a \u2191 \u0438 \u2193 \u043c\u043e\u0436\u043d\u043e \u043f\u0440\u043e\u043a\u0440\u0443\u0442\u0438\u0442\u044c \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 \u043d\u0430\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u043a\u043e\u043c\u0430\u043d\u0434\u044b.\n\u0421 \u043f\u043e\u043c\u043e\u0449\u044c\u044e \u0443\u043a\u0430\u0437\u044b\u0432\u0430\u044e\u0449\u0435\u0433\u043e \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 \u043c\u043e\u0436\u043d\u043e \u043f\u0440\u043e\u043a\u0440\u0443\u0442\u0438\u0442\u044c \u0442\u0435\u043a\u0441\u0442 \u043a\u043e\u043d\u0441\u043e\u043b\u0438.", true, 0xC0C0C0);
        this.write("\u042d\u0442\u0438\u043c \u0446\u0432\u0435\u0442\u043e\u043c ", false, 49152);
        this.write("\u0432\u044b\u0432\u043e\u0434\u0438\u0442\u0441\u044f \u0432\u0441\u0451, \u0447\u0442\u043e \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0432\u044b\u0432\u043e\u0434\u0438\u0442 \u0447\u0435\u0440\u0435\u0437 System.out.", true, 0xC0C0C0);
        this.write("\u042d\u0442\u0438\u043c \u0446\u0432\u0435\u0442\u043e\u043c ", false, 0xFF4040);
        this.write("\u0432\u044b\u0432\u043e\u0434\u0438\u0442\u0441\u044f \u0432\u0441\u0451, \u0447\u0442\u043e \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0432\u044b\u0432\u043e\u0434\u0438\u0442 \u0447\u0435\u0440\u0435\u0437 System.err.", true, 0xC0C0C0);
    }

    void executeEnteredCommand() {
        boolean cq;
        int c;
        InputStringBuilder entered = this.entered;
        int len = entered.length();
        char[] buffer = this.buffer;
        entered.copy(0, len, this.buffer, 0);
        int argsStart = -1;
        int i0 = -1;
        int i = 0;
        while (i <= len) {
            c = i < len ? buffer[i] : 0;
            if (c > 32 && (i <= 0 || buffer[i - 1] <= ' ')) {
                i0 = i;
            }
            if (i > 0 && c <= 32 && buffer[i - 1] > ' ') {
                argsStart = i + 1;
                break;
            }
            ++i;
        }
        if (i0 < 0 || argsStart < 0) {
            return;
        }
        String name = new String(buffer, i0, argsStart - i0 - 1);
        boolean q = false;
        int argsLen = 0;
        int p = buffer[argsStart - 1];
        int i2 = argsStart;
        while (i2 <= len) {
            c = i2 < len ? buffer[i2] : 0;
            cq = c == 34 && p != 92;
            if (cq) {
                q = !q;
                c = 32;
            }
            if (cq ? !q : (q ? i2 == len : c <= 32 && p > 32)) {
                ++argsLen;
            }
            p = c;
            ++i2;
        }
        q = false;
        int index = 0;
        String[] args = new String[argsLen];
        p = buffer[argsStart - 1];
        i2 = argsStart;
        while (i2 <= len) {
            c = i2 < len ? buffer[i2] : 0;
            cq = c == 34 && p != 92;
            if (cq) {
                q = !q;
                c = 32;
            }
            if (cq ? q : !q && c > 32 && p <= 32) {
                int n = i0 = cq ? i2 + 1 : i2;
            }
            if (cq ? !q : (q ? i2 == len : c <= 32 && p > 32)) {
                args[index++] = Console.toString(buffer, i0, i2 - i0);
            }
            p = c;
            ++i2;
        }
        if (index < argsLen) {
            return;
        }
        String text = String.valueOf(buffer, 0, len).intern();
        this.addToHistory(text);
        entered.clear();
        this.write(text, true, 0xFFFFFF);
        this.serviceRepaints();
        ConsoleCommand command = this.getConsoleCommand(name);
        if (command == null) {
            this.write("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u0430: ".concat(name), true, 0xC0C0C0);
            return;
        }
        command.execute(args, this);
    }

    ConsoleCommand getConsoleCommand(String name) {
        ConsoleCommand[] list = this.commands;
        int i = this.count;
        while (i-- > 0) {
            ConsoleCommand command = list[i];
            if (!name.equals(command.name)) continue;
            return command;
        }
        return null;
    }

    private void paintCommand(Graphics render, int left, int top, int width, int height, Command command, boolean asDefault, boolean asPressed) {
        if (command == null) {
            return;
        }
        int x = left + (width >> 1) + (asPressed ? 1 : 0);
        int y = top + (asPressed ? 3 : 2);
        Font font = asDefault ? this.getDefaultCommandFont() : this.getNormalCommandFont();
        render.setFont(font);
        render.setColor(0xFFFFFF);
        render.drawRoundRect(left, top, width - 1, height - 1, 2, 2);
        render.drawString(command.getTruncatedLabel(width - 4, font), x, y, 17);
    }

    private void scroll(int deltaX, int deltaY) {
        int line = this.lineHeight;
        int maxScrollVert = (this.lines + 1) * line;
        long newScrollHorz = (long)this.scrollHorz + (long)deltaX;
        long newScrollVert = (long)this.scrollVert + (long)deltaY;
        if ((maxScrollVert -= super.getHeight() - line - 1) < 0) {
            maxScrollVert = 0;
        }
        int n = newScrollHorz < 0L ? 0 : (this.scrollHorz = newScrollHorz > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)newScrollHorz);
        this.scrollVert = newScrollVert < 0L ? 0 : (newScrollVert > (long)maxScrollVert ? maxScrollVert : (int)newScrollVert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(String string, boolean ending, int color) {
        short consoleAttr = (short)((color & 0xF80000) >> 8 | (color & 0xFC00) >> 5 | (color & 0xF8) >> 3);
        int stringLength = string.length();
        Object object = this.monitor;
        synchronized (object) {
            int consoleLineIndex = this.lines;
            char[] consoleChars = this.chars;
            short[] consoleAttrs = this.attrs;
            short[] consoleSizes = this.sizes;
            short consoleLineLength = consoleSizes[consoleLineIndex];
            int consoleCharOffset = 128 * consoleLineIndex + consoleLineLength;
            int stringBegin = 0;
            while (stringBegin < stringLength) {
                boolean newLine;
                int stringLengthLimit = 128 - consoleLineLength;
                int stringEnd = Console.getLineEndIndex(string, stringBegin, stringLength);
                if (stringEnd < 0) {
                    newLine = false;
                    if (stringEnd - stringBegin > stringLengthLimit) {
                        stringEnd = stringBegin + stringLengthLimit;
                    }
                } else if (stringEnd - stringBegin > stringLengthLimit) {
                    newLine = false;
                    stringEnd = stringBegin + stringLengthLimit;
                } else {
                    newLine = true;
                }
                int substringLength = stringEnd - stringBegin;
                consoleSizes[consoleLineIndex] = (short)(consoleLineLength + substringLength);
                Array.fill((short[])consoleAttrs, (int)consoleCharOffset, (int)substringLength, (int)consoleAttr);
                string.getChars(stringBegin, stringEnd, consoleChars, consoleCharOffset);
                if (stringEnd < stringLength) {
                    if (this.lift(consoleLineIndex, consoleChars, consoleAttrs, consoleSizes)) {
                        ++consoleLineIndex;
                    }
                    consoleCharOffset = 128 * consoleLineIndex;
                    consoleLineLength = 0;
                }
                if (!newLine || ++stringEnd >= stringLength || string.charAt(stringEnd - 1) != '\r' || string.charAt(stringEnd) == '\n') {
                    // empty if block
                }
                stringBegin = ++stringEnd;
            }
            if (ending) {
                this.lift(consoleLineIndex, consoleChars, consoleAttrs, consoleSizes);
            }
            this.updateScrollVert();
        }
        this.repaint();
    }

    private void updateScrollVert() {
        if (this.focused < 0) {
            int line = this.lineHeight;
            int scrollRange = (this.lines + 1) * line;
            int scrollPos = scrollRange - (super.getHeight() - line - 1);
            if (scrollPos < 0) {
                scrollPos = 0;
            }
            this.scrollHorz = 0;
            this.scrollVert = scrollPos;
        }
    }

    private void addToHistory(String command) {
        int size = this.size;
        Object[] history = this.history;
        if (size < history.length) {
            history[size++] = command;
            this.index = size;
            this.size = size;
            return;
        }
        this.index = size--;
        Array.copy((Object[])history, (int)1, (Object[])history, (int)0, (int)size);
        history[size] = command;
    }

    private boolean lift(int lines, char[] chars, short[] attrs, short[] sizes) {
        if (lines < 511) {
            this.lines = lines + 1;
            return true;
        }
        Array.copy((char[])chars, (int)128, (char[])chars, (int)0, (int)65408);
        Array.fill((char[])chars, (int)65408, (int)128, (int)0);
        Array.copy((short[])attrs, (int)128, (short[])attrs, (int)0, (int)65408);
        Array.fill((short[])attrs, (int)65408, (int)128, (int)0);
        Array.copy((short[])sizes, (int)1, (short[])sizes, (int)0, (int)511);
        sizes[511] = 0;
        return false;
    }
}

