/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.microedition.system.console;

import malik.emulator.microedition.DeviceManager;
import malik.emulator.microedition.DeviceSettings;
import malik.emulator.microedition.system.Console;
import malik.emulator.microedition.system.ConsoleCommand;
import malik.emulator.util.StringBuilder;

public class DeviceKeyConsoleCommand
extends ConsoleCommand {
    private static final int[] DEVICE_KEY_CODES = new int[]{49, 50, 51, 52, 53, 54, 55, 56, 57, 42, 48, 35, 38, 36, 40, 41, 43, 37, 39, 44, 46};
    private static final String[] DEVICE_KEY_NAMES = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "*", "0", "#", "\u0432\u0432\u0435\u0440\u0445", "\u0432\u043d\u0438\u0437", "\u0432\u043b\u0435\u0432\u043e", "\u0432\u043f\u0440\u0430\u0432\u043e", "\u0432\u044b\u0431\u043e\u0440", "\u043b\u043a\u0432", "\u043f\u043a\u0432", "\u043a\u043e\u043d\u0441\u043e\u043b\u044c", "\u0432\u044b\u0445\u043e\u0434"};

    private static int getCompjuterKey(String name) {
        return name == null ? 0 : DeviceSettings.stringToKey((String)name.toUpperCase());
    }

    private static int getDeviceKeyCode(String name) {
        if (name == null) {
            return 0;
        }
        int i = DEVICE_KEY_NAMES.length;
        while (i-- > 0) {
            if (!name.equals(DEVICE_KEY_NAMES[i])) continue;
            return DEVICE_KEY_CODES[i];
        }
        return 0;
    }

    public DeviceKeyConsoleCommand() {
        super("\u043a\u043b\u0430\u0432\u0438\u0448\u0430", "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435:\n \u043a\u043b\u0430\u0432\u0438\u0448\u0430\n \u043a\u043b\u0430\u0432\u0438\u0448\u0430 <\u043a\u043b\u0430\u0432\u0438\u0448\u0430 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430>\n \u043a\u043b\u0430\u0432\u0438\u0448\u0430 <\u043a\u043b\u0430\u0432\u0438\u0448\u0430 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430> <\u043a\u043b\u0430\u0432\u0438\u0448\u0430 \u043a\u043e\u043c\u043f\u044c\u044e\u0442\u0435\u0440\u0430>\n\u0412\u0430\u0440\u0438\u0430\u043d\u0442 \u0431\u0435\u0437 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0432\u044b\u0432\u043e\u0434\u0438\u0442 \u043d\u0430 \u043a\u043e\u043d\u0441\u043e\u043b\u044c \u0432\u0441\u0435 \u043a\u043b\u0430\u0432\u0438\u0448\u0438 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 \u0438 \u044d\u043a\u0432\u0438\u0432\u0430\u043b\u0435\u043d\u0442\u043d\u044b\u0435 \u0438\u043c \u043a\u043b\u0430\u0432\u0438\u0448\u0438 \u043a\u043e\u043c\u043f\u044c\u044e\u0442\u0435\u0440\u0430.\n\u0412\u0430\u0440\u0438\u0430\u043d\u0442 \u0441 \u043e\u0434\u043d\u0438\u043c \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u043e\u043c \u0432\u044b\u0432\u043e\u0434\u0438\u0442 \u043d\u0430 \u043a\u043e\u043d\u0441\u043e\u043b\u044c \u043a\u043b\u0430\u0432\u0438\u0448\u0443 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 \u0438 \u044d\u043a\u0432\u0438\u0432\u0430\u043b\u0435\u043d\u0442\u043d\u0443\u044e \u0435\u0439 \u043a\u043b\u0430\u0432\u0438\u0448\u0443 \u043a\u043e\u043c\u043f\u044c\u044e\u0442\u0435\u0440\u0430.\n\u0412\u0430\u0440\u0438\u0430\u043d\u0442 \u0441 \u0434\u0432\u0443\u043c\u044f \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u0430\u043c\u0438 \u0437\u0430\u0434\u0430\u0451\u0442 \u043d\u043e\u0432\u0443\u044e \u044d\u043a\u0432\u0438\u0432\u0430\u043b\u0435\u043d\u0442\u043d\u0443\u044e \u043a\u043b\u0430\u0432\u0438\u0448\u0443 \u043a\u043e\u043c\u043f\u044c\u044e\u0442\u0435\u0440\u0430 \u0434\u043b\u044f \u0437\u0430\u0434\u0430\u043d\u043d\u043e\u0439 \u043a\u043b\u0430\u0432\u0438\u0448\u0438 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430.\n\u0421\u043b\u0435\u0434\u0438\u0442\u0435 \u0437\u0430 \u0442\u0435\u043c, \u0447\u0442\u043e\u0431\u044b \u0434\u043b\u044f \u0440\u0430\u0437\u043d\u044b\u0445 \u043a\u043b\u0430\u0432\u0438\u0448 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 \u0431\u044b\u043b\u0438 \u0437\u0430\u0434\u0430\u043d\u044b \u0440\u0430\u0437\u043d\u044b\u0435 \u043a\u043b\u0430\u0432\u0438\u0448\u0438 \u043a\u043e\u043c\u043f\u044c\u044e\u0442\u0435\u0440\u0430.");
    }

    protected void execute(String[] arguments, Console console) {
        int alen = arguments.length;
        DeviceSettings proxy = DeviceManager.getInstance().getSettings();
        if (alen <= 0) {
            StringBuilder text = new StringBuilder();
            int len = DEVICE_KEY_NAMES.length;
            int i = 0;
            while (i < len) {
                text.append(DEVICE_KEY_NAMES[i]).append(" \u2013 ").append(DeviceSettings.keyToString((int)proxy.getKeyUsedAs(DEVICE_KEY_CODES[i]))).append('\n');
                ++i;
            }
            console.print(text.toString());
            return;
        }
        if (alen == 1) {
            String argument = arguments[0];
            int deviceKey = DeviceKeyConsoleCommand.getDeviceKeyCode(argument);
            if (deviceKey == 0) {
                console.println("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043a\u043b\u0430\u0432\u0438\u0448\u0430 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 ".concat(argument));
                return;
            }
            console.println(new StringBuilder().append(argument).append(" \u2013 ").append(DeviceSettings.keyToString((int)proxy.getKeyUsedAs(deviceKey))).toString());
            return;
        }
        String argument = arguments[0];
        int deviceKey = DeviceKeyConsoleCommand.getDeviceKeyCode(argument);
        if (deviceKey == 0) {
            console.println("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043a\u043b\u0430\u0432\u0438\u0448\u0430 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 ".concat(argument));
            return;
        }
        argument = arguments[1];
        int compjuterKey = DeviceKeyConsoleCommand.getCompjuterKey(argument);
        if (compjuterKey == 0) {
            console.println("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043a\u043b\u0430\u0432\u0438\u0448\u0430 \u043a\u043e\u043c\u043f\u044c\u044e\u0442\u0435\u0440\u0430 ".concat(argument));
            return;
        }
        proxy.setKeyUsedAs(deviceKey, compjuterKey);
    }
}

