/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.microedition.system.player;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import javax.microedition.media.Control;
import javax.microedition.media.MediaException;
import malik.emulator.fileformats.sound.sampled.SampledSoundDecoder;
import malik.emulator.media.sound.SampledSoundPlayer;
import malik.emulator.media.sound.SoundPlayer;
import malik.emulator.media.sound.SoundPlayerException;
import malik.emulator.media.sound.SoundPlayerListener;
import malik.emulator.microedition.media.ControlList;
import malik.emulator.microedition.media.CustomPlayer;
import malik.emulator.microedition.media.SampledPlayerDecoder;
import malik.emulator.microedition.system.player.Volume;

public final class SampledPlayer
extends CustomPlayer {
    private final boolean closeNeed;
    private double microsPerPackedSample;
    private int channels;
    private int samplesPerSecond;
    private Playback playback;
    private InputStream stream;
    private final SampledSoundDecoder decoder;

    private static long[] packSamples(short[] samples) {
        int sample3;
        int sample2;
        int sample1;
        int sample0;
        int pos = 0;
        int slen = samples == null ? 0 : samples.length;
        int len = slen >> 2;
        long[] result = new long[len + 1];
        int i = 0;
        while (i < len) {
            sample0 = samples[pos++] & 0xFFFF;
            sample1 = samples[pos++] & 0xFFFF;
            sample2 = samples[pos++] & 0xFFFF;
            sample3 = samples[pos++] & 0xFFFF;
            result[i] = (long)sample0 | (long)sample1 << 16 | (long)sample2 << 32 | (long)sample3 << 48;
            ++i;
        }
        sample0 = (pos < slen ? samples[pos++] : (pos > 0 ? samples[pos - 1] : (short)0)) & 0xFFFF;
        sample1 = (pos < slen ? samples[pos++] : (pos > 0 ? samples[pos - 1] : (short)0)) & 0xFFFF;
        sample2 = (pos < slen ? samples[pos++] : (pos > 0 ? samples[pos - 1] : (short)0)) & 0xFFFF;
        sample3 = (pos < slen ? samples[pos++] : (pos > 0 ? samples[pos - 1] : (short)0)) & 0xFFFF;
        result[len] = (long)sample0 | (long)sample1 << 16 | (long)sample2 << 32 | (long)sample3 << 48;
        return result;
    }

    public SampledPlayer(SampledPlayerDecoder decoder, InputStream stream, boolean closeNeed) {
        int len;
        if (decoder == null) {
            throw new NullPointerException("SampledPlayer: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 decoder \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (stream == null) {
            throw new NullPointerException("SampledPlayer: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 stream \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        SampledPlayer sampledPlayer = this;
        ((Object)((Object)sampledPlayer)).getClass();
        Playback playback = sampledPlayer.new Playback(this.monitor);
        Object[] controls = decoder.getControls();
        if (controls == null || (len = controls.length) <= 0) {
            controls = new Control[]{playback};
        } else {
            Object[] objectArray = controls;
            controls = new Control[len + 1];
            Array.copy((Object[])objectArray, (int)0, (Object[])controls, (int)0, (int)len);
            controls[len] = playback;
        }
        ((ControlList)this).controls = controls;
        this.contentType = decoder.getContentType();
        this.closeNeed = closeNeed;
        this.playback = playback;
        this.stream = stream;
        this.decoder = decoder;
    }

    public SampledSoundDecoder getDecoder() {
        return this.decoder;
    }

    protected void postEvent(String event, Object data) {
        super.postEvent(event, data);
    }

    protected void playerClose() {
        Playback playback = this.playback;
        if (playback != null) {
            playback.closeSystemPlayer();
            playback.packedSamples = null;
        }
        this.playback = null;
        this.stream = null;
        this.decoder.stopDecoding();
    }

    protected void playerRestart() {
        super.playerRestart();
    }

    protected void playerEndOfMedia() {
        super.playerEndOfMedia();
    }

    protected void playerUnrealize() {
        this.decoder.stopDecoding();
    }

    protected void playerUnprefetch() {
        Playback playback = this.playback;
        if (playback != null) {
            playback.closeSystemPlayer();
        }
    }

    protected void playerRealize() throws MediaException, InterruptedException {
        Playback playback;
        InputStream stream = this.stream;
        if (stream != null && (playback = this.playback) != null) {
            this.stream = null;
            try {
                int ss;
                int c;
                SampledSoundDecoder decoder;
                try {
                    decoder = this.decoder;
                    decoder.loadFromInputStream(stream);
                }
                finally {
                    if (this.closeNeed) {
                        stream.close();
                    }
                }
                this.channels = c = decoder.getChannels();
                this.samplesPerSecond = ss = decoder.getSamplesPerSecond();
                long samples = (long)c * (long)ss;
                this.microsPerPackedSample = 4000000.0 / (double)samples;
                playback.packedSamples = SampledPlayer.packSamples(decoder.getSamples());
                int len = playback.packedSamples.length;
                this.setDuration(4000000L * (long)len / samples);
            }
            catch (InterruptedIOException interruptedIOException) {
                throw new InterruptedException();
            }
            catch (IOException e) {
                throw new MediaException(e.getMessage());
            }
        }
    }

    protected void playerPrefetch() throws MediaException {
        Playback playback = this.playback;
        if (playback != null && playback.systemPlayer == null) {
            try {
                playback.setSystemPlayer(SampledSoundPlayer.open((int)this.channels, (int)this.samplesPerSecond, (int)65536));
            }
            catch (SoundPlayerException e) {
                throw new MediaException(e.getMessage());
            }
        }
    }

    protected void playerStart() throws MediaException {
        SampledSoundPlayer player;
        Playback playback = this.playback;
        if (playback != null && (player = playback.systemPlayer) != null) {
            long[] samples = playback.packedSamples;
            if (playback.packedSamples != null) {
                if (playback.loopCountRemaining == 0) {
                    playback.loopCountRemaining = playback.loopCountSetted;
                }
                try {
                    if (playback.loaded) {
                        player.start();
                    } else {
                        int pos = playback.position;
                        player.loadBlock(samples, pos, Math.min(samples.length - pos, 65536));
                        playback.loaded = true;
                    }
                }
                catch (SoundPlayerException e) {
                    throw new MediaException(e.getMessage());
                }
            }
        }
    }

    protected void playerStop() throws MediaException {
        SampledSoundPlayer player;
        Playback playback = this.playback;
        if (playback != null && (player = playback.systemPlayer) != null) {
            try {
                player.stop();
            }
            catch (SoundPlayerException e) {
                throw new MediaException(e.getMessage());
            }
        }
    }

    protected void playerSetLoopCount(int loopCount) {
        Playback playback = this.playback;
        if (playback != null) {
            playback.loopCountSetted = loopCount;
            playback.loopCountRemaining = loopCount;
        }
    }

    protected long playerSetMediaTime(long mediaTime) throws MediaException {
        SampledSoundPlayer player;
        Playback playback = this.playback;
        if (playback != null && (player = playback.systemPlayer) != null) {
            long[] samples = playback.packedSamples;
            if (playback.packedSamples != null) {
                int pos;
                double microsPS = this.microsPerPackedSample;
                int lim = samples.length - 1;
                long maxTime = (long)(microsPS * (double)lim);
                if (mediaTime < 0L) {
                    mediaTime = 0L;
                }
                if (mediaTime > maxTime) {
                    mediaTime = maxTime;
                }
                if ((pos = (int)((double)mediaTime / microsPS)) < 0) {
                    pos = 0;
                }
                if (pos > lim) {
                    pos = lim;
                }
                playback.position = pos;
                mediaTime = (long)(microsPS * (double)pos);
                try {
                    switch (this.getState()) {
                        case 300: {
                            if (playback.loaded) {
                                player.reset();
                                playback.loaded = false;
                            }
                            break;
                        }
                        case 400: {
                            player.reset();
                            player.loadBlock(samples, pos, Math.min(lim - pos + 1, 65536));
                            playback.loaded = true;
                        }
                    }
                }
                catch (SoundPlayerException e) {
                    throw new MediaException(e.getMessage());
                }
            }
        }
        return mediaTime;
    }

    protected long playerGetMediaTime() {
        SampledSoundPlayer player;
        Playback playback = this.playback;
        if (playback != null && (player = playback.systemPlayer) != null && playback.packedSamples != null) {
            int pos;
            if (playback.loaded) {
                try {
                    long blockpos = player.getCurrentBlockIndexAndPosition();
                    pos = playback.position + (int)(blockpos >> 32) * 65536 + (int)blockpos;
                }
                catch (SoundPlayerException soundPlayerException) {
                    pos = playback.position;
                }
            } else {
                pos = playback.position;
            }
            return (long)(this.microsPerPackedSample * (double)pos);
        }
        return -1L;
    }

    private final class Playback
    extends Volume
    implements SoundPlayerListener {
        boolean loaded;
        int position;
        int loopCountSetted = 1;
        int loopCountRemaining = 1;
        long[] packedSamples;
        SampledSoundPlayer systemPlayer;

        public Playback(Object monitor) {
            super(monitor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endOfBlock(SoundPlayer player, int blockIndexForLoad) {
            Object object = this.monitor;
            synchronized (object) {
                int len;
                SampledPlayer parent = SampledPlayer.this;
                long[] samples = this.packedSamples;
                int n = len = this.packedSamples == null ? 0 : samples.length;
                if (blockIndexForLoad < 0) {
                    if (--this.loopCountRemaining == 0) {
                        this.loaded = false;
                        parent.playerEndOfMedia();
                    } else {
                        parent.playerRestart();
                        try {
                            player.loadBlock(samples, 0, Math.min(len, 65536));
                        }
                        catch (SoundPlayerException e) {
                            e.printRealStackTrace();
                        }
                    }
                } else {
                    int pos = this.position + blockIndexForLoad * 65536;
                    if (pos >= 0 && pos < len) {
                        try {
                            player.loadBlock(samples, pos, Math.min(len - pos, 65536));
                        }
                        catch (SoundPlayerException e) {
                            e.printRealStackTrace();
                        }
                    }
                }
            }
        }

        public void setSystemPlayer(SampledSoundPlayer player) throws SoundPlayerException {
            this.setupSystemPlayer((SoundPlayer)player);
            this.loaded = false;
            this.systemPlayer = player;
        }

        public void closeSystemPlayer() {
            SampledSoundPlayer player = this.systemPlayer;
            if (player != null) {
                this.systemPlayer = null;
                player.close();
            }
        }

        protected void volumeChanged(boolean muted, int level) {
            SampledPlayer.this.postEvent("volumeChanged", this);
        }

        protected void setupSystemPlayer(SoundPlayer player) throws SoundPlayerException {
            player.setSoundPlayerListener((SoundPlayerListener)this);
            super.setupSystemPlayer(player);
        }

        protected SoundPlayer getSystemPlayer() {
            return this.systemPlayer;
        }
    }
}

