/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.microedition.system.player;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import javax.microedition.media.Control;
import javax.microedition.media.MediaException;
import javax.microedition.media.control.MIDIControl;
import malik.emulator.fileformats.sound.synthetic.SyntheticSoundDecoder;
import malik.emulator.media.sound.SoundPlayer;
import malik.emulator.media.sound.SoundPlayerException;
import malik.emulator.media.sound.SoundPlayerListener;
import malik.emulator.media.sound.SyntheticSoundPlayer;
import malik.emulator.microedition.media.ControlList;
import malik.emulator.microedition.media.CustomPlayer;
import malik.emulator.microedition.media.SyntheticPlayerDecoder;
import malik.emulator.microedition.system.player.BankQueryNotSupportedException;
import malik.emulator.microedition.system.player.Volume;

public final class SyntheticPlayer
extends CustomPlayer {
    private final boolean closeNeed;
    private Playback playback;
    private InputStream stream;
    private final SyntheticSoundDecoder decoder;

    public SyntheticPlayer(SyntheticPlayerDecoder decoder, InputStream stream, boolean closeNeed) {
        int len;
        if (decoder == null) {
            throw new NullPointerException("SyntheticPlayer: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 decoder \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (stream == null) {
            throw new NullPointerException("SyntheticPlayer: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 stream \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        SyntheticPlayer syntheticPlayer = this;
        ((Object)((Object)syntheticPlayer)).getClass();
        Playback playback = syntheticPlayer.new Playback(this.monitor);
        Object[] controls = decoder.getControls();
        if (controls == null || (len = controls.length) <= 0) {
            controls = new Control[]{playback};
        } else {
            Object[] objectArray = controls;
            controls = new Control[len + 1];
            Array.copy((Object[])objectArray, (int)0, (Object[])controls, (int)0, (int)len);
            controls[len] = playback;
        }
        ((ControlList)this).controls = controls;
        this.contentType = decoder.getContentType();
        this.closeNeed = closeNeed;
        this.playback = playback;
        this.stream = stream;
        this.decoder = decoder;
    }

    public SyntheticSoundDecoder getDecoder() {
        return this.decoder;
    }

    protected void postEvent(String event, Object data) {
        super.postEvent(event, data);
    }

    protected void playerClose() {
        Playback playback = this.playback;
        if (playback != null) {
            playback.closeSystemPlayer();
            playback.synthesizerMessages = null;
        }
        this.playback = null;
        this.stream = null;
        this.decoder.stopDecoding();
    }

    protected void playerRestart() {
        super.playerRestart();
    }

    protected void playerEndOfMedia() {
        super.playerEndOfMedia();
    }

    protected void playerUnrealize() {
        this.decoder.stopDecoding();
    }

    protected void playerUnprefetch() {
        Playback playback = this.playback;
        if (playback != null) {
            playback.closeSystemPlayer();
        }
    }

    protected void playerRealize() throws MediaException, InterruptedException {
        Playback playback;
        InputStream stream = this.stream;
        if (stream != null && (playback = this.playback) != null) {
            this.stream = null;
            try {
                int lim;
                SyntheticSoundDecoder decoder;
                try {
                    decoder = this.decoder;
                    decoder.loadFromInputStream(stream);
                }
                finally {
                    if (this.closeNeed) {
                        stream.close();
                    }
                }
                long[] messages = decoder.getMessages();
                playback.synthesizerMessages = messages;
                if (messages != null && (lim = messages.length - 1) >= 0) {
                    this.setDuration(1000L * (messages[lim] >> 24));
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                throw new InterruptedException();
            }
            catch (IOException e) {
                throw new MediaException(e.getMessage());
            }
        }
    }

    protected void playerPrefetch() throws MediaException {
        Playback playback = this.playback;
        if (playback != null && playback.systemPlayer == null) {
            try {
                playback.setSystemPlayer(SyntheticSoundPlayer.open());
            }
            catch (SoundPlayerException e) {
                throw new MediaException(e.getMessage());
            }
        }
    }

    protected void playerStart() throws MediaException {
        SyntheticSoundPlayer player;
        Playback playback = this.playback;
        if (playback != null && (player = playback.systemPlayer) != null) {
            long[] messages = playback.synthesizerMessages;
            if (playback.synthesizerMessages != null) {
                if (playback.loopCountRemaining == 0) {
                    playback.loopCountRemaining = playback.loopCountSetted;
                }
                try {
                    if (playback.loaded) {
                        player.start();
                    } else {
                        player.loadBlock(messages, 0, messages.length);
                        playback.loaded = true;
                        int pos = playback.position;
                        if (pos > 0) {
                            player.setCurrentBlockPosition(pos);
                        }
                    }
                }
                catch (SoundPlayerException e) {
                    throw new MediaException(e.getMessage());
                }
            }
        }
    }

    protected void playerStop() throws MediaException {
        SyntheticSoundPlayer player;
        Playback playback = this.playback;
        if (playback != null && (player = playback.systemPlayer) != null) {
            try {
                player.stop();
            }
            catch (SoundPlayerException e) {
                throw new MediaException(e.getMessage());
            }
        }
    }

    protected void playerSetLoopCount(int loopCount) {
        Playback playback = this.playback;
        if (playback != null) {
            playback.loopCountSetted = loopCount;
            playback.loopCountRemaining = loopCount;
        }
    }

    protected long playerSetMediaTime(long mediaTime) throws MediaException {
        SyntheticSoundPlayer player;
        Playback playback = this.playback;
        if (playback != null && (player = playback.systemPlayer) != null) {
            long[] messages = playback.synthesizerMessages;
            if (playback.synthesizerMessages != null) {
                long guessTime;
                int posGuess;
                int pos1 = 0;
                int pos2 = messages.length - 1;
                while (true) {
                    posGuess = pos1 + pos2 >> 1;
                    guessTime = 1000L * (messages[posGuess] >> 24);
                    if (pos1 == pos2) break;
                    if (mediaTime < guessTime) {
                        pos2 = posGuess - 1;
                        if (pos2 >= pos1) continue;
                        pos2 = pos1;
                        continue;
                    }
                    if (mediaTime <= guessTime) break;
                    pos1 = posGuess + 1;
                    if (pos1 <= pos2) continue;
                    pos1 = pos2;
                }
                mediaTime = guessTime;
                if (playback.loaded) {
                    try {
                        player.setCurrentBlockPosition(posGuess);
                    }
                    catch (SoundPlayerException e) {
                        throw new MediaException(e.getMessage());
                    }
                } else {
                    playback.position = posGuess;
                }
            }
        }
        return mediaTime;
    }

    protected long playerGetMediaTime() {
        SyntheticSoundPlayer player;
        Playback playback = this.playback;
        if (playback != null && (player = playback.systemPlayer) != null) {
            long[] messages = playback.synthesizerMessages;
            if (playback.synthesizerMessages != null) {
                int pos;
                if (playback.loaded) {
                    try {
                        pos = player.getCurrentBlockPosition();
                    }
                    catch (SoundPlayerException soundPlayerException) {
                        pos = playback.position;
                    }
                } else {
                    pos = playback.position;
                }
                return 1000L * (messages[pos] >> 24);
            }
        }
        return -1L;
    }

    private final class Playback
    extends Volume
    implements SoundPlayerListener,
    MIDIControl {
        boolean loaded;
        int position;
        int loopCountSetted = 1;
        int loopCountRemaining = 1;
        long[] synthesizerMessages;
        SyntheticSoundPlayer systemPlayer;

        public Playback(Object monitor) {
            super(monitor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endOfBlock(SoundPlayer player, int blockIndexForLoad) {
            if (blockIndexForLoad >= 0) {
                return;
            }
            Object object = this.monitor;
            synchronized (object) {
                SyntheticPlayer parent = SyntheticPlayer.this;
                if (--this.loopCountRemaining == 0) {
                    parent.playerEndOfMedia();
                } else {
                    parent.playerRestart();
                    try {
                        player.start();
                    }
                    catch (SoundPlayerException e) {
                        e.printRealStackTrace();
                    }
                }
            }
        }

        public void shortMidiEvent(int statusByte, int dataByte1, int dataByte2) {
            if (statusByte < 128 || statusByte >= 240 && statusByte <= 247 || statusByte > 255) {
                throw new IllegalArgumentException("MIDIControl.shortMidiEvent: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 statusByte \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
            }
            if (dataByte1 < 0 || dataByte1 > 127) {
                throw new IllegalArgumentException("MIDIControl.shortMidiEvent: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 dataByte1 \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
            }
            if (dataByte2 < 0 || dataByte2 > 127) {
                throw new IllegalArgumentException("MIDIControl.shortMidiEvent: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 dataByte2 \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
            }
            SyntheticSoundPlayer player = this.systemPlayer;
            if (player == null) {
                throw new IllegalStateException("MIDIControl.shortMidiEvent: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435 \u043f\u043e\u043b\u0443\u0447\u0438\u043b \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u0440\u0435\u0441\u0443\u0440\u0441\u0430\u043c.");
            }
            try {
                player.sendMessage(statusByte << 16 | dataByte1 << 8 | dataByte2);
            }
            catch (SoundPlayerException soundPlayerException) {
                throw new IllegalStateException("MIDIControl.shortMidiEvent: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
        }

        public void setChannelVolume(int channel, int volume) {
            if (channel < 0 || channel > 15) {
                throw new IllegalArgumentException("MIDIControl.setChannelVolume: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 channel \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
            }
            if (volume < 0 || volume > 127) {
                throw new IllegalArgumentException("MIDIControl.setChannelVolume: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 volume \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
            }
            SyntheticSoundPlayer player = this.systemPlayer;
            if (player == null) {
                throw new IllegalStateException("MIDIControl.setChannelVolume: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435 \u043f\u043e\u043b\u0443\u0447\u0438\u043b \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u0440\u0435\u0441\u0443\u0440\u0441\u0430\u043c.");
            }
            try {
                player.sendMessage((0xB0 | channel) << 16 | 0x700 | volume);
            }
            catch (SoundPlayerException soundPlayerException) {
                throw new IllegalStateException("MIDIControl.setChannelVolume: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
        }

        public void setProgram(int channel, int bank, int programme) {
            if (channel < 0 || channel > 15) {
                throw new IllegalArgumentException("MIDIControl.setProgram: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 channel \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
            }
            if (bank < -1 || bank > 16383) {
                throw new IllegalArgumentException("MIDIControl.setProgram: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 bank \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
            }
            if (programme < 0 || programme > 127) {
                throw new IllegalArgumentException("MIDIControl.setProgram: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 programme \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
            }
            SyntheticSoundPlayer player = this.systemPlayer;
            if (player == null) {
                throw new IllegalStateException("MIDIControl.setProgram: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435 \u043f\u043e\u043b\u0443\u0447\u0438\u043b \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u0440\u0435\u0441\u0443\u0440\u0441\u0430\u043c.");
            }
            try {
                if (bank >= 0) {
                    player.sendMessage((0xB0 | channel) << 16 | bank >> 7);
                    player.sendMessage((0xB0 | channel) << 16 | 0x2000 | bank & 0x7F);
                }
                player.sendMessage((0xC0 | channel) << 16 | programme << 8);
            }
            catch (SoundPlayerException soundPlayerException) {
                throw new IllegalStateException("MIDIControl.setProgram: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
        }

        public boolean isBankQuerySupported() {
            return false;
        }

        public int longMidiEvent(byte[] src, int offset, int length) {
            return length;
        }

        public int getChannelVolume(int channel) {
            return -1;
        }

        public int[] getProgram(int channel) throws MediaException {
            throw new BankQueryNotSupportedException("MIDIControl.getProgram: \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0431\u0430\u043d\u043a\u043e\u0432 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.");
        }

        public int[] getProgramList(int bank) throws MediaException {
            throw new BankQueryNotSupportedException("MIDIControl.getProgramList: \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0431\u0430\u043d\u043a\u043e\u0432 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.");
        }

        public int[] getBankList(boolean custom) throws MediaException {
            throw new BankQueryNotSupportedException("MIDIControl.getBankList: \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0431\u0430\u043d\u043a\u043e\u0432 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.");
        }

        public String getProgramName(int bank, int programme) throws MediaException {
            throw new BankQueryNotSupportedException("MIDIControl.getProgramName: \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0431\u0430\u043d\u043a\u043e\u0432 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.");
        }

        public String getKeyName(int bank, int programme, int key) throws MediaException {
            throw new BankQueryNotSupportedException("MIDIControl.getKeyName: \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0431\u0430\u043d\u043a\u043e\u0432 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.");
        }

        public void setSystemPlayer(SyntheticSoundPlayer player) throws SoundPlayerException {
            this.setupSystemPlayer((SoundPlayer)player);
            this.loaded = false;
            this.systemPlayer = player;
        }

        public void closeSystemPlayer() {
            SyntheticSoundPlayer player = this.systemPlayer;
            if (player != null) {
                this.systemPlayer = null;
                player.close();
            }
        }

        protected void volumeChanged(boolean muted, int level) {
            SyntheticPlayer.this.postEvent("volumeChanged", this);
        }

        protected void setupSystemPlayer(SoundPlayer player) throws SoundPlayerException {
            player.setSoundPlayerListener((SoundPlayerListener)this);
            super.setupSystemPlayer(player);
        }

        protected SoundPlayer getSystemPlayer() {
            return this.systemPlayer;
        }
    }
}

