/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.MIDletProxy;
import javax.microedition.lcdui.ScrollBar;
import javax.microedition.lcdui.ScrollingScreen;
import javax.microedition.lcdui.Ticker;
import malik.emulator.media.graphics.RasterCanvas;

public class CharList
extends ScrollingScreen {
    private int focusedCharIndex;
    private int charSize;
    private char[] chars;
    private Font font;
    private Object lock;

    public CharList(boolean fullScreenMode, String title, Ticker ticker, Command[] commands, Command defaultCommand, CommandListener listener, char[] chars) {
        super(true, fullScreenMode, title, ticker, commands, defaultCommand, listener, 1);
        char[] c;
        Font font = Font.getFont(0, 0, 0);
        if (chars == null) {
            c = new char[]{};
        } else {
            int len = chars.length;
            c = new char[len];
            Array.copy((char[])chars, (int)0, (char[])c, (int)0, (int)len);
        }
        this.charSize = (3 * font.getHeight() >> 1) + 1;
        this.chars = c;
        this.font = font;
        this.lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChars(char[] chars) {
        Object object = this.lock;
        synchronized (object) {
            char[] c;
            int len;
            if (chars == null) {
                len = 0;
                c = new char[]{};
            } else {
                len = chars.length;
                c = new char[len];
                Array.copy((char[])chars, (int)0, (char[])c, (int)0, (int)len);
            }
            this.chars = c;
            if (this.focusedCharIndex >= len) {
                this.focusedCharIndex = Math.max(0, len - 1);
            }
            this.correctScrollBarRange(this.getHeight());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedIndex(int selected) {
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            if (selected < 0 || selected >= this.chars.length) {
                error = true;
            } else {
                this.focusedCharIndex = selected;
                this.correctScrollBarPositionToChar();
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("CharList.setSelectedIndex: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 selected \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public char getChar(int index) {
        error = false;
        var5_3 = this.lock;
        synchronized (var5_3) {
            if (index < 0) ** GOTO lbl-1000
            c = this.chars;
            if (index >= this.chars.length) lbl-1000:
            // 2 sources

            {
                error = true;
                result = '\u0000';
            } else {
                result = c[index];
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("CharList.getChar: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 index \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return result;
    }

    public int getSelectedIndex() {
        return this.focusedCharIndex;
    }

    public int size() {
        return this.chars.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paint(Graphics render, ScrollBar horzScrollBar, ScrollBar vertScrollBar) {
        int size = this.charSize;
        Font font = this.font;
        int t = size - font.getHeight() >> 1;
        int x = 0;
        int y = 0;
        int left = horzScrollBar.getPosition();
        int right = left + horzScrollBar.getPage();
        render.setColor(RasterCanvas.getSystemColor((int)40));
        render.setFont(font);
        Object object = this.lock;
        synchronized (object) {
            char[] c = this.chars;
            int len = this.chars.length;
            int focused = this.focusedCharIndex;
            int charsPerColumn = Math.max(1, this.getHeight() / size);
            int i = 0;
            while (i < len) {
                if (x < right && x + size > left) {
                    if (i == focused) {
                        render.drawElementOfGUI(1, 0, 0, x, y, size, size);
                    }
                    render.drawChar(c[i], x + (size >> 1) - 1, y + t, 17);
                }
                if (++i % charsPerColumn == 0) {
                    x += size;
                    y = 0;
                    continue;
                }
                y += size;
            }
        }
    }

    void onKeyPressed(int key, int charCode) {
        if (!super.keyHandling(key)) {
            this.moveCursor(key);
            return;
        }
        super.onKeyPressed(key, charCode);
    }

    void onKeyRepeated(int key, int charCode) {
        if (!super.keyHandling(key)) {
            this.moveCursor(key);
            return;
        }
        super.onKeyRepeated(key, charCode);
    }

    void onClientPointerPressed(int x, int y, int button) {
        this.pointerHandle(x, y);
    }

    void onClientPointerDragged(int x, int y) {
        this.pointerHandle(x, y);
    }

    void onClientPointerReleased(int x, int y, int button) {
        this.pointerHandle(x, y);
    }

    void onSizeChanged(int width, int height) {
        this.correctScrollBarRange(height);
        super.onSizeChanged(width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveCursor(int key) {
        MIDletProxy proxy = MIDletProxy.getInstance();
        if (key == proxy.getKeyUsedAs(38)) {
            Object object = this.lock;
            synchronized (object) {
                int len = this.chars.length;
                if (len > 0) {
                    this.focusedCharIndex = (this.focusedCharIndex + len - 1) % len;
                    this.correctScrollBarPositionToChar();
                }
            }
            return;
        }
        if (key == proxy.getKeyUsedAs(36)) {
            Object object = this.lock;
            synchronized (object) {
                int len = this.chars.length;
                if (len > 0) {
                    this.focusedCharIndex = (this.focusedCharIndex + 1) % len;
                    this.correctScrollBarPositionToChar();
                }
            }
            return;
        }
        if (key == proxy.getKeyUsedAs(40)) {
            Object object = this.lock;
            synchronized (object) {
                int focused = this.focusedCharIndex;
                int charsPerColumn = Math.max(1, this.getHeight() / this.charSize);
                if (focused >= charsPerColumn) {
                    this.focusedCharIndex = focused - charsPerColumn;
                    this.correctScrollBarPositionToChar();
                }
            }
            return;
        }
        if (key == proxy.getKeyUsedAs(41)) {
            Object object = this.lock;
            synchronized (object) {
                int focused = this.focusedCharIndex;
                int charsPerColumn = Math.max(1, this.getHeight() / this.charSize);
                if (focused < this.chars.length - charsPerColumn) {
                    this.focusedCharIndex = focused + charsPerColumn;
                    this.correctScrollBarPositionToChar();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pointerHandle(int x, int y) {
        Object object = this.lock;
        synchronized (object) {
            int size = this.charSize;
            int col = x / size;
            int row = y / size;
            int charsPerColumn = Math.max(1, this.getHeight() / size);
            int index = row + col * charsPerColumn;
            if (index >= 0 && index < this.chars.length) {
                this.focusedCharIndex = index;
                this.correctScrollBarPositionToChar();
            }
        }
    }

    private void correctScrollBarRange(int height) {
        int len = this.chars.length;
        int size = this.charSize;
        int charsPerColumn = Math.max(1, height / size);
        this.getHorzScrollBar().setRange(size * (len / charsPerColumn + (len % charsPerColumn == 0 ? 0 : 1)));
    }

    private void correctScrollBarPositionToChar() {
        int need;
        int size = this.charSize;
        int charsPerColumn = Math.max(1, this.getHeight() / size);
        int focusedColumn = this.focusedCharIndex / charsPerColumn;
        ScrollBar scrollbar = this.getHorzScrollBar();
        int pos = scrollbar.getPosition();
        if (pos > (need = focusedColumn * size)) {
            scrollbar.setPosition(need);
        } else if (pos < (need -= scrollbar.getPage() - size)) {
            scrollbar.setPosition(need);
        }
        this.callSeriallyPaintScreen(4);
    }
}

