/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.MIDletProxy;

public abstract class CustomItem
extends Item {
    protected static final int NONE = 0;
    protected static final int TRAVERSE_HORIZONTAL = 1;
    protected static final int TRAVERSE_VERTICAL = 2;
    protected static final int KEY_PRESS = 4;
    protected static final int KEY_RELEASE = 8;
    protected static final int KEY_REPEAT = 16;
    protected static final int POINTER_PRESS = 32;
    protected static final int POINTER_RELEASE = 64;
    protected static final int POINTER_DRAG = 128;
    private boolean pointerFocused;

    protected CustomItem(String label) {
        super(0, -1, -1, label, null, null, null);
    }

    protected CustomItem(int layout, int lockedWidth, int lockedHeight, String label, Command[] commands, Command defaultCommand, ItemCommandListener listener) {
        super(layout, lockedWidth, lockedHeight, label, commands, defaultCommand, listener);
    }

    public int getGameAction(int keyCode) {
        return MIDletProxy.getInstance().keyCodeToGameAction(keyCode);
    }

    protected abstract void paint(Graphics var1, int var2, int var3);

    protected abstract int getMinContentWidth();

    protected abstract int getMinContentHeight();

    protected abstract int getPrefContentWidth(int var1);

    protected abstract int getPrefContentHeight(int var1);

    protected void showNotify() {
    }

    protected void hideNotify() {
    }

    protected void keyPressed(int keyCode) {
    }

    protected void keyRepeated(int keyCode) {
    }

    protected void keyReleased(int keyCode) {
    }

    protected void pointerPressed(int x, int y) {
    }

    protected void pointerDragged(int x, int y) {
    }

    protected void pointerReleased(int x, int y) {
    }

    protected void sizeChanged(int contentWidth, int contentHeight) {
    }

    protected void traverseOut() {
    }

    protected boolean traverse(int direction, int viewportWidth, int viewportHeight, int[] visibleRectangle) {
        return false;
    }

    protected final void invalidate() {
        this.notifyUpdate();
    }

    protected final void repaint() {
        this.notifyPaint();
    }

    protected final void repaint(int left, int top, int width, int height) {
        this.notifyPaint();
    }

    protected final int getInteractionModes() {
        return -1;
    }

    void paintContent(Graphics render, int contentWidth, int contentHeight) {
        this.paint(render, contentWidth, contentHeight);
    }

    void onShow() {
        this.showNotify();
    }

    void onHide() {
        this.hideNotify();
    }

    void onSizeChanged(int contentWidth, int contentHeight) {
        this.sizeChanged(contentWidth, contentHeight);
    }

    void onKeyPressed(int key, int charCode) {
        int keyCode = MIDletProxy.getInstance().getKeyCode(key);
        if (keyCode == 0) {
            return;
        }
        this.keyPressed(keyCode);
    }

    void onKeyRepeated(int key, int charCode) {
        int keyCode;
        if (!Canvas.isKeyRepeatedEvent() || (keyCode = MIDletProxy.getInstance().getKeyCode(key)) == 0) {
            return;
        }
        this.keyRepeated(keyCode);
    }

    void onKeyReleased(int key) {
        int keyCode = MIDletProxy.getInstance().getKeyCode(key);
        if (keyCode == 0) {
            return;
        }
        this.keyReleased(keyCode);
    }

    void onContentPointerPressed(int x, int y, int button) {
        if (button != 0) {
            return;
        }
        this.pointerFocused = true;
        this.pointerPressed(x, y);
    }

    void onContentPointerDragged(int x, int y) {
        if (!this.pointerFocused) {
            return;
        }
        this.pointerDragged(x, y);
    }

    void onContentPointerReleased(int x, int y, int button) {
        if (!this.pointerFocused || button != 0) {
            return;
        }
        this.pointerFocused = false;
        this.pointerReleased(x, y);
    }

    void onTraverseOut() {
        this.traverseOut();
    }

    boolean onTraverseNeedStayOn(int direction, int viewportWidth, int viewportHeight, int[] visibleRectangle) {
        return this.traverse(direction, viewportWidth, viewportHeight, visibleRectangle);
    }

    boolean keyHandling(int key) {
        int keyCode = MIDletProxy.getInstance().getKeyCode(key);
        return keyCode == 42 || keyCode == 35 || keyCode >= 48 && keyCode <= 57;
    }

    int getPreferredContentWidth(int contentHeight, int containerClientWidth) {
        return this.getPrefContentWidth(contentHeight);
    }

    int getPreferredContentHeight(int contentWidth) {
        return this.getPrefContentHeight(contentWidth);
    }

    int getMinimumContentWidth(int containerClientWidth) {
        return this.getMinContentWidth();
    }

    int getMinimumContentHeight() {
        return this.getMinContentHeight();
    }
}

