/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Calendar;
import java.util.TimeZone;
import malik.emulator.time.GregorianCalendar;

public class Date {
    private long millis;
    private Calendar calendar;

    public Date() {
        this(System.currentTimeMillis());
    }

    public Date(long millis) {
        Calendar c;
        this.millis = millis;
        this.calendar = c = Calendar.getInstance();
        if (c != null) {
            c.setTimeInMillis(millis);
        }
    }

    public boolean equals(Object ref) {
        return ref == this || ref instanceof Date && this.getTime() == ((Date)ref).getTime();
    }

    public int hashCode() {
        long t = this.getTime();
        return (int)(t ^ t >>> 32);
    }

    public String toString() {
        String string;
        Calendar c = this.calendar;
        if (c != null && c instanceof GregorianCalendar) {
            string = ((GregorianCalendar)c).toString(GregorianCalendar.getStandardFormat());
        } else {
            long t = this.getTime();
            TimeZone z = TimeZone.getDefault();
            long f = GregorianCalendar.computeFields(t, z.getRawOffset());
            int ms = (int)f & 0xFFFF;
            string = GregorianCalendar.getStandardFormat().represent(1, (int)(f >>> 48), (byte)(f >>> 40) - 1, (byte)(f >>> 32), ((int)(t / 86400000L % 7L) + 1) % 7 + 1, (byte)(f >>> 24), (byte)(f >>> 16), ms / 1000, ms % 1000, z);
        }
        return string;
    }

    public void setTime(long millis) {
        this.millis = millis;
        Calendar c = this.calendar;
        if (c != null) {
            c.setTimeInMillis(millis);
        }
    }

    public long getTime() {
        Calendar c = this.calendar;
        return c != null ? c.getTimeInMillis() : this.millis;
    }
}

