/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class Hashtable {
    private int factor;
    private int length;
    private Entry[] table;
    private Object lock;

    public Hashtable() {
        this(15);
    }

    public Hashtable(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Hashtable: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 initialCapacity \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.factor = initialCapacity * 3 / 4;
        this.table = new Entry[initialCapacity];
        this.lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer result = new StringBuffer(123);
        Object object = this.lock;
        synchronized (object) {
            Entry[] t = this.table;
            Enumerator k = new Enumerator(true, t);
            Enumerator e = new Enumerator(false, t);
            int i = this.length;
            while (i-- > 0) {
                result.append(k.nextElement().toString()).append('=').append(e.nextElement().toString());
                if (i <= 0) continue;
                result.append(", ");
            }
        }
        return result.append('}').toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            Entry[] t = this.table;
            int i = this.table.length;
            while (i-- > 0) {
                t[i] = null;
            }
            this.length = 0;
        }
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object value) {
        boolean result;
        if (value == null) {
            throw new NullPointerException("Hashtable.contains: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 value \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Object object = this.lock;
        synchronized (object) {
            block7: {
                Entry[] t = this.table;
                int i = this.table.length;
                while (i-- > 0) {
                    Entry e = t[i];
                    while (e != null) {
                        if (value.equals(e.value)) {
                            result = true;
                            break block7;
                        }
                        e = e.next;
                    }
                }
                result = false;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        boolean result;
        if (key == null) {
            throw new NullPointerException("Hashtable.containsKey: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 key \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Object object = this.lock;
        synchronized (object) {
            block6: {
                Entry[] t = this.table;
                int hash = key.hashCode();
                Entry e = this.table[(hash & Integer.MAX_VALUE) % t.length];
                while (e != null) {
                    if (hash == e.hash && key.equals(e.key)) {
                        result = true;
                        break block6;
                    }
                    e = e.next;
                }
                result = false;
            }
        }
        return result;
    }

    public int size() {
        return this.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        Object result;
        if (key == null) {
            throw new NullPointerException("Hashtable.remove: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 key \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Object object = this.lock;
        synchronized (object) {
            block8: {
                Entry f = null;
                Entry[] t = this.table;
                int hash = key.hashCode();
                int i = (hash & Integer.MAX_VALUE) % t.length;
                Entry e = this.table[i];
                while (e != null) {
                    if (hash == e.hash && key.equals(e.key)) {
                        if (f != null) {
                            f.next = e.next;
                        } else {
                            t[i] = e.next;
                        }
                        --this.length;
                        result = e.value;
                        break block8;
                    }
                    f = e;
                    e = e.next;
                }
                result = null;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        Object result;
        if (key == null) {
            throw new NullPointerException("Hashtable.get: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 key \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Object object = this.lock;
        synchronized (object) {
            block6: {
                Entry[] t = this.table;
                int hash = key.hashCode();
                Entry e = this.table[(hash & Integer.MAX_VALUE) % t.length];
                while (e != null) {
                    if (hash == e.hash && key.equals(e.key)) {
                        result = e.value;
                        break block6;
                    }
                    e = e.next;
                }
                result = null;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        Object result;
        if (key == null) {
            throw new NullPointerException("Hashtable.put: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 key \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (value == null) {
            throw new NullPointerException("Hashtable.put: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 value \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Object object = this.lock;
        synchronized (object) {
            block8: {
                Entry[] t = this.table;
                int hash = key.hashCode();
                int i = (hash & Integer.MAX_VALUE) % t.length;
                Entry e = this.table[i];
                while (e != null) {
                    if (hash == e.hash && key.equals(e.key)) {
                        result = e.value;
                        e.value = value;
                        break block8;
                    }
                    e = e.next;
                }
                int l = this.length;
                if (l >= this.factor) {
                    this.rehash();
                    t = this.table;
                    i = (hash & Integer.MAX_VALUE) % this.table.length;
                }
                t[i] = new Entry(hash, key, value, t[i]);
                this.length = l + 1;
                result = null;
            }
        }
        return result;
    }

    public Enumeration keys() {
        return new Enumerator(true, this.table);
    }

    public Enumeration elements() {
        return new Enumerator(false, this.table);
    }

    protected void rehash() {
        Entry[] ot = this.table;
        int oc = this.table.length;
        int nc = (oc << 1) + 1;
        Entry[] nt = new Entry[nc];
        this.table = nt;
        this.factor = nc * 3 / 4;
        int i = oc;
        while (i-- > 0) {
            Entry f = ot[i];
            while (f != null) {
                Entry e = f;
                int j = (e.hash & Integer.MAX_VALUE) % nc;
                f = f.next;
                e.next = nt[j];
                nt[j] = e;
            }
        }
    }

    private static class Entry {
        public int hash;
        public Object key;
        public Object value;
        public Entry next;

        Entry(int hash, Object key, Object value, Entry next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }
    }

    private static class Enumerator
    implements Enumeration {
        private boolean keys;
        private int index;
        private Entry[] table;
        private Entry entry;

        Enumerator(boolean keys, Entry[] table) {
            this.keys = keys;
            this.index = table.length;
            this.table = table;
            this.entry = null;
        }

        public boolean hasMoreElements() {
            if (this.entry != null) {
                return true;
            }
            Entry[] t = this.table;
            int i = this.index;
            while (i-- > 0) {
                this.entry = t[i];
                if (this.entry == null) continue;
                this.index = i;
                return true;
            }
            this.index = i;
            return false;
        }

        public Object nextElement() {
            Entry e;
            if (this.entry == null) {
                Entry[] t = this.table;
                int i = this.index;
                while (i-- > 0 && (this.entry = t[i]) == null) {
                }
                this.index = i;
            }
            if ((e = this.entry) == null) {
                throw new NoSuchElementException("Hashtable: \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435 \u043e\u0441\u0442\u0430\u043b\u043e\u0441\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0434\u043b\u044f \u043f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f.");
            }
            this.entry = e.next;
            return this.keys ? e.key : e.value;
        }
    }
}

