/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.application;

import java.util.Queue;
import malik.emulator.application.ImmediatelyRunnable;

final class QueueOfMalikAppEvents
extends Queue {
    private static final int INITIAL_CAPACITY = 17;
    private static final Runnable EMPTY_EVENT = new Runnable(){

        public void run() {
        }
    };
    private long[] eventsFromUser = new long[17];
    private Runnable[] eventsFromApp = new Runnable[17];

    public QueueOfMalikAppEvents() {
        super(17);
    }

    public void removeTailElement() {
        int t = this.tail;
        this.eventsFromUser[t] = 0L;
        this.eventsFromApp[t] = null;
        this.advanceTail();
    }

    public void push(long eventFromUser, Runnable eventFromApp) {
        long[] lq = this.eventsFromUser;
        Object[] rq = this.eventsFromApp;
        if (this.getFreeElements() == 0) {
            int nc = (this.capacity << 1) - 1;
            lq = this.eventsFromUser = this.expand(lq, nc);
            this.eventsFromApp = (Runnable[])this.expand(rq, nc);
            rq = this.eventsFromApp;
            this.reset(nc);
        }
        int h = this.head;
        lq[h] = eventFromUser;
        rq[h] = eventFromApp;
        this.advanceHead();
    }

    public long peekEventFromUser() {
        return this.eventsFromUser[this.tail];
    }

    public Runnable peekEventFromApp() {
        return this.eventsFromApp[this.tail];
    }

    public Runnable findImmediatelyRunnable(Object argument) {
        int t = this.tail;
        int c = this.capacity;
        Runnable[] e = this.eventsFromApp;
        int i = this.head;
        while (i != t) {
            Runnable r = e[i = (c + i - 1) % c];
            if (!(r instanceof ImmediatelyRunnable) || ((ImmediatelyRunnable)r).argument() != argument) continue;
            e[i] = EMPTY_EVENT;
            return r;
        }
        return null;
    }
}

